/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.demo;

import de.cismet.cismap.commons.rasterservice.HTTPImageRetrieval;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ImageRetrievalDemo
extends JFrame
implements RetrievalListener {
    HTTPImageRetrieval ir;
    private final Logger log = Logger.getLogger(this.getClass());
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton jButton1;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JPanel panMain;
    private JMenuItem pasteMenuItem;
    private JProgressBar prBar;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;

    public ImageRetrievalDemo() {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        this.log.info((Object)"Simple Mapping Client started");
        this.initComponents();
        this.prBar.setMaximum(100);
    }

    private void initComponents() {
        this.prBar = new JProgressBar();
        this.panMain = new JPanel();
        this.jButton1 = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.prBar, "South");
        this.panMain.setMinimumSize(new Dimension(100, 100));
        this.getContentPane().add((Component)this.panMain, "Center");
        this.jButton1.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageRetrievalDemo.this.jButton1ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButton1, "North");
        this.fileMenu.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.fileMenu.text"));
        this.openMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.openMenuItem.text"));
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.saveMenuItem.text"));
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.saveAsMenuItem.text"));
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.exitMenuItem.text"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageRetrievalDemo.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.editMenu.text"));
        this.cutMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.cutMenuItem.text"));
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.copyMenuItem.text"));
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.pasteMenuItem.text"));
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.deleteMenuItem.text"));
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.helpMenu.text"));
        this.contentsMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.contentsMenuItem.text"));
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText(NbBundle.getMessage(ImageRetrievalDemo.class, (String)"ImageRetrievalDemo.aboutMenuItem.text"));
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.prBar.setValue(0);
        this.prBar.setIndeterminate(true);
        if (this.ir == null) {
            this.ir = new HTTPImageRetrieval(this);
            this.ir.setUrl("http://s102w2k1.wuppertal-intra.de/wunda_dk_v61/isserver/ims/scripts/ShowMap.pl?datasource=grundlkarten&VERSION=1.1.1&REQUEST=GetMap&BBOX=2581794.0773859876,5684502.5686845,2581948.756619977,5684588.15786064&WIDTH=750&HEIGHT=415&SRS=EPSG:31466&FORMAT=image/png&TRANSPARENT=true&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_inimage&LAYERS=02_11&STYLES=farbig");
            this.ir.start();
        } else {
            this.ir.endRetrieval();
            this.ir = new HTTPImageRetrieval(this);
            this.ir.setUrl("http://s102w2k1.wuppertal-intra.de/wunda_dk_v61/isserver/ims/scripts/ShowMap.pl?datasource=grundlkarten&VERSION=1.1.1&REQUEST=GetMap&BBOX=2581794.0773859876,5684502.5686845,2581948.756619977,5684588.15786064&WIDTH=750&HEIGHT=415&SRS=EPSG:31466&FORMAT=image/png&TRANSPARENT=true&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_inimage&LAYERS=02_11&STYLES=farbig");
            this.ir.start();
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImageRetrievalDemo().setVisible(true);
            }
        });
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
    }

    @Override
    public void retrievalProgress(RetrievalEvent e) {
        final double p = e.getPercentageDone();
        System.out.println(p);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImageRetrievalDemo.this.prBar.isIndeterminate()) {
                    ImageRetrievalDemo.this.prBar.setIndeterminate(false);
                }
                ImageRetrievalDemo.this.prBar.setValue((int)p);
            }
        });
    }

    @Override
    public void retrievalError(RetrievalEvent e) {
        this.log.error((Object)("Error:" + e.getRetrievedObject()));
    }

    @Override
    public void retrievalComplete(RetrievalEvent e) {
        Object o = e.getRetrievedObject();
        Image i = null;
        if (o instanceof Image) {
            i = (Image)o;
        }
        this.panMain.getGraphics().drawImage(i, 0, 0, this);
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
    }
}

