/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.demo;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SimpleMoveListener;
import de.cismet.cismap.commons.preferences.CismapPreferences;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.event.PNotification;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.openide.util.NbBundle;

public class SimpleMappingClient
extends JFrame
implements RetrievalListener {
    private final Logger log = Logger.getLogger(this.getClass());
    private JMenuItem aboutMenuItem;
    private JComboBox cboMode;
    private JButton cmdBack;
    private JButton cmdFwd;
    private JButton cmdShowFeatureCollection;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton jButton1;
    private JPanel jPanel1;
    private JLabel lblCoord;
    private MappingComponent mapC;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JPanel panStatus;
    private JPanel panToolbar;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JTextField txtKZ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleMappingClient() {
        Object object;
        try {
            InputStream configStream = ClassLoader.getSystemResourceAsStream("de/cismet/cismap/commons/demo/log4j.xml");
            object = null;
            try {
                ConfigurationSource source = new ConfigurationSource(configStream);
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.start((Configuration)new XmlConfiguration(context, source));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (configStream != null) {
                    if (object != null) {
                        try {
                            configStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        configStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.info((Object)"Simple Mapping Client started");
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception e) {
            this.log.warn((Object)"Error during the configuration of the Look&Feel!", (Throwable)e);
        }
        this.initComponents();
        CismapPreferences cismapPrefs = new CismapPreferences(this.getClass().getResource("/cismapPreferences.xml"));
        object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        this.mapC.setPreferences(cismapPrefs);
        PNotificationCenter.defaultCenter().addListener((Object)this, "coordinatesChanged", "COORDINATES_CHANGED", (Object)this.mapC.getInputListener("MOTION"));
    }

    public void coordinatesChanged(PNotification notification) {
        Object o = notification.getObject();
        if (o instanceof SimpleMoveListener) {
            double x = ((SimpleMoveListener)((Object)o)).getXCoord();
            double y = ((SimpleMoveListener)((Object)o)).getYCoord();
            this.lblCoord.setText(MappingComponent.getCoordinateString(x, y));
        }
    }

    private void initComponents() {
        this.panToolbar = new JPanel();
        this.panStatus = new JPanel();
        this.cboMode = new JComboBox();
        this.cmdShowFeatureCollection = new JButton();
        this.txtKZ = new JTextField();
        this.lblCoord = new JLabel();
        this.jButton1 = new JButton();
        this.cmdBack = new JButton();
        this.cmdFwd = new JButton();
        this.jPanel1 = new JPanel();
        this.mapC = new MappingComponent();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.panToolbar, "North");
        this.panStatus.setLayout(new GridBagLayout());
        this.cboMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Zoom", "Pan"}));
        this.cboMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleMappingClient.this.cboModeActionPerformed(evt);
                SimpleMappingClient.this.jComboBox1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panStatus.add((Component)this.cboMode, gridBagConstraints);
        this.cmdShowFeatureCollection.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.cmdShowFeatureCollection.text"));
        this.cmdShowFeatureCollection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleMappingClient.this.cmdShowFeatureCollectionActionPerformed(evt);
            }
        });
        this.panStatus.add((Component)this.cmdShowFeatureCollection, new GridBagConstraints());
        this.txtKZ.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.txtKZ.text"));
        this.txtKZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleMappingClient.this.txtKZActionPerformed(evt);
            }
        });
        this.panStatus.add((Component)this.txtKZ, new GridBagConstraints());
        this.lblCoord.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panStatus.add((Component)this.lblCoord, gridBagConstraints);
        this.jButton1.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleMappingClient.this.jButton1ActionPerformed(evt);
            }
        });
        this.panStatus.add((Component)this.jButton1, new GridBagConstraints());
        this.cmdBack.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.cmdBack.text"));
        this.cmdBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleMappingClient.this.cmdBackActionPerformed(evt);
            }
        });
        this.panStatus.add((Component)this.cmdBack, new GridBagConstraints());
        this.cmdFwd.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.cmdFwd.text"));
        this.cmdFwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleMappingClient.this.cmdFwdActionPerformed(evt);
            }
        });
        this.panStatus.add((Component)this.cmdFwd, new GridBagConstraints());
        this.getContentPane().add((Component)this.panStatus, "South");
        this.jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createEtchedBorder()));
        this.jPanel1.setLayout(new GridBagLayout());
        this.mapC.setBackground(new Color(236, 233, 216));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)((Object)this.mapC), gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.fileMenu.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.fileMenu.text"));
        this.openMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.openMenuItem.text"));
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.saveMenuItem.text"));
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.saveAsMenuItem.text"));
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.exitMenuItem.text"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleMappingClient.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.editMenu.text"));
        this.cutMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.cutMenuItem.text"));
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.copyMenuItem.text"));
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.pasteMenuItem.text"));
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.deleteMenuItem.text"));
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.helpMenu.text"));
        this.contentsMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.contentsMenuItem.text"));
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText(NbBundle.getMessage(SimpleMappingClient.class, (String)"SimpleMappingClient.aboutMenuItem.text"));
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 600) / 2, 800, 600);
    }

    private void cmdFwdActionPerformed(ActionEvent evt) {
        Object o = this.mapC.forward(true);
        if (o != null && o instanceof PBounds) {
            this.mapC.gotoBoundsWithoutHistory((PBounds)o);
        }
    }

    private void cmdBackActionPerformed(ActionEvent evt) {
        Object o = this.mapC.back(true);
        if (o != null && o instanceof PBounds) {
            this.mapC.gotoBoundsWithoutHistory((PBounds)o);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.mapC.showInternalLayerWidget(!this.mapC.isInternalLayerWidgetVisible(), 500);
    }

    private void txtKZActionPerformed(ActionEvent evt) {
    }

    private void cmdShowFeatureCollectionActionPerformed(ActionEvent evt) {
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
    }

    private void cboModeActionPerformed(ActionEvent evt) {
        if (this.cboMode.getSelectedItem().equals("Zoom")) {
            this.mapC.setInteractionMode("ZOOM");
        } else if (this.cboMode.getSelectedItem().equals("Pan")) {
            this.mapC.setInteractionMode("PAN");
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SimpleMappingClient().setVisible(true);
            }
        });
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
    }

    @Override
    public void retrievalProgress(RetrievalEvent e) {
    }

    @Override
    public void retrievalError(RetrievalEvent e) {
        this.log.error((Object)("Retrieve error message\n" + e.getRetrievedObject()));
    }

    @Override
    public void retrievalComplete(RetrievalEvent e) {
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
    }
}

