/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.drophandler.builtin;

import de.cismet.cismap.commons.drophandler.MappingComponentDropHandler;
import de.cismet.cismap.commons.drophandler.MappingComponentDropHandlerFileMatcher;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidgetProvider;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RasterGeoRefFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.ImageFileUtils;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingBackend;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class MappingComponentGeoReferencedImageFileDropHandler
implements MappingComponentDropHandler,
LayerWidgetProvider {
    private final MappingComponentDropHandlerFileMatcher fileMatcher = new ImageFileMatcher();
    private LayerWidget layerWidget;

    @Override
    public int getPriority() {
        return 999;
    }

    @Override
    public void dropFiles(Collection<File> files) {
        ArrayList<RasterGeoRefFeature> coll = new ArrayList<RasterGeoRefFeature>();
        for (File file : files) {
            LayerDropUtils.handleImageFile(file, this.layerWidget.getMappingModel(), -1, this.layerWidget, ImageFileUtils.Mode.GEO_REFERENCED);
            RasterGeoRefFeature feature = RasterGeoReferencingBackend.getInstance().getHandler(file).getFeature();
            if (feature == null) continue;
            coll.add(feature);
        }
        if (!CismapBroker.getInstance().getMappingComponent().isFixedMapExtent()) {
            CismapBroker.getInstance().getMappingComponent().zoomToAFeatureCollection(coll, true, CismapBroker.getInstance().getMappingComponent().isFixedMapScale());
        }
    }

    @Override
    public MappingComponentDropHandlerFileMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    @Override
    public LayerWidget getLayerWidget() {
        return this.layerWidget;
    }

    @Override
    public void setLayerWidget(LayerWidget layerWidget) {
        this.layerWidget = layerWidget;
    }

    class ImageFileMatcher
    implements MappingComponentDropHandlerFileMatcher {
        ImageFileMatcher() {
        }

        @Override
        public boolean isMatching(File file) {
            File worldFile = ImageFileUtils.getWorldFile(file);
            return ImageFileUtils.isImageFileEnding(file.getName()) && (worldFile == null || ImageFileUtils.checkIfRasterGeoRef(worldFile));
        }
    }
}

