/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.RasterDocumentFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public class DefaultRasterDocumentFeature
implements RasterDocumentFeature {
    private static final Logger log = Logger.getLogger(DefaultRasterDocumentFeature.class);
    private final BufferedImage rasterDocument;
    private PImage pImage;
    private Geometry geometry;
    private boolean canBeSelected;
    private boolean editable;
    private boolean hidden;

    public DefaultRasterDocumentFeature(BufferedImage rasterDocument, Geometry geom) {
        this(rasterDocument, geom, true, true, false);
    }

    public DefaultRasterDocumentFeature(BufferedImage rasterDocument, double x, double y) {
        this(rasterDocument, DefaultRasterDocumentFeature.getGeomFromRasterImage(rasterDocument, x, y));
    }

    public DefaultRasterDocumentFeature(BufferedImage rasterDocument, double x, double y, int srid) {
        this(rasterDocument, DefaultRasterDocumentFeature.getGeomFromRasterImage(rasterDocument, x, y, srid));
    }

    public DefaultRasterDocumentFeature(BufferedImage rasterDocument, Geometry geometry, boolean canBeSelected, boolean editable, boolean hidden) {
        this.rasterDocument = rasterDocument;
        this.geometry = geometry;
        this.canBeSelected = canBeSelected;
        this.editable = editable;
    }

    @Override
    public BufferedImage getRasterDocument() {
        return this.rasterDocument;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public void setGeometry(Geometry geom) {
        this.geometry = geom;
    }

    @Override
    public boolean canBeSelected() {
        return this.canBeSelected;
    }

    @Override
    public void setCanBeSelected(boolean canBeSelected) {
        this.canBeSelected = canBeSelected;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void hide(boolean hiding) {
        this.hidden = hiding;
    }

    private static Geometry getGeomFromRasterImage(BufferedImage bi, double x, double y) {
        return DefaultRasterDocumentFeature.getGeomFromRasterImage(bi, x, y, CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getDefaultCrs()));
    }

    private static Geometry getGeomFromRasterImage(BufferedImage bi, double x, double y, int srid) {
        GeometryFactory GEOM_FACTORY = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        int width = bi.getWidth();
        int height = bi.getHeight();
        Coordinate ursprung0 = new Coordinate(x, y);
        Coordinate x1 = new Coordinate((double)width + x, y);
        Coordinate xy2 = new Coordinate((double)width + x, (double)height + y);
        Coordinate y3 = new Coordinate(x, (double)height + y);
        Coordinate ursprung4 = new Coordinate(x, y);
        Coordinate[] coords = new Coordinate[]{ursprung0, x1, xy2, y3, ursprung4};
        LinearRing linearRing = GEOM_FACTORY.createLinearRing(coords);
        Polygon result = GEOM_FACTORY.createPolygon(linearRing, null);
        log.info((Object)("Created Geometry: " + result));
        return result;
    }

    public String toString() {
        return "Dokument";
    }
}

