/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.AnnotatedFeature;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.DrawingFeature;
import de.cismet.cismap.commons.features.DrawingFeatureInterface;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PSticky;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import org.deegree.commons.utils.Triple;
import org.deegree.style.se.unevaluated.Style;
import org.deegree.style.styling.LineStyling;
import org.deegree.style.styling.PointStyling;
import org.deegree.style.styling.PolygonStyling;
import org.deegree.style.styling.TextStyling;
import org.deegree.style.styling.components.UOM;
import org.jfree.util.Log;

public class DrawingSLDStyledFeature
extends DefaultFeatureServiceFeature
implements DrawingFeatureInterface,
AnnotatedFeature {
    private static final ImageIcon textAnnotationSymbol = new ImageIcon(DrawingFeature.class.getResource("/de/cismet/cismap/commons/gui/res/transparentPoint.png"));
    private AbstractNewFeature.geomTypes geomType = AbstractNewFeature.geomTypes.UNKNOWN;
    private String text;
    private boolean autoscale = false;

    public DrawingSLDStyledFeature() {
        DefaultLayerProperties layerProps = new DefaultLayerProperties();
        layerProps.getStyle().setMaxScale(Integer.MAX_VALUE);
        this.setLayerProperties(layerProps);
    }

    public DrawingSLDStyledFeature(DrawingFeature feature) {
        DefaultLayerProperties layerProps = new DefaultLayerProperties();
        layerProps.getStyle().setMaxScale(Integer.MAX_VALUE);
        this.setLayerProperties(layerProps);
        if (feature.getGeometryType() != null) {
            this.setGeometryType(feature.getGeometryType());
        }
        this.text = feature.getName();
        this.setId(feature.getId());
        this.setGeometry(feature.getGeometry());
        this.setProperty("sld", feature.getSld());
        if (feature.getGeometryType().equals((Object)this.geomType)) {
            this.setAutoScale(feature.isAutoscale());
            if (feature.getPrimaryAnnotationHalo() != null) {
                this.setPrimaryAnnotationHalo(feature.getPrimaryAnnotationHalo());
            }
            this.setPrimaryAnnotationFont(feature.getPrimaryAnnotationFont());
        }
    }

    @Override
    public int getTypeOrder() {
        return TYPE_ORDER.indexOf((Object)this.getGeometryType());
    }

    @Override
    public AbstractNewFeature.geomTypes getGeometryType() {
        return this.geomType;
    }

    @Override
    public void applyStyle(PFeature pfeature, WorldToScreenTransform wtst) {
        if (this.geomType.equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
            return;
        }
        if (this.styles == null) {
            return;
        }
        this.stylings = null;
        pfeature.setStrokePaint(null);
        pfeature.setStroke(null);
        pfeature.setPaintOnAllFeatures(null);
        pfeature.setPaint(null);
        for (Style tempStyle : this.styles) {
            Style filteredStyle = tempStyle.filter(pfeature.getMappingComponent().getScaleDenominator());
            LinkedList tempStylings = filteredStyle.evaluate(this.getDeegreeFeature(), this.evaluator);
            if (this.stylings == null) {
                this.stylings = tempStylings;
                continue;
            }
            this.stylings.addAll(tempStylings);
        }
        for (PImage image : pfeature.sldStyledImage) {
            if (!(image instanceof PSticky)) continue;
            pfeature.getMappingComponent().removeStickyNode((PSticky)image);
            this.removeChildFromPfeature(pfeature, (PNode)image);
        }
        pfeature.sldStyledImage.clear();
        for (PImage image : pfeature.sldStyledSelectedImage) {
            if (!(image instanceof PSticky)) continue;
            pfeature.getMappingComponent().removeStickyNode((PSticky)image);
            this.removeChildFromPfeature(pfeature, (PNode)image);
        }
        pfeature.sldStyledSelectedImage.clear();
        if (this.geomType.equals((Object)AbstractNewFeature.geomTypes.POINT) && !this.hasPointStyling()) {
            return;
        }
        if (!this.geomType.equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
            Iterator<Object> it = pfeature.getChildrenIterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (!(child instanceof PSticky)) continue;
                pfeature.getMappingComponent().removeStickyNode((PSticky)child);
            }
            pfeature.removeAllChildren();
        }
        pfeature.sldStyledPolygon.clear();
        for (PFeature.PTextWithDisplacement text : pfeature.sldStyledText) {
            pfeature.getMappingComponent().removeStickyNode(text);
            this.removeChildFromPfeature(pfeature, (PNode)text);
        }
        pfeature.sldStyledText.clear();
        if (this.stylings == null || this.stylings.size() == 0) {
            return;
        }
        Geometry geom = pfeature.getFeature().getGeometry();
        int polygonNr = -1;
        int textNr = 0;
        int imageNr = 0;
        for (Triple styling : this.stylings) {
            PImage selectedImage;
            PImage image;
            PFeature path;
            if (styling.first instanceof PolygonStyling && (geom instanceof Polygon || geom instanceof MultiPolygon)) {
                if (polygonNr < 0) {
                    path = pfeature;
                } else {
                    try {
                        path = pfeature.sldStyledPolygon.get(polygonNr);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        path = new PPath();
                        pfeature.sldStyledPolygon.add(path);
                        pfeature.addChild((PNode)path);
                    }
                    path.setPathTo(pfeature.getPathReference());
                }
                this.applyPolygonStyling(path, (PolygonStyling)styling.first, pfeature.getMappingComponent());
                ++polygonNr;
                continue;
            }
            if (styling.first instanceof LineStyling && (geom instanceof LineString || geom instanceof MultiLineString)) {
                if (polygonNr < 0) {
                    path = pfeature;
                } else {
                    try {
                        path = pfeature.sldStyledPolygon.get(polygonNr);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        path = new PPath();
                        pfeature.sldStyledPolygon.add(path);
                        pfeature.addChild((PNode)path);
                    }
                    path.setPathTo(pfeature.getPathReference());
                }
                this.applyLineStyling(path, (LineStyling)styling.first, pfeature.getMappingComponent());
                ++polygonNr;
                continue;
            }
            if (styling.first instanceof TextStyling) {
                PFeature.PTextWithDisplacement text;
                try {
                    text = pfeature.sldStyledText.get(textNr++);
                }
                catch (IndexOutOfBoundsException ex) {
                    text = new PFeature.PTextWithDisplacement(pfeature);
                    pfeature.sldStyledText.add(text);
                    pfeature.addChild((PNode)text);
                    pfeature.getMappingComponent().addStickyNode(text);
                }
                Point intPoint = CrsTransformer.transformToGivenCrs(this.getGeometry(), pfeature.getMappingComponent().getMappingModel().getSrs().getCode()).getInteriorPoint();
                this.applyTextStyling(text, (String)styling.third, (TextStyling)styling.first, wtst, intPoint.getX(), intPoint.getY());
                this.rescaleStickyNode(pfeature, text);
                continue;
            }
            if (!(styling.first instanceof PointStyling) || !(geom instanceof Point) && !(geom instanceof MultiPoint)) continue;
            try {
                image = pfeature.sldStyledImage.get(imageNr);
                selectedImage = pfeature.sldStyledSelectedImage.get(imageNr++);
            }
            catch (IndexOutOfBoundsException ex) {
                if (((PointStyling)styling.first).uom == UOM.Pixel) {
                    image = new FixedPImage();
                    pfeature.getMappingComponent().addStickyNode((PSticky)image);
                    selectedImage = new FixedPImage();
                    pfeature.getMappingComponent().addStickyNode((PSticky)selectedImage);
                } else {
                    image = new PImage();
                    selectedImage = new PImage();
                }
                pfeature.sldStyledImage.add(image);
                pfeature.sldStyledSelectedImage.add(selectedImage);
                pfeature.addChild((PNode)image);
            }
            if (((PointStyling)styling.first).uom == UOM.Pixel) {
                if (!(image instanceof FixedPImage)) {
                    pfeature.removeChild((PNode)image);
                    pfeature.sldStyledImage.remove(image);
                    pfeature.sldStyledSelectedImage.remove(selectedImage);
                    image = new FixedPImage();
                    pfeature.sldStyledImage.add(image);
                    pfeature.sldStyledSelectedImage.add(selectedImage);
                    pfeature.addChild((PNode)image);
                    pfeature.addChild((PNode)selectedImage);
                    pfeature.getMappingComponent().addStickyNode((PSticky)image);
                    pfeature.getMappingComponent().addStickyNode((PSticky)selectedImage);
                }
            } else if (image instanceof FixedPImage) {
                pfeature.getMappingComponent().removeStickyNode((PSticky)image);
                pfeature.sldStyledImage.remove(image);
                pfeature.sldStyledSelectedImage.remove(selectedImage);
                pfeature.removeChild((PNode)image);
                image = new PImage();
                pfeature.sldStyledImage.add(image);
                pfeature.sldStyledSelectedImage.add(selectedImage);
                pfeature.addChild((PNode)image);
            }
            Point intPoint = CrsTransformer.transformToGivenCrs(this.getGeometry(), pfeature.getMappingComponent().getMappingModel().getSrs().getCode()).getInteriorPoint();
            this.applyPointStyling(image, (PointStyling)styling.first, wtst, intPoint.getX(), intPoint.getY(), pfeature.getMappingComponent().getCamera(), false);
            this.applyPointStyling(selectedImage, (PointStyling)styling.first, wtst, intPoint.getX(), intPoint.getY(), pfeature.getMappingComponent().getCamera(), true);
            if (((PointStyling)styling.first).uom != UOM.Pixel) continue;
            this.rescaleStickyNode(pfeature, (PSticky)image);
            this.rescaleStickyNode(pfeature, (PSticky)selectedImage);
        }
        if (polygonNr == -1 && imageNr == 0 && textNr == 0) {
            Log.warn((Object)"Es wurde kein passender Symbolizer f\u00fcr das Feature gefunden, Darstellung unm\u00f6glich.");
        }
    }

    private void removeChildFromPfeature(PFeature pfeature, PNode node) {
        if (pfeature.indexOfChild(node) != -1) {
            pfeature.removeChild(node);
        }
    }

    private boolean hasPointStyling() {
        int styles = 0;
        for (Triple styling : this.stylings) {
            if (!(styling.first instanceof PointStyling) || ++styles <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPrimaryAnnotation() {
        if (AbstractNewFeature.geomTypes.TEXT.equals((Object)this.geomType)) {
            return this.getText();
        }
        return super.getPrimaryAnnotation();
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isAutoscale() {
        return this.autoscale;
    }

    @Override
    public void setAutoScale(boolean autoScale) {
        this.autoscale = autoScale;
    }

    public void setGeometryType(AbstractNewFeature.geomTypes geomType) {
        this.geomType = geomType == null ? AbstractNewFeature.geomTypes.UNKNOWN : geomType;
    }

    @Override
    public boolean isPrimaryAnnotationVisible() {
        if (AbstractNewFeature.geomTypes.TEXT.equals((Object)this.geomType)) {
            return true;
        }
        return super.isPrimaryAnnotationVisible();
    }

    @Override
    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        if (AbstractNewFeature.geomTypes.TEXT.equals((Object)this.geomType)) {
            FeatureAnnotationSymbol symbol = new FeatureAnnotationSymbol(textAnnotationSymbol.getImage());
            symbol.setSweetSpotX(0.0);
            symbol.setSweetSpotY(0.0);
            symbol.setOffset(0.0, 0.0);
            return symbol;
        }
        return super.getPointAnnotationSymbol();
    }

    @Override
    public float getTransparency() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().getAlpha();
        }
        return 1.0f;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getName() {
        return this.getText();
    }
}

