/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import java.util.Set;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class FeatureCollectionAndListModel
extends DefaultFeatureCollection
implements ListSelectionModel {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    protected Vector<ListSelectionListener> listSelectionListeners = new Vector();
    protected int leadIndex = 0;
    protected int anchorIndex = 0;
    protected boolean valueIsAdjusting = false;
    private final Logger log = Logger.getLogger(this.getClass());
    private int selectionMode = 2;
    private int firstChangedIndex = Integer.MAX_VALUE;
    private int lastChangedIndex = -1;
    private int firstAdjustedIndex = Integer.MAX_VALUE;
    private int lastAdjustedIndex = -1;

    @Override
    public void setSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = selectionMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        try {
            this.leadIndex = index;
            if (this.selectedFeatures.size() > 0) {
                int from = -1;
                int to = -1;
                if (index > this.getAnchorSelectionIndex()) {
                    from = this.getAnchorSelectionIndex();
                    to = index;
                } else {
                    from = index;
                    to = this.getAnchorSelectionIndex();
                }
                Vector<Feature> v = new Vector<Feature>();
                for (int i = from; i <= to; ++i) {
                    v.add(this.getAllFeatures().get(i));
                }
                this.select(v);
            }
            this.fireValueChanged();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in setLeadSelectionIndex", t);
        }
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        try {
            this.anchorIndex = index;
            if (index > -1) {
                this.select((Feature)this.features.get(index));
                this.fireValueChanged();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in setAnchorSelectionIndex", t);
        }
    }

    @Override
    public boolean isSelectedIndex(int index) {
        try {
            return this.isSelected(this.getAllFeatures().get(index));
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in isSelectedIndex", t);
            return false;
        }
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        try {
            this.valueIsAdjusting = valueIsAdjusting;
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in setValueIsAdjusting", t);
        }
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener x) {
        this.listSelectionListeners.remove(x);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener x) {
        this.listSelectionListeners.add(x);
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        try {
            this.select(this.getVectorOfFeatures(index0, index1));
            this.fireValueChanged();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in setSelectionInterval", t);
        }
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        try {
            this.unselect(this.getVectorOfFeatures(index0, index1));
            this.fireValueChanged();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in removeSelectionInterval", t);
        }
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        try {
            this.addToSelection(this.getVectorOfFeatures(index0, index1));
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in addSelectionInterval", t);
        }
    }

    @Override
    public void clearSelection() {
        try {
            this.unselectAll();
            this.fireValueChanged();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in clearSelection", t);
        }
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    @Override
    public int getMaxSelectionIndex() {
        try {
            if (this.selectedFeatures.isEmpty()) {
                return -1;
            }
            int ret = -1;
            Set c = this.selectedFeatures;
            for (Feature f : c) {
                int index = this.getAllFeatures().indexOf(f);
                if (index <= ret) continue;
                ret = index;
            }
            return ret;
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in getMaxSelectionIndex", t);
            return -1;
        }
    }

    @Override
    public int getMinSelectionIndex() {
        try {
            if (this.selectedFeatures.isEmpty()) {
                return -1;
            }
            int ret = this.features.size();
            Set c = this.selectedFeatures;
            for (Feature f : c) {
                int index = this.getAllFeatures().indexOf(f);
                if (index >= ret) continue;
                ret = index;
            }
            return ret;
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in getMinSelectionIndex", t);
            return -1;
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public boolean isSelectionEmpty() {
        try {
            return this.selectedFeatures.isEmpty();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in isSelectionEmpty", t);
            return true;
        }
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        try {
            this.removeFeatures(this.getVectorOfFeatures(index0, index1));
            this.fireValueChanged();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in ", t);
        }
    }

    private Vector<Feature> getVectorOfFeatures(int index0, int index1) {
        try {
            int from = -1;
            int to = -1;
            if (index0 < index1) {
                from = index0;
                to = index1;
            } else {
                from = index1;
                to = index0;
            }
            this.anchorIndex = from;
            this.leadIndex = to;
            Vector<Feature> v = new Vector<Feature>();
            for (int i = from; i <= to; ++i) {
                v.add(this.getAllFeatures().get(i));
            }
            return v;
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in getVectorOfFeatures", t);
            return null;
        }
    }

    protected void fireValueChanged(boolean isAdjusting) {
        if (this.lastChangedIndex == -1) {
            return;
        }
        int oldFirstChangedIndex = this.firstChangedIndex;
        int oldLastChangedIndex = this.lastChangedIndex;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.fireValueChanged(oldFirstChangedIndex, oldLastChangedIndex, isAdjusting);
    }

    protected void fireValueChanged(int firstIndex, int lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        for (ListSelectionListener l : this.listSelectionListeners) {
            ListSelectionEvent e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            l.valueChanged(e);
        }
    }

    private void fireValueChanged() {
        if (this.lastAdjustedIndex == -1) {
            return;
        }
        if (this.getValueIsAdjusting()) {
            this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
            this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
        }
        int oldFirstAdjustedIndex = this.firstAdjustedIndex;
        int oldLastAdjustedIndex = this.lastAdjustedIndex;
        this.firstAdjustedIndex = Integer.MAX_VALUE;
        this.lastAdjustedIndex = -1;
        this.fireValueChanged(oldFirstAdjustedIndex, oldLastAdjustedIndex);
    }
}

