/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.SubFeature;
import de.cismet.tools.collections.TypeSafeCollections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public final class FeatureGroups {
    private static final Logger log = Logger.getLogger(FeatureGroups.class);
    public static final boolean SHOW_GROUPING_ENABLED = false;
    public static final boolean SHOW_GROUPS_AS_ENVELOPES = false;

    private FeatureGroups() {
        throw new AssertionError();
    }

    public static boolean hasSubFeatures(FeatureGroup fg) {
        Collection<? extends Feature> subFeatures = fg.getFeatures();
        return subFeatures != null && subFeatures.size() != 0;
    }

    public static Collection<? extends Feature> expand(FeatureGroup featureGroup, boolean includeGroups) {
        ArrayList result = TypeSafeCollections.newArrayList();
        Collection<? extends Feature> subFeatures = featureGroup.getFeatures();
        if (subFeatures != null) {
            for (Feature f : featureGroup) {
                if (f instanceof FeatureGroup) {
                    result.addAll(FeatureGroups.expand((FeatureGroup)f, includeGroups));
                    continue;
                }
                result.add(f);
            }
        }
        if (includeGroups || result.size() == 0) {
            result.add(featureGroup);
        }
        return result;
    }

    public static Collection<? extends Feature> expandAll(FeatureGroup fg) {
        return FeatureGroups.expand(fg, true);
    }

    public static Collection<? extends Feature> expandToLeafs(FeatureGroup fg) {
        return FeatureGroups.expand(fg, false);
    }

    public static Geometry getEnclosingGeometry(FeatureGroup group) {
        return FeatureGroups.getEnclosingGeometry(group.getFeatures());
    }

    public static Geometry getEnclosingGeometry(Collection<? extends Feature> featureCollection) {
        boolean hasLinestringOrPoints = false;
        Geometry union = null;
        Geometry[] array = new Geometry[featureCollection.size()];
        int i = 0;
        try {
            for (Feature feature : featureCollection) {
                Geometry newGeom = feature.getGeometry();
                if (!(hasLinestringOrPoints || newGeom instanceof Polygon || newGeom instanceof MultiPolygon)) {
                    hasLinestringOrPoints = true;
                }
                if (newGeom == null) continue;
                array[i++] = newGeom;
            }
            int srid = 0;
            if (array.length > 0) {
                srid = array[0].getSRID();
            }
            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
            if (!hasLinestringOrPoints) {
                GeometryCollection collection = geometryFactory.createGeometryCollection(array);
                union = collection.buffer(0.0);
            } else {
                union = geometryFactory.buildGeometry(Arrays.asList(array));
                if (union instanceof GeometryCollection) {
                    union = ((GeometryCollection)union).union();
                }
            }
            return union;
        }
        catch (Exception e) {
            log.error((Object)"Error during creation of enclosing geom", (Throwable)e);
            return null;
        }
    }

    public static FeatureGroup getRootFeature(FeatureGroup hierarchyMember) {
        while (hierarchyMember.getParentFeature() != null) {
            hierarchyMember = hierarchyMember.getParentFeature();
        }
        return hierarchyMember;
    }

    public static Feature getRootFeature(SubFeature hierarchyMember) {
        while (hierarchyMember.getParentFeature() != null) {
            hierarchyMember = hierarchyMember.getParentFeature();
        }
        return hierarchyMember;
    }
}

