/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.util.SimpleCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JDBCFeatureInfo {
    private static final Logger LOG = Logger.getLogger(JDBCFeatureInfo.class);
    private final SimpleCache<LinkedHashMap<String, Object>> cache = new SimpleCache(2);
    private final SimpleCache<Geometry> geoCache = new SimpleCache(1);
    private final SimpleCache<Object> propertyCache = new SimpleCache(10);
    private int srid;
    private Connection connection;
    private PreparedStatement geometryStatement;
    private PreparedStatement propertiesStatement;
    private String tableName;
    private final String geoField;
    private final Map<String, PreparedStatement> propStats = new HashMap<String, PreparedStatement>();
    private String idField = "id";

    public JDBCFeatureInfo(Connection connection, int srid, String geoField, String tableName, String idField) {
        this.connection = connection;
        this.srid = srid;
        this.tableName = tableName;
        this.geoField = geoField;
        this.idField = idField;
        this.createStatements();
    }

    private void createStatements() {
        try {
            if (this.getGeoField() != null) {
                this.geometryStatement = this.connection.prepareStatement("select \"" + this.getGeoField() + "\" from \"" + this.tableName + "\" where \"" + this.idField + "\" = ?");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating prepared statement for geometries", (Throwable)e);
        }
        try {
            this.propertiesStatement = this.connection.prepareStatement("select * from \"" + this.tableName + "\" where \"" + this.idField + "\" = ?");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating prepared statement for properties", (Throwable)e);
        }
    }

    public PreparedStatement getPreparedStatementForProperty(String property) {
        PreparedStatement ps = this.propStats.get(property);
        if (ps == null) {
            try {
                String query = "select \"" + property + "\" from \"" + this.tableName + "\" WHERE \"" + this.idField + "\" = ?";
                ps = this.connection.prepareStatement(query);
                this.propStats.put(property, ps);
            }
            catch (Exception e) {
                LOG.error((Object)("Error while creating prepared statement for property " + property), (Throwable)e);
            }
        }
        return ps;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    public synchronized LinkedHashMap<String, Object> getPropertiesFromCache(int id) {
        return this.cache.get(id);
    }

    public synchronized void addPropertiesToCache(int id, LinkedHashMap<String, Object> container) {
        this.cache.add(id, container);
    }

    public synchronized void clearCache() {
        this.cache.clear();
        this.geoCache.clear();
        this.propertyCache.clear();
    }

    public synchronized Object getPropertyFromCache(String id) {
        return this.propertyCache.get(id);
    }

    public synchronized void addPropertyToCache(String id, Object container) {
        this.propertyCache.add(id, container);
    }

    public synchronized Geometry getGeometryFromCache(int id) {
        return this.geoCache.get(id);
    }

    public synchronized void addGeometryToCache(int id, Geometry geo) {
        this.geoCache.add(id, geo);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public PreparedStatement getGeometryStatement() {
        return this.geometryStatement;
    }

    public PreparedStatement getPropertiesStatement() {
        return this.propertiesStatement;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.propStats.clear();
        this.createStatements();
    }

    public String getGeoField() {
        return this.geoField;
    }

    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }
}

