/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.tools.collections.TypeSafeCollections;
import java.awt.Paint;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class PureFeatureGroup
implements FeatureGroup,
StyledFeature {
    private final Logger log = Logger.getLogger(this.getClass());
    private String myAttributeStringInParentFeature = null;
    private FeatureGroup parentFeature = null;
    private final Set<Feature> groupFeatures;
    private final Collection<Feature> readOnlyGroupFeatures;
    private Geometry enclosingGeometry;

    public PureFeatureGroup() {
        this(Collections.EMPTY_LIST);
    }

    public PureFeatureGroup(Feature feature) {
        this();
        this.groupFeatures.add(feature);
    }

    public PureFeatureGroup(Collection<? extends Feature> features) {
        this.groupFeatures = features == null || features.size() <= 0 ? TypeSafeCollections.newHashSet() : TypeSafeCollections.newHashSet(features);
        this.readOnlyGroupFeatures = Collections.unmodifiableCollection(this.groupFeatures);
    }

    @Override
    public boolean addFeature(Feature toAdd) {
        boolean changeHappened = this.groupFeatures.add(toAdd);
        if (changeHappened) {
            this.enclosingGeometry = null;
        }
        return changeHappened;
    }

    @Override
    public boolean addFeatures(Collection<? extends Feature> toAdd) {
        boolean changeHappened = this.groupFeatures.addAll(toAdd);
        if (changeHappened) {
            this.enclosingGeometry = null;
        }
        return changeHappened;
    }

    @Override
    public boolean removeFeature(Feature toRemove) {
        boolean changeHappened = this.groupFeatures.remove(toRemove);
        if (changeHappened) {
            this.enclosingGeometry = null;
        }
        return changeHappened;
    }

    @Override
    public boolean removeFeatures(Collection<? extends Feature> toRemove) {
        boolean changeHappened = this.groupFeatures.removeAll(toRemove);
        if (changeHappened) {
            this.enclosingGeometry = null;
        }
        return changeHappened;
    }

    @Override
    public Geometry getGeometry() {
        if (this.enclosingGeometry == null) {
            this.refreshEnclosingGeometry();
        }
        return this.enclosingGeometry;
    }

    @Override
    public void setGeometry(Geometry geom) {
        this.log.warn((Object)"Call for setGeometry(...) on FeatureGroup has no effects");
    }

    @Override
    public boolean canBeSelected() {
        return false;
    }

    @Override
    public void setCanBeSelected(boolean canBeSelected) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setEditable(boolean editable) {
        this.log.warn((Object)"Call for setEditable(...) on FeatureGroup has no effects");
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void hide(boolean hiding) {
    }

    @Override
    public Iterator<Feature> iterator() {
        return new IteratorWrapper(this.groupFeatures.iterator());
    }

    public Feature[] toArray() {
        return this.groupFeatures.toArray(new Feature[this.groupFeatures.size()]);
    }

    public int getSize() {
        return this.groupFeatures.size();
    }

    private void refreshEnclosingGeometry() {
        this.enclosingGeometry = FeatureGroups.getEnclosingGeometry(this.groupFeatures);
    }

    @Override
    public Collection<? extends Feature> getFeatures() {
        return this.readOnlyGroupFeatures;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parentFeature instanceof XStyledFeature) {
            sb.append(((XStyledFeature)((Object)this.parentFeature)).getName());
        } else {
            sb.append(this.parentFeature);
        }
        sb.append(".");
        sb.append(this.myAttributeStringInParentFeature);
        return sb.toString();
    }

    @Override
    public Paint getLinePaint() {
        return null;
    }

    @Override
    public void setLinePaint(Paint linePaint) {
    }

    @Override
    public int getLineWidth() {
        return 0;
    }

    @Override
    public void setLineWidth(int width) {
    }

    @Override
    public Paint getFillingPaint() {
        return null;
    }

    @Override
    public void setFillingPaint(Paint fillingStyle) {
    }

    @Override
    public float getTransparency() {
        return 0.0f;
    }

    @Override
    public void setTransparency(float transparrency) {
    }

    @Override
    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        return null;
    }

    @Override
    public void setPointAnnotationSymbol(FeatureAnnotationSymbol featureAnnotationSymbol) {
    }

    @Override
    public boolean isHighlightingEnabled() {
        return false;
    }

    @Override
    public void setHighlightingEnabled(boolean enabled) {
    }

    public Geometry getEnclosingGeometry() {
        return this.enclosingGeometry;
    }

    @Override
    public String getMyAttributeStringInParentFeature() {
        return this.myAttributeStringInParentFeature;
    }

    @Override
    public void setMyAttributeStringInParentFeature(String myAttributeStringInParentFeature) {
        this.myAttributeStringInParentFeature = myAttributeStringInParentFeature;
    }

    @Override
    public FeatureGroup getParentFeature() {
        return this.parentFeature;
    }

    @Override
    public void setParentFeature(FeatureGroup parentFeature) {
        this.parentFeature = parentFeature;
    }

    final class IteratorWrapper
    implements Iterator<Feature> {
        private final Iterator<Feature> delegate;

        public IteratorWrapper(Iterator<Feature> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Feature next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            PureFeatureGroup.this.enclosingGeometry = null;
            this.delegate.remove();
        }
    }
}

