/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DoubleClickableFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SelectFeature
extends AbstractNewFeature
implements DoubleClickableFeature {
    private static final Logger LOG = Logger.getLogger(SelectFeature.class);
    private String inputListenerName;

    public SelectFeature(Geometry g, String inputListenerName) {
        super(g);
        this.inputListenerName = inputListenerName;
    }

    public SelectFeature(Point2D point, WorldToScreenTransform wtst) {
        super(point, wtst);
    }

    public SelectFeature(Point2D[] canvasPoints, WorldToScreenTransform wtst) {
        super(canvasPoints, wtst);
    }

    public SelectFeature(Coordinate[] coordArr, WorldToScreenTransform wtst) {
        super(coordArr, wtst);
    }

    public String getInputListenerName() {
        return this.inputListenerName;
    }

    public void setInputListenerName(String inputListenerName) {
        this.inputListenerName = inputListenerName;
    }

    @Override
    public Paint getFillingPaint() {
        SelectionListener selectListener = (SelectionListener)CismapBroker.getInstance().getMappingComponent().getInputListener("SELECT");
        return selectListener.getSelectColor();
    }

    @Override
    public Paint getLinePaint() {
        Color color = (Color)this.getFillingPaint();
        return color.darker();
    }

    @Override
    public String getName() {
        if (this.getGeometryType() != null) {
            switch (this.getGeometryType()) {
                case RECTANGLE: {
                    return NbBundle.getMessage(SelectFeature.class, (String)"SelectFeature.etName().selectRectangle");
                }
                case LINESTRING: {
                    return NbBundle.getMessage(SelectFeature.class, (String)"SelectFeature.getName().selectPolyline");
                }
                case ELLIPSE: {
                    return NbBundle.getMessage(SelectFeature.class, (String)"SelectFeature.getName().selectEllipse");
                }
                case POINT: {
                    return NbBundle.getMessage(SelectFeature.class, (String)"SelectFeature.getName().selectPoint");
                }
                case POLYGON: {
                    return NbBundle.getMessage(SelectFeature.class, (String)"SelectFeature.getName().selectPOLYGON");
                }
                case MULTIPOLYGON: {
                    return NbBundle.getMessage(SelectFeature.class, (String)"SelectFeature.getName().selectMULTIPOLYGON");
                }
            }
            if (super.getName() != null) {
                return super.getName();
            }
            return "---";
        }
        return "--";
    }

    @Override
    public String getType() {
        return "Auswahl";
    }

    @Override
    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        int strokeWidth = 4;
        int imageSize = 24;
        int circleSize = 16;
        Color color = (Color)this.getFillingPaint();
        BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(4.0f));
        graphics.drawOval(4, 4, 16, 16);
        FeatureAnnotationSymbol pointAnnotationSymbol = FeatureAnnotationSymbol.newCustomSweetSpotFeatureAnnotationSymbol(bufferedImage, null, 0.5, 0.5);
        return pointAnnotationSymbol;
    }

    public String getInteractionMode() {
        return this.inputListenerName;
    }

    @Override
    public void doubleClickPerformed(SelectionListener selectionListener) {
        MappingComponent mappingComponent = selectionListener.getMappingComponent();
        ((DefaultFeatureCollection)mappingComponent.getFeatureCollection()).unselectAll();
        mappingComponent.getHandleLayer().removeAllChildren();
        selectionListener.select(this);
    }
}

