/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.features.ShapeInfo;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.factory.ShapeFeatureFactory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.SimpleFeatureCollection;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.deegree.feature.Feature;
import org.deegree.feature.types.FeatureType;
import org.deegree.io.shpapi.shape_new.ShapeFile;
import org.deegree.io.shpapi.shape_new.ShapeFileWriter;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.JTSAdapter;
import org.deegree.style.se.unevaluated.Style;

public class ShapeFeature
extends DefaultFeatureServiceFeature
implements ModifiableFeature {
    private static final Object sync = new Object();
    private final ShapeInfo shapeInfo;
    private com.vividsolutions.jts.geom.Geometry geom;
    private boolean isChanged;

    public ShapeFeature(ShapeInfo shapeInfo) {
        this.shapeInfo = shapeInfo;
    }

    public ShapeFeature(ShapeInfo shapeInfo, List<Style> styles) {
        this.setSLDStyles(styles);
        this.shapeInfo = shapeInfo;
    }

    @Override
    public void setEditable(boolean editable) {
        boolean oldEditableStatus = this.isEditable();
        super.setEditable(editable);
        if (oldEditableStatus != editable) {
            this.isChanged = false;
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().unholdFeature(this);
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature(this);
            if (editable) {
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(this);
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getProperties() {
        LinkedHashMap<Object, Object> container = null;
        int id = this.getId();
        if (this.existProperties()) {
            return super.getProperties();
        }
        if (this.shapeInfo.getFc() == null) {
            try {
                FeatureProperty[] featureProperties;
                container = this.shapeInfo.getPropertiesFromCache(id);
                if (container != null) {
                    return container;
                }
                container = new LinkedHashMap();
                org.deegree.model.feature.Feature degreeFeature = null;
                Object object = sync;
                synchronized (object) {
                    degreeFeature = this.shapeInfo.getFile().getFeatureByRecNo(id);
                }
                for (FeatureProperty fp : featureProperties = degreeFeature.getProperties()) {
                    container.put(fp.getName().getAsString(), fp.getValue());
                }
                this.shapeInfo.addPropertiesToCache(id, container);
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot read properties from file.", (Throwable)e);
            }
        } else {
            container = new LinkedHashMap();
            try {
                FeatureProperty[] featureProperties;
                org.deegree.model.feature.Feature degreeFeature = this.shapeInfo.getFc().getFeature(id);
                for (FeatureProperty fp : featureProperties = degreeFeature.getProperties()) {
                    container.put(fp.getName().getAsString(), fp.getValue());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot read properties from file.", (Throwable)e);
            }
        }
        return container;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        if (!this.existProperties()) {
            super.setProperties(this.getProperties());
        }
        this.isChanged = true;
        super.addProperty(propertyName, propertyValue);
    }

    private boolean existProperties() {
        return !super.getProperties().isEmpty();
    }

    @Override
    public FeatureServiceFeature saveChanges() throws Exception {
        AbstractFeatureService featureService = this.getLayerProperties().getFeatureService();
        List features = featureService.retrieveFeatures(null, 0, 0, null);
        features.remove(this);
        features.add(this);
        Collections.sort(features, new Comparator<FeatureServiceFeature>(){

            @Override
            public int compare(FeatureServiceFeature o1, FeatureServiceFeature o2) {
                return Integer.compare(o1.getId(), o2.getId());
            }
        });
        SimpleFeatureCollection fc = new SimpleFeatureCollection(String.valueOf(System.currentTimeMillis()), features.toArray(new FeatureServiceFeature[features.size()]), null);
        String filename = ((ShapeFileFeatureService)featureService).getDocumentURI().getPath();
        File shapeFile = new File(filename);
        if (shapeFile.exists()) {
            File[] files;
            String file = shapeFile.getName();
            if (file.contains(".")) {
                file = file.substring(0, file.lastIndexOf("."));
            }
            final String nameStem = file;
            for (File f : files = shapeFile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().substring(0, nameStem.length()).equals(nameStem);
                }
            })) {
                if (!f.getName().endsWith(".sbx") && !f.getName().endsWith(".rti")) continue;
                f.delete();
            }
        }
        if (filename.contains(".")) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        ShapeFile shape = new ShapeFile((FeatureCollection)fc, filename);
        ShapeFileWriter writer = new ShapeFileWriter(shape);
        writer.write();
        ((ShapeFeatureFactory)featureService.getFeatureFactory()).refreshData();
        super.getProperties().clear();
        this.geom = null;
        this.isChanged = false;
        return this;
    }

    @Override
    public void undoAll() {
        super.getProperties().clear();
        this.geom = null;
    }

    @Override
    public void addProperty(String propertyName, Object property) {
    }

    @Override
    public void addProperties(Map<String, Object> map) {
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getGeometry() {
        if (this.geom != null) {
            return this.geom;
        }
        com.vividsolutions.jts.geom.Geometry g = null;
        if (this.shapeInfo.getFc() == null) {
            g = this.shapeInfo.getGeometryFromCache(this.getId());
            if (g != null) {
                return g;
            }
            try {
                g = JTSAdapter.export((Geometry)this.shapeInfo.getFile().getGeometryByRecNo(this.getId()));
                g.setSRID(this.shapeInfo.getSrid());
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot read geometry from shape file.", (Throwable)e);
            }
            this.shapeInfo.addGeometryToCache(this.getId(), g);
        } else {
            try {
                g = JTSAdapter.export((Geometry)this.shapeInfo.getFc().getFeature(this.getId()).getDefaultGeometryPropertyValue());
                g.setSRID(this.shapeInfo.getSrid());
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot read geometry from shape file.", (Throwable)e);
            }
        }
        return g;
    }

    @Override
    public void setGeometry(com.vividsolutions.jts.geom.Geometry geom) {
        this.geom = geom;
        this.isChanged = true;
    }

    @Override
    protected Feature getDeegreeFeature() {
        return new ShapeFileLayerDeegreeFeature();
    }

    @Override
    public void saveChangesWithoutReload() throws Exception {
        this.saveChanges();
    }

    @Override
    public void delete() throws Exception {
    }

    @Override
    public void restore() throws Exception {
    }

    @Override
    public boolean isFeatureChanged() {
        return this.isChanged;
    }

    protected class ShapeFileLayerDeegreeFeature
    extends DefaultFeatureServiceFeature.DeegreeFeature {
        protected ShapeFileLayerDeegreeFeature() {
        }

        @Override
        public FeatureType getType() {
            return new DefaultFeatureServiceFeature.DeegreeFeatureType(){

                @Override
                public QName getName() {
                    return new QName("Feature");
                }
            };
        }
    }
}

