/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.deegree.io.shpapi.ShapeFile;
import org.deegree.model.feature.FeatureCollection;

public class ShapeInfo {
    private Cache<LinkedHashMap<String, Object>> cache = new Cache(2);
    private Cache<Geometry> geoCache = new Cache(1);
    private String typename;
    private ShapeFile file;
    private int srid;
    private FeatureCollection fc;

    public ShapeInfo(String typename, ShapeFile file, int srid, FeatureCollection fc) {
        this.typename = typename;
        this.file = file;
        this.srid = srid;
        this.fc = fc;
    }

    public String getTypename() {
        return this.typename;
    }

    public void setTypename(String typename) {
        this.typename = typename;
    }

    public ShapeFile getFile() {
        return this.file;
    }

    public void setFile(ShapeFile file) {
        this.file = file;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    public FeatureCollection getFc() {
        return this.fc;
    }

    public void setFc(FeatureCollection fc) {
        this.fc = fc;
    }

    public synchronized LinkedHashMap<String, Object> getPropertiesFromCache(int id) {
        return this.cache.get(id);
    }

    public synchronized void addPropertiesToCache(int id, LinkedHashMap<String, Object> container) {
        this.cache.add(id, container);
    }

    public synchronized Geometry getGeometryFromCache(int id) {
        return this.geoCache.get(id);
    }

    public synchronized void addGeometryToCache(int id, Geometry geo) {
        this.geoCache.add(id, geo);
    }

    private class Cache<T> {
        private Integer[] ids;
        private int index = 0;
        private Map<Integer, T> dataMap;

        public Cache(int size) {
            this.init(size);
        }

        private void init(int size) {
            this.ids = new Integer[size];
            this.index = 0;
            this.dataMap = new HashMap<Integer, T>();
        }

        public void add(int id, T data) {
            if (this.ids[this.index] != null) {
                this.dataMap.remove(this.ids[this.index]);
            }
            this.ids[this.index] = id;
            this.increaseIndex();
            this.dataMap.put(id, data);
        }

        public T get(int id) {
            T res = this.dataMap.get(id);
            if (res != null) {
                while (this.ids[this.index] == null || this.ids[this.index] != id) {
                    this.increaseIndex();
                }
                this.increaseIndex();
            }
            return res;
        }

        private void setSize(int size) {
            this.init(size);
        }

        private void increaseIndex() {
            ++this.index;
            if (this.index >= this.ids.length) {
                this.index = 0;
            }
        }
    }
}

