/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.XMLObjectFactory;
import de.cismet.cismap.commons.features.DefaultFeatureSimplifier;
import de.cismet.cismap.commons.features.FeatureSimplifier;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.style.BasicStyle;
import de.cismet.cismap.commons.featureservice.style.Style;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.DefaultAttributeTableRuleSet;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class DefaultLayerProperties
implements LayerProperties {
    protected static final Logger logger = Logger.getLogger(DefaultLayerProperties.class);
    private Style style;
    private int idExpressionType = -1;
    private int primaryAnnotationExpressionType = -1;
    private int secondaryAnnotationExpressionType = -1;
    private int queryType = -1;
    private String idExpression;
    private String primaryAnnotationExpression;
    private String secondaryAnnotationExpression;
    private boolean idExpressionEnabled = true;
    private AbstractFeatureService featureService;
    private AttributeTableRuleSet attributeTableRuleSet;
    private FeatureSimplifier featureSimplifier;

    public DefaultLayerProperties() {
        this.style = new BasicStyle();
    }

    public DefaultLayerProperties(Style style) {
        this.style = style;
    }

    public DefaultLayerProperties(Element element) throws Exception {
        this.initFromElement(element);
    }

    public DefaultLayerProperties(LayerProperties layerProperties) {
        this.assign(layerProperties);
    }

    @Override
    public LayerProperties clone() {
        return new DefaultLayerProperties(this);
    }

    @Override
    public void setStyle(Style featureStyle) {
        this.style = featureStyle;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public String getIdExpression() {
        return this.idExpression;
    }

    @Override
    public void setIdExpression(String idExpression, int type) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setIdExpression: '" + idExpression + "', " + type));
        }
        this.idExpression = idExpression;
        this.idExpressionType = type;
    }

    @Override
    public int getIdExpressionType() {
        return this.idExpressionType;
    }

    @Override
    public String getPrimaryAnnotationExpression() {
        return this.primaryAnnotationExpression;
    }

    @Override
    public int getPrimaryAnnotationExpressionType() {
        return this.primaryAnnotationExpressionType;
    }

    @Override
    public void setPrimaryAnnotationExpression(String primaryAnnotationExpression, int type) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setPrimaryAnnotationExpression: '" + primaryAnnotationExpression + "', " + type));
        }
        this.primaryAnnotationExpression = primaryAnnotationExpression;
        this.primaryAnnotationExpressionType = type;
        if (this.style != null) {
            this.style.setLabel(primaryAnnotationExpression);
        }
    }

    @Override
    public String getSecondaryAnnotationExpression() {
        return this.secondaryAnnotationExpression;
    }

    @Override
    public int getSecondaryAnnotationExpressionType() {
        return this.secondaryAnnotationExpressionType;
    }

    @Override
    public void setSecondaryAnnotationExpression(String secondaryAnnotationExpression, int type) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setSecondaryAnnotationExpression: '" + secondaryAnnotationExpression + "', " + type));
        }
        this.secondaryAnnotationExpression = secondaryAnnotationExpression;
        this.secondaryAnnotationExpressionType = type;
    }

    @Override
    public int getQueryType() {
        return this.queryType;
    }

    @Override
    public Element toElement() {
        Element element = new Element("LayerProperties");
        element.setAttribute("type", this.getClass().getCanonicalName());
        if (this.getIdExpression() != null) {
            element.setAttribute("idExpression", this.getIdExpression());
            element.setAttribute("idExpressionType", String.valueOf(this.getIdExpressionType()));
        }
        element.setAttribute("idExpressionEnabled", String.valueOf(this.isIdExpressionEnabled()));
        if (this.getPrimaryAnnotationExpression() != null) {
            element.setAttribute("primaryAnnotationExpression", this.getPrimaryAnnotationExpression());
            element.setAttribute("primaryAnnotationExpressionType", String.valueOf(this.getPrimaryAnnotationExpressionType()));
        }
        if (this.getSecondaryAnnotationExpression() != null) {
            element.setAttribute("secondaryAnnotationExpression", this.getSecondaryAnnotationExpression());
            element.setAttribute("secondaryAnnotationExpressionType", String.valueOf(this.getSecondaryAnnotationExpressionType()));
        }
        element.setAttribute("queryType", String.valueOf(this.getQueryType()));
        if (this.getStyle() != null) {
            try {
                element.addContent((Content)this.getStyle().toElement());
            }
            catch (Throwable t) {
                logger.error((Object)"style element could not be created", t);
            }
        } else {
            logger.warn((Object)"style element could not be created (is null), setting default basic style");
            element.addContent((Content)new BasicStyle().toElement());
        }
        return element;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        Element styleElement;
        String type = element.getAttributeValue("type");
        if (type == null) {
            throw new ClassNotFoundException("madatory attribute 'type' missing in xml element");
        }
        Class<?> typeClass = Class.forName(type);
        if (!typeClass.isAssignableFrom(this.getClass())) {
            throw new ClassNotFoundException("the XML element type '" + type + "'does not match the layer properties class '" + this.getClass().getCanonicalName() + "'");
        }
        if (element.getAttribute("idExpression") != null) {
            this.setIdExpression(element.getAttributeValue("idExpression"), element.getAttribute("idExpressionType").getIntValue());
        }
        if (element.getAttribute("primaryAnnotationExpression") != null) {
            this.setPrimaryAnnotationExpression(element.getAttributeValue("primaryAnnotationExpression"), element.getAttribute("primaryAnnotationExpressionType").getIntValue());
        }
        if (element.getAttribute("idExpressionEnablesd") != null) {
            this.setIdExpressionEnabled(element.getAttribute("idExpressionEnabled").getBooleanValue());
        }
        if (element.getAttribute("secondaryAnnotationExpression") != null) {
            this.setSecondaryAnnotationExpression(element.getAttributeValue("secondaryAnnotationExpression"), element.getAttribute("secondaryAnnotationExpressionType").getIntValue());
        }
        if (element.getAttribute("queryType") != null) {
            this.setQueryType(element.getAttribute("queryType").getIntValue());
        }
        if ((styleElement = element.getChild("StyleHistoryElement")) != null && styleElement.getAttribute("type") == null) {
            logger.warn((Object)"initFromElement: restoring object from deprecated xml element");
            this.setStyle(new BasicStyle());
            this.setPrimaryAnnotationExpression(this.getStyle().getLabel(), 1);
        } else if (styleElement != null) {
            try {
                Style restoredStyle = (Style)XMLObjectFactory.restoreObjectfromElement(styleElement);
                this.setStyle(restoredStyle);
            }
            catch (Throwable t) {
                logger.error((Object)("could not restore generic style element '" + styleElement.getAttribute("type") + "': \n" + t.getMessage()), t);
                this.setStyle(new BasicStyle());
            }
        } else {
            logger.warn((Object)"no style found in XML Element, setting default random Basic Style");
            this.setStyle(new BasicStyle());
        }
    }

    @Override
    public void assign(LayerProperties layerProperties) {
        if (layerProperties.getIdExpression() != null) {
            this.setIdExpression(new String(layerProperties.getIdExpression()), layerProperties.getIdExpressionType());
        } else {
            this.idExpressionType = -1;
        }
        if (layerProperties.getPrimaryAnnotationExpression() != null) {
            this.setPrimaryAnnotationExpression(new String(layerProperties.getPrimaryAnnotationExpression()), layerProperties.getPrimaryAnnotationExpressionType());
        } else {
            this.primaryAnnotationExpressionType = -1;
        }
        if (layerProperties.getSecondaryAnnotationExpression() != null) {
            this.setSecondaryAnnotationExpression(new String(layerProperties.getSecondaryAnnotationExpression()), layerProperties.getSecondaryAnnotationExpressionType());
        } else {
            this.secondaryAnnotationExpressionType = -1;
        }
        this.setIdExpressionEnabled(layerProperties.isIdExpressionEnabled());
        this.setQueryType(layerProperties.getQueryType());
        try {
            this.setStyle((Style)(layerProperties.getStyle() != null ? layerProperties.getStyle().clone() : new BasicStyle()));
        }
        catch (CloneNotSupportedException ex) {
            logger.warn((Object)"unexpected CloneNotSupportedException while cloning Style object, setting default Basic Style", (Throwable)ex);
            this.setStyle(new BasicStyle());
        }
        this.setFeatureService(layerProperties.getFeatureService());
    }

    @Override
    public boolean isIdExpressionEnabled() {
        return this.idExpressionEnabled;
    }

    @Override
    public void setIdExpressionEnabled(boolean idExpressionEnabled) {
        this.idExpressionEnabled = idExpressionEnabled;
    }

    @Override
    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    @Override
    public AbstractFeatureService getFeatureService() {
        return this.featureService;
    }

    @Override
    public void setFeatureService(AbstractFeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public AttributeTableRuleSet getAttributeTableRuleSet() {
        if (this.attributeTableRuleSet != null) {
            return this.attributeTableRuleSet;
        }
        if (this.featureService == null) {
            return null;
        }
        String ruleSetName = DefaultLayerProperties.camelize(this.featureService.getName()) + "RuleSet";
        try {
            Class<?> ruleSetClass = Class.forName("de.cismet.cismap.custom.attributerule." + ruleSetName);
            Object o = ruleSetClass.newInstance();
            if (o instanceof DefaultAttributeTableRuleSet) {
                this.attributeTableRuleSet = (DefaultAttributeTableRuleSet)o;
                return this.attributeTableRuleSet;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.attributeTableRuleSet = new DefaultAttributeTableRuleSet();
        return this.attributeTableRuleSet;
    }

    public static String camelize(String toCamelize) {
        boolean upperCase = true;
        char[] result = new char[toCamelize.length()];
        int resultPosition = 0;
        for (int i = 0; i < toCamelize.length(); ++i) {
            char current = toCamelize.charAt(i);
            if (Character.isLetterOrDigit(current)) {
                if (upperCase) {
                    current = Character.toUpperCase(current);
                    upperCase = false;
                } else {
                    current = Character.toLowerCase(current);
                }
                result[resultPosition++] = current;
                continue;
            }
            upperCase = true;
        }
        return String.valueOf(result, 0, resultPosition);
    }

    public void setAttributeTableRuleSet(AttributeTableRuleSet attributeTableRuleSet) {
        this.attributeTableRuleSet = attributeTableRuleSet;
    }

    public void setFeatureSimplifier(FeatureSimplifier featureSimplifier) {
        this.featureSimplifier = featureSimplifier;
    }

    @Override
    public FeatureSimplifier getFeatureSimplifier() {
        if (this.featureSimplifier != null) {
            return this.featureSimplifier;
        }
        if (this.featureService == null) {
            return null;
        }
        String ruleSetName = DefaultLayerProperties.camelize(this.featureService.getName()) + "FeatureSimplifier";
        try {
            Class<?> ruleSetClass = Class.forName("de.cismet.cismap.custom.simplifier." + ruleSetName);
            Object o = ruleSetClass.newInstance();
            if (o instanceof FeatureSimplifier) {
                this.featureSimplifier = (FeatureSimplifier)o;
                return this.featureSimplifier;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.featureSimplifier = new DefaultFeatureSimplifier();
        return this.featureSimplifier;
    }
}

