/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.exceptions.FileExtensionContentMissmatchException;
import de.cismet.cismap.commons.exceptions.UnknownDocumentException;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.GMLFeatureService;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerAlreadyAddedException;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.factory.DxfReader;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.deegree.io.shpapi.FileHeader;
import org.openide.util.NbBundle;

public class DocumentFeatureServiceFactory {
    private static final Logger log = Logger.getLogger(DocumentFeatureServiceFactory.class);
    public static final String XML_FILE_EXTENSION = ".xml";
    public static final String GML_FILE_EXTENSION = ".gml";
    public static final String SHP_FILE_EXTENSION = ".shp";
    public static final String CSV_FILE_EXTENSION = ".csv";
    public static final String DXF_FILE_EXTENSION = ".dxf";
    public static final String SHP_DBF_FILE_EXTENSION = ".dbf";
    public static final String SHP_INDEX_FILE_EXTENSION = ".shx";
    public static final String XML_IDENTIFICATION_STRING = "<?xml";
    public static final String GML_IDENTIFICATION_STRING = "xmlns:gml";

    public static AbstractFeatureService createDocumentFeatureService(File documentFile) throws Exception {
        if (documentFile == null) {
            log.error((Object)"URI ist null es kann kein FeatureService angelegt werden");
            throw new Exception("Pfad ist ung\u00fcltig es kann kein FeatureService angelegt werden");
        }
        long documentSize = documentFile.length();
        try {
            if (documentFile.getName().endsWith(XML_FILE_EXTENSION) || documentFile.getName().endsWith(GML_FILE_EXTENSION)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"File extension ist xml/gml");
                }
                if (DocumentFeatureServiceFactory.isGMLDocument(documentFile)) {
                    return new GMLFeatureService(documentFile.getName(), documentFile.toURI(), documentSize, null);
                }
                throw new FileExtensionContentMissmatchException("File extension ist xml/gml aber kein g\u00fcltiges xml/gml Dokument");
            }
            if (documentFile.getPath().endsWith(SHP_FILE_EXTENSION) || documentFile.getPath().endsWith(SHP_DBF_FILE_EXTENSION) || documentFile.getPath().endsWith(CSV_FILE_EXTENSION)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"File extension ist shp/dbf/csv");
                }
                if ((documentFile.getPath().endsWith(SHP_DBF_FILE_EXTENSION) || documentFile.getPath().endsWith(CSV_FILE_EXTENSION)) && CismapBroker.getInstance().isUseInternalDb() || DocumentFeatureServiceFactory.isShapeFile(documentFile)) {
                    if (CismapBroker.getInstance().isUseInternalDb()) {
                        String hexString = DocumentFeatureServiceFactory.calcMd5FromFile(documentFile);
                        String fileName = documentFile.getName();
                        String tableName = (fileName = fileName.substring(0, fileName.lastIndexOf("."))) + "_" + hexString;
                        if (H2FeatureService.tableAlreadyExists(tableName)) {
                            JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(DocumentFeatureServiceFactory.class, (String)"DocumentFeatureServiceFactory.createDocumentFeatureService.message"), NbBundle.getMessage(DocumentFeatureServiceFactory.class, (String)"DocumentFeatureServiceFactory.createDocumentFeatureService.title"), 2);
                        }
                        return new H2FeatureService(fileName, "~/cismap/internalH2", tableName, null, documentFile);
                    }
                    return new ShapeFileFeatureService(documentFile.getName(), documentFile.toURI(), documentSize, null);
                }
                throw new FileExtensionContentMissmatchException("File extension ist shp aber kein g\u00fcltiges shp Dokument");
            }
            if (documentFile.getPath().toLowerCase().endsWith(DXF_FILE_EXTENSION)) {
                H2FeatureService service;
                String tableName;
                String serviceName;
                DxfReader reader = new DxfReader(documentFile.getPath());
                List<FeatureServiceAttribute> attributes = reader.getFeatureServiceAttributes();
                String hexString = DocumentFeatureServiceFactory.calcMd5FromFile(documentFile);
                String fileName = documentFile.getName();
                String folderName = fileName = fileName.substring(0, fileName.lastIndexOf("."));
                List<FeatureServiceFeature> pointFeatures = reader.getPointFeatures();
                List<FeatureServiceFeature> linestringFeatures = reader.getLinestringFeatures();
                List<FeatureServiceFeature> polygonFeatures = reader.getPolygonFeatures();
                List<FeatureServiceFeature> annotationFeatures = reader.getAnnotationFeatures();
                if (pointFeatures != null && !pointFeatures.isEmpty()) {
                    serviceName = fileName + "_point";
                    tableName = folderName + "->" + fileName + "_point_" + hexString;
                    service = new H2FeatureService(serviceName, "~/cismap/internalH2", tableName, attributes, null, pointFeatures, null, "dxf");
                    service.initAndWait();
                    DocumentFeatureServiceFactory.showService(service, folderName);
                }
                if (linestringFeatures != null && !linestringFeatures.isEmpty()) {
                    serviceName = fileName + "_linestring";
                    tableName = folderName + "->" + fileName + "_linestring_" + hexString;
                    service = new H2FeatureService(serviceName, "~/cismap/internalH2", tableName, attributes, null, linestringFeatures, null, "dxf");
                    service.initAndWait();
                    DocumentFeatureServiceFactory.showService(service, folderName);
                }
                if (polygonFeatures != null && !polygonFeatures.isEmpty()) {
                    serviceName = fileName + "_polygon";
                    tableName = folderName + "->" + fileName + "_polygon_" + hexString;
                    service = new H2FeatureService(serviceName, "~/cismap/internalH2", tableName, attributes, null, polygonFeatures, null, "dxf");
                    service.initAndWait();
                    DocumentFeatureServiceFactory.showService(service, folderName);
                }
                if (annotationFeatures != null && !annotationFeatures.isEmpty()) {
                    serviceName = fileName + "_annotation";
                    tableName = folderName + "->" + fileName + "_annotation_" + hexString;
                    service = new H2FeatureService(serviceName, "~/cismap/internalH2", tableName, attributes, null, annotationFeatures, null, "dxf");
                    service.initAndWait();
                    DocumentFeatureServiceFactory.showService(service, folderName);
                }
                throw new LayerAlreadyAddedException();
            }
            throw new UnknownDocumentException("Endung des Dokumentes ist nicht bekannt");
        }
        catch (LayerAlreadyAddedException e) {
            throw e;
        }
        catch (Exception ex) {
            if (ex instanceof UnknownDocumentException || ex instanceof FileExtensionContentMissmatchException) {
                log.error((Object)"Fehler beim erstellen eines DocumentFeaturelayers anhand eines Dokumentes --> versuche Inhalt automatisch zu bestimmen", (Throwable)ex);
                if (DocumentFeatureServiceFactory.isGMLDocument(documentFile)) {
                    return new GMLFeatureService(documentFile.getName(), documentFile.toURI(), documentSize, null);
                }
                if (DocumentFeatureServiceFactory.isShapeFile(documentFile)) {
                    return new ShapeFileFeatureService(documentFile.getName(), documentFile.toURI(), documentSize, null);
                }
                throw new Exception("Inhalt des Dokumentes ist nicht bekannt und kann nicht verarbeitet werden");
            }
            log.error((Object)"Fehler beim anlegen eines DocumentFeatureServices", (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calcMd5FromFile(File documentFile) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] inputArray = new byte[256];
        int byteCount = 0;
        try (BufferedInputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(documentFile));
            while ((byteCount = is.read(inputArray)) != -1) {
                md5.update(inputArray, 0, byteCount);
            }
        }
        byte[] hashValue = md5.digest();
        StringBuffer hexString = new StringBuffer();
        for (byte b : hashValue) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    public static void showService(H2FeatureService service, String folder) {
        ActiveLayerModel model = (ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel();
        LayerCollection layerCollection = null;
        if (folder != null) {
            String folderWithDem = folder.replaceAll("->", "\\");
            StringTokenizer st = new StringTokenizer(folderWithDem, "\\");
            while (st.hasMoreTokens()) {
                Object tmp;
                int i;
                boolean found;
                String subFolder = st.nextToken();
                if (layerCollection != null) {
                    found = false;
                    for (i = 0; i < layerCollection.size(); ++i) {
                        tmp = layerCollection.get(i);
                        if (!(tmp instanceof LayerCollection) || !((LayerCollection)tmp).getName().equals(subFolder)) continue;
                        layerCollection = (LayerCollection)tmp;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LayerCollection newLayerCollection = new LayerCollection();
                    newLayerCollection.setName(subFolder);
                    layerCollection.add(newLayerCollection);
                    layerCollection = newLayerCollection;
                    continue;
                }
                found = false;
                for (i = 0; i < model.getChildCount(model.getRoot()); ++i) {
                    tmp = model.getChild(model.getRoot(), i);
                    if (!(tmp instanceof LayerCollection) || !((LayerCollection)tmp).getName().equals(subFolder)) continue;
                    layerCollection = (LayerCollection)tmp;
                    found = true;
                    break;
                }
                if (found) continue;
                layerCollection = new LayerCollection();
                layerCollection.setName(subFolder);
                model.addEmptyLayerCollection(layerCollection);
            }
        }
        if (layerCollection != null) {
            model.registerRetrievalServiceLayer(service);
            layerCollection.add(service);
        } else {
            model.addLayer(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGMLDocument(File documentFile) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pr\u00fcfe ob Document ein GML Dokument ist");
        }
        if (documentFile != null) {
            try (BufferedReader bf = new BufferedReader(new FileReader(documentFile));){
                String currentLine = null;
                for (int counter = 0; (currentLine = bf.readLine()) != null && counter < 100; ++counter) {
                    if (!currentLine.contains(GML_IDENTIFICATION_STRING)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            log.info((Object)"Im ganzen Dokument konnte keine Zeile mit: xmlns:gml gefunden werden");
            return false;
        }
        log.warn((Object)"Achtung documentFile war null");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isShapeFile(File documentFile) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pr\u00fcfe ob Document ein ShapeFile ist");
        }
        RandomAccessFile raf = null;
        try {
            if (documentFile != null) {
                raf = new RandomAccessFile(documentFile, "r");
                FileHeader fh = new FileHeader(raf);
                boolean bl = true;
                return bl;
            }
            log.warn((Object)"Achtung documentFile war null");
            boolean fh = false;
            return fh;
        }
        catch (Exception ex) {
            log.warn((Object)"Document ist wahrscheinlich kein Shapefile");
            boolean bl = false;
            return bl;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException ex) {
                    log.error((Object)"Cannot close file", (Throwable)ex);
                }
            }
        }
    }
}

