/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.DocumentFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.GMLFeatureFactory;
import de.cismet.commons.wms.capabilities.Layer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class GMLFeatureService
extends DocumentFeatureService<FeatureServiceFeature, String>
implements LayerInfoProvider {
    private static final transient Logger LOG = Logger.getLogger(GMLFeatureService.class);
    public static final String GML_FEATURELAYER_TYPE = "GMLFeatureServiceLayer";
    public static final Map<Integer, Icon> layerIcons = new HashMap<Integer, Icon>();

    public GMLFeatureService(Element e) throws Exception {
        super(e);
    }

    public GMLFeatureService(String name, URI documentURI, long documentSize, List<FeatureServiceAttribute> attributes) throws Exception {
        super(name, documentURI, documentSize, attributes);
    }

    protected GMLFeatureService(GMLFeatureService gfs) {
        super(gfs);
    }

    @Override
    public Icon getLayerIcon(int type) {
        return layerIcons.get(type);
    }

    @Override
    protected LayerProperties createLayerProperties() {
        DefaultLayerProperties defaultLayerProperties = new DefaultLayerProperties();
        defaultLayerProperties.setIdExpression(null, -1);
        defaultLayerProperties.setFeatureService(this);
        return defaultLayerProperties;
    }

    @Override
    protected FeatureFactory createFeatureFactory() throws Exception {
        return new GMLFeatureFactory(this.getLayerProperties(), this.getDocumentURI(), this.maxSupportedFeatureCount, this.layerInitWorker);
    }

    @Override
    public String getQuery() {
        return null;
    }

    @Override
    public void setQuery(String query) {
        LOG.warn((Object)("unexpected call to setQuery, not supported by this service:\n" + query));
    }

    @Override
    protected void initConcreteInstance() throws Exception {
    }

    @Override
    public void setDocumentURI(URI documentURI) {
        super.setDocumentURI(documentURI);
        if (this.getFeatureFactory() != null) {
            ((GMLFeatureFactory)this.getFeatureFactory()).setDocumentURI(documentURI);
        }
    }

    @Override
    protected String getFeatureLayerType() {
        return GML_FEATURELAYER_TYPE;
    }

    @Override
    public Object clone() {
        LOG.info((Object)("cloning service " + this.getName()));
        return new GMLFeatureService(this);
    }

    @Override
    public String getLayerURI() {
        return null;
    }

    @Override
    public String getServerURI() {
        return this.documentURI.toString();
    }

    @Override
    public boolean isLayerQuerySelected() {
        return false;
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
    }

    @Override
    public boolean isQueryable() {
        return false;
    }

    @Override
    public Layer getLayerInformation() {
        return null;
    }

    static {
        layerIcons.put(0, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerGml.png")));
        layerIcons.put(2, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerGmlInvisible.png")));
        layerIcons.put(1, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerGml.png")));
        layerIcons.put(3, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerGmlInvisible.png")));
    }
}

