/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.schema.FeatureType;
import org.deegree.model.feature.schema.GeometryPropertyType;
import org.deegree.model.spatialschema.Geometry;

public class GeometryHeuristics {
    private static final Logger log = Logger.getLogger((String)"de.cismet.cismap.commons.featureservice.GeometryHeuristics");
    private static final String POINT = "Point";
    private static final String MULTIPOINT = "MultiPoint";
    private static final String LINESTRING = "LineString";
    private static final String MULTILINESTRING = "MultiLineString";
    private static final String POLYGON = "Polygon";
    private static final String MULTIPOLYGON = "MultiPolygon";
    private static final HashMap<String, Integer> geomOrder = new HashMap();

    public static String findBestGeometryName(Feature f) {
        GeometryPropertyType best = null;
        if (f != null) {
            FeatureType type = f.getFeatureType();
            GeometryPropertyType[] geoProp = type.getGeometryProperties();
            Geometry[] geo = f.getGeometryPropertyValues();
            if (geoProp.length == 1) {
                best = geoProp[0];
            } else {
                for (int i = 0; i < geoProp.length; ++i) {
                    if (best == null) {
                        if (GeometryHeuristics.isBoundingBox(geo[i])) continue;
                        best = geoProp[i];
                        continue;
                    }
                    int bestValue = geomOrder.get(best.getTypeName().getLocalName());
                    int geomValue = geomOrder.get(geoProp[i].getTypeName().getLocalName());
                    if (geomValue <= bestValue || GeometryHeuristics.isBoundingBox(geo[i])) continue;
                    best = geoProp[i];
                }
            }
        }
        return best.getName().getAsString();
    }

    public static int findBestGeometryIndex(Feature f) {
        int bestIndex = 0;
        GeometryPropertyType best = null;
        if (f != null) {
            FeatureType type = f.getFeatureType();
            GeometryPropertyType[] geoProp = type.getGeometryProperties();
            Geometry[] geo = f.getGeometryPropertyValues();
            if (geoProp.length == 1) {
                bestIndex = 0;
            } else {
                for (int i = 0; i < geoProp.length; ++i) {
                    if (best == null) {
                        if (GeometryHeuristics.isBoundingBox(geo[i])) continue;
                        best = geoProp[i];
                        bestIndex = i;
                        continue;
                    }
                    int bestValue = geomOrder.get(best.getTypeName().getLocalName());
                    int geomValue = geomOrder.get(geoProp[i].getTypeName().getLocalName());
                    if (geomValue <= bestValue || GeometryHeuristics.isBoundingBox(geo[i])) continue;
                    best = geoProp[i];
                    bestIndex = i;
                }
            }
        }
        return bestIndex;
    }

    private static boolean isBoundingBox(Geometry g) {
        return g.isEmpty();
    }

    static {
        geomOrder.put(POINT, 1);
        geomOrder.put(MULTIPOINT, 2);
        geomOrder.put(LINESTRING, 3);
        geomOrder.put(MULTILINESTRING, 4);
        geomOrder.put(POLYGON, 5);
        geomOrder.put(MULTIPOLYGON, 6);
    }
}

