/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.commons.security.AccessHandler;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.StaticHtmlTools;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.deegree.ogcwebservices.wfs.capabilities.FeatureTypeList;
import org.deegree.ogcwebservices.wfs.capabilities.WFSCapabilities;
import org.deegree.ogcwebservices.wfs.capabilities.WFSCapabilitiesDocument;
import org.deegree.ogcwebservices.wfs.capabilities.WFSFeatureType;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class WFSOperator {
    private static final Logger log = Logger.getLogger((String)"de.cismet.cismap.commons.raster.wfs.WFSQueryFactory");
    public static final String CISMAP_QUERY = "CismapQuery";
    public static final String QUERY = "Query";
    public static final String CISMAP_DESCRIBEFEATURETYPE = "CismapDescribeFeatureType";
    public static final String DESCRIBEFEATURETYPE = "DescribeFeatureType";
    public static final String CISMAP_GETCAPABILITIES = "CismapGetCapabilities";
    public static final String GETCAPABILITIES = "GetCapabilities";
    public static final String SERVICE_IDENT = "ServiceIdentification";
    public static final String FILTER = "Filter";
    public static final String BBOX = "BBOX";
    public static final String GET_FEATURE = "GetFeature";
    public static final String TYPE_NAME = "typeName";
    public static final String DFT_TYPE_NAME = "TypeName";
    public static final String PROPERTY_NAME = "PropertyName";
    public static final String GEO_PROPERTY_TYPE = "gml:GeometryPropertyType";
    public static final Namespace WFS = Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs");
    public static final Namespace OGC = Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc");
    public static final Namespace GML = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    public static final Namespace OWS = Namespace.getNamespace((String)"ows", (String)"http://www.opengis.net/ows");
    public static final Namespace xsd = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private final URL XML_FILE = this.getClass().getResource("wfs.xml");
    private Document xmlDoc;
    private Document capabilities;
    private Element rootNode;
    private Element query;

    public WFSOperator() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createStandardQuery()");
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            this.xmlDoc = builder.build(this.XML_FILE);
            this.rootNode = this.xmlDoc.getRootElement();
        }
        catch (Exception ex) {
            log.error((Object)"Error during parsing of the CismapXML-Files", (Throwable)ex);
        }
    }

    public WFSOperator(String typeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createStandardQuery(" + typeName + ")"));
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            this.xmlDoc = builder.build(this.XML_FILE);
            this.rootNode = this.xmlDoc.getRootElement();
            this.query = this.rootNode.getChild(CISMAP_QUERY).getChild(GET_FEATURE, WFS);
            this.query.getChild(QUERY, WFS).getAttribute(TYPE_NAME).setValue(typeName);
        }
        catch (Exception ex) {
            log.error((Object)"Error during the creation of a default query.", (Throwable)ex);
        }
    }

    public void setPropertyNames(Collection<Element> properties) {
        this.getQuery().getChild(QUERY, WFS).removeChildren(PROPERTY_NAME, WFS);
        for (Element e : properties) {
            Element tmp = new Element(PROPERTY_NAME, WFS);
            tmp.setText(e.getAttributeValue("name"));
            this.getQuery().getChild(QUERY, WFS).addContent((Content)tmp);
        }
    }

    public static Vector<String> getPropertyNamesFromQuery(Element query) {
        Vector<String> result = new Vector<String>();
        try {
            for (Object o : query.getChild(QUERY, WFS).getChildren(PROPERTY_NAME, WFS)) {
                if (!(o instanceof Element)) continue;
                result.add(((Element)o).getText());
            }
            if (log.isDebugEnabled()) {
                log.debug(result);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error in getPropertyNamesFromQuery()");
            return new Vector<String>();
        }
        return result;
    }

    public static Element changePropertyNames(Element query, Collection<String> properties) {
        query.getChild(QUERY, WFS).removeChildren(PROPERTY_NAME, WFS);
        for (String s : properties) {
            Element tmp = new Element(PROPERTY_NAME, WFS);
            tmp.setText(s);
            query.getChild(QUERY, WFS).addContent((Content)tmp);
        }
        return query;
    }

    public void setGeometry(Element e) {
        for (Element tmp : e.getChildren()) {
            if (!tmp.getAttributeValue("type").equals(GEO_PROPERTY_TYPE)) continue;
            this.getQuery().getChild(QUERY, WFS).getChild(FILTER, OGC).getChild(BBOX, OGC).getChild(PROPERTY_NAME, OGC).setText(tmp.getAttributeValue("name"));
            break;
        }
    }

    public static void setGeometry(Element query, String s) {
        query.getChild(QUERY, WFS).getChild(FILTER, OGC).getChild(BBOX, OGC).getChild(PROPERTY_NAME, OGC).setText(s);
    }

    public static String getGeometry(Element query) {
        return query.getChild(QUERY, WFS).getChild(FILTER, OGC).getChild(BBOX, OGC).getChild(PROPERTY_NAME, OGC).getTextTrim();
    }

    public static String elementToString(Element e) {
        if (e == null) {
            return "";
        }
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        return out.outputString(e);
    }

    public Element getQuery() {
        return this.query;
    }

    public String createDescribeFeatureTypeRequest(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create DescribeFeatureTypeRequest for " + name));
        }
        Element describeFeatType = this.rootNode.getChild(CISMAP_DESCRIBEFEATURETYPE).getChild(DESCRIBEFEATURETYPE, WFS);
        describeFeatType.getChild(DFT_TYPE_NAME, WFS).setText(name);
        return WFSOperator.elementToString(describeFeatType);
    }

    private String createGetCapabilitiesRequest() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Create GetCapabilitiesRequest");
        }
        return WFSOperator.elementToString(this.rootNode.getChild(CISMAP_GETCAPABILITIES).getChild(GETCAPABILITIES, WFS));
    }

    public WFSCapabilities parseWFSCapabilites(URL server) throws Exception {
        XMLOutputter out = new XMLOutputter();
        this.capabilities = WFSOperator.doRequest(server, this.createGetCapabilitiesRequest());
        String buf = out.outputString(this.capabilities);
        WFSCapabilitiesDocument wfsDoc = new WFSCapabilitiesDocument();
        wfsDoc.load((Reader)new StringReader(buf), "http://test0r");
        return (WFSCapabilities)wfsDoc.parseCapabilities();
    }

    public WFSCapabilities parseWFSCapabilites(BufferedReader reader) throws Exception {
        WFSCapabilitiesDocument wfsDoc = new WFSCapabilitiesDocument();
        wfsDoc.load((Reader)reader, "http://test0r");
        return (WFSCapabilities)wfsDoc.parseCapabilities();
    }

    public String getServiceName() {
        Element id = this.capabilities.getRootElement().getChild(SERVICE_IDENT, OWS);
        if (id.getChild("Title", OWS) != null && !id.getChild("Title", OWS).getText().equals("")) {
            return id.getChild("Title", OWS).getText();
        }
        if (id.getChild("Abstract", OWS) != null && !id.getChild("Abstract", OWS).getText().equals("")) {
            return id.getChild("Abstract", OWS).getText();
        }
        return id.getChild("ServiceType", OWS).getText();
    }

    public static String parseDocumentToString(Document doc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"parseDocumentToString()");
        }
        XMLOutputter out = new XMLOutputter();
        return out.outputString(doc);
    }

    public List<Element> getElements(URL postURL, FeatureTypeList featTypes) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getElements()");
        }
        Document doc = null;
        LinkedList<Element> list = new LinkedList<Element>();
        for (int i = 0; i < featTypes.getFeatureTypes().length; ++i) {
            WFSFeatureType ft = featTypes.getFeatureTypes()[i];
            String name = ft.getName().getAsString();
            Element element = null;
            if (doc == null) {
                doc = WFSOperator.doRequest(postURL, this.createDescribeFeatureTypeRequest(name));
            }
            if ((element = WFSOperator.getAttributes(name, doc)) == null) {
                doc = WFSOperator.doRequest(postURL, this.createDescribeFeatureTypeRequest(name));
                element = WFSOperator.getAttributes(name, doc);
            }
            if (!this.checkElementHasGeometry(element)) continue;
            list.add(element);
        }
        return list;
    }

    private boolean checkElementHasGeometry(Element element) {
        for (Element e : element.getChildren()) {
            if (!e.getAttributeValue("type").equals(GEO_PROPERTY_TYPE)) continue;
            return true;
        }
        return false;
    }

    private static Element getAttributes(String name, Document doc) {
        Element result = null;
        String shortName = WFSOperator.deleteApp(name);
        String type = null;
        try {
            for (Object o : doc.getContent()) {
                if (!(o instanceof Element)) continue;
                Element root = (Element)o;
                String prefix = null;
                for (Object child : root.getChildren("element", xsd)) {
                    Element e = (Element)child;
                    if (e.getAttributeValue("name") == null || !e.getAttributeValue("name").equals(shortName)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(">> Element with name = \"" + name + "\" found"));
                    }
                    e.setAttribute("name", name);
                    result = e;
                    prefix = e.getAttributeValue("type").substring(0, e.getAttributeValue("type").indexOf(":") + 1);
                    type = WFSOperator.deleteApp(e.getAttributeValue("type"));
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)(">> searched Typ = \"" + e.getAttributeValue("type") + "\""));
                    break;
                }
                for (Object child : root.getChildren("complexType", xsd)) {
                    Element comp = (Element)child;
                    if (!comp.getAttributeValue("name").equals(type)) continue;
                    List l = comp.getChild("complexContent", xsd).getChild("extension", xsd).getChild("sequence", xsd).getChildren("element", xsd);
                    while (l.size() > 0) {
                        Element neu = (Element)((Element)l.get(0)).detach();
                        neu.setAttribute("name", prefix + neu.getAttributeValue("name"));
                        result.addContent((Content)neu);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("OK, result = " + result));
                    }
                    return result;
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error at getElements()", (Throwable)ex);
        }
        return null;
    }

    public static String deleteApp(String s) {
        if (s.startsWith("app:")) {
            return s.replaceAll("app:", "");
        }
        return s;
    }

    public static Document doRequest(URL serverURL, String request) throws Exception {
        String poststring = request;
        if (log.isDebugEnabled()) {
            log.debug((Object)("WFS Query = " + StaticHtmlTools.stringToHTMLString((String)poststring)));
        }
        try {
            InputStream result = WebAccessManager.getInstance().doRequest(serverURL, (Reader)new StringReader(poststring), AccessHandler.ACCESS_METHODS.POST_REQUEST);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Server has processed request and responds");
                log.debug((Object)"parse InputStream");
            }
            SAXBuilder builder = new SAXBuilder();
            return builder.build((Reader)new InputStreamReader(result, Charset.forName("UTF-8")));
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }
}

