/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.features.WFSFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.WFSFeatureFactory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.DefaultQueryButtonAction;
import de.cismet.cismap.commons.interaction.DefaultXMLQueryButtonAction;
import de.cismet.cismap.commons.preferences.CapabilityLink;
import de.cismet.cismap.commons.wfs.WFSFacade;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilitiesFactory;
import de.cismet.commons.wms.capabilities.Layer;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public final class WebFeatureService
extends AbstractFeatureService<WFSFeature, String>
implements LayerInfoProvider {
    private static final transient Logger LOG = Logger.getLogger(WebFeatureService.class);
    public static final String WFS_FEATURELAYER_TYPE = "WebFeatureServiceLayer";
    public static final HashMap<Integer, Icon> layerIcons = new HashMap();
    private Crs crs;
    private String wfsQueryString;
    private Element wfsQueryElement;
    private String hostname;
    private String capabilitiesLink;
    private FeatureType feature;
    private String backupVersion = "";
    private boolean reverseAxisOrder;

    public WebFeatureService(Element e) throws Exception {
        super(e);
        this.queryButtons.clear();
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsEqualTo", "="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsNotEqualTo", "<>"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLike", "Like"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsGreaterThan", ">"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsGreaterThanOrEqualTo", ">="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("And", "And"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLessThan", "<"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLessThanOrEqualTo", "<="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Or", "Or"));
        this.queryButtons.add(new DefaultQueryButtonAction("_", 1));
        this.queryButtons.add(new DefaultQueryButtonAction("%", 1));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Not", "Not"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsNull", "Null"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Literal", "Lit"));
        if (e.getAttribute("reverseAxisOrder") != null) {
            try {
                this.reverseAxisOrder = e.getAttribute("reverseAxisOrder").getBooleanValue();
            }
            catch (DataConversionException ex) {
                LOG.error((Object)"Invalid attribute value", (Throwable)ex);
            }
        }
    }

    public WebFeatureService(String name, String host, Element query, List<FeatureServiceAttribute> attributes, FeatureType feature) throws Exception {
        this(name, host, query, attributes, feature, false);
    }

    public WebFeatureService(String name, String host, Element query, List<FeatureServiceAttribute> attributes, FeatureType feature, boolean reverseAxisOrder) throws Exception {
        super(name, attributes);
        this.queryButtons.clear();
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsEqualTo", "="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsNotEqualTo", "<>"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLike", "Like"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsGreaterThan", ">"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsGreaterThanOrEqualTo", ">="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("And", "And"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLessThan", "<"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLessThanOrEqualTo", "<="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Or", "Or"));
        this.queryButtons.add(new DefaultQueryButtonAction("_", 1));
        this.queryButtons.add(new DefaultQueryButtonAction("%", 1));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Not", "Not"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsNull", "Null"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Literal", "Lit"));
        this.crs = CismapBroker.getInstance().getSrs();
        this.setFeature(feature);
        this.setQueryElement(query);
        this.setHostname(CismapBroker.getInstance().urlToAlias(host));
        this.capabilitiesLink = host;
        this.setTranslucency(0.2f);
        this.setMaxFeatureCount(100000);
        this.reverseAxisOrder = reverseAxisOrder;
    }

    protected WebFeatureService(WebFeatureService wfs) {
        super(wfs);
        this.queryButtons.clear();
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsEqualTo", "="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsNotEqualTo", "<>"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLike", "Like"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsGreaterThan", ">"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsGreaterThanOrEqualTo", ">="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("And", "And"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLessThan", "<"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsLessThanOrEqualTo", "<="));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Or", "Or"));
        this.queryButtons.add(new DefaultQueryButtonAction("_", 1));
        this.queryButtons.add(new DefaultQueryButtonAction("%", 1));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Not", "Not"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("PropertyIsNull", "Null"));
        this.queryButtons.add(new DefaultXMLQueryButtonAction("Literal", "Lit"));
        this.setCrs(wfs.getCrs());
        this.setFeature(wfs.getFeature());
        this.setHostname(wfs.getHostname());
        this.setQueryElement(wfs.getQueryElement());
        this.setQuery(wfs.getQuery());
        this.maxFeatureCount = Integer.MAX_VALUE;
        this.backupVersion = wfs.backupVersion;
        this.setInitialisationError(wfs.getInitialisationError());
        this.errorObject = wfs.errorObject;
        this.reverseAxisOrder = wfs.reverseAxisOrder;
        this.capabilitiesLink = wfs.capabilitiesLink;
    }

    @Override
    protected void initConcreteInstance() throws Exception {
        this.layerProperties.setQueryType(2);
    }

    @Override
    public void setMaxFeatureCount(int maxFeatureCount) {
        super.setMaxFeatureCount(maxFeatureCount);
        if (this.wfsQueryElement != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("setting max features of WFS query to " + (maxFeatureCount + 100)));
            }
            WFSFacade.setMaxFeatureCount(this.wfsQueryElement, maxFeatureCount + 100, this.getVersion());
            this.wfsQueryString = FeatureServiceUtilities.elementToString(this.wfsQueryElement);
        }
    }

    @Override
    public Element toElement() {
        Element parentElement = super.toElement();
        CapabilityLink capLink = new CapabilityLink("OGC", this.hostname, this.reverseAxisOrder, this.getVersion(), false, CismapBroker.getInstance().urlToAlias(this.capabilitiesLink == null ? this.hostname : this.capabilitiesLink));
        if (this.reverseAxisOrder) {
            parentElement.setAttribute("reverseAxisOrder", "true");
        }
        try {
            parentElement.addContent((Content)capLink.getElement());
        }
        catch (Exception e) {
            LOG.warn((Object)"error in parentElement.addContent(capLink.getElement());", (Throwable)e);
        }
        try {
            parentElement.addContent(this.getQueryElement().detach());
        }
        catch (Exception e) {
            LOG.warn((Object)"error in parentElement.addContent(getQueryElement().detach());", (Throwable)e);
        }
        return parentElement;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        this.initFromElement(element, this.getInitialisationError());
    }

    public void initFromElement(Element element, boolean loadCapDoc) throws Exception {
        if (element == null) {
            element = this.getInitElement();
        }
        if (!this.initializedFromElement) {
            super.initFromElement(element);
        }
        CapabilityLink cp = new CapabilityLink(element);
        Element query = element.getChild("GetFeature", FeatureServiceUtilities.WFS);
        String capLink = cp.getLink();
        if (cp.getVersion() != null && !cp.getVersion().equals("")) {
            capLink = capLink + "?VERSION=" + cp.getVersion();
        }
        if (loadCapDoc && this.feature == null) {
            try {
                WFSCapabilitiesFactory fac = new WFSCapabilitiesFactory();
                WFSCapabilities cap = fac.createCapabilities(capLink);
                if (cap != null && !cap.getVersion().equals(cp.getVersion())) {
                    LOG.warn((Object)("Cannot retrieve the wfs capabilities for version " + cp.getVersion() + " but for version " + cap.getVersion()));
                }
                this.feature = WFSFacade.extractRequestedFeatureType(FeatureServiceUtilities.elementToString(query), cap);
                this.setErrorObject(null);
                this.setInitialisationError(false);
            }
            catch (Exception ex) {
                this.setErrorObject(ex.toString());
                this.backupVersion = cp.getVersion();
                this.setQueryElement(query);
                this.setHostname(cp.getLink());
                this.setInitialisationError(true);
            }
        } else {
            this.setErrorObject(null);
            this.backupVersion = cp.getVersion();
            this.setQueryElement(query);
            this.setHostname(cp.getLink());
            this.setInitialisationError(true);
        }
        this.setQueryElement(query);
        this.setHostname(cp.getLink());
    }

    @Override
    public Object clone() {
        return new WebFeatureService(this);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public String getHostname() {
        return this.hostname;
    }

    protected void setHostname(String hostname) {
        this.hostname = hostname;
        if (this.getFeatureFactory() != null) {
            ((WFSFeatureFactory)this.getFeatureFactory()).setHostname(hostname);
        }
    }

    @Override
    public String getQuery() {
        return this.wfsQueryString;
    }

    @Override
    public void setQuery(String wfsQueryString) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setting the string representation of the WFS query (will not be saved)");
        }
        this.wfsQueryString = wfsQueryString;
    }

    public Element getQueryElement() {
        return this.wfsQueryElement;
    }

    public void setQueryElement(Element wfsQuery) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setting the XML Element representation of the WFS query (will be saved)");
        }
        this.wfsQueryElement = wfsQuery;
        if (this.wfsQueryElement != null) {
            WFSFacade.setMaxFeatureCount(this.wfsQueryElement, this.maxFeatureCount, this.getVersion());
            this.wfsQueryString = FeatureServiceUtilities.elementToString(wfsQuery);
        }
    }

    @Override
    protected String getFeatureLayerType() {
        return WFS_FEATURELAYER_TYPE;
    }

    @Override
    public Icon getLayerIcon(int type) {
        return layerIcons.get(type);
    }

    @Override
    protected LayerProperties createLayerProperties() {
        DefaultLayerProperties defaultLayerProperties = new DefaultLayerProperties();
        defaultLayerProperties.setPrimaryAnnotationExpression("app:flurstz", 1);
        defaultLayerProperties.getStyle().setMultiplier(1.0);
        defaultLayerProperties.getStyle().setFont(new Font("sansserif", 0, 12));
        defaultLayerProperties.setIdExpression("app:gid", 1);
        defaultLayerProperties.setQueryType(2);
        defaultLayerProperties.setFeatureService(this);
        return defaultLayerProperties;
    }

    @Override
    protected FeatureFactory createFeatureFactory() throws Exception {
        return new WFSFeatureFactory(this.getLayerProperties(), this.getHostname(), this.feature, this.getCrs(), this.parseSLD(this.getSLDDefiniton()), this.reverseAxisOrder);
    }

    public void setLayerPropertiesWithoutUpdate(LayerProperties layerProperties) {
        this.layerProperties = layerProperties;
        this.featureFactory.setLayerProperties(layerProperties);
    }

    public String getVersion() {
        if (this.feature != null) {
            return this.feature.getWFSCapabilities().getVersion();
        }
        LOG.warn((Object)("Version is not set. Use backup version " + this.backupVersion));
        return this.backupVersion;
    }

    @Override
    public String getLayerURI() {
        return this.wfsQueryString;
    }

    @Override
    public String getServerURI() {
        return this.hostname;
    }

    @Override
    public boolean isLayerQuerySelected() {
        return false;
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
    }

    @Override
    public boolean isQueryable() {
        return false;
    }

    @Override
    public Layer getLayerInformation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FeatureType getFeature() {
        return this.feature;
    }

    public void setFeature(FeatureType feature) {
        this.feature = feature;
    }

    public Crs getCrs() {
        if (this.crs == null) {
            return CismapBroker.getInstance().getSrs();
        }
        return this.crs;
    }

    public void setCrs(Crs crs) {
        this.crs = crs;
        if (this.featureFactory != null) {
            ((WFSFeatureFactory)this.featureFactory).setCrs(crs);
        }
    }

    @Override
    public String decoratePropertyName(String name) {
        return "<PropertyName>" + name + "</PropertyName>";
    }

    @Override
    public String decoratePropertyValue(String column, String value) {
        return "<Literal>" + value + "</Literal>";
    }

    static {
        layerIcons.put(0, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfs.png")));
        layerIcons.put(2, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfsInvisible.png")));
        layerIcons.put(1, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfs.png")));
        layerIcons.put(3, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfsInvisible.png")));
    }
}

