/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.factory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import com.ysystems.ycad.lib.ydxf.YdxfGet;
import com.ysystems.ycad.lib.ydxf.YdxfGetBuffer;
import com.ysystems.ycad.lib.yxxf.Yxxf;
import com.ysystems.ycad.lib.yxxf.YxxfDictionary;
import com.ysystems.ycad.lib.yxxf.YxxfEnt;
import com.ysystems.ycad.lib.yxxf.YxxfEntArc;
import com.ysystems.ycad.lib.yxxf.YxxfEntCircle;
import com.ysystems.ycad.lib.yxxf.YxxfEntHeader;
import com.ysystems.ycad.lib.yxxf.YxxfEntInsert;
import com.ysystems.ycad.lib.yxxf.YxxfEntLine;
import com.ysystems.ycad.lib.yxxf.YxxfEntLwpolyline;
import com.ysystems.ycad.lib.yxxf.YxxfEntMtext;
import com.ysystems.ycad.lib.yxxf.YxxfEntPoint;
import com.ysystems.ycad.lib.yxxf.YxxfEntPolyline;
import com.ysystems.ycad.lib.yxxf.YxxfEntText;
import com.ysystems.ycad.lib.yxxf.YxxfEntVertex;
import com.ysystems.ycad.lib.yxxf.YxxfGfxPointW;
import com.ysystems.ycad.lib.yxxf.YxxfObject;
import com.ysystems.ycad.lib.yxxf.YxxfXRecord;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.CrsDeterminer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DxfReader {
    private static final Logger LOG = Logger.getLogger(DxfReader.class);
    private List<FeatureServiceAttribute> featureServiceAttributes;
    private List<FeatureServiceFeature> annotationFeatures = new ArrayList<FeatureServiceFeature>();
    private List<FeatureServiceFeature> pointFeatures = new ArrayList<FeatureServiceFeature>();
    private List<FeatureServiceFeature> polygonFeatures = new ArrayList<FeatureServiceFeature>();
    private List<FeatureServiceFeature> linestringFeatures = new ArrayList<FeatureServiceFeature>();
    private LayerProperties properties;
    private int lastGeneratedId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DxfReader(String filename) {
        File f = new File(filename);
        BufferedInputStream in = null;
        try {
            YxxfEnt ent;
            in = new BufferedInputStream(new FileInputStream(f));
            Yxxf drawing = new Yxxf();
            YdxfGetBuffer buffer = new YdxfGetBuffer();
            boolean type = true;
            buffer.setInput(1, (InputStream)in, drawing);
            YdxfGet.get((YdxfGetBuffer)buffer);
            drawing = buffer.getDrawing();
            int srid = CrsTransformer.extractSridFromCrs(this.getCrs(buffer));
            this.printHoleDictionary(buffer);
            String originFeatureType = this.getOriginFeatureType(buffer);
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
            int nextToDraw = 0;
            while ((ent = (YxxfEnt)drawing.secEntities.insMSpace.block.nextEntity(nextToDraw)) instanceof YxxfEntHeader) {
                Map<String, Object> featureAttr;
                Geometry geom;
                YxxfEntPolyline line;
                Map<String, Object> featureAttr2;
                Geometry geom2;
                Map<String, Object> featureAttr3;
                Point geom3;
                YxxfGfxPointW point;
                YxxfEntText text;
                if (ent instanceof YxxfEntText) {
                    text = (YxxfEntText)ent;
                    point = text.inspnt;
                    geom3 = factory.createPoint(new Coordinate(point.x, point.y, point.z));
                    featureAttr3 = this.getFeatureAttributes(buffer, (YxxfEntHeader)text, true);
                    featureAttr3.put("annotation", text.text);
                    this.annotationFeatures.add(this.toFeature((Geometry)geom3, featureAttr3));
                } else if (ent instanceof YxxfEntMtext) {
                    text = (YxxfEntMtext)ent;
                    point = text.inspnt;
                    geom3 = factory.createPoint(new Coordinate(point.x, point.y, point.z));
                    featureAttr3 = this.getFeatureAttributes(buffer, (YxxfEntHeader)text, true);
                    featureAttr3.put("annotation", text.text);
                    this.annotationFeatures.add(this.toFeature((Geometry)geom3, featureAttr3));
                } else if (ent instanceof YxxfEntInsert) {
                    YxxfEntInsert ins = (YxxfEntInsert)ent;
                    point = ins.inspnt;
                    geom3 = factory.createPoint(new Coordinate(point.x, point.y, point.z));
                    featureAttr3 = this.getFeatureAttributes(buffer, (YxxfEntHeader)ins, true);
                    this.pointFeatures.add(this.toFeature((Geometry)geom3, featureAttr3));
                } else if (ent instanceof YxxfEntPoint) {
                    YxxfEntPoint point2 = (YxxfEntPoint)ent;
                    geom2 = factory.createPoint(new Coordinate(point2.pnt.x, point2.pnt.y, point2.pnt.z));
                    featureAttr2 = this.getFeatureAttributes(buffer, (YxxfEntHeader)point2, true);
                    this.pointFeatures.add(this.toFeature(geom2, featureAttr2));
                } else if (ent instanceof YxxfEntPolyline) {
                    line = (YxxfEntPolyline)ent;
                    geom2 = this.readPolyLine(line, factory, originFeatureType);
                    featureAttr2 = this.getFeatureAttributes(buffer, (YxxfEntHeader)line, true);
                    if (originFeatureType != null && originFeatureType.toLowerCase().equals("polygon")) {
                        this.polygonFeatures.add(this.toFeature(geom2, featureAttr2));
                    } else {
                        this.linestringFeatures.add(this.toFeature(geom2, featureAttr2));
                    }
                } else if (ent instanceof YxxfEntLine) {
                    line = (YxxfEntLine)ent;
                    Coordinate coord = new Coordinate(line.begpnt.x, line.begpnt.y, line.begpnt.z);
                    coord = new Coordinate(line.endpnt.x, line.endpnt.y, line.endpnt.z);
                    Coordinate[] coordArray = new Coordinate[]{coord, coord};
                    geom = factory.createLineString(coordArray);
                    featureAttr = this.getFeatureAttributes(buffer, (YxxfEntHeader)line, true);
                    this.linestringFeatures.add(this.toFeature(geom, featureAttr));
                } else if (ent instanceof YxxfEntLwpolyline) {
                    line = (YxxfEntLwpolyline)ent;
                    geom2 = this.readPolyLine(line.pline, factory, originFeatureType);
                    featureAttr2 = this.getFeatureAttributes(buffer, (YxxfEntHeader)line, true);
                    if (originFeatureType != null && originFeatureType.toLowerCase().equals("polygon")) {
                        this.polygonFeatures.add(this.toFeature(geom2, featureAttr2));
                    } else {
                        this.linestringFeatures.add(this.toFeature(geom2, featureAttr2));
                    }
                } else if (ent instanceof YxxfEntCircle) {
                    YxxfEntCircle circle = (YxxfEntCircle)ent;
                    point = circle.center;
                    Point center = factory.createPoint(new Coordinate(point.x, point.y, point.z));
                    geom = center.buffer(circle.radius);
                    featureAttr = this.getFeatureAttributes(buffer, (YxxfEntHeader)circle, true);
                    this.polygonFeatures.add(this.toFeature(geom, featureAttr));
                } else if (ent instanceof YxxfEntArc) {
                    YxxfEntArc arc = (YxxfEntArc)ent;
                    point = arc.center;
                    GeometricShapeFactory gsf = new GeometricShapeFactory();
                    gsf.setCentre(new Coordinate(point.x, point.y, point.z));
                    gsf.setSize(arc.radius * 2.0);
                    geom = gsf.createArcPolygon(arc.entbegang, arc.entendang);
                    featureAttr = this.getFeatureAttributes(buffer, (YxxfEntHeader)arc, true);
                    this.polygonFeatures.add(this.toFeature(geom, featureAttr));
                } else {
                    LOG.warn((Object)("Unknown type: " + ent.getClass().getName()));
                }
                ++nextToDraw;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"While while reading dxf file.", (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (this.properties != null) {
                try {
                    this.properties.setFeatureService(new H2FeatureService("dummy", "dummy", null, this.featureServiceAttributes));
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot create dummy H2FeatureService.", (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) {
        String filename = "/home/therter/Downloads/beispieldaten-dxf-dwg/dxf-2010-poly-mit-proj-wsg-daten2/2013-08-01-wsg-eurawasser-hro.dxf";
        new DxfReader("/home/therter/Downloads/beispieldaten-dxf-dwg/dxf-2010-poly-mit-proj-wsg-daten2/2013-08-01-wsg-eurawasser-hro.dxf");
    }

    public List<FeatureServiceFeature> getPointFeatures() {
        return this.pointFeatures;
    }

    public List<FeatureServiceFeature> getAnnotationFeatures() {
        return this.annotationFeatures;
    }

    public List<FeatureServiceFeature> getPolygonFeatures() {
        return this.polygonFeatures;
    }

    public List<FeatureServiceFeature> getLinestringFeatures() {
        return this.linestringFeatures;
    }

    public List<FeatureServiceAttribute> getFeatureServiceAttributes() {
        return this.featureServiceAttributes;
    }

    private Map<String, Object> getFeatureAttributes(YdxfGetBuffer buffer, YxxfEntHeader header, boolean annotation) throws Exception {
        boolean createFeatureAttirbutes;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        String esriAttributesHandle = this.getDictionaryHandle(buffer, header, "ESRI_Attributes");
        boolean bl = createFeatureAttirbutes = this.featureServiceAttributes == null;
        if (esriAttributesHandle != null) {
            YxxfObject attributeHeader = buffer.currObjectsBlock.getObjectByHandle(esriAttributesHandle);
            if (attributeHeader instanceof YxxfDictionary) {
                YxxfDictionary dict = (YxxfDictionary)attributeHeader;
                for (String attrName : dict.nameSoftOwnerIdMap.keySet()) {
                    String valueHandle = (String)dict.nameSoftOwnerIdMap.get(attrName);
                    YxxfObject value = buffer.currObjectsBlock.getObjectByHandle(valueHandle);
                    if (!(value instanceof YxxfXRecord)) continue;
                    YxxfXRecord val = (YxxfXRecord)value;
                    if (val.values.isEmpty()) continue;
                    Integer key = (Integer)val.values.keySet().iterator().next();
                    attributeMap.put(attrName, this.getConvertToDbType((String)val.values.get(key), key));
                    if (!createFeatureAttirbutes) continue;
                    if (this.featureServiceAttributes == null) {
                        this.featureServiceAttributes = new ArrayList<FeatureServiceAttribute>();
                        this.properties = new DefaultLayerProperties();
                        this.featureServiceAttributes.add(new FeatureServiceAttribute("geom", String.valueOf(10012), true));
                        if (annotation) {
                            this.featureServiceAttributes.add(new FeatureServiceAttribute("annotation", String.valueOf(12), true));
                        }
                    }
                    FeatureServiceAttribute attr = new FeatureServiceAttribute(attrName, this.getTypeByEsriCode(key), true);
                    this.featureServiceAttributes.add(attr);
                }
            }
        } else if (createFeatureAttirbutes) {
            this.featureServiceAttributes = new ArrayList<FeatureServiceAttribute>();
            this.properties = new DefaultLayerProperties();
            this.featureServiceAttributes.add(new FeatureServiceAttribute("geom", String.valueOf(10012), true));
            if (annotation) {
                this.featureServiceAttributes.add(new FeatureServiceAttribute("annotation", String.valueOf(12), true));
            }
        }
        return attributeMap;
    }

    private String getOriginFeatureType(YdxfGetBuffer buffer) {
        List objects = buffer.currObjectsBlock.getObjectsWichPointTo0();
        for (YxxfObject obj : objects) {
            YxxfObject geomType;
            if (!(obj instanceof YxxfDictionary)) continue;
            YxxfDictionary dic = (YxxfDictionary)obj;
            String featureTypeHandle = (String)dic.nameSoftOwnerIdMap.get("FeatureType");
            if (featureTypeHandle == null || !((geomType = buffer.currObjectsBlock.getObjectByHandle(featureTypeHandle)) instanceof YxxfXRecord)) continue;
            YxxfXRecord rec = (YxxfXRecord)geomType;
            return (String)rec.values.get(1);
        }
        return null;
    }

    private String getTypeByEsriCode(Integer esriCode) {
        if (esriCode == 1) {
            return String.valueOf(12);
        }
        if (esriCode == 70 || esriCode == 90) {
            return String.valueOf(4);
        }
        if (esriCode == 40) {
            return String.valueOf(8);
        }
        return String.valueOf(12);
    }

    private Object getConvertToDbType(String value, Integer esriCode) {
        if (esriCode == 70 || esriCode == 90) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Cannot convert " + value + " to integer"));
                return null;
            }
        }
        if (esriCode == 40) {
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Cannot convert " + value + " to double"));
                return null;
            }
        }
        byte[] asByte = new byte[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            asByte[i] = (byte)value.charAt(i);
        }
        return new String(asByte);
    }

    private String getDictionaryHandle(YdxfGetBuffer buffer, YxxfEntHeader header, String name) {
        List objects = buffer.currObjectsBlock.getObjectsOfEntity(header);
        for (YxxfObject obj : objects) {
            if (!(obj instanceof YxxfDictionary)) continue;
            YxxfDictionary dic = (YxxfDictionary)obj;
            String handle = (String)dic.nameSoftOwnerIdMap.get(name);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    private String getCrs(YdxfGetBuffer buffer) {
        List objects = buffer.currObjectsBlock.getObjectsWichPointTo0();
        String crsDefinition = null;
        for (YxxfObject obj : objects) {
            YxxfObject prjObj;
            if (!(obj instanceof YxxfDictionary)) continue;
            YxxfDictionary dic = (YxxfDictionary)obj;
            String prjPnt = (String)dic.nameSoftOwnerIdMap.get("ESRI_PRJ");
            if (prjPnt == null || !((prjObj = buffer.currObjectsBlock.getObjectByHandle(prjPnt)) instanceof YxxfXRecord)) continue;
            YxxfXRecord rec = (YxxfXRecord)prjObj;
            crsDefinition = (String)rec.values.get(1);
        }
        return this.determineCrs(crsDefinition);
    }

    private void printHoleDictionary(YdxfGetBuffer buffer) {
        List objects = buffer.currObjectsBlock.getObjectsWichPointTo0();
        for (YxxfObject obj : objects) {
            if (obj instanceof YxxfDictionary) {
                YxxfDictionary dic = (YxxfDictionary)obj;
                this.printDictionary(buffer, dic);
                continue;
            }
            System.out.println("class: " + obj.getClass().getName());
        }
    }

    private void printDictionary(YdxfGetBuffer buffer, YxxfDictionary dic) {
        for (String key : dic.nameSoftOwnerIdMap.keySet()) {
            String handle = (String)dic.nameSoftOwnerIdMap.get(key);
            YxxfObject prjObj = buffer.currObjectsBlock.getObjectByHandle(handle);
            System.out.println("key: " + key);
            if (prjObj instanceof YxxfXRecord) {
                YxxfXRecord rec = (YxxfXRecord)prjObj;
                for (Integer intKey : rec.values.keySet()) {
                    System.out.println(intKey + ": " + (String)rec.values.get(intKey));
                }
                continue;
            }
            if (prjObj instanceof YxxfDictionary) {
                this.printDictionary(buffer, (YxxfDictionary)prjObj);
                continue;
            }
            System.out.println("class: " + (prjObj == null ? "null" : prjObj.getClass().getName()));
        }
    }

    private String determineCrs(String crsDefinition) {
        if (crsDefinition != null) {
            String epsg = CrsDeterminer.getEpsgCode(crsDefinition);
            if (epsg != null) {
                return epsg;
            }
        } else {
            LOG.warn((Object)"No crs found. Assume that the default crs is used");
        }
        return CismapBroker.getInstance().getSrs().getCode();
    }

    private void printObjects(List<YxxfObject> objects) {
        for (YxxfObject o : objects) {
            System.out.println(o.toString());
        }
    }

    private Geometry readPolyLine(YxxfEntPolyline line, GeometryFactory factory, String originFeatureType) {
        Vector vertexList = line.vtxEntities;
        Coordinate[] coordArray = new Coordinate[vertexList.size()];
        int index = -1;
        for (YxxfEntVertex vertex : vertexList) {
            Coordinate coord = new Coordinate(vertex.pnt.x, vertex.pnt.y, vertex.pnt.z);
            coordArray[++index] = coord;
        }
        if (originFeatureType != null && originFeatureType.toLowerCase().equals("polygon")) {
            return factory.createPolygon(coordArray);
        }
        return factory.createLineString(coordArray);
    }

    private FeatureServiceFeature toFeature(Geometry geom, Map<String, Object> attributes) {
        Object id = attributes.get("FID");
        if (!(id instanceof Integer) && !((id = attributes.get("id")) instanceof Integer)) {
            id = this.generateId();
        }
        DefaultFeatureServiceFeature feature = new DefaultFeatureServiceFeature((Integer)id, geom, this.properties);
        feature.addProperties(attributes);
        feature.addProperty("geom", geom);
        return feature;
    }

    private Integer generateId() {
        return ++this.lastGeneratedId;
    }
}

