/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.factory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.CachingFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.DegreeFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.GMLFeatureCollectionDocument;
import org.deegree.model.feature.schema.PropertyType;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.JTSAdapter;

public class GMLFeatureFactory
extends DegreeFeatureFactory<DefaultFeatureServiceFeature, String>
implements CachingFeatureFactory<DefaultFeatureServiceFeature, String> {
    protected int maxCachedFeatureCount = 150000;
    protected URI documentURI;
    protected GMLFeatureCollectionDocument gmlDocument;
    protected boolean initialised = false;
    protected STRtree degreeFeaturesTree = null;
    protected Vector<FeatureServiceAttribute> featureServiceAttributes;
    protected BufferedReader documentReader;
    protected com.vividsolutions.jts.geom.Geometry envelope;

    public GMLFeatureFactory(LayerProperties layerProperties, URI documentURL, int maxCachedFeatureCount, SwingWorker workerThread) throws Exception {
        this.layerProperties = layerProperties;
        this.documentURI = documentURL;
        this.maxCachedFeatureCount = maxCachedFeatureCount;
        try {
            this.parseGMLFile(workerThread);
            this.initialised = true;
        }
        catch (Exception ex) {
            this.logger.error((Object)("SW[" + workerThread + "]: error parsing gml file"), (Throwable)ex);
            this.cleanup();
        }
    }

    protected GMLFeatureFactory(GMLFeatureFactory gmlff) {
        super(gmlff);
        this.maxCachedFeatureCount = gmlff.maxCachedFeatureCount;
        this.documentURI = gmlff.documentURI;
        this.gmlDocument = gmlff.gmlDocument;
        this.degreeFeaturesTree = gmlff.degreeFeaturesTree;
        this.featureServiceAttributes = new Vector<FeatureServiceAttribute>(gmlff.featureServiceAttributes);
        this.initialised = gmlff.initialised;
    }

    @Override
    protected DefaultFeatureServiceFeature createFeatureInstance(Feature degreeFeature, int index) throws Exception {
        DefaultFeatureServiceFeature gmlFeature = new DefaultFeatureServiceFeature();
        int currentSrid = -1;
        gmlFeature.setId(index);
        try {
            gmlFeature.setGeometry(JTSAdapter.export((Geometry)degreeFeature.getGeometryPropertyValues()[this.geometryIndex]));
            currentSrid = CrsTransformer.extractSridFromCrs(degreeFeature.getGeometryPropertyValues()[this.geometryIndex].getCoordinateSystem().getPrefixedName());
            gmlFeature.getGeometry().setSRID(currentSrid);
        }
        catch (Exception e) {
            gmlFeature.setGeometry(JTSAdapter.export((Geometry)degreeFeature.getDefaultGeometryPropertyValue()));
        }
        gmlFeature.setGeometry(CrsTransformer.transformToDefaultCrs(gmlFeature.getGeometry()));
        this.degreeFeaturesTree.insert(gmlFeature.getGeometry().getEnvelopeInternal(), (Object)gmlFeature);
        if (this.envelope == null) {
            this.envelope = gmlFeature.getGeometry().getEnvelope();
            this.envelope.setSRID(currentSrid);
        } else {
            this.envelope = this.envelope.getEnvelope().union(gmlFeature.getGeometry().getEnvelope());
        }
        return gmlFeature;
    }

    protected synchronized void cleanup() {
        if (this.documentReader != null) {
            try {
                this.documentReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.documentReader = null;
            System.gc();
        }
        this.gmlDocument = null;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    protected synchronized void parseGMLFile(SwingWorker workerThread) throws Exception {
        this.logger.info((Object)("SW[" + workerThread + "]: initialising GMLFeatureFactory with document: '" + this.documentURI + "'"));
        long start = System.currentTimeMillis();
        this.envelope = null;
        this.documentReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.documentURI))));
        this.gmlDocument = new GMLFeatureCollectionDocument();
        this.gmlDocument.load((Reader)this.documentReader, "http://dummyID");
        if (this.checkCancelled(workerThread, " initialising gml document ")) {
            this.cleanup();
            return;
        }
        int max = this.gmlDocument.getFeatureCount();
        if (max > this.maxCachedFeatureCount) {
            this.logger.error((Object)("SW[" + workerThread + "]: number of features in gml file (" + max + ") exceeds maximum of supported features (" + this.maxCachedFeatureCount + ")"));
            max = this.maxCachedFeatureCount;
        }
        if (max == 0) {
            this.logger.error((Object)("SW[" + workerThread + "]: no features found in gml file"));
            throw new Exception("no features found in gml file '" + this.documentURI + "'");
        }
        this.degreeFeaturesTree = new STRtree(max);
        FeatureCollection featureCollection = this.gmlDocument.parse();
        this.cleanup();
        if (this.checkCancelled(workerThread, " parsing gml document ")) {
            return;
        }
        if (featureCollection.size() > 0) {
            Feature type = featureCollection.getFeature(0);
            this.logger.info((Object)("SW[" + workerThread + "]: creating " + type.getProperties().length + " featureServiceAttributes from first parsed degree feature"));
            this.featureServiceAttributes = new Vector(type.getProperties().length);
            for (PropertyType pt : type.getFeatureType().getProperties()) {
                this.featureServiceAttributes.add(new FeatureServiceAttribute(pt.getName().getAsString(), Integer.toString(pt.getType()), true));
            }
        } else {
            this.logger.error((Object)"could not create feature service attributes, no valid gml fetures found");
        }
        if (this.checkCancelled(workerThread, " creating feature service attributes")) {
            return;
        }
        this.processFeatureCollection(workerThread, featureCollection.toArray(), this.initialised);
        if (this.checkCancelled(workerThread, " processing parsed features")) {
            return;
        }
        this.logger.info((Object)("parsing, converting and initialising " + max + " gml features took " + (System.currentTimeMillis() - start) + " ms"));
    }

    @Override
    public synchronized void flush() {
        this.logger.warn((Object)"flushing cached features");
        this.lastCreatedfeatureVector.clear();
    }

    @Override
    public int getMaxCachedFeatureCount() {
        return this.maxCachedFeatureCount;
    }

    @Override
    public void setMaxCachedFeatureCount(int maxCachedFeatureCount) {
        this.maxCachedFeatureCount = maxCachedFeatureCount;
    }

    public URI getDocumentURI() {
        return this.documentURI;
    }

    public synchronized void setDocumentURI(URI documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public synchronized List<DefaultFeatureServiceFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeatures_internal(query, boundingBox, workerThread, 0, 0, null, true);
    }

    public synchronized Vector<FeatureServiceAttribute> createAttributes(SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
        if (this.featureServiceAttributes == null || this.featureServiceAttributes.size() == 0) {
            this.logger.warn((Object)("SW[" + workerThread + "]: Factory not correctopy initialised, parsing gml file"));
            this.parseGMLFile(workerThread);
        }
        if (this.featureServiceAttributes == null || this.featureServiceAttributes.size() == 0) {
            this.logger.error((Object)("SW[" + workerThread + "]: no attributes could be found in gml file"));
            throw new Exception("no attributes could be found in gml file '" + this.documentURI + "'");
        }
        return this.featureServiceAttributes;
    }

    @Override
    protected boolean isGenerateIds() {
        return true;
    }

    @Override
    public GMLFeatureFactory clone() {
        return new GMLFeatureFactory(this);
    }

    @Override
    public int getFeatureCount(String query, BoundingBox bb) {
        return this.degreeFeaturesTree.size();
    }

    @Override
    public synchronized List<DefaultFeatureServiceFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeatures_internal(query, boundingBox, workerThread, offset, limit, orderBy, false);
    }

    private synchronized List<DefaultFeatureServiceFeature> createFeatures_internal(String query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy, boolean saveAsLastCreated) throws FeatureFactory.TooManyFeaturesException, Exception {
        List<Object> selectedFeatures;
        if (!this.initialised) {
            this.logger.warn((Object)("SW[" + workerThread + "]: Factory not correclty initialised, parsing gml file"));
            this.parseGMLFile(workerThread);
            this.initialised = true;
            if (this.checkCancelled(workerThread, " initialisation")) {
                return null;
            }
        }
        long start = System.currentTimeMillis();
        Coordinate[] polyCords = new Coordinate[]{new Coordinate(boundingBox.getX1(), boundingBox.getY1()), new Coordinate(boundingBox.getX1(), boundingBox.getY2()), new Coordinate(boundingBox.getX2(), boundingBox.getY2()), new Coordinate(boundingBox.getX2(), boundingBox.getY1()), new Coordinate(boundingBox.getX1(), boundingBox.getY1())};
        GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
        Polygon boundingPolygon = geomFactory.createPolygon(geomFactory.createLinearRing(polyCords), null);
        if (this.featuresAlreadyInMemory((com.vividsolutions.jts.geom.Geometry)boundingPolygon, query)) {
            selectedFeatures = this.createFeaturesFromMemory(query, (com.vividsolutions.jts.geom.Geometry)boundingPolygon);
        } else {
            selectedFeatures = this.degreeFeaturesTree.query(boundingPolygon.getEnvelopeInternal());
            if (this.checkCancelled(workerThread, " quering spatial index structure")) {
                return null;
            }
            this.logger.info((Object)("SW[" + workerThread + "]: " + selectedFeatures.size() + " features selected by bounding box out of " + this.degreeFeaturesTree.size() + " in spatial index"));
        }
        if (selectedFeatures.size() > this.getMaxFeatureCount()) {
            throw new FeatureFactory.TooManyFeaturesException("features in selected area " + selectedFeatures.size() + " exceeds max feature count " + this.getMaxFeatureCount());
        }
        if (selectedFeatures.isEmpty()) {
            this.logger.warn((Object)("SW[" + workerThread + "]: no features found in selected bounding box"));
            return null;
        }
        if (orderBy != null && orderBy.length > 0) {
            this.sortFeatureList(selectedFeatures, orderBy);
        }
        if (offset > 0) {
            selectedFeatures = selectedFeatures.subList(offset, selectedFeatures.size());
        }
        if (limit > 0 && selectedFeatures.size() > limit) {
            selectedFeatures = selectedFeatures.subList(0, limit);
        }
        this.reEvaluteExpressions(selectedFeatures, workerThread);
        if (this.checkCancelled(workerThread, " saving LastCreatedFeatures ")) {
            return null;
        }
        if (saveAsLastCreated) {
            this.updateLastCreatedFeatures(selectedFeatures, (com.vividsolutions.jts.geom.Geometry)boundingPolygon, query);
        }
        return new Vector<Object>(selectedFeatures);
    }

    public com.vividsolutions.jts.geom.Geometry getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(com.vividsolutions.jts.geom.Geometry envelope) {
        this.envelope = envelope;
    }
}

