/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import de.cismet.cismap.commons.RestrictedFileSystemView;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.style.BasicStyle;
import de.cismet.cismap.commons.featureservice.style.FontChooserDialog;
import de.cismet.cismap.commons.featureservice.style.PointSymbolListRenderer;
import de.cismet.cismap.commons.featureservice.style.Style;
import de.cismet.cismap.commons.featureservice.style.StyleHistoryListCellRenderer;
import de.cismet.cismap.commons.featureservice.style.StyleHistoryListModel;
import de.cismet.cismap.commons.featureservice.style.StylePreviewPanel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.bounce.text.LineNumberMargin;
import org.bounce.text.ScrollableEditorPanel;
import org.bounce.text.xml.XMLEditorKit;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openide.util.NbBundle;

public class StyleDialog
extends JDialog
implements ListSelectionListener {
    private static final String CISMAP_FOLDER = ".cismap";
    private static final String DEFAULT_HISTORY_NAME = "defaultStyleHistory.xml";
    private static final String COLORCHOOSER_TITLE = NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.COLORCHOOSER_TITLE");
    private static final String FONTCHOOSER_TITLE = NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.FONTCHOOSER_TITLE");
    private static final String POINTSYMBOL_FOLDER = "/de/cismet/cismap/commons/featureservice/res/pointsymbols/";
    private static final String POPUP_SAVE = NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.POPUP_SAVE");
    private static final String POPUP_LOAD = NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.POPUP_LOAD");
    private static final String POPUP_CLEAR = NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.POPUP_CLEAR");
    private final Logger logger = Logger.getLogger(this.getClass());
    private final String home = System.getProperty("user.home");
    private final String seperator = System.getProperty("file.separator");
    private final File fileToCismapFolder = new File(this.home + this.seperator + ".cismap");
    private TreeMap<String, FeatureAnnotationSymbol> pointSymbolHM = new TreeMap();
    private TreeMap<String, FeatureServiceAttribute> featureServiceAttributes;
    private Map<String, FeatureServiceAttribute> oldFeatureServiceAttributes;
    private FeatureAnnotationSymbol pointSymbol = null;
    private File defaultHistory;
    private JColorChooser colorChooser;
    private FontChooserDialog fontChooser;
    private JPopupMenu popupMenu;
    private JEditorPane queryEditor = new JEditorPane();
    private LayerProperties layerProperties;
    private boolean accepted = false;
    private boolean ignoreSelectionEvent = true;
    private ButtonGroup btgAlignment;
    private ButtonGroup btgGeom;
    private JComboBox cbbAnnotationExpression;
    private JComboBox cbbFillPattern;
    private JComboBox cbbIdExpression;
    private JComboBox cbbLinePattern;
    private JComboBox cbbPointSymbol;
    private JCheckBox chkActivateLabels;
    private JCheckBox chkAutoscale;
    private JCheckBox chkCustomSLD;
    private JCheckBox chkFill;
    private JCheckBox chkFillPattern;
    private JCheckBox chkHighlightable;
    private JCheckBox chkLine;
    private JCheckBox chkLinePattern;
    private JCheckBox chkLinewrap;
    private JCheckBox chkSync;
    private JCheckBox chkUseQueryString;
    private JButton cmdAdd;
    private JButton cmdCancel;
    private JButton cmdChangeFont;
    private JButton cmdChangeTextColor;
    private JButton cmdFill;
    private JButton cmdLine;
    private JButton cmdOK;
    private JButton cmdRemove;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lblAlignment;
    private JLabel lblAlpha;
    private JLabel lblAnnotationExpression;
    private JLabel lblFontname;
    private JLabel lblHistory;
    private JLabel lblIdExpression;
    private JLabel lblLineWidth;
    private JLabel lblMax;
    private JLabel lblMin;
    private JLabel lblMultiplier;
    private JLabel lblPointSymbol;
    private JLabel lblPointSymbolSize;
    private JLabel lblPreview;
    private JList lstHistory;
    private JPanel panAlignment;
    private JPanel panAttribGeo;
    private JPanel panAttribNorm;
    private JPanel panAttribSeparator;
    private JPanel panDialogButtons;
    private JPanel panFill;
    private JPanel panFillColor;
    private JPanel panFontColor;
    private JPanel panInfo;
    private JPanel panInfoComp;
    private JPanel panLabelButtons;
    private JPanel panLabeling;
    private JPanel panLineColor;
    private JPanel panMain;
    private JPanel panPreview;
    private JPanel panQueryCheckbox;
    private JPanel panRules;
    private JPanel panRulesButtons;
    private JPanel panRulesScroll;
    private JPanel panSLDDefinition;
    private JPanel panScale;
    private JPanel panScrollpane;
    private JPanel panTabAttrib;
    private JPanel panTabFill;
    private JPanel panTabLabeling;
    private JPanel panTabQuery;
    private JPanel panTabRules;
    private JPanel panTabs;
    private JPanel panTransColor;
    private JPanel panTransWhite;
    private JRadioButton radCenter;
    private JRadioButton radLeft;
    private JRadioButton radRight;
    private JScrollPane scpQuery;
    private JScrollPane scrHistory;
    private JSlider sldAlpha;
    private JSlider sldLineWidth;
    private JSlider sldPointSymbolSize;
    private JTabbedPane tbpTabs;
    private JTextField txtLineWidth;
    private JFormattedTextField txtMax;
    private JFormattedTextField txtMin;
    private JFormattedTextField txtMultiplier;
    private JTextField txtPointSymbolSize;
    private JTextField txtTransparency;
    private BindingGroup bindingGroup;
    private String layerName;

    private void closeDialog(WindowEvent evt) {
        this.doClose(false);
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        this.setMinScale(Integer.parseInt(this.txtMin.getText()));
        this.setMaxScale(Integer.parseInt(this.txtMax.getText()));
        try {
            this.txtMultiplier.commitEdit();
        }
        catch (ParseException ex) {
            this.logger.warn((Object)"Could not perform a commitEdit()", (Throwable)ex);
        }
        this.setMultiplier(this.txtMultiplier.getValue());
        if (this.defaultHistory != null) {
            this.writeHistory(this.defaultHistory, true);
        }
        if (this.isQueryStringChanged() && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"setting new Query Template");
        }
        this.doClose(true);
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doClose(false);
    }

    private void chkFillPatternItemStateChanged(ItemEvent evt) {
    }

    private void chkFillItemStateChanged(ItemEvent evt) {
        this.cmdFill.setEnabled(this.chkFill.isSelected());
        this.getStyle().setDrawFill(this.chkFill.isSelected());
        this.updatePreview();
    }

    private void chkLineItemStateChanged(ItemEvent evt) {
        this.switchLineActive(this.chkLine.isSelected());
        this.getStyle().setDrawLine(this.chkLine.isSelected());
        this.updatePreview();
    }

    private void switchLineActive(boolean flag) {
        this.cmdLine.setEnabled(flag);
        this.sldLineWidth.setEnabled(flag);
        this.txtLineWidth.setEnabled(flag);
        this.lblLineWidth.setEnabled(flag);
    }

    private void chkLinePatternItemStateChanged(ItemEvent evt) {
    }

    private void sldLineWidthStateChanged(ChangeEvent evt) {
        if (this.sldLineWidth.getValue() == 0) {
            this.sldLineWidth.setValue(1);
        }
        this.setLineWidth(this.sldLineWidth.getValue());
        this.updatePreview();
    }

    private void sldAlphaStateChanged(ChangeEvent evt) {
        this.setAlpha((float)this.sldAlpha.getValue() / 100.0f);
        this.updatePreview();
    }

    private void cmdFillActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.getStyle().getFillColor());
        JDialog colorChooserDialog = JColorChooser.createDialog(this, COLORCHOOSER_TITLE, true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleDialog.this.logger.isDebugEnabled()) {
                    StyleDialog.this.logger.debug((Object)("new filling = " + StyleDialog.this.colorChooser.getColor()));
                }
                StyleDialog.this.setFillColor(true, StyleDialog.this.colorChooser.getColor());
                if (StyleDialog.this.chkSync.isSelected()) {
                    StyleDialog.this.setLineColor(true, BasicStyle.darken(StyleDialog.this.colorChooser.getColor()));
                }
                StyleDialog.this.updatePreview();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleDialog.this.logger.isDebugEnabled()) {
                    StyleDialog.this.logger.debug((Object)"ColorChooser cancelled");
                }
            }
        });
        StaticSwingTools.showDialog((JDialog)colorChooserDialog);
    }

    private void cmdLineActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.getStyle().getLineColor());
        StaticSwingTools.showDialog((JDialog)JColorChooser.createDialog(this, COLORCHOOSER_TITLE, true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleDialog.this.logger.isDebugEnabled()) {
                    StyleDialog.this.logger.debug((Object)("new line color = " + StyleDialog.this.colorChooser.getColor()));
                }
                StyleDialog.this.setLineColor(true, StyleDialog.this.colorChooser.getColor());
                StyleDialog.this.updatePreview();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleDialog.this.logger.isDebugEnabled()) {
                    StyleDialog.this.logger.debug((Object)"ColorChooser cancelled");
                }
            }
        }));
    }

    private void chkActivateLabelsItemStateChanged(ItemEvent evt) {
        boolean flag = this.chkActivateLabels.isSelected();
        this.setLabelingEnabled(flag);
        this.lblAnnotationExpression.setEnabled(flag);
        this.cbbAnnotationExpression.setEnabled(flag);
        this.lblAlignment.setEnabled(flag);
        this.radLeft.setEnabled(flag);
        this.radCenter.setEnabled(flag);
        this.radRight.setEnabled(flag);
        this.lblMultiplier.setEnabled(flag);
        this.txtMultiplier.setEnabled(flag);
        this.chkAutoscale.setEnabled(flag);
        this.lblMin.setEnabled(flag);
        this.txtMin.setEnabled(flag);
        this.lblMax.setEnabled(flag);
        this.txtMax.setEnabled(flag);
        this.lblFontname.setEnabled(flag);
        this.panLabelButtons.setEnabled(flag);
        this.cmdChangeTextColor.setEnabled(flag);
        this.cmdChangeFont.setEnabled(flag);
        this.updatePreview();
    }

    private void sldPointSymbolSizeStateChanged(ChangeEvent evt) {
        this.setPointSymbolSize(this.sldPointSymbolSize.getValue());
        this.updatePreview();
    }

    private void sldPointSymbolSizeMouseWheelMoved(MouseWheelEvent evt) {
        if (this.sldPointSymbolSize.isEnabled() && this.sldPointSymbolSize.isFocusOwner()) {
            this.sldPointSymbolSize.setValue(this.sldPointSymbolSize.getValue() - evt.getWheelRotation());
        }
    }

    private void sldAlphaMouseWheelMoved(MouseWheelEvent evt) {
        this.sldAlpha.setValue(this.sldAlpha.getValue() - evt.getWheelRotation() * 5);
    }

    private void cmdChangeTextColorActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.getStyle().getFontColor());
        StaticSwingTools.showDialog((JDialog)JColorChooser.createDialog(this, COLORCHOOSER_TITLE, true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleDialog.this.logger.isDebugEnabled()) {
                    StyleDialog.this.logger.debug((Object)("new font color = " + StyleDialog.this.colorChooser.getColor()));
                }
                StyleDialog.this.setFontColor(StyleDialog.this.colorChooser.getColor());
                StyleDialog.this.updatePreview();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleDialog.this.logger.isDebugEnabled()) {
                    StyleDialog.this.logger.debug((Object)"ColorChooser cancelled");
                }
            }
        }));
    }

    private void cmdChangeFontActionPerformed(ActionEvent evt) {
        Font temp = this.getStyle().getFont();
        this.fontChooser.setSelectedFont(temp, temp.getSize(), temp.isBold(), temp.isItalic());
        StaticSwingTools.showDialog((JDialog)this.fontChooser, (boolean)false);
        if (this.fontChooser.getReturnStatus() != null) {
            this.setFontType(this.fontChooser.getReturnStatus());
            this.updatePreview();
        }
        this.setLineWidth(this.sldLineWidth.getValue());
        this.updatePreview();
    }

    private void chkAutoscaleItemStateChanged(ItemEvent evt) {
        this.setAutoscale(this.chkAutoscale.isSelected());
    }

    private void cbbPointSymbolItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String selectedPointSymbol = evt.getItem().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("select Point Symbol '" + selectedPointSymbol + "'"));
            }
            if (this.pointSymbolHM.containsKey(selectedPointSymbol)) {
                this.setPointSymbol(selectedPointSymbol);
            } else {
                this.logger.warn((Object)("unsupported point symbol '" + selectedPointSymbol + "'"));
                this.setPointSymbol("Keins");
            }
        }
        this.updatePreview();
    }

    private void chkHighlightableItemStateChanged(ItemEvent evt) {
        this.setHighlighting(this.chkHighlightable.isSelected());
    }

    private void chkSyncItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setLineColor(true, BasicStyle.darken(this.getStyle().getFillColor()));
            this.updatePreview();
        }
    }

    private void chkLinewrapActionPerformed(ActionEvent evt) {
        XMLEditorKit kit = (XMLEditorKit)this.queryEditor.getEditorKit();
        kit.setLineWrappingEnabled(this.chkLinewrap.isSelected());
        this.queryEditor.updateUI();
    }

    private void chkFillActionPerformed(ActionEvent evt) {
    }

    private void chkHighlightableActionPerformed(ActionEvent evt) {
    }

    private void cbbPointSymbolActionPerformed(ActionEvent evt) {
    }

    private void cbbAnnotationExpressionItemStateChanged(ItemEvent evt) {
        if (!this.ignoreSelectionEvent && evt.getStateChange() == 1) {
            String annotationExpression = this.cbbAnnotationExpression.getSelectedItem().toString();
            if (this.featureServiceAttributes.containsKey(annotationExpression)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("setting annotation expression to '" + annotationExpression + "' (EXPRESSIONTYPE_PROPERTYNAME)"));
                }
                this.layerProperties.setPrimaryAnnotationExpression(annotationExpression, 1);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("setting annotation expression to '" + annotationExpression + "' (EXPRESSIONTYPE_GROOVY)"));
                }
                this.layerProperties.setPrimaryAnnotationExpression(annotationExpression, 2);
            }
        }
    }

    private void cbbIdExpressionItemStateChanged(ItemEvent evt) {
        if (!this.ignoreSelectionEvent && evt.getStateChange() == 1) {
            String idExpression = this.cbbIdExpression.getSelectedItem().toString();
            if (this.featureServiceAttributes.containsKey(idExpression)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("setting primary key to '" + idExpression + "' (EXPRESSIONTYPE_PROPERTYNAME)"));
                }
                this.layerProperties.setIdExpression(idExpression, 1);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("setting primary key to '" + idExpression + "' (EXPRESSIONTYPE_GROOVY)"));
                }
                this.layerProperties.setIdExpression(idExpression, 2);
            }
        }
    }

    private void cmdAddActionPerformed(ActionEvent evt) {
    }

    private void chkUseQueryStringActionPerformed(ActionEvent evt) {
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        try {
            Style restoredStyle = (Style)this.lstHistory.getSelectedValue();
            this.layerProperties.setStyle((Style)restoredStyle.clone());
            this.updateDialog();
            this.updatePreview();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Fehler beim Auslesen des Styles", (Throwable)ex);
        }
    }

    public Map<String, FeatureServiceAttribute> getFeatureServiceAttributes() {
        if (!this.isAccepted()) {
            this.logger.warn((Object)"supicious call to 'getFeatureServiceAttributes()', changes not accepted");
        }
        return this.featureServiceAttributes;
    }

    public void setFeatureServiceAttributes(Map<String, FeatureServiceAttribute> featureServiceAttributes) {
        this.oldFeatureServiceAttributes = featureServiceAttributes;
        this.featureServiceAttributes = new TreeMap();
        for (FeatureServiceAttribute fsa : featureServiceAttributes.values()) {
            this.featureServiceAttributes.put(fsa.getName(), fsa.clone());
        }
    }

    public boolean isGeoAttributeChanged() {
        for (FeatureServiceAttribute oldAttribute : this.oldFeatureServiceAttributes.values()) {
            FeatureServiceAttribute newAttribute;
            if (!oldAttribute.isGeometry() || (newAttribute = this.featureServiceAttributes.get(oldAttribute.getName())).isSelected() == oldAttribute.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeSelectionChanged() {
        for (FeatureServiceAttribute oldAttribute : this.oldFeatureServiceAttributes.values()) {
            FeatureServiceAttribute newAttribute;
            if (oldAttribute.isGeometry() || (newAttribute = this.featureServiceAttributes.get(oldAttribute.getName())).isSelected() == oldAttribute.isSelected()) continue;
            return true;
        }
        return false;
    }

    public StyleDialog(Frame parent, boolean modal) {
        super(parent, modal);
        try {
            this.logger.info((Object)"Erstelle StyleDialog");
            this.layerProperties = new DefaultLayerProperties();
            this.createPointSymbols();
            this.initComponents();
            this.createXMLEditor();
            this.setLocationRelativeTo(this.getParent());
            this.colorChooser = new JColorChooser();
            this.fontChooser = new FontChooserDialog(this, FONTCHOOSER_TITLE);
            this.createHistoryListPopupMenu();
            this.lstHistory.setCellRenderer(new StyleHistoryListCellRenderer());
            this.lstHistory.addListSelectionListener(this);
            this.lstHistory.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() && !StyleDialog.this.popupMenu.isVisible()) {
                        StyleDialog.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() && !StyleDialog.this.popupMenu.isVisible()) {
                        StyleDialog.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.defaultHistory = this.searchDefaultHistory();
            this.loadHistory(this.defaultHistory);
            this.queryEditor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    StyleDialog.this.chkUseQueryString.setSelected(true);
                    if (StyleDialog.this.logger.isDebugEnabled()) {
                        StyleDialog.this.logger.debug((Object)e.getChange(e.getDocument().getDefaultRootElement()));
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    StyleDialog.this.chkUseQueryString.setSelected(true);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    StyleDialog.this.chkUseQueryString.setSelected(true);
                }
            });
            this.chkFillPattern.setVisible(false);
            this.cbbFillPattern.setVisible(false);
            this.chkLinePattern.setVisible(false);
            this.cbbLinePattern.setVisible(false);
        }
        catch (Throwable t) {
            this.logger.error((Object)("could not create StyleDialog: " + t.getMessage()), t);
        }
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    StyleDialog dialog = new StyleDialog((Frame)new JFrame(), true);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    dialog.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void sldLineWidthMouseWheelMoved(MouseWheelEvent evt) {
        if (this.sldLineWidth.isEnabled() && this.sldLineWidth.isFocusOwner()) {
            this.sldLineWidth.setValue(this.sldLineWidth.getValue() - evt.getWheelRotation());
        }
    }

    private void radRightActionPerformed(ActionEvent evt) {
        this.setAlignment(1.0f);
    }

    private void radLeftActionPerformed(ActionEvent evt) {
        this.setAlignment(0.0f);
    }

    private void radCenterActionPerformed(ActionEvent evt) {
        this.setAlignment(0.5f);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTabRules = new JPanel();
        this.panRulesButtons = new JPanel();
        this.cmdAdd = new JButton();
        this.cmdRemove = new JButton();
        this.panRulesScroll = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panRules = new JPanel();
        this.btgGeom = new ButtonGroup();
        this.btgAlignment = new ButtonGroup();
        this.panTabQuery = new JPanel();
        this.panScrollpane = new JPanel();
        this.scpQuery = new JScrollPane();
        this.panQueryCheckbox = new JPanel();
        this.chkLinewrap = new JCheckBox();
        this.chkUseQueryString = new JCheckBox();
        this.panMain = new JPanel();
        this.panInfo = new JPanel();
        this.panInfoComp = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.panPreview = new StylePreviewPanel();
        this.lblPreview = new JLabel();
        this.panTabs = new JPanel();
        this.tbpTabs = new JTabbedPane();
        this.panTabFill = new JPanel();
        this.panFill = new JPanel();
        this.chkFill = new JCheckBox();
        this.chkFillPattern = new JCheckBox();
        this.cbbFillPattern = new JComboBox();
        this.chkLine = new JCheckBox();
        this.chkLinePattern = new JCheckBox();
        this.cbbLinePattern = new JComboBox();
        this.chkSync = new JCheckBox();
        this.chkHighlightable = new JCheckBox();
        this.lblLineWidth = new JLabel();
        this.sldLineWidth = new JSlider();
        this.txtLineWidth = new JTextField();
        this.lblAlpha = new JLabel();
        this.txtTransparency = new JTextField();
        this.jPanel7 = new JPanel();
        this.panTransWhite = new JPanel();
        this.sldAlpha = new JSlider();
        this.panTransColor = new JPanel();
        this.jPanel8 = new JPanel();
        this.panFillColor = new JPanel();
        this.cmdFill = new JButton();
        this.jPanel9 = new JPanel();
        this.panLineColor = new JPanel();
        this.cmdLine = new JButton();
        this.scrHistory = new JScrollPane();
        this.lstHistory = new JList();
        this.lblHistory = new JLabel();
        this.lblPointSymbol = new JLabel();
        this.cbbPointSymbol = new JComboBox();
        this.cbbPointSymbol.setModel(new DefaultComboBoxModel<String>(new Vector<String>(this.pointSymbolHM.keySet())));
        this.lblPointSymbolSize = new JLabel();
        this.sldPointSymbolSize = new JSlider();
        this.txtPointSymbolSize = new JTextField();
        this.panTabLabeling = new JPanel();
        this.panLabeling = new JPanel();
        this.chkActivateLabels = new JCheckBox();
        this.lblAnnotationExpression = new JLabel();
        this.cbbAnnotationExpression = new JComboBox();
        this.panLabelButtons = new JPanel();
        this.cmdChangeTextColor = new JButton();
        this.cmdChangeFont = new JButton();
        this.lblFontname = new JLabel();
        this.panFontColor = new JPanel();
        this.panScale = new JPanel();
        this.lblMin = new JLabel();
        this.txtMin = new JFormattedTextField();
        this.lblMax = new JLabel();
        this.txtMax = new JFormattedTextField();
        this.chkAutoscale = new JCheckBox();
        this.panAlignment = new JPanel();
        this.radLeft = new JRadioButton();
        this.radCenter = new JRadioButton();
        this.radRight = new JRadioButton();
        this.lblAlignment = new JLabel();
        this.lblMultiplier = new JLabel();
        this.txtMultiplier = new JFormattedTextField();
        this.panTabAttrib = new JPanel();
        this.jPanel2 = new JPanel();
        this.panAttribGeo = new JPanel();
        this.panAttribSeparator = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.panAttribNorm = new JPanel();
        this.lblIdExpression = new JLabel();
        this.cbbIdExpression = new JComboBox();
        this.panSLDDefinition = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.chkCustomSLD = new JCheckBox();
        this.panDialogButtons = new JPanel();
        this.cmdOK = new JButton();
        this.cmdCancel = new JButton();
        this.panTabRules.setLayout(new BorderLayout());
        this.panRulesButtons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.panRulesButtons.setLayout(new FlowLayout(0));
        this.cmdAdd.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/rule_add.png")));
        this.cmdAdd.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.cmdAdd.text"));
        this.cmdAdd.setMargin(new Insets(2, 5, 2, 5));
        this.panRulesButtons.add(this.cmdAdd);
        this.cmdRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/rule_remove.png")));
        this.cmdRemove.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.cmdRemove.text"));
        this.cmdRemove.setMargin(new Insets(2, 5, 2, 5));
        this.panRulesButtons.add(this.cmdRemove);
        this.panTabRules.add((Component)this.panRulesButtons, "South");
        this.panRulesScroll.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panRulesScroll.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createBevelBorder(1));
        this.panRules.setBackground(new Color(255, 255, 255));
        this.panRules.setLayout(new GridLayout(1, 0));
        this.jScrollPane1.setViewportView(this.panRules);
        this.panRulesScroll.add((Component)this.jScrollPane1, "Center");
        this.panTabRules.add((Component)this.panRulesScroll, "Center");
        this.panTabQuery.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder("Query bearbeiten")));
        this.panTabQuery.setLayout(new BorderLayout());
        this.panScrollpane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.panScrollpane.setLayout(new BorderLayout());
        this.panScrollpane.add((Component)this.scpQuery, "Center");
        this.panTabQuery.add((Component)this.panScrollpane, "Center");
        this.panQueryCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.panQueryCheckbox.setLayout(new GridLayout(2, 0));
        this.chkLinewrap.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkLinewrap.text"));
        this.chkLinewrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.chkLinewrapActionPerformed(evt);
            }
        });
        this.panQueryCheckbox.add(this.chkLinewrap);
        this.chkUseQueryString.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkUseQueryString.text"));
        this.chkUseQueryString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.chkUseQueryStringActionPerformed(evt);
            }
        });
        this.panQueryCheckbox.add(this.chkUseQueryString);
        this.panTabQuery.add((Component)this.panQueryCheckbox, "South");
        this.setTitle(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.title"));
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(685, 461));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StyleDialog.this.closeDialog(evt);
            }
        });
        this.panMain.setMinimumSize(new Dimension(620, 433));
        this.panMain.setPreferredSize(new Dimension(620, 433));
        this.panMain.setLayout(new BorderLayout());
        this.panInfo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.panInfo.setLayout(new BorderLayout());
        this.panInfoComp.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/style.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.panInfoComp.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jLabel1);
        this.jLabel2.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.jLabel2.text"));
        this.jLabel2.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.panInfoComp.add((Component)this.jLabel2, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoComp, "North");
        this.jPanel3.setPreferredSize(new Dimension(150, 220));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setMinimumSize(new Dimension(150, 200));
        this.jPanel1.setPreferredSize(new Dimension(150, 150));
        this.jPanel1.setLayout(new BorderLayout());
        this.panPreview.setBackground(new Color(255, 255, 255));
        GroupLayout panPreviewLayout = new GroupLayout(this.panPreview);
        this.panPreview.setLayout(panPreviewLayout);
        panPreviewLayout.setHorizontalGroup(panPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 146, Short.MAX_VALUE));
        panPreviewLayout.setVerticalGroup(panPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 184, Short.MAX_VALUE));
        this.jPanel1.add((Component)this.panPreview, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.lblPreview.setLabelFor(this.panPreview);
        this.lblPreview.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblPreview.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.jPanel3.add((Component)this.lblPreview, gridBagConstraints);
        this.panInfo.add((Component)this.jPanel3, "South");
        this.panMain.add((Component)this.panInfo, "West");
        this.panTabs.setBorder(BorderFactory.createEmptyBorder(2, 0, 5, 5));
        this.panTabs.setLayout(new BorderLayout());
        this.tbpTabs.setToolTipText("");
        this.panTabFill.setLayout(new BorderLayout());
        this.panFill.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.panFill.setLayout(new GridBagLayout());
        this.chkFill.setSelected(true);
        this.chkFill.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkFill.text"));
        this.chkFill.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkFillItemStateChanged(evt);
            }
        });
        this.chkFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.chkFillActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.chkFill, gridBagConstraints);
        this.chkFillPattern.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkFillPattern.text"));
        this.chkFillPattern.setEnabled(false);
        this.chkFillPattern.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkFillPatternItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.chkFillPattern, gridBagConstraints);
        this.cbbFillPattern.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbbFillPattern.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.cbbFillPattern, gridBagConstraints);
        this.chkLine.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkLine.text"));
        this.chkLine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkLineItemStateChanged(evt);
            }
        });
        this.chkLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.chkLineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 10);
        this.panFill.add((Component)this.chkLine, gridBagConstraints);
        this.chkLinePattern.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkLinePattern.text"));
        this.chkLinePattern.setEnabled(false);
        this.chkLinePattern.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkLinePatternItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.chkLinePattern, gridBagConstraints);
        this.cbbLinePattern.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbbLinePattern.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.cbbLinePattern, gridBagConstraints);
        this.chkSync.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkLineSync.text"));
        this.chkSync.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkSyncItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 10);
        this.panFill.add((Component)this.chkSync, gridBagConstraints);
        this.chkHighlightable.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkHighlightable.text"));
        this.chkHighlightable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkHighlightableItemStateChanged(evt);
            }
        });
        this.chkHighlightable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.chkHighlightableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.panFill.add((Component)this.chkHighlightable, gridBagConstraints);
        this.lblLineWidth.setLabelFor(this.sldLineWidth);
        this.lblLineWidth.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblLineWidth.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.lblLineWidth, gridBagConstraints);
        this.sldLineWidth.setMajorTickSpacing(10);
        this.sldLineWidth.setMaximum(20);
        this.sldLineWidth.setMinorTickSpacing(1);
        this.sldLineWidth.setPaintLabels(true);
        this.sldLineWidth.setSnapToTicks(true);
        this.sldLineWidth.setValue(1);
        this.sldLineWidth.setEnabled(false);
        this.sldLineWidth.setMinimumSize(new Dimension(130, 37));
        this.sldLineWidth.setPreferredSize(new Dimension(130, 37));
        this.sldLineWidth.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                StyleDialog.this.sldLineWidthMouseWheelMoved(evt);
            }
        });
        this.sldLineWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StyleDialog.this.sldLineWidthStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panFill.add((Component)this.sldLineWidth, gridBagConstraints);
        this.txtLineWidth.setColumns(2);
        this.txtLineWidth.setEditable(false);
        this.txtLineWidth.setHorizontalAlignment(4);
        this.txtLineWidth.setText("1");
        this.txtLineWidth.setEnabled(false);
        this.txtLineWidth.setFocusable(false);
        this.txtLineWidth.setMinimumSize(new Dimension(35, 20));
        this.txtLineWidth.setPreferredSize(new Dimension(35, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panFill.add((Component)this.txtLineWidth, gridBagConstraints);
        this.lblAlpha.setLabelFor(this.jPanel7);
        this.lblAlpha.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblAlpha.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.lblAlpha, gridBagConstraints);
        this.txtTransparency.setColumns(3);
        this.txtTransparency.setEditable(false);
        this.txtTransparency.setHorizontalAlignment(4);
        this.txtTransparency.setText("100");
        this.txtTransparency.setFocusable(false);
        this.txtTransparency.setMinimumSize(new Dimension(35, 20));
        this.txtTransparency.setPreferredSize(new Dimension(35, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panFill.add((Component)this.txtTransparency, gridBagConstraints);
        this.jPanel7.setLayout(new FlowLayout(1, 2, 0));
        this.panTransWhite.setBackground(new Color(255, 255, 255));
        this.panTransWhite.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panTransWhite.setMaximumSize(new Dimension(14, 14));
        this.panTransWhite.setMinimumSize(new Dimension(14, 14));
        this.panTransWhite.setPreferredSize(new Dimension(14, 14));
        GroupLayout panTransWhiteLayout = new GroupLayout(this.panTransWhite);
        this.panTransWhite.setLayout(panTransWhiteLayout);
        panTransWhiteLayout.setHorizontalGroup(panTransWhiteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        panTransWhiteLayout.setVerticalGroup(panTransWhiteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.jPanel7.add(this.panTransWhite);
        this.sldAlpha.setMajorTickSpacing(10);
        this.sldAlpha.setMinorTickSpacing(1);
        this.sldAlpha.setSnapToTicks(true);
        this.sldAlpha.setValue(100);
        this.sldAlpha.setMinimumSize(new Dimension(100, 23));
        this.sldAlpha.setPreferredSize(new Dimension(100, 23));
        this.sldAlpha.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                StyleDialog.this.sldAlphaMouseWheelMoved(evt);
            }
        });
        this.sldAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StyleDialog.this.sldAlphaStateChanged(evt);
            }
        });
        this.jPanel7.add(this.sldAlpha);
        this.panTransColor.setBackground(new Color(0, 180, 0));
        this.panTransColor.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panTransColor.setMaximumSize(new Dimension(14, 14));
        this.panTransColor.setMinimumSize(new Dimension(14, 14));
        this.panTransColor.setPreferredSize(new Dimension(14, 14));
        GroupLayout panTransColorLayout = new GroupLayout(this.panTransColor);
        this.panTransColor.setLayout(panTransColorLayout);
        panTransColorLayout.setHorizontalGroup(panTransColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        panTransColorLayout.setVerticalGroup(panTransColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.jPanel7.add(this.panTransColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panFill.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new FlowLayout(0, 5, 0));
        this.panFillColor.setBackground(new Color(0, 180, 0));
        this.panFillColor.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panFillColor.setMaximumSize(new Dimension(35, 15));
        this.panFillColor.setMinimumSize(new Dimension(35, 15));
        this.panFillColor.setPreferredSize(new Dimension(35, 15));
        GroupLayout panFillColorLayout = new GroupLayout(this.panFillColor);
        this.panFillColor.setLayout(panFillColorLayout);
        panFillColorLayout.setHorizontalGroup(panFillColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 33, Short.MAX_VALUE));
        panFillColorLayout.setVerticalGroup(panFillColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        this.jPanel8.add(this.panFillColor);
        this.cmdFill.setText("...");
        this.cmdFill.setMaximumSize(new Dimension(90, 18));
        this.cmdFill.setMinimumSize(new Dimension(30, 18));
        this.cmdFill.setPreferredSize(new Dimension(30, 18));
        this.cmdFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.cmdFillActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.cmdFill);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFill.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setLayout(new FlowLayout(0, 5, 0));
        this.panLineColor.setBackground(new Color(0, 125, 0));
        this.panLineColor.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panLineColor.setMaximumSize(new Dimension(35, 15));
        this.panLineColor.setMinimumSize(new Dimension(35, 15));
        this.panLineColor.setPreferredSize(new Dimension(35, 15));
        GroupLayout panLineColorLayout = new GroupLayout(this.panLineColor);
        this.panLineColor.setLayout(panLineColorLayout);
        panLineColorLayout.setHorizontalGroup(panLineColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 33, Short.MAX_VALUE));
        panLineColorLayout.setVerticalGroup(panLineColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        this.jPanel9.add(this.panLineColor);
        this.cmdLine.setText("...");
        this.cmdLine.setEnabled(false);
        this.cmdLine.setMaximumSize(new Dimension(30, 18));
        this.cmdLine.setMinimumSize(new Dimension(30, 18));
        this.cmdLine.setPreferredSize(new Dimension(30, 18));
        this.cmdLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.cmdLineActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.cmdLine);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 10);
        this.panFill.add((Component)this.jPanel9, gridBagConstraints);
        this.scrHistory.setMinimumSize(new Dimension(80, 50));
        this.scrHistory.setPreferredSize(new Dimension(80, 50));
        this.lstHistory.setSelectionMode(0);
        this.scrHistory.setViewportView(this.lstHistory);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.panFill.add((Component)this.scrHistory, gridBagConstraints);
        this.lblHistory.setFont(new Font("Tahoma", 0, 9));
        this.lblHistory.setLabelFor(this.lstHistory);
        this.lblHistory.setText("history.xml");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.panFill.add((Component)this.lblHistory, gridBagConstraints);
        this.lblPointSymbol.setLabelFor(this.cbbPointSymbol);
        this.lblPointSymbol.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblPointSymbol.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.panFill.add((Component)this.lblPointSymbol, gridBagConstraints);
        this.cbbPointSymbol.setMaximumRowCount(9);
        this.cbbPointSymbol.setMinimumSize(new Dimension(45, 25));
        this.cbbPointSymbol.setPreferredSize(new Dimension(45, 25));
        this.cbbPointSymbol.setRenderer(new PointSymbolListRenderer());
        this.cbbPointSymbol.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.cbbPointSymbolItemStateChanged(evt);
            }
        });
        this.cbbPointSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.cbbPointSymbolActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.panFill.add((Component)this.cbbPointSymbol, gridBagConstraints);
        this.lblPointSymbolSize.setLabelFor(this.sldPointSymbolSize);
        this.lblPointSymbolSize.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblPointSymbolSize.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        this.panFill.add((Component)this.lblPointSymbolSize, gridBagConstraints);
        this.sldPointSymbolSize.setMajorTickSpacing(10);
        this.sldPointSymbolSize.setMaximum(50);
        this.sldPointSymbolSize.setMinimum(5);
        this.sldPointSymbolSize.setMinorTickSpacing(1);
        this.sldPointSymbolSize.setPaintLabels(true);
        this.sldPointSymbolSize.setSnapToTicks(true);
        this.sldPointSymbolSize.setValue(5);
        this.sldPointSymbolSize.setMinimumSize(new Dimension(130, 37));
        this.sldPointSymbolSize.setPreferredSize(new Dimension(130, 37));
        this.sldPointSymbolSize.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                StyleDialog.this.sldPointSymbolSizeMouseWheelMoved(evt);
            }
        });
        this.sldPointSymbolSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StyleDialog.this.sldPointSymbolSizeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panFill.add((Component)this.sldPointSymbolSize, gridBagConstraints);
        this.txtPointSymbolSize.setColumns(2);
        this.txtPointSymbolSize.setEditable(false);
        this.txtPointSymbolSize.setHorizontalAlignment(4);
        this.txtPointSymbolSize.setText("10");
        this.txtPointSymbolSize.setFocusable(false);
        this.txtPointSymbolSize.setMinimumSize(new Dimension(35, 20));
        this.txtPointSymbolSize.setPreferredSize(new Dimension(35, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panFill.add((Component)this.txtPointSymbolSize, gridBagConstraints);
        this.panTabFill.add((Component)this.panFill, "West");
        this.tbpTabs.addTab(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.tbpTabs.tab1.title"), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/style_color.png")), this.panTabFill);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkCustomSLD, (Property)ELProperty.create((String)"${selected}"), (Object)this.panTabLabeling, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panTabLabeling.setLayout(new FlowLayout(0, 20, 20));
        this.panLabeling.setLayout(new GridBagLayout());
        this.chkActivateLabels.setSelected(true);
        this.chkActivateLabels.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkActivateLabels.text"));
        this.chkActivateLabels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkActivateLabelsItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.panLabeling.add((Component)this.chkActivateLabels, gridBagConstraints);
        this.lblAnnotationExpression.setLabelFor(this.cbbAnnotationExpression);
        this.lblAnnotationExpression.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblAttrib.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 15);
        this.panLabeling.add((Component)this.lblAnnotationExpression, gridBagConstraints);
        this.cbbAnnotationExpression.setEditable(true);
        this.cbbAnnotationExpression.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.cbbAnnotationExpressionItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panLabeling.add((Component)this.cbbAnnotationExpression, gridBagConstraints);
        this.panLabelButtons.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.panLabelButtons.border.title")));
        this.panLabelButtons.setLayout(new GridBagLayout());
        this.cmdChangeTextColor.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.cmdChangeColor.text"));
        this.cmdChangeTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.cmdChangeTextColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panLabelButtons.add((Component)this.cmdChangeTextColor, gridBagConstraints);
        this.cmdChangeFont.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.cmdChangeFont.text"));
        this.cmdChangeFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.cmdChangeFontActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.panLabelButtons.add((Component)this.cmdChangeFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 0);
        this.panLabelButtons.add((Component)this.lblFontname, gridBagConstraints);
        this.panFontColor.setBackground(new Color(0, 0, 0));
        this.panFontColor.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panFontColor.setMinimumSize(new Dimension(20, 20));
        this.panFontColor.setPreferredSize(new Dimension(20, 20));
        GroupLayout panFontColorLayout = new GroupLayout(this.panFontColor);
        this.panFontColor.setLayout(panFontColorLayout);
        panFontColorLayout.setHorizontalGroup(panFontColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 18, Short.MAX_VALUE));
        panFontColorLayout.setVerticalGroup(panFontColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 18, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 0);
        this.panLabelButtons.add((Component)this.panFontColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panLabeling.add((Component)this.panLabelButtons, gridBagConstraints);
        this.panScale.setLayout(new FlowLayout(1, 5, 0));
        this.lblMin.setLabelFor(this.txtMin);
        this.lblMin.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblMin.text"));
        this.panScale.add(this.lblMin);
        this.txtMin.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtMin.setText("1");
        this.txtMin.setMinimumSize(new Dimension(60, 20));
        this.txtMin.setPreferredSize(new Dimension(60, 20));
        this.panScale.add(this.txtMin);
        this.lblMax.setLabelFor(this.txtMax);
        this.lblMax.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblMax.text"));
        this.panScale.add(this.lblMax);
        this.txtMax.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtMax.setText("2500");
        this.txtMax.setMinimumSize(new Dimension(60, 20));
        this.txtMax.setPreferredSize(new Dimension(60, 20));
        this.panScale.add(this.txtMax);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.panLabeling.add((Component)this.panScale, gridBagConstraints);
        this.chkAutoscale.setSelected(true);
        this.chkAutoscale.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.chkAutoscale.text"));
        this.chkAutoscale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.chkAutoscaleItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.panLabeling.add((Component)this.chkAutoscale, gridBagConstraints);
        this.panAlignment.setLayout(new FlowLayout(0, 5, 0));
        this.btgAlignment.add(this.radLeft);
        this.radLeft.setSelected(true);
        this.radLeft.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.radleft.text"));
        this.radLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.radLeftActionPerformed(evt);
            }
        });
        this.panAlignment.add(this.radLeft);
        this.btgAlignment.add(this.radCenter);
        this.radCenter.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.radCenter.text"));
        this.radCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.radCenterActionPerformed(evt);
            }
        });
        this.panAlignment.add(this.radCenter);
        this.btgAlignment.add(this.radRight);
        this.radRight.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.radRight.text"));
        this.radRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.radRightActionPerformed(evt);
            }
        });
        this.panAlignment.add(this.radRight);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panLabeling.add((Component)this.panAlignment, gridBagConstraints);
        this.lblAlignment.setLabelFor(this.panAlignment);
        this.lblAlignment.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblAlignment.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 15);
        this.panLabeling.add((Component)this.lblAlignment, gridBagConstraints);
        this.lblMultiplier.setLabelFor(this.txtMultiplier);
        this.lblMultiplier.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblMultiplier.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 15);
        this.panLabeling.add((Component)this.lblMultiplier, gridBagConstraints);
        this.txtMultiplier.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.00"))));
        this.txtMultiplier.setText("1,00");
        this.txtMultiplier.setMinimumSize(new Dimension(40, 20));
        this.txtMultiplier.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panLabeling.add((Component)this.txtMultiplier, gridBagConstraints);
        this.panTabLabeling.add(this.panLabeling);
        this.tbpTabs.addTab(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.tbpTabs.tab2.title"), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/labelling.png")), this.panTabLabeling);
        this.panTabAttrib.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.panTabAttrib.border.title"))));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkCustomSLD, (Property)ELProperty.create((String)"${selected}"), (Object)this.panTabAttrib, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panTabAttrib.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.panTabAttrib.border.title"))));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkCustomSLD, (Property)ELProperty.create((String)"${selected}"), (Object)this.panTabAttrib, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panTabAttrib.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.panTabAttrib.border.title"))));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkCustomSLD, (Property)ELProperty.create((String)"${selected}"), (Object)this.panTabAttrib, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panTabAttrib.setLayout(new FlowLayout(1, 5, 0));
        this.jPanel2.setLayout(new GridBagLayout());
        this.panAttribGeo.setLayout(new BoxLayout(this.panAttribGeo, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 20);
        this.jPanel2.add((Component)this.panAttribGeo, gridBagConstraints);
        this.panAttribSeparator.setLayout(new BorderLayout());
        this.panAttribSeparator.add((Component)this.jSeparator1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel2.add((Component)this.panAttribSeparator, gridBagConstraints);
        this.panAttribNorm.setLayout(new BoxLayout(this.panAttribNorm, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 20);
        this.jPanel2.add((Component)this.panAttribNorm, gridBagConstraints);
        this.lblIdExpression.setLabelFor(this.cbbIdExpression);
        this.lblIdExpression.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.lblPrimary.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 20, 10);
        this.jPanel2.add((Component)this.lblIdExpression, gridBagConstraints);
        this.cbbIdExpression.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StyleDialog.this.cbbIdExpressionItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.jPanel2.add((Component)this.cbbIdExpression, gridBagConstraints);
        this.panTabAttrib.add(this.jPanel2);
        this.tbpTabs.addTab(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.tbpTabs.tab3.title"), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/attributes.png")), this.panTabAttrib);
        this.panTabAttrib.getAccessibleContext().setAccessibleName(null);
        this.panSLDDefinition.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder("SLD Definition")));
        this.panSLDDefinition.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkCustomSLD, (Property)ELProperty.create((String)"${!selected}"), (Object)this.jEditorPane1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane2.setViewportView(this.jEditorPane1);
        this.jEditorPane1.getAccessibleContext().setAccessibleName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel4.add((Component)this.jScrollPane2, gridBagConstraints);
        this.chkCustomSLD.setSelected(true);
        this.chkCustomSLD.setText("Expertenmodus");
        this.chkCustomSLD.setToolTipText("");
        this.chkCustomSLD.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/icon-unlock.png")));
        this.chkCustomSLD.setIcon(new ImageIcon(this.getClass().getResource("/icon-unlock.png")));
        this.chkCustomSLD.setSelectedIcon(new ImageIcon(this.getClass().getResource("/icon-lock.png")));
        this.chkCustomSLD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.chkCustomSLDActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.chkCustomSLD, gridBagConstraints);
        this.panSLDDefinition.add((Component)this.jPanel4, "Center");
        this.tbpTabs.addTab("SLD Definition", this.panSLDDefinition);
        this.panTabs.add((Component)this.tbpTabs, "Center");
        this.tbpTabs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.tbpTabs.tab1.title"));
        this.panMain.add((Component)this.panTabs, "Center");
        this.getContentPane().add((Component)this.panMain, "Center");
        this.panDialogButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, -5));
        this.panDialogButtons.setLayout(new FlowLayout(2, 10, 0));
        this.cmdOK.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.cmdIOK.text"));
        this.cmdOK.setMaximumSize(new Dimension(88, 23));
        this.cmdOK.setMinimumSize(new Dimension(88, 23));
        this.cmdOK.setPreferredSize(new Dimension(88, 23));
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.cmdOKActionPerformed(evt);
            }
        });
        this.panDialogButtons.add(this.cmdOK);
        this.cmdCancel.setText(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.cmdCancel.text"));
        this.cmdCancel.setMaximumSize(new Dimension(88, 23));
        this.cmdCancel.setMinimumSize(new Dimension(88, 23));
        this.cmdCancel.setPreferredSize(new Dimension(88, 23));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.cmdCancelActionPerformed(evt);
            }
        });
        this.panDialogButtons.add(this.cmdCancel);
        this.getContentPane().add((Component)this.panDialogButtons, "South");
        this.bindingGroup.bind();
        this.pack();
    }

    private void chkLineActionPerformed(ActionEvent evt) {
    }

    private void chkCustomSLDActionPerformed(ActionEvent evt) {
        if (!this.chkCustomSLD.isSelected()) {
            int i = JOptionPane.showConfirmDialog(this, "Das aktivieren des Expertenmodus \u00fcbernimmt die F\u00fcllfarbe,\nLinienfarbe und Linienstaerke aus dem einfachen Stil", "Sind Sie sicher?", 0, 2);
            if (i == 0) {
                this.jEditorPane1.setText(this.getSLDStyle(true));
            } else {
                this.chkCustomSLD.setSelected(true);
                return;
            }
        }
        this.tbpTabs.setEnabledAt(this.tbpTabs.indexOfComponent(this.panTabFill), this.chkCustomSLD.isSelected());
        this.tbpTabs.setEnabledAt(this.tbpTabs.indexOfComponent(this.panTabLabeling), this.chkCustomSLD.isSelected());
        this.tbpTabs.setEnabledAt(this.tbpTabs.indexOfComponent(this.panTabAttrib), this.chkCustomSLD.isSelected());
    }

    public String getSLDStyle() {
        return this.chkCustomSLD.isSelected() ? "" : this.getSLDStyle(false);
    }

    public String getSLDStyle(boolean simpleStyle) {
        if (simpleStyle) {
            String sld = "<sld:StyledLayerDescriptor xmlns:sld=\"http://www.opengis.net/sld\" xmlns:se=\"http://www.opengis.net/se\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"\n  xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns=\"http://www.opengis.net/sld\" version=\"1.1.0\"\n  xsi:schemaLocation=\"http://www.opengis.net/sld http://schemas.opengis.net/sld/1.1.0/StyledLayerDescriptor.xsd\">\n  <sld:NamedLayer>\n    <!--  This styling file shows the use of SLD styling -->\n    <sld:Name>" + this.layerName + "</sld:Name>\n        <sld:UserStyle>\n            <sld:Name>" + this.layerName + "</sld:Name>\n    <sld:Title>" + this.layerName + "</sld:Title>\n            <sld:FeatureTypeStyle>\n                <sld:Name>" + this.layerName + "</sld:Name>\n                <sld:Rule>\n                    <sld:Name>" + this.layerName + "</sld:Name>\n";
            sld = sld + "                    <sld:PolygonSymbolizer uom=\"http://www.opengeospatial/se/units/pixel\">\n";
            if (this.chkFill.isSelected()) {
                sld = sld + "                        <sld:Fill>\n";
                sld = sld + "                            <sld:CssParameter name=\"fill\">";
                sld = sld + "#" + Integer.toHexString(this.panFillColor.getBackground().getRGB()).substring(2).toUpperCase();
                sld = sld + "</sld:CssParameter>\n";
                if (this.panFillColor.getBackground().getAlpha() != 255) {
                    sld = sld + "                            <sld:CssParameter name=\"fill-opacity\">";
                    sld = sld + (float)(this.panFillColor.getBackground().getAlpha() * 100 / 255) * 0.01f;
                    sld = sld + "</sld:CssParameter>\n";
                }
                sld = sld + "                        </sld:Fill>\n";
            }
            if (this.chkLine.isSelected()) {
                sld = sld + "                        <sld:Stroke>\n";
                sld = sld + "                            <sld:CssParameter name=\"stroke\">";
                sld = sld + "#" + Integer.toHexString(this.panLineColor.getBackground().getRGB()).substring(2).toUpperCase();
                sld = sld + "</sld:CssParameter>\n";
                if (this.panLineColor.getBackground().getAlpha() != 255) {
                    sld = sld + "                            <sld:CssParameter name=\"stroke-opacity\">";
                    sld = sld + (float)(this.panLineColor.getBackground().getAlpha() * 100 / 255) * 0.01f;
                    sld = sld + "</sld:CssParameter>\n";
                }
                sld = sld + "                            <sld:CssParameter name=\"stroke-width\">";
                sld = sld + this.sldLineWidth.getValue();
                sld = sld + "</sld:CssParameter>\n";
                sld = sld + "                        </sld:Stroke>\n";
            }
            sld = sld + "                    </sld:PolygonSymbolizer>\n";
            sld = sld + "                </sld:Rule>\n            </sld:FeatureTypeStyle>\n        </sld:UserStyle>\n    </sld:NamedLayer>\n</sld:StyledLayerDescriptor>";
            return sld;
        }
        return this.jEditorPane1.getText();
    }

    public LayerProperties getLayerProperties() {
        if (!this.isAccepted()) {
            this.logger.warn((Object)"supicious call to 'getLayerProperties()', changes not accepted");
        }
        return this.layerProperties;
    }

    protected void setLayerProperties(LayerProperties layerProperties) {
        this.layerProperties = layerProperties.clone();
    }

    private Style getStyle() {
        return this.layerProperties.getStyle();
    }

    private void doClose(boolean accepted) {
        this.setAccepted(accepted);
        this.tbpTabs.setSelectedComponent(this.panTabFill);
        this.lstHistory.setSelectedIndex(-1);
        this.setVisible(false);
        this.dispose();
    }

    private void createXMLEditor() {
        try {
            XMLEditorKit kit = new XMLEditorKit(true);
            kit.setWrapStyleWord(true);
            kit.setLineWrappingEnabled(this.chkLinewrap.isSelected());
            this.queryEditor.setEditorKit((EditorKit)kit);
            this.queryEditor.setFont(new Font("Monospace", 0, 12));
            this.queryEditor.getDocument().putProperty("tabSize", new Integer(4));
            this.queryEditor.getDocument().putProperty("autoIndentation", new Boolean(true));
            this.queryEditor.getDocument().putProperty("tagCompletion", new Boolean(true));
            kit.setStyle("attribute-name", Color.GREEN.darker(), 0);
            kit.setStyle("attribute-value", Color.MAGENTA.darker(), 0);
            kit.setStyle("Comment", Color.GRAY, 0);
            kit.setStyle("Declaration", Color.DARK_GRAY, 1);
            kit.setStyle("element-name", Color.BLUE, 0);
            kit.setStyle("element-prefix", Color.BLUE, 0);
            kit.setStyle("element-value", Color.BLACK, 1);
            kit.setStyle("namespace-name", Color.GREEN.darker(), 0);
            kit.setStyle("namespace-value", Color.MAGENTA.darker(), 0);
            kit.setStyle("namespace-prefix", Color.GREEN.darker(), 0);
            kit.setStyle("Special", Color.BLACK, 0);
            ScrollableEditorPanel editorPanel = new ScrollableEditorPanel(this.queryEditor);
            this.scpQuery.setViewportView((Component)editorPanel);
            this.scpQuery.setRowHeaderView((Component)new LineNumberMargin((JTextComponent)this.queryEditor));
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error during the creation of the QueryEditor", (Throwable)ex);
        }
    }

    private void createPointSymbols() {
        this.pointSymbolHM.put("Keins", null);
        this.pointSymbolHM.put("Punkt", null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/pushpin.png"));
        }
        FeatureAnnotationSymbol pushPin = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/pushpin.png")).getImage());
        pushPin.setSweetSpotX(0.14);
        pushPin.setSweetSpotY(1.0);
        this.pointSymbolHM.put("pushpin.png", pushPin);
        FeatureAnnotationSymbol arrowBlue = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/arrow-blue-down.png")).getImage());
        arrowBlue.setSweetSpotX(0.5);
        arrowBlue.setSweetSpotY(1.0);
        this.pointSymbolHM.put("arrow-blue-down.png", arrowBlue);
        FeatureAnnotationSymbol arrowGreen = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/arrow-green-down.png")).getImage());
        arrowGreen.setSweetSpotX(0.5);
        arrowGreen.setSweetSpotY(1.0);
        this.pointSymbolHM.put("arrow-green-down.png", arrowGreen);
        FeatureAnnotationSymbol flagBlack = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/flag-black.png")).getImage());
        flagBlack.setSweetSpotX(0.18);
        flagBlack.setSweetSpotY(0.96);
        this.pointSymbolHM.put("flag-black.png", flagBlack);
        FeatureAnnotationSymbol flagBlue = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/flag-blue.png")).getImage());
        flagBlue.setSweetSpotX(0.18);
        flagBlue.setSweetSpotY(0.96);
        this.pointSymbolHM.put("flag-blue.png", flagBlue);
        FeatureAnnotationSymbol flagGreen = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/flag-green.png")).getImage());
        flagGreen.setSweetSpotX(0.18);
        flagGreen.setSweetSpotY(0.96);
        this.pointSymbolHM.put("flag-green.png", flagGreen);
        FeatureAnnotationSymbol flagRed = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/flag-red.png")).getImage());
        flagRed.setSweetSpotX(0.18);
        flagRed.setSweetSpotY(0.96);
        this.pointSymbolHM.put("flag-red.png", flagRed);
        FeatureAnnotationSymbol flagYellow = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/flag-yellow.png")).getImage());
        flagYellow.setSweetSpotX(0.18);
        flagYellow.setSweetSpotY(0.96);
        this.pointSymbolHM.put("flag-yellow.png", flagYellow);
        FeatureAnnotationSymbol starBlack = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/star-black.png")).getImage());
        starBlack.setSweetSpotX(0.5);
        starBlack.setSweetSpotY(0.5);
        this.pointSymbolHM.put("star-black.png", starBlack);
        FeatureAnnotationSymbol starYellow = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/star-yellow.png")).getImage());
        starYellow.setSweetSpotX(0.5);
        starYellow.setSweetSpotY(0.5);
        this.pointSymbolHM.put("star-yellow.png", starYellow);
        FeatureAnnotationSymbol infoButton = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/info.png")).getImage());
        infoButton.setSweetSpotX(0.5);
        infoButton.setSweetSpotY(0.5);
        this.pointSymbolHM.put("info.png", infoButton);
    }

    private void updatePreview() {
        ((StylePreviewPanel)this.panPreview).update(this.getStyle(), this.getStyle().getPointSymbol());
        Object object = this.cbbPointSymbol.getSelectedItem();
        this.getStyle();
        if (object.equals("Punkt") && !this.sldLineWidth.getValueIsAdjusting() && !this.sldPointSymbolSize.getValueIsAdjusting()) {
            if (this.pointSymbol == null) {
                this.pointSymbol = ((BasicStyle)this.layerProperties.getStyle()).createAutoPointSymbol();
            } else {
                this.pointSymbol.setImage(((StylePreviewPanel)this.panPreview).getPointSymbol());
            }
        }
    }

    private File searchDefaultHistory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"search for defaultStyleHistory.xml");
        }
        if (this.fileToCismapFolder.exists() && this.fileToCismapFolder.isDirectory()) {
            File test = new File(this.fileToCismapFolder.getPath() + this.seperator + DEFAULT_HISTORY_NAME);
            if (test.exists() && test.isFile() && test.canRead() && test.canWrite()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"defaultStyleHistory.xml found");
                }
                return test;
            }
            return this.createDefaultHistory();
        }
        this.fileToCismapFolder.mkdir();
        return this.createDefaultHistory();
    }

    private File createDefaultHistory() {
        try {
            File newFile = new File(this.fileToCismapFolder.getPath() + this.seperator + DEFAULT_HISTORY_NAME);
            newFile.createNewFile();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"defaultStyleHistory.xml successfully created");
            }
            return newFile;
        }
        catch (IOException ex) {
            this.logger.error((Object)"defaultStyleHistory.xml could not create", (Throwable)ex);
            return null;
        }
    }

    private void writeHistory(final File f, final boolean onClose) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("writeHistory(" + f + ")"));
        }
        Runnable writeHistoryRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputStreamWriter writer = null;
                try {
                    f.createNewFile();
                    if (f.canWrite()) {
                        if (onClose) {
                            ((StyleHistoryListModel)StyleDialog.this.lstHistory.getModel()).addStyle((Style)StyleDialog.this.getStyle().clone());
                        }
                        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
                        Document doc = new Document(((StyleHistoryListModel)StyleDialog.this.lstHistory.getModel()).toElement());
                        writer = new FileWriter(f);
                        out.output(doc, (Writer)writer);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StyleDialog.this.lblHistory.setText(f.getName());
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    StyleDialog.this.logger.error((Object)"Error during writing the history.", (Throwable)ex);
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)StyleDialog.this), NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.writeHistory(File,boolean).JOptionPane.message", (Object[])new Object[]{ex.getMessage()}), NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.writeHistory(File,boolean).JOptionPane.title"), 0);
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(writeHistoryRunnable, "StyleDialog writeHistory()"));
    }

    private void loadHistory(final File f) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("loadHistory(" + f + ")"));
        }
        Runnable loadHistoryRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    final StyleHistoryListModel model = new StyleHistoryListModel(f);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StyleDialog.this.lstHistory.setModel(model);
                            StyleDialog.this.lblHistory.setText(f.getName());
                            StyleDialog.this.defaultHistory = f;
                            if (StyleDialog.this.logger.isDebugEnabled()) {
                                StyleDialog.this.logger.debug((Object)(f + " successfully loaded"));
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    StyleDialog.this.logger.error((Object)"Error during loading of the history", (Throwable)ex);
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)StyleDialog.this), NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.loadHistory().JOptionPane.message", (Object[])new Object[]{ex.getMessage()}), NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.loadHistory().JOptionPane.title"), 0);
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(loadHistoryRunnable, "StyleDialog loadHistory()"));
    }

    private void createHistoryListPopupMenu() {
        final FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().endsWith(".xml") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.createHistoryListPopupMenu().description");
            }
        };
        JMenuItem save = new JMenuItem();
        save.setText(POPUP_SAVE);
        try {
            save.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/save.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser fc;
                    try {
                        fc = new JFileChooser(StyleDialog.this.home + StyleDialog.this.seperator + StyleDialog.CISMAP_FOLDER);
                    }
                    catch (Exception bug) {
                        fc = new JFileChooser(StyleDialog.this.home + StyleDialog.this.seperator + StyleDialog.CISMAP_FOLDER, (FileSystemView)new RestrictedFileSystemView());
                    }
                    fc.setFileFilter(filter);
                    fc.setMultiSelectionEnabled(false);
                    fc.setFileSelectionMode(0);
                    int returnValue = fc.showSaveDialog(StyleDialog.this);
                    if (returnValue == 0) {
                        File dst = fc.getSelectedFile();
                        if (!dst.getName().endsWith(".xml")) {
                            dst = new File(dst.toString() + ".xml");
                        }
                        StyleDialog.this.writeHistory(dst, false);
                        StyleDialog.this.defaultHistory = dst;
                    }
                }
                catch (Throwable ex) {
                    StyleDialog.this.logger.error((Object)"Error during opening the Open Dialog of the style history", ex);
                }
            }
        });
        JMenuItem open = new JMenuItem();
        open.setText(POPUP_LOAD);
        try {
            open.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/open.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser fc;
                    try {
                        fc = new JFileChooser(StyleDialog.this.home + StyleDialog.this.seperator + StyleDialog.CISMAP_FOLDER);
                    }
                    catch (Exception bug) {
                        fc = new JFileChooser(StyleDialog.this.home + StyleDialog.this.seperator + StyleDialog.CISMAP_FOLDER, (FileSystemView)new RestrictedFileSystemView());
                    }
                    fc.setFileFilter(filter);
                    fc.setMultiSelectionEnabled(false);
                    fc.setFileSelectionMode(0);
                    int returnVal = fc.showOpenDialog(StyleDialog.this);
                    if (returnVal == 0) {
                        File fileToLoad = fc.getSelectedFile();
                        StyleDialog.this.loadHistory(fileToLoad);
                    }
                }
                catch (Throwable ex) {
                    StyleDialog.this.logger.error((Object)"Error in open dialog of the StyleHistory", ex);
                }
            }
        });
        JMenuItem clear = new JMenuItem();
        clear.setText(POPUP_CLEAR);
        try {
            clear.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/delete_history.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleHistoryListModel model = (StyleHistoryListModel)StyleDialog.this.lstHistory.getModel();
                model.clear();
                StyleDialog.this.lstHistory.repaint();
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(save);
        this.popupMenu.add(open);
        this.popupMenu.add(new JSeparator());
        this.popupMenu.add(clear);
    }

    public void configureDialog(LayerProperties layerProperties, Map<String, FeatureServiceAttribute> featureServiceAttributes, Object query) {
        this.configureDialog(null, "default", layerProperties, featureServiceAttributes, query);
    }

    public void configureDialog(Reader sldDefinition, AbstractFeatureService featureService) {
        this.configureDialog(sldDefinition, featureService.getName(), featureService.getLayerProperties(), featureService.getFeatureServiceAttributes(), featureService.getQuery());
    }

    public void configureDialog(Reader sldDefinition, String layerName, LayerProperties layerProperties, Map<String, FeatureServiceAttribute> featureServiceAttributes, Object query) {
        try {
            this.layerName = layerName;
            this.chkCustomSLD.setSelected(sldDefinition == null);
            this.tbpTabs.setEnabledAt(this.tbpTabs.indexOfComponent(this.panTabFill), this.chkCustomSLD.isSelected());
            this.tbpTabs.setEnabledAt(this.tbpTabs.indexOfComponent(this.panTabLabeling), this.chkCustomSLD.isSelected());
            this.tbpTabs.setEnabledAt(this.tbpTabs.indexOfComponent(this.panTabAttrib), this.chkCustomSLD.isSelected());
            this.setAccepted(false);
            this.setFeatureServiceAttributes(featureServiceAttributes);
            this.setLayerProperties(layerProperties);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("QueryType: " + this.layerProperties.getQueryType()));
            }
            if (this.layerProperties.getQueryType() != -1 && query != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Layer supports query, adding query dialog");
                }
                this.tbpTabs.addTab("Query Editor", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/editor.png")), this.panTabQuery);
                this.setQueryString(query.toString());
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Layer does not support query, removing query dialog");
                }
                this.tbpTabs.remove(this.panTabQuery);
            }
            if (sldDefinition != null) {
                this.jEditorPane1.setText(IOUtils.toString((Reader)sldDefinition));
            }
            this.updateDialog();
            this.updateAttributes();
            this.updatePreview();
        }
        catch (Throwable t) {
            this.logger.error((Object)t.getMessage(), t);
        }
    }

    private void updateDialog() {
        this.panFillColor.setBackground(this.getStyle().getFillColor());
        this.panTransColor.setBackground(this.getStyle().getFillColor());
        this.chkFill.setSelected(this.getStyle().isDrawFill());
        this.panLineColor.setBackground(this.getStyle().getLineColor());
        this.chkLine.setSelected(this.getStyle().isDrawLine());
        this.chkSync.setSelected(false);
        this.chkHighlightable.setSelected(this.getStyle().isHighlightFeature());
        this.sldLineWidth.setValue(this.getStyle().getLineWidth());
        this.setAlpha(this.getStyle().getAlpha());
        if (!this.pointSymbolHM.containsKey(this.getStyle().getPointSymbolFilename())) {
            this.logger.warn((Object)("unkown point symbol: '" + this.getStyle().getPointSymbolFilename() + "', adding to list"));
            this.pointSymbolHM.put(this.getStyle().getPointSymbolFilename(), this.getStyle().getPointSymbol());
            this.cbbPointSymbol.setModel(new DefaultComboBoxModel<String>(new Vector<String>(this.pointSymbolHM.keySet())));
        }
        this.cbbPointSymbol.setSelectedItem(this.getStyle().getPointSymbolFilename());
        String string = this.getStyle().getPointSymbolFilename();
        this.getStyle();
        if (string.equals("Punkt")) {
            this.setPointSymbolSizeActivated(true);
            this.sldPointSymbolSize.setValue(this.getStyle().getPointSymbolSize());
        } else {
            this.setPointSymbolSizeActivated(false);
            this.getStyle();
            this.sldPointSymbolSize.setValue(5);
        }
        this.chkActivateLabels.setSelected(this.getStyle().isDrawLabel());
        this.setFontType(this.getStyle().getFont());
        this.panFontColor.setBackground(this.getStyle().getFontColor());
        this.setAlignment(this.getStyle().getAlignment());
        this.txtMin.setText("" + this.getStyle().getMinScale());
        this.txtMax.setText("" + this.getStyle().getMaxScale());
        this.setMultiplier(this.getStyle().getMultiplier());
        this.chkAutoscale.setSelected(this.getStyle().isAutoscale());
    }

    private void updateAttributes() {
        boolean expressionSet;
        this.cbbAnnotationExpression.removeAllItems();
        this.cbbIdExpression.removeAllItems();
        this.panAttribGeo.removeAll();
        this.panAttribNorm.removeAll();
        this.btgGeom = new ButtonGroup();
        this.ignoreSelectionEvent = true;
        if (this.layerProperties.isIdExpressionEnabled()) {
            String idExpression = this.layerProperties.getIdExpression();
            if (idExpression == null || this.layerProperties.getIdExpressionType() == 1 && !this.featureServiceAttributes.containsKey(idExpression)) {
                expressionSet = false;
                for (FeatureServiceAttribute fsa : this.featureServiceAttributes.values()) {
                    if (fsa.isGeometry() || !fsa.isSelected()) continue;
                    this.layerProperties.setIdExpression(fsa.getName(), 1);
                    this.logger.warn((Object)("idExpression is null or not in attriute list, setting to '" + fsa.getName() + "' (" + fsa.getType() + ", EXPRESSIONTYPE_PROPERTYNAME)"));
                    expressionSet = true;
                    break;
                }
                if (!expressionSet) {
                    for (FeatureServiceAttribute fsa : this.featureServiceAttributes.values()) {
                        if (fsa.isGeometry()) continue;
                        fsa.setSelected(true);
                        this.layerProperties.setIdExpression(fsa.getName(), 1);
                        this.logger.warn((Object)("idExpression is null or not in attriute list, setting to '" + fsa.getName() + "' (EXPRESSIONTYPE_PROPERTYNAME) and forcing attribute enabled"));
                        expressionSet = true;
                        break;
                    }
                }
                if (!expressionSet) {
                    this.logger.error((Object)"no valid id expression could be dertimed from the list of available attributes");
                }
            } else if (this.layerProperties.getIdExpressionType() == 1 && !this.featureServiceAttributes.get(idExpression).isSelected()) {
                this.logger.warn((Object)("idExpression '" + idExpression + "' is not selected, forcing selected"));
                this.featureServiceAttributes.get(idExpression).setSelected(true);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"the selected layer does not support id expressions");
            }
            this.cbbIdExpression.setEnabled(false);
        }
        String annotationExpression = this.layerProperties.getPrimaryAnnotationExpression();
        if (annotationExpression == null || this.layerProperties.getPrimaryAnnotationExpressionType() == 1 && !this.featureServiceAttributes.containsKey(annotationExpression)) {
            expressionSet = false;
            for (FeatureServiceAttribute fsa : this.featureServiceAttributes.values()) {
                if (fsa.isGeometry() || !fsa.isSelected()) continue;
                this.layerProperties.setPrimaryAnnotationExpression(fsa.getName(), 1);
                this.logger.warn((Object)("annotationExpressionExpression is null or not in attriute list, setting to '" + fsa.getName() + "' (EXPRESSIONTYPE_PROPERTYNAME)"));
                expressionSet = true;
                break;
            }
            if (!expressionSet) {
                for (FeatureServiceAttribute fsa : this.featureServiceAttributes.values()) {
                    if (fsa.isGeometry()) continue;
                    fsa.setSelected(true);
                    this.layerProperties.setPrimaryAnnotationExpression(fsa.getName(), 1);
                    this.logger.warn((Object)("annotationExpressionExpression is null or not in attriute list, setting to '" + fsa.getName() + "' (EXPRESSIONTYPE_PROPERTYNAME) and forcing attribute enabled"));
                    expressionSet = true;
                    break;
                }
            }
            if (!expressionSet) {
                this.logger.error((Object)"no valid annotationExpression expression could be determined from the list of available attributes");
            }
        } else if (this.layerProperties.getPrimaryAnnotationExpressionType() == 1 && !this.featureServiceAttributes.get(annotationExpression).isSelected()) {
            this.logger.warn((Object)("annotationExpression '" + annotationExpression + "' is not selected, forcing selected"));
            this.featureServiceAttributes.get(annotationExpression).setSelected(true);
        }
        for (FeatureServiceAttribute fsa : this.featureServiceAttributes.values()) {
            if (!fsa.isGeometry()) {
                this.createNormalAttributeButton(fsa);
                continue;
            }
            this.createGeoAttributeButton(fsa);
        }
        if (this.layerProperties.isIdExpressionEnabled()) {
            this.cbbIdExpression.setSelectedItem(this.layerProperties.getIdExpression());
        }
        this.cbbAnnotationExpression.setSelectedItem(this.layerProperties.getPrimaryAnnotationExpression());
        this.ignoreSelectionEvent = false;
        if (this.btgGeom.getSelection() == null && this.btgGeom.getButtonCount() > 0) {
            this.btgGeom.setSelected(this.btgGeom.getElements().nextElement().getModel(), true);
            this.logger.warn((Object)("no geo attribute selected, forcing selection of attribute '" + this.btgGeom.getSelection().getActionCommand() + "'"));
        }
    }

    private void setAttributes(List<FeatureServiceAttribute> attributes) {
    }

    private void createGeoAttributeButton(final FeatureServiceAttribute fsa) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Geo-Attribut \"" + fsa.getName() + "\" adden"));
        }
        JRadioButton rb = new JRadioButton(fsa.getName());
        rb.setActionCommand(fsa.getName());
        this.btgGeom.add(rb);
        rb.setSelected(fsa.isSelected());
        this.panAttribGeo.add(rb);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!StyleDialog.this.ignoreSelectionEvent && e.getStateChange() == 1) {
                    fsa.setSelected(true);
                } else {
                    fsa.setSelected(false);
                }
            }
        });
    }

    private void createNormalAttributeButton(final FeatureServiceAttribute fsa) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attribut \"" + fsa.getName() + "\" adden"));
        }
        JCheckBox cb = new JCheckBox(fsa.getName(), false);
        cb.setActionCommand(fsa.getName());
        cb.setSelected(fsa.isSelected());
        if (fsa.isSelected()) {
            this.cbbAnnotationExpression.addItem(fsa.getName());
            this.cbbIdExpression.addItem(fsa.getName());
        }
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!StyleDialog.this.ignoreSelectionEvent && e.getStateChange() == 1) {
                    fsa.setSelected(true);
                    StyleDialog.this.cbbAnnotationExpression.addItem(fsa.getName());
                    StyleDialog.this.cbbIdExpression.addItem(fsa.getName());
                } else if (!StyleDialog.this.ignoreSelectionEvent && e.getStateChange() == 2) {
                    fsa.setSelected(false);
                    StyleDialog.this.cbbAnnotationExpression.removeItem(fsa.getName());
                    StyleDialog.this.cbbIdExpression.removeItem(fsa.getName());
                }
            }
        });
        this.panAttribNorm.add(cb);
    }

    public Vector<String> getSelectedAttributes() {
        Vector<String> selectedAttributes = new Vector<String>(this.featureServiceAttributes.size());
        for (FeatureServiceAttribute fsa : this.featureServiceAttributes.values()) {
            if (!fsa.isSelected()) continue;
            selectedAttributes.add(fsa.getName());
        }
        return selectedAttributes;
    }

    public String getSelectedGeoAttribute() {
        if (!this.isAccepted()) {
            this.logger.warn((Object)"supicious call to 'getQueryString()', changes not accepted");
        }
        return this.btgGeom.getSelection().getActionCommand();
    }

    private void setFillColor(boolean paint, Color fillColor) {
        this.getStyle().setDrawFill(paint);
        this.getStyle().setFillColor(fillColor);
        this.panFillColor.setBackground(fillColor);
        this.panTransColor.setBackground(fillColor);
        this.chkFill.setSelected(paint);
    }

    private void setLineColor(boolean paint, Color lineColor) {
        this.getStyle().setDrawLine(paint);
        this.getStyle().setLineColor(lineColor);
        this.panLineColor.setBackground(lineColor);
        this.chkLine.setSelected(paint);
    }

    private void setLineWidth(int lineWidth) {
        this.getStyle().setLineWidth(lineWidth);
        if (this.sldLineWidth.getValue() != lineWidth) {
            this.sldLineWidth.setValue(lineWidth);
        }
        this.txtLineWidth.setText("" + lineWidth);
    }

    private void setAlpha(float alpha) {
        this.getStyle().setAlpha(alpha);
        int a = Math.round(alpha * 100.0f);
        if (this.sldAlpha.getValue() != a) {
            this.sldAlpha.setValue(a);
        }
        this.txtTransparency.setText("" + a);
    }

    private void setPointSymbol(String pointSymbol) {
        this.getStyle();
        this.setPointSymbolSizeActivated(pointSymbol.equals("Punkt"));
        this.getStyle().setPointSymbolFilename(pointSymbol);
    }

    private void setPointSymbolSize(int size) {
        this.getStyle().setPointSymbolSize(size);
        this.txtPointSymbolSize.setText(size + "");
    }

    private void setPointSymbolSizeActivated(boolean flag) {
        this.lblPointSymbolSize.setEnabled(flag);
        this.sldPointSymbolSize.setEnabled(flag);
        this.txtPointSymbolSize.setEnabled(flag);
    }

    private void setHighlighting(boolean flag) {
        this.getStyle().setHighlightFeature(flag);
        if (this.chkHighlightable.isSelected() != flag) {
            this.chkHighlightable.setSelected(flag);
        }
    }

    private void setLabelingEnabled(boolean flag) {
        this.getStyle().setDrawLabel(flag);
        if (flag != this.chkActivateLabels.isSelected()) {
            this.chkActivateLabels.setSelected(flag);
        }
    }

    private void setMaxScale(int max) {
        this.getStyle().setMaxScale(max);
        if (!this.txtMax.getText().equals(max + "")) {
            this.txtMax.setText(max + "");
        }
    }

    private void setMinScale(int min) {
        this.getStyle().setMinScale(min);
        if (!this.txtMin.getText().equals(min + "")) {
            this.txtMin.setText(min + "");
        }
    }

    private void setAlignment(float align) {
        this.getStyle().setAlignment(align);
        if (align == 0.0f) {
            this.radLeft.setSelected(true);
        } else if (align == 0.5f) {
            this.radCenter.setSelected(true);
        } else {
            this.radRight.setSelected(true);
        }
    }

    private void setMultiplier(Object multi) {
        if (multi instanceof Double) {
            this.getStyle().setMultiplier((Double)multi);
        } else if (multi instanceof Long) {
            this.getStyle().setMultiplier(new Double(((Long)multi).longValue()));
        }
        this.txtMultiplier.setValue(multi);
    }

    private double getMultiplier() {
        Double o = this.getStyle().getMultiplier();
        if (o instanceof Double) {
            return o;
        }
        if (o instanceof Long) {
            long l = (Long)((Object)o);
            double d = l;
            return d;
        }
        return 1.0;
    }

    private void setFontColor(Color fontColor) {
        this.getStyle().setFontColor(fontColor);
        this.panFontColor.setBackground(fontColor);
    }

    private void setFontType(Font fontType) {
        this.getStyle().setFont(fontType);
        StringBuffer name = new StringBuffer(fontType.getSize() + "pt ");
        name.append(fontType.getName());
        if (fontType.isBold()) {
            name.append(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.setFontType(Font).name.bold"));
        }
        if (fontType.isItalic()) {
            name.append(NbBundle.getMessage(StyleDialog.class, (String)"StyleDialog.setFontType(Font).name.italic"));
        }
        this.lblFontname.setText(name.toString());
    }

    private void setAutoscale(boolean flag) {
        this.getStyle().setAutoscale(flag);
        if (this.chkAutoscale.isSelected() != flag) {
            this.chkAutoscale.setSelected(flag);
        }
    }

    private void setQueryString(String s) {
        this.queryEditor.setText(s);
        this.chkUseQueryString.setSelected(false);
    }

    public String getQueryString() {
        if (!this.isAccepted()) {
            this.logger.warn((Object)"supicious call to 'getQueryString()', changes not accepted");
        }
        return this.queryEditor.getText();
    }

    public boolean isQueryStringChanged() {
        return this.chkUseQueryString.isSelected();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    private void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.lstHistory.updateUI();
            if (this.chkCustomSLD.isSelected()) {
                this.tbpTabs.setSelectedComponent(this.panTabFill);
            } else {
                this.tbpTabs.setSelectedComponent(this.panSLDDefinition);
            }
        }
        super.setVisible(visible);
    }
}

