/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.style.StyleDialogClosedEvent;
import de.cismet.cismap.commons.featureservice.style.StyleDialogClosedListener;
import de.cismet.cismap.commons.featureservice.style.StyleDialogInterface;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.JDialog;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class StyleDialogStarter
extends WaitingDialogThread<JDialog> {
    private static final Logger log = Logger.getLogger(StyleDialogStarter.class);
    private final Frame parentFrame;
    private final AbstractFeatureService selectedService;
    private StyleDialogInterface styleDialog;
    private final ArrayList<String> panel;
    private final List<StyleDialogClosedListener> listener = new ArrayList<StyleDialogClosedListener>();

    public StyleDialogStarter(Frame parent, AbstractFeatureService selectedService, ArrayList<String> panel, int delay) {
        super(parent, true, NbBundle.getMessage(StyleDialogStarter.class, (String)"StyleDialogStarter.StyleDialogStarter()"), null, delay);
        this.parentFrame = parent;
        this.selectedService = selectedService;
        this.panel = panel;
    }

    protected JDialog doInBackground() throws Exception {
        if (this.styleDialog == null) {
            String lookupkey;
            if (log.isDebugEnabled()) {
                log.debug((Object)("creating new StyleDialog '" + this.parentFrame.getTitle() + "'"));
            }
            if ((lookupkey = CismapBroker.getInstance().getFeatureStylingComponentKey()) != null && !lookupkey.isEmpty()) {
                Lookup.Result result = Lookup.getDefault().lookupResult(StyleDialogInterface.class);
                for (StyleDialogInterface dialog : result.allInstances()) {
                    if (!lookupkey.equals(dialog.getKey())) continue;
                    this.styleDialog = dialog;
                }
            }
            if (this.styleDialog == null) {
                this.styleDialog = (StyleDialogInterface)Lookup.getDefault().lookup(StyleDialogInterface.class);
            }
        }
        return this.styleDialog.configureDialog(this.selectedService, this.parentFrame, CismapBroker.getInstance().getMappingComponent(), this.panel);
    }

    protected void done() {
        try {
            JDialog dialog = (JDialog)this.get();
            dialog.setPreferredSize(new Dimension(dialog.getPreferredSize().width + 70, dialog.getPreferredSize().height));
            if (log.isDebugEnabled()) {
                log.debug((Object)"set dialog visible");
            }
            StaticSwingTools.showDialog((JDialog)dialog);
            if (this.styleDialog != null && this.styleDialog.isAccepted()) {
                Runnable r = this.styleDialog.createResultTask();
                ExecutorService es = CismetExecutors.newSingleThreadExecutor();
                es.submit(r);
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StyleDialogStarter.this.fireStyleDialogClosed(new StyleDialogClosedEvent(StyleDialogStarter.this.styleDialog));
                            }
                        });
                    }
                });
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Style Dialog canceled");
            }
        }
        catch (Throwable t) {
            log.error((Object)("could not configure StyleDialog: " + t.getMessage()), t);
        }
    }

    private void fireStyleDialogClosed(StyleDialogClosedEvent evt) {
        for (StyleDialogClosedListener l : this.listener) {
            l.StyleDialogClosed(evt);
        }
    }

    public void addStyleDialogClosedListener(StyleDialogClosedListener l) {
        this.listener.add(l);
    }

    public void removeStyleDialogClosedListener(StyleDialogClosedListener l) {
        this.listener.remove(l);
    }
}

