/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import de.cismet.cismap.commons.ConvertableToXML;
import de.cismet.cismap.commons.featureservice.style.BasicStyle;
import de.cismet.cismap.commons.featureservice.style.Style;
import java.io.File;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class StyleHistoryListModel
implements ListModel,
ConvertableToXML {
    private static final int MAX_STYLES = 15;
    public static final String STYLE_ROOT = "StyleHistory";
    private final Logger logger = Logger.getLogger(StyleHistoryListModel.class);
    private Vector<Style> styleList;
    private SAXBuilder builder = new SAXBuilder();

    public StyleHistoryListModel() {
        this.styleList = new Vector();
        this.styleList.ensureCapacity(15);
    }

    public StyleHistoryListModel(File f) throws Exception {
        this();
        try {
            Document doc = this.builder.build(f);
            Element root = doc.getRootElement();
            if (root != null && root.getName().equals(STYLE_ROOT)) {
                this.initFromElement(root);
            } else {
                this.logger.error((Object)("file '" + f.getName() + "' contains wrong xml content:\n" + doc));
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Could not load style history from '" + f.getName() + "'"), (Throwable)ex);
        }
    }

    public void addStyle(Style newStyle) {
        if (!this.elementEquals(newStyle)) {
            this.styleList.add(newStyle);
            if (this.styleList.size() > 15) {
                this.styleList.remove(0);
            }
        }
    }

    public Object getElementAt(int index) {
        return this.styleList.get(index);
    }

    @Override
    public int getSize() {
        return this.styleList.size();
    }

    public void clear() {
        this.styleList.clear();
    }

    public boolean elementEquals(Style compare) {
        if (this.styleList.isEmpty()) {
            return false;
        }
        boolean returnValue = false;
        for (Style s : this.styleList) {
            if (s.compareTo(compare) != 0) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    @Override
    public Element toElement() {
        Element e = new Element(STYLE_ROOT);
        for (Style s : this.styleList) {
            e.addContent((Content)s.toElement());
        }
        return e;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        this.styleList.clear();
        this.styleList.ensureCapacity(element.getChildren("StyleHistoryElement").size());
        for (Object o : element.getChildren("StyleHistoryElement")) {
            BasicStyle newStyle;
            if (!(o instanceof Element) || (newStyle = new BasicStyle((Element)o)) == null) continue;
            this.styleList.add(newStyle);
        }
    }
}

