/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gpx.helper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.gpx.GpxType;
import de.cismet.cismap.commons.gpx.RteType;
import de.cismet.cismap.commons.gpx.TrkType;
import de.cismet.cismap.commons.gpx.TrksegType;
import de.cismet.cismap.commons.gpx.WptType;
import de.cismet.cismap.commons.jtsgeometryfactories.CoordinateM;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;

public class GpxReader {
    private final GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);

    public boolean isValid(String gpx) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"de.cismet.cismap.commons.gpx");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object o = unmarshaller.unmarshal((Reader)new StringReader(gpx));
            return o instanceof JAXBElement && GpxType.class.isAssignableFrom(((JAXBElement)o).getDeclaredType());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Geometry[] read(String gpx) throws Exception {
        ArrayList<Object> geometries = new ArrayList<Object>();
        JAXBContext context = JAXBContext.newInstance((String)"de.cismet.cismap.commons.gpx");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Object o = unmarshaller.unmarshal((Reader)new StringReader(gpx));
        if (o instanceof JAXBElement && GpxType.class.isAssignableFrom(((JAXBElement)o).getDeclaredType())) {
            GpxType gpxType = (GpxType)((JAXBElement)o).getValue();
            if (gpxType.getRte() != null) {
                for (RteType rte : gpxType.getRte()) {
                    ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                    for (WptType wayPoint : rte.getRtept()) {
                        coordinates.add(this.getCoordinateFromWaypoint(wayPoint));
                    }
                    geometries.add(this.geometryFactory.createLineString(coordinates.toArray(new Coordinate[coordinates.size()])));
                }
            }
            if (gpxType.getTrk() != null) {
                for (TrkType trk : gpxType.getTrk()) {
                    for (TrksegType seg : trk.getTrkseg()) {
                        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                        for (WptType wayPoint : seg.getTrkpt()) {
                            coordinates.add(this.getCoordinateFromWaypoint(wayPoint));
                        }
                        geometries.add(this.geometryFactory.createLineString(coordinates.toArray(new Coordinate[coordinates.size()])));
                    }
                }
            }
            if (gpxType.getWpt() != null) {
                for (WptType wpt : gpxType.getWpt()) {
                    geometries.add(this.getWaypoint(wpt));
                }
            }
        }
        return geometries.toArray(new Geometry[geometries.size()]);
    }

    private Point getWaypoint(WptType wayPoint) {
        return this.geometryFactory.createPoint(this.getCoordinateFromWaypoint(wayPoint));
    }

    private Coordinate getCoordinateFromWaypoint(WptType wayPoint) {
        XMLGregorianCalendar calendar = wayPoint.getTime();
        double timeInMillis = calendar != null ? (double)calendar.toGregorianCalendar().getTimeInMillis() : 0.0;
        double height = wayPoint.getEle() != null ? wayPoint.getEle().doubleValue() : 0.0;
        CoordinateM coord = new CoordinateM(wayPoint.getLon().doubleValue(), wayPoint.getLat().doubleValue(), height, timeInMillis);
        return coord;
    }
}

