/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.MappingModelEvent;
import de.cismet.cismap.commons.MappingModelListener;
import de.cismet.cismap.commons.ModeLayer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Bufferable;
import de.cismet.cismap.commons.features.ChildNodesProvider;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.RasterLayerSupportedFeature;
import de.cismet.cismap.commons.features.RequestForHidingHandles;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DocumentFeatureService;
import de.cismet.cismap.commons.featureservice.JDBCFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.FeatureGroupMember;
import de.cismet.cismap.commons.gui.MapListener;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.PBoundsWithCleverToString;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PFeatureComparable;
import de.cismet.cismap.commons.gui.piccolo.PNodeFactory;
import de.cismet.cismap.commons.gui.piccolo.PSticky;
import de.cismet.cismap.commons.gui.piccolo.XPImage;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AttachFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListenerInterface;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateLinearReferencedMarksListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateSimpleGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CustomFeatureInfoListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeleteFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeregistrationListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.FeatureMoveListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.GetFeatureInfoClickDetectionListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.GetFeatureInfoMultiGeomListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.JoinPolygonsListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.KeyboardListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MeasurementListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchCreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.OverviewModeListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PanAndMousewheelZoomListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PerpendicularIntersectionListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PrintTemplateFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PrintingTemplatePreviewListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RaisePolygonListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RasterGeoReferencingInputListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RubberBandZoomListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SimpleMoveListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SplitPolygonListener;
import de.cismet.cismap.commons.gui.printing.PrintingSettingsWidget;
import de.cismet.cismap.commons.gui.printing.PrintingWidget;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.progresswidgets.DocumentProgressWidget;
import de.cismet.cismap.commons.gui.simplelayerwidget.LayerControl;
import de.cismet.cismap.commons.gui.simplelayerwidget.NewSimpleInternalLayerWidget;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.GetFeatureInfoListener;
import de.cismet.cismap.commons.interaction.events.CrsChangedEvent;
import de.cismet.cismap.commons.interaction.events.MapDnDEvent;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.interaction.memento.Memento;
import de.cismet.cismap.commons.interaction.memento.MementoInterface;
import de.cismet.cismap.commons.preferences.CismapPreferences;
import de.cismet.cismap.commons.preferences.GlobalPreferences;
import de.cismet.cismap.commons.preferences.LayersPreferences;
import de.cismet.cismap.commons.rasterservice.FeatureAwareRasterService;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.rasterservice.RasterMapService;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RepaintEvent;
import de.cismet.cismap.commons.retrieval.RepaintListener;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.historybutton.DefaultHistoryModel;
import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.openide.util.NbBundle;
import pswing.PSwingCanvas;

public final class MappingComponent
extends PSwingCanvas
implements MappingModelListener,
FeatureCollectionListener,
HistoryModel,
Configurable,
DropTargetListener,
CrsChangeListener,
GUIWindow {
    private static final boolean DEBUG = false;
    public static final String PROPERTY_MAP_INTERACTION_MODE = "INTERACTION_MODE";
    public static final String MOTION = "MOTION";
    public static final String PERPENDICULAR_INTERSECTION = "PERPENDICULAR_INTERSECTION";
    public static final String SELECT = "SELECT";
    public static final String GEO_REF = "GEO_REF";
    public static final String ZOOM = "ZOOM";
    public static final String PAN = "PAN";
    public static final String ALKIS_PRINT = "ALKIS_PRINT";
    public static final String FEATURE_INFO = "FEATURE_INFO";
    public static final String FEATURE_INFO_MULTI_GEOM = "FEATURE_INFO_MULTI_GEOM";
    public static final String CREATE_SEARCH_POLYGON = "SEARCH_POLYGON";
    public static final String CREATE_SIMPLE_GEOMETRY = "CREATE_SIMPLE_GEOMETRY";
    public static final String MOVE_POLYGON = "MOVE_POLYGON";
    public static final String REMOVE_POLYGON = "REMOVE_POLYGON";
    public static final String NEW_POLYGON = "NEW_POLYGON";
    public static final String SPLIT_POLYGON = "SPLIT_POLYGON";
    public static final String JOIN_POLYGONS = "JOIN_POLYGONS";
    public static final String RAISE_POLYGON = "RAISE_POLYGON";
    public static final String ROTATE_POLYGON = "ROTATE_POLYGON";
    public static final String REFLECT_POLYGON = "REFLECT_POLYGON";
    public static final String ATTACH_POLYGON_TO_ALPHADATA = "ATTACH_POLYGON_TO_ALPHADATA";
    public static final String MOVE_HANDLE = "MOVE_HANDLE";
    public static final String REMOVE_HANDLE = "REMOVE_HANDLE";
    public static final String ADD_HANDLE = "ADD_HANDLE";
    public static final String MEASUREMENT = "MEASUREMENT";
    public static final String LINEAR_REFERENCING = "LINEMEASUREMENT";
    public static final String PRINTING_AREA_SELECTION = "PRINTING_AREA_SELECTION";
    public static final String CUSTOM_FEATUREACTION = "CUSTOM_FEATUREACTION";
    public static final String CUSTOM_FEATUREINFO = "CUSTOM_FEATUREINFO";
    public static final String OVERVIEW = "OVERVIEW";
    static final double OGC_DEGREE_TO_METERS = 111319.49079327358;
    public static final String LAYERWIDGET = "SimpleInternalLayerWidget";
    public static final String PROGRESSWIDGET = "DocumentProgressWidget";
    public static final int POSITION_NORTHWEST = 1;
    public static final int POSITION_SOUTHWEST = 2;
    public static final int POSITION_NORTHEAST = 4;
    public static final int POSITION_SOUTHEAST = 8;
    private static final int RESIZE_DELAY = 500;
    private static final long criticalDocumentSize = 10000000L;
    private static final transient Logger LOG = Logger.getLogger(MappingComponent.class);
    private boolean featureServiceLayerVisible = true;
    private final List<LayerControl> layerControls = new ArrayList<LayerControl>();
    private boolean gridEnabled = true;
    private MappingModel mappingModel;
    private ConcurrentHashMap<Feature, PFeature> pFeatureHM = new ConcurrentHashMap();
    private WorldToScreenTransform wtst = null;
    private double clip_offset_x;
    private double clip_offset_y;
    private double printingResolution = 0.0;
    private boolean backgroundEnabled = true;
    private PLayer featureLayer = new PLayer();
    private PLayer tmpFeatureLayer = new PLayer();
    private PLayer mapServicelayer = new PLayer();
    private PLayer featureServiceLayer = new PLayer();
    private PLayer handleLayer = new PLayer();
    private PLayer snapHandleLayer = new PLayer();
    private PLayer rubberBandLayer = new PLayer();
    private PLayer highlightingLayer = new PLayer();
    private PLayer crosshairLayer = new PLayer();
    private PLayer stickyLayer = new PLayer();
    private PLayer dragPerformanceImproverLayer = new PLayer();
    private boolean readOnly = true;
    private SnappingMode snappingMode = SnappingMode.POINT;
    private boolean visualizeSnappingEnabled = true;
    private boolean visualizeSnappingRectEnabled = false;
    private int snappingRectSize = 20;
    private final Map<String, Cursor> cursors = new HashMap<String, Cursor>();
    private final Map<String, PBasicInputEventHandler> inputEventListener = new HashMap<String, PBasicInputEventHandler>();
    private final Action zoomAction;
    private int acceptableActions = 3;
    private FeatureCollection featureCollection;
    private boolean infoNodesVisible = false;
    private boolean fixedMapExtent = false;
    private boolean fixedMapScale = false;
    private boolean inGlueIdenticalPointsMode = true;
    private String interactionMode;
    private String handleInteractionMode;
    private final PCanvas selectedObjectPresenter = new PCanvas();
    private Rectangle2D newViewBounds;
    private int animationDuration = 500;
    private int taskCounter = 0;
    private CismapPreferences cismapPrefs;
    private DefaultHistoryModel historyModel = new DefaultHistoryModel();
    private final List<Scale> scales = new ArrayList<Scale>();
    private PrintingSettingsWidget printingSettingsDialog;
    private PrintingWidget printingDialog;
    private double screenResolution = 100.0;
    private volatile boolean locked = true;
    private final List<PSticky> stickyPNodes = Collections.synchronizedList(new ArrayList());
    private final MementoInterface memUndo = new Memento();
    private final MementoInterface memRedo = new Memento();
    private boolean featureDebugging = false;
    private BoundingBox fixedBoundingBox = null;
    private final List<MapListener> mapListeners = new ArrayList<MapListener>();
    private final Map<String, JInternalFrame> internalWidgets = new HashMap<String, JInternalFrame>();
    private final Map<String, Integer> internalWidgetPositions = new HashMap<String, Integer>();
    private Timer delayedResizeEventTimer = null;
    private DocumentProgressListener documentProgressListener = null;
    private List<Crs> crsList = new ArrayList<Crs>();
    private CrsTransformer transformer;
    private boolean resetCrs = false;
    private final Timer showHandleDelay;
    private final Map<MapService, Future<?>> serviceFuturesMap = new HashMap();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ButtonGroup interactionButtonGroup;
    private boolean mainMappingComponent = false;
    private volatile boolean rescaleStickyNodesEnabled = true;
    private volatile int retrievalCompleteInProgressCount = 0;
    private double featurePrintingDpi = 125.0;
    private Color crossHairColor = new Color(100, 100, 100, 255);
    private int crossHairThickness = 2;
    private final HashMap<String, PLayer> featureGrpLayerMap = new HashMap();
    private BoundingBox initialBoundingBox;
    private WaitDialog crsChangedWaitingDialog = null;
    private final ArrayList<RepaintListener> repaintListeners = new ArrayList();
    private boolean resizeEventActivated = true;
    private double stickyFeatureCorrectionFactor = 1.0;
    private volatile Coordinate currentCrosshairPoint;
    private Thread specialFeatureZoomThread;
    private long specialFeatureZoomTime;
    private boolean selectionInProgress = false;

    public MappingComponent() {
        this(false);
    }

    public MappingComponent(boolean mainMappingComponent) {
        this.mainMappingComponent = mainMappingComponent;
        this.locked = true;
        this.setSnappingRectSize(20);
        this.setSnappingMode(SnappingMode.OFF);
        this.setVisualizeSnappingEnabled(false);
        this.setAnimationDuration(500);
        this.setInteractionMode(ZOOM);
        this.showHandleDelay = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingComponent.this.showHandles(false);
            }
        });
        this.showHandleDelay.setRepeats(false);
        this.featureDebugging = StaticDebuggingTools.checkHomeForFile((String)"cismetTurnOnFeatureDebugging");
        this.setFeatureCollection(new DefaultFeatureCollection());
        this.addMapListener((DefaultFeatureCollection)this.getFeatureCollection());
        DropTarget dt = new DropTarget((Component)((Object)this), this.acceptableActions, this);
        this.setDefaultRenderQuality(0);
        this.setAnimatingRenderQuality(0);
        this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
        this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (MappingComponent.this.resizeEventActivated) {
                    if (MappingComponent.this.delayedResizeEventTimer == null) {
                        MappingComponent.this.delayedResizeEventTimer = new Timer(500, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MappingComponent.this.delayedResizeEventTimer.stop();
                                MappingComponent.this.delayedResizeEventTimer = null;
                                MappingComponent.this.componentResizedDelayed();
                            }
                        });
                        MappingComponent.this.delayedResizeEventTimer.start();
                    } else {
                        MappingComponent.this.componentResizedIntermediate();
                        MappingComponent.this.delayedResizeEventTimer.restart();
                    }
                }
            }
        });
        PRoot root = this.getRoot();
        PCamera otherCamera = new PCamera();
        otherCamera.addLayer(this.featureLayer);
        this.selectedObjectPresenter.setCamera(otherCamera);
        root.addChild((PNode)otherCamera);
        this.getLayer().addChild((PNode)this.mapServicelayer);
        this.getLayer().addChild((PNode)this.featureServiceLayer);
        this.getLayer().addChild((PNode)this.featureLayer);
        this.getLayer().addChild((PNode)this.tmpFeatureLayer);
        this.getLayer().addChild((PNode)this.rubberBandLayer);
        this.getLayer().addChild((PNode)this.crosshairLayer);
        this.getLayer().addChild((PNode)this.highlightingLayer);
        this.getLayer().addChild((PNode)this.dragPerformanceImproverLayer);
        this.getCamera().addLayer(this.mapServicelayer);
        this.getCamera().addLayer(this.featureLayer);
        this.getCamera().addLayer(this.tmpFeatureLayer);
        this.getCamera().addLayer(this.rubberBandLayer);
        this.getCamera().addLayer(this.crosshairLayer);
        this.getCamera().addLayer(this.highlightingLayer);
        this.getCamera().addLayer(this.dragPerformanceImproverLayer);
        this.getCamera().addChild((PNode)this.snapHandleLayer);
        this.getCamera().addChild((PNode)this.handleLayer);
        this.getCamera().addChild((PNode)this.stickyLayer);
        this.handleLayer.moveToFront();
        otherCamera.setTransparency(0.05f);
        this.initInputListener();
        this.initCursors();
        this.addInputEventListener(this.getInputListener(MOTION));
        this.addInputEventListener(this.getInputListener(CUSTOM_FEATUREACTION));
        KeyboardListener k = new KeyboardListener(this);
        this.addInputEventListener((PInputEventListener)k);
        this.getRoot().getDefaultInputManager().setKeyboardFocus((PInputEventListener)k);
        this.setInteractionMode(ZOOM);
        this.setHandleInteractionMode(MOVE_HANDLE);
        this.dragPerformanceImproverLayer.setVisible(false);
        this.historyModel.setMaximumPossibilities(30);
        this.zoomAction = new AbstractAction(){
            {
                this.putValue("Name", NbBundle.getMessage(MappingComponent.class, (String)"MappingComponent.zoomAction.NAME"));
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layers.png")));
                this.putValue("ShortDescription", NbBundle.getMessage(MappingComponent.class, (String)"MappingComponent.zoomAction.SHORT_DESCRIPTION"));
                this.putValue("LongDescription", NbBundle.getMessage(MappingComponent.class, (String)"MappingComponent.zoomAction.LONG_DESCRIPTION"));
                this.putValue("MnemonicKey", 90);
                this.putValue("ActionCommandKey", "zoom.action");
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                MappingComponent.this.zoomAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/server.png")));
                MappingComponent.this.setInteractionMode(MappingComponent.ZOOM);
            }
        };
        this.getCamera().addPropertyChangeListener("viewTransform", new PropertyChangeListener(){
            private double lastScale = -1.0;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PAffineTransform transform = (PAffineTransform)evt.getNewValue();
                MappingComponent.this.checkAndFixErroneousTransformation();
                MappingComponent.this.handleLayer.removeAllChildren();
                MappingComponent.this.showHandleDelay.restart();
                if (transform == null || this.lastScale != transform.getScale()) {
                    MappingComponent.this.rescaleStickyNodes();
                }
                if (transform != null) {
                    this.lastScale = transform.getScale();
                }
                if (MappingComponent.this.mainMappingComponent) {
                    CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("scale", MappingComponent.this.interactionMode));
                }
            }
        });
    }

    public int getCrossHairThickness() {
        return this.crossHairThickness;
    }

    public void setCrossHairThickness(int crossHairThickness) {
        this.crossHairThickness = crossHairThickness;
    }

    public Color getCrossHairColor() {
        return this.crossHairColor;
    }

    public void setCrossHairColor(Color crossHairColor) {
        this.crossHairColor = crossHairColor;
    }

    public boolean isResizeEventActivated() {
        return this.resizeEventActivated;
    }

    public void setResizeEventActivated(boolean resizeEventActivated) {
        this.resizeEventActivated = resizeEventActivated;
    }

    public ButtonGroup getInteractionButtonGroup() {
        return this.interactionButtonGroup;
    }

    public void setInteractionButtonGroup(ButtonGroup interactionButtonGroup) {
        this.interactionButtonGroup = interactionButtonGroup;
    }

    public void addMapListener(MapListener mapListener) {
        if (mapListener != null) {
            this.mapListeners.add(mapListener);
        }
    }

    public void removeMapListener(MapListener mapListener) {
        if (mapListener != null) {
            this.mapListeners.remove(mapListener);
        }
    }

    public void dispose() {
        CismapBroker.getInstance().removeCrsChangeListener(this);
        this.getFeatureCollection().removeAllFeatures();
        this.mapListeners.clear();
        this.inputEventListener.clear();
    }

    public boolean isFeatureDebugging() {
        return this.featureDebugging;
    }

    public void initPrintingDialogs() {
        this.printingSettingsDialog = new PrintingSettingsWidget(true, this);
        this.printingDialog = new PrintingWidget(true, this);
    }

    public Image getImage() {
        return this.getCamera().toImage(this.getWidth(), this.getHeight(), (Paint)Color.white);
    }

    public void addToPRoot(PCamera cam) {
        this.getRoot().addChild((PNode)cam);
    }

    public void addStickyNode(PSticky pn) {
        if (pn != null && !this.stickyPNodes.contains(pn)) {
            this.stickyPNodes.add(pn);
        }
    }

    public void removeStickyNode(PSticky pn) {
        this.stickyPNodes.remove(pn);
    }

    public void adjustMapForSpecialFeatureClasses(final Class specialFeatureClass) {
        int delayTime = 500;
        this.specialFeatureZoomTime = System.currentTimeMillis() + 500L;
        if (this.specialFeatureZoomThread == null || !this.specialFeatureZoomThread.isAlive()) {
            this.specialFeatureZoomThread = new Thread("specialFeatureZoomThread for:" + specialFeatureClass.getCanonicalName()){

                @Override
                public void run() {
                    while (System.currentTimeMillis() < MappingComponent.this.specialFeatureZoomTime) {
                        try {
                            5.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MappingComponent.this.ensureVisibilityOfSpecialFeatures(specialFeatureClass);
                        }
                    });
                }
            };
            this.specialFeatureZoomThread.setPriority(5);
            CismetThreadPool.execute((Runnable)this.specialFeatureZoomThread);
        }
    }

    public void ensureVisibilityOfSpecialFeatures(Class specialFeatureClass, boolean fixedScale) {
        if (!this.isFixedMapExtent()) {
            this.zoomToAFeatureCollection(this.getSpecialFeatureCollection(specialFeatureClass), false, fixedScale);
        }
    }

    public void ensureVisibilityOfSpecialFeatures(Class specialFeatureClass) {
        this.ensureVisibilityOfSpecialFeatures(specialFeatureClass, this.isFixedMapScale());
    }

    public <T extends Feature> Collection<T> getSpecialFeatureCollection(Class<T> featureclass) {
        ArrayList<Feature> fc = new ArrayList<Feature>();
        for (Feature f : this.getFeatureCollection().getAllFeatures()) {
            if (!featureclass.isInstance(f)) continue;
            fc.add(f);
        }
        return fc;
    }

    public List<PSticky> getStickyNodes() {
        return this.stickyPNodes;
    }

    public void rescaleStickyNode(final PSticky n) {
        if (this.rescaleStickyNodesEnabled && n != null) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Thread("MappingComponent rescaleStickyNode()"){

                    @Override
                    public void run() {
                        MappingComponent.this.rescaleStickyNodeWork(n);
                    }
                });
            } else {
                this.rescaleStickyNodeWork(n);
            }
        }
    }

    public void rescaleStickyNodes(final List<PSticky> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Thread("MappingComponent rescaleStickyNodes()"){

                    @Override
                    public void run() {
                        ArrayList nodesCopy = new ArrayList(nodes);
                        for (PSticky node : nodesCopy) {
                            MappingComponent.this.rescaleStickyNodeWork(node);
                        }
                    }
                });
            } else {
                ArrayList<PSticky> nodesCopy = new ArrayList<PSticky>(nodes);
                for (PSticky node : nodesCopy) {
                    this.rescaleStickyNodeWork(node);
                }
            }
        }
    }

    private double getPrintingResolution() {
        return this.printingResolution;
    }

    public void setPrintingResolution(double printingResolution) {
        this.printingResolution = printingResolution;
    }

    public double getStickyFeatureCorrectionFactor() {
        return this.stickyFeatureCorrectionFactor;
    }

    public void setStickyFeatureCorrectionFactor(double stickyFeatureCorrectionFactor) {
        this.stickyFeatureCorrectionFactor = stickyFeatureCorrectionFactor;
    }

    private void rescaleStickyNodeWork(PSticky n) {
        double s = this.getCamera().getViewScale();
        n.setScale(this.getStickyFeatureCorrectionFactor() / s);
    }

    public void rescaleStickyNodes() {
        if (this.rescaleStickyNodesEnabled) {
            ArrayList<PSticky> stickyNodeList = new ArrayList<PSticky>();
            ArrayList<PSticky> stickyNodeCopy = new ArrayList<PSticky>(this.getStickyNodes());
            for (PSticky each : stickyNodeCopy) {
                if (each instanceof PSticky && each.getVisible()) {
                    stickyNodeList.add(each);
                    continue;
                }
                if (each.getParent() != null) continue;
                this.removeStickyNode(each);
            }
            this.rescaleStickyNodes(stickyNodeList);
        }
    }

    public Action getZoomAction() {
        return this.zoomAction;
    }

    public void gotoBoundsWithoutHistory(PBounds bounds) {
        try {
            PBoundsWithCleverToString boundWCTS;
            try {
                this.handleLayer.removeAllChildren();
            }
            catch (Exception e) {
                LOG.warn((Object)"error during removeAllCHildren", (Throwable)e);
            }
            if (bounds.getWidth() < 0.0) {
                bounds.setSize(bounds.getWidth() * -1.0, bounds.getHeight());
            }
            if (bounds.getHeight() < 0.0) {
                bounds.setSize(bounds.getWidth(), bounds.getHeight() * -1.0);
            }
            if (bounds instanceof PBoundsWithCleverToString && !(boundWCTS = (PBoundsWithCleverToString)bounds).getCrsCode().equals(this.mappingModel.getSrs().getCode())) {
                try {
                    Rectangle2D.Double pos = new Rectangle2D.Double();
                    XBoundingBox bbox = boundWCTS.getWorldCoordinates();
                    CrsTransformer trans = new CrsTransformer(this.mappingModel.getSrs().getCode());
                    bbox = trans.transformBoundingBox(bbox);
                    bounds = bbox.getPBounds(this.getWtst());
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot transform the bounding box from " + boundWCTS.getCrsCode() + " to " + this.mappingModel.getSrs().getCode()));
                }
            }
            this.getCamera().animateViewToCenterBounds((Rectangle2D)bounds, true, (long)this.animationDuration);
            this.queryServicesWithoutHistory();
            this.showHandles(true);
        }
        catch (NullPointerException npe) {
            LOG.warn((Object)("NPE in gotoBoundsWithoutHistory(" + bounds + ")"), (Throwable)npe);
        }
    }

    private void checkAndFixErroneousTransformation() {
        if (this.getCamera().getViewTransform().getScaleY() < 0.0) {
            double y = this.getCamera().getViewTransform().getScaleY();
            double x = this.getCamera().getViewTransform().getScaleX();
            LOG.warn((Object)("Erroneous ViewTransform: getViewTransform (scaleY=" + y + " scaleX=" + x + "). Try to fix it."));
            this.getCamera().getViewTransformReference().setToScale(this.getCamera().getViewTransform().getScaleX() * -1.0, y * -1.0);
        }
    }

    private void adjustLayers() {
        int counter = 0;
        this.getCamera().removeLayer(this.mapServicelayer);
        this.getCamera().removeLayer(this.featureLayer);
        this.getCamera().removeLayer(this.tmpFeatureLayer);
        this.getCamera().removeLayer(this.rubberBandLayer);
        this.getCamera().removeLayer(this.dragPerformanceImproverLayer);
        this.getCamera().addLayer(counter++, this.mapServicelayer);
        for (int i = 0; i < this.featureServiceLayer.getChildrenCount(); ++i) {
            this.getCamera().removeLayer((PLayer)this.featureServiceLayer.getChild(i));
            this.getCamera().addLayer(counter++, (PLayer)this.featureServiceLayer.getChild(i));
        }
        this.getCamera().addLayer(counter++, this.featureLayer);
        this.getCamera().addLayer(counter++, this.tmpFeatureLayer);
        this.getCamera().addLayer(counter++, this.rubberBandLayer);
        this.getCamera().addLayer(counter++, this.dragPerformanceImproverLayer);
    }

    public void initInputListener() {
        this.inputEventListener.put(MOTION, new SimpleMoveListener(this));
        this.inputEventListener.put(PERPENDICULAR_INTERSECTION, new PerpendicularIntersectionListener(this));
        this.inputEventListener.put(ZOOM, new RubberBandZoomListener());
        this.inputEventListener.put(PAN, (PBasicInputEventHandler)new PanAndMousewheelZoomListener());
        this.inputEventListener.put(SELECT, new SelectionListener());
        this.inputEventListener.put(GEO_REF, (PBasicInputEventHandler)RasterGeoReferencingInputListener.getInstance());
        this.inputEventListener.put(FEATURE_INFO, new GetFeatureInfoClickDetectionListener());
        this.inputEventListener.put(FEATURE_INFO_MULTI_GEOM, new GetFeatureInfoMultiGeomListener());
        this.inputEventListener.put(CREATE_SEARCH_POLYGON, new MetaSearchCreateSearchGeometryListener(this));
        this.inputEventListener.put(CREATE_SIMPLE_GEOMETRY, new CreateSimpleGeometryListener(this));
        this.inputEventListener.put(MOVE_POLYGON, new FeatureMoveListener(this));
        this.inputEventListener.put(NEW_POLYGON, new CreateNewGeometryListener(this));
        this.inputEventListener.put(RAISE_POLYGON, new RaisePolygonListener(this));
        this.inputEventListener.put(REMOVE_POLYGON, new DeleteFeatureListener(this));
        this.inputEventListener.put(ATTACH_POLYGON_TO_ALPHADATA, new AttachFeatureListener());
        this.inputEventListener.put(JOIN_POLYGONS, new JoinPolygonsListener());
        this.inputEventListener.put(SPLIT_POLYGON, new SplitPolygonListener(this));
        this.inputEventListener.put(LINEAR_REFERENCING, new CreateLinearReferencedMarksListener(this));
        this.inputEventListener.put(MEASUREMENT, new MeasurementListener(this));
        this.inputEventListener.put(PRINTING_AREA_SELECTION, new PrintingTemplatePreviewListener(this));
        this.inputEventListener.put(CUSTOM_FEATUREINFO, new CustomFeatureInfoListener());
        this.inputEventListener.put(OVERVIEW, new OverviewModeListener());
    }

    public void addCustomInputListener(String key, PBasicInputEventHandler listener) {
        this.inputEventListener.put(key, listener);
    }

    public void initCursors() {
        this.putCursor(SELECT, new Cursor(0));
        this.putCursor(PERPENDICULAR_INTERSECTION, new Cursor(0));
        this.putCursor(ZOOM, new Cursor(1));
        this.putCursor(PAN, new Cursor(12));
        this.putCursor(GEO_REF, new Cursor(1));
        this.putCursor(FEATURE_INFO, new Cursor(0));
        this.putCursor(FEATURE_INFO_MULTI_GEOM, new Cursor(0));
        this.putCursor(CREATE_SEARCH_POLYGON, new Cursor(1));
        this.putCursor(MOVE_POLYGON, new Cursor(12));
        this.putCursor(ROTATE_POLYGON, new Cursor(0));
        this.putCursor(NEW_POLYGON, new Cursor(1));
        this.putCursor(RAISE_POLYGON, new Cursor(0));
        this.putCursor(REMOVE_POLYGON, new Cursor(0));
        this.putCursor(ATTACH_POLYGON_TO_ALPHADATA, new Cursor(0));
        this.putCursor(JOIN_POLYGONS, new Cursor(0));
        this.putCursor(SPLIT_POLYGON, new Cursor(1));
        this.putCursor(MEASUREMENT, new Cursor(1));
        this.putCursor(LINEAR_REFERENCING, new Cursor(0));
        this.putCursor(CREATE_SIMPLE_GEOMETRY, new Cursor(1));
        this.putCursor(MOVE_HANDLE, new Cursor(1));
        this.putCursor(REMOVE_HANDLE, new Cursor(1));
        this.putCursor(ADD_HANDLE, new Cursor(1));
    }

    public void showPrintingSettingsDialog() {
        this.showPrintingSettingsDialog(false);
    }

    public void showPrintingSettingsDialog(boolean chooseFile) {
        this.printingSettingsDialog = this.printingSettingsDialog.cloneWithNewParent(true, this);
        this.printingSettingsDialog.setChooseFileName(chooseFile);
        StaticSwingTools.showDialog((JDialog)this.printingSettingsDialog);
    }

    public void showPrintingDialog() {
        this.setPointerAnnotationVisibility(false);
        this.printingDialog = this.printingDialog.cloneWithNewParent(true, this);
        try {
            this.printingDialog.startLoading();
            StaticSwingTools.showDialog((JDialog)this.printingDialog);
        }
        catch (Exception e) {
            LOG.error((Object)"Fehler beim Anzeigen des Printing Dialogs", (Throwable)e);
        }
    }

    public void printingAction() {
        this.showPrintingSettingsDialog();
    }

    public void showPrintingSettingsDialog(String ignoredHandlerString) {
        this.showPrintingSettingsDialog();
    }

    public String getInteractionMode() {
        return this.interactionMode;
    }

    public void setInteractionMode(String interactionMode) {
        try {
            try {
                this.handleLayer.removeAllChildren();
            }
            catch (Exception e) {
                LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
            }
            this.setPointerAnnotationVisibility(false);
            if (this.interactionMode != null) {
                PInputEventListener pivl;
                if (interactionMode.equals(FEATURE_INFO)) {
                    ((GetFeatureInfoClickDetectionListener)this.getInputListener(interactionMode)).getPInfo().setVisible(true);
                } else {
                    ((GetFeatureInfoClickDetectionListener)this.getInputListener(FEATURE_INFO)).getPInfo().setVisible(false);
                }
                if (this.isReadOnly()) {
                    ((DefaultFeatureCollection)this.getFeatureCollection()).removeFeaturesByInstance(PureNewFeature.class);
                }
                if ((pivl = this.getInputListener(this.interactionMode)) != null) {
                    if (pivl instanceof DeregistrationListener) {
                        ((DeregistrationListener)pivl).deregistration();
                    }
                    if (pivl instanceof FeatureMoveListener) {
                        ((FeatureMoveListener)pivl).cleanup();
                    }
                    this.removeInputEventListener(pivl);
                } else {
                    LOG.warn((Object)"this.getInputListener(this.interactionMode)==null");
                }
                if (interactionMode.equals(NEW_POLYGON)) {
                    this.featureCollection.unselectAll();
                }
                if ((interactionMode.equals(SELECT) || interactionMode.equals(LINEAR_REFERENCING) || interactionMode.equals(SPLIT_POLYGON) || interactionMode.equals(MOVE_POLYGON) || interactionMode.equals(PRINTING_AREA_SELECTION)) && !this.readOnly) {
                    this.featureSelectionChanged(null);
                }
                if (interactionMode.equals(JOIN_POLYGONS)) {
                    try {
                        this.handleLayer.removeAllChildren();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
                    }
                }
            }
            PropertyChangeEvent interactionModeChangedEvent = new PropertyChangeEvent(this, PROPERTY_MAP_INTERACTION_MODE, this.interactionMode, interactionMode);
            this.interactionMode = interactionMode;
            PInputEventListener pivl = this.getInputListener(interactionMode);
            if (pivl != null) {
                this.addInputEventListener(pivl);
                this.propertyChangeSupport.firePropertyChange(interactionModeChangedEvent);
                if (this.mainMappingComponent) {
                    CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("mode", interactionMode));
                }
            } else {
                LOG.warn((Object)("this.getInputListener(this.interactionMode)==null bei interactionMode=" + interactionMode));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Fehler beim \u00c4ndern des InteractionModes", (Throwable)e);
        }
    }

    @Deprecated
    public void formComponentResized(ComponentEvent evt) {
        this.componentResizedDelayed();
    }

    public void componentResizedIntermediate() {
        if (!this.isLocked()) {
            if (this.getSize().height >= 0 && this.getSize().width >= 0 && this.mappingModel != null && this.historyModel.getCurrentElement() != null) {
                PBounds bounds = (PBounds)this.historyModel.getCurrentElement();
                if (bounds == null) {
                    bounds = this.initialBoundingBox.getPBounds(this.wtst);
                }
                if (bounds.getWidth() < 0.0) {
                    bounds.setSize(bounds.getWidth() * -1.0, bounds.getHeight());
                }
                if (bounds.getHeight() < 0.0) {
                    bounds.setSize(bounds.getWidth(), bounds.getHeight() * -1.0);
                }
                this.getCamera().animateViewToCenterBounds((Rectangle2D)bounds, true, (long)this.animationDuration);
            }
            for (String internalWidget : this.internalWidgets.keySet()) {
                if (!this.getInternalWidget(internalWidget).isVisible()) continue;
                this.showInternalWidget(internalWidget, true, 0);
            }
        }
    }

    public void componentResizedDelayed() {
        if (!this.isLocked()) {
            try {
                if (this.getSize().height >= 0 && this.getSize().width >= 0 && this.mappingModel != null) {
                    PBounds bounds = (PBounds)this.historyModel.getCurrentElement();
                    if (bounds != null) {
                        this.gotoBoundsWithoutHistory(bounds);
                    } else {
                        this.gotoBoundsWithoutHistory(this.getInitialBoundingBox().getPBounds(this.wtst));
                    }
                    for (String internalWidget : this.internalWidgets.keySet()) {
                        if (!this.getInternalWidget(internalWidget).isVisible()) continue;
                        this.showInternalWidget(internalWidget, true, 0);
                    }
                }
            }
            catch (Exception t) {
                LOG.error((Object)"Fehler in formComponentResized()", (Throwable)t);
            }
        }
    }

    public void syncSelectedObjectPresenter(int i) {
        this.selectedObjectPresenter.setVisible(true);
        if (this.featureCollection.getSelectedFeatures().size() > 0) {
            PFeature selectedFeature;
            if (this.featureCollection.getSelectedFeatures().size() == 1 && (selectedFeature = this.pFeatureHM.get(this.featureCollection.getSelectedFeatures().toArray()[0])) != null) {
                this.selectedObjectPresenter.getCamera().animateViewToCenterBounds((Rectangle2D)selectedFeature.getBounds(), true, (long)(this.getAnimationDuration() * 2));
            }
        } else {
            LOG.warn((Object)("in syncSelectedObjectPresenter(" + i + "): selectedFeature==null"));
        }
    }

    public BoundingBox getInitialBoundingBox() {
        if (this.initialBoundingBox == null) {
            return this.mappingModel.getInitialBoundingBox();
        }
        return this.initialBoundingBox;
    }

    public FeatureCollection getFeatureCollection() {
        return this.featureCollection;
    }

    public void setFeatureCollection(FeatureCollection featureCollection) {
        this.featureCollection = featureCollection;
        featureCollection.addFeatureCollectionListener(this);
    }

    public void setFeatureCollectionVisibility(boolean visibility) {
        this.featureLayer.setVisible(visibility);
    }

    public boolean isFeatureCollectionVisible() {
        return this.featureLayer.getVisible();
    }

    public void addMapService(MapService mapService, int position) {
        try {
            Object p = new PNode();
            if (mapService instanceof RasterMapService) {
                LOG.info((Object)("adding RasterMapService '" + mapService + "' " + mapService.getClass().getSimpleName() + ")"));
                if (mapService.getPNode() instanceof XPImage) {
                    p = (XPImage)mapService.getPNode();
                } else {
                    p = new XPImage();
                    mapService.setPNode((PNode)p);
                }
                mapService.addRetrievalListener(new MappingComponentRasterServiceListener(position, (PNode)p, (ServiceLayer)((Object)mapService)));
            } else {
                AbstractFeatureService documentFeatureService;
                if (mapService instanceof ModeLayer) {
                    return;
                }
                LOG.info((Object)("adding FeatureMapService '" + mapService + "' (" + mapService.getClass().getSimpleName() + ")"));
                p = new PLayer();
                mapService.setPNode((PNode)p);
                if (DocumentFeatureService.class.isAssignableFrom(mapService.getClass())) {
                    documentFeatureService = (DocumentFeatureService)mapService;
                    if (((DocumentFeatureService)documentFeatureService).getDocumentSize() > 10000000L) {
                        LOG.warn((Object)("FeatureMapService(" + mapService + "): DocumentFeatureService '" + documentFeatureService.getName() + "' size of " + ((DocumentFeatureService)documentFeatureService).getDocumentSize() / 1000000L + "MB exceeds critical document size (" + 10000000L / 1000000L + "MB)"));
                        if (this.documentProgressListener == null) {
                            this.documentProgressListener = new DocumentProgressListener();
                        }
                        if (this.documentProgressListener.getRequestId() != -1L) {
                            LOG.error((Object)("FeatureMapService(" + mapService + "): The documentProgressListener is already in use by request '" + this.documentProgressListener.getRequestId() + ", document progress cannot be tracked"));
                        } else {
                            documentFeatureService.addRetrievalListener(this.documentProgressListener);
                        }
                    }
                }
                if (JDBCFeatureService.class.isAssignableFrom(mapService.getClass())) {
                    documentFeatureService = (JDBCFeatureService)mapService;
                    if (this.documentProgressListener == null) {
                        this.documentProgressListener = new DocumentProgressListener();
                    }
                    if (this.documentProgressListener.getRequestId() != -1L) {
                        LOG.error((Object)("FeatureMapService(" + mapService + "): The documentProgressListener is already in use by request '" + this.documentProgressListener.getRequestId() + ", document progress cannot be tracked"));
                    } else {
                        documentFeatureService.addRetrievalListener(this.documentProgressListener);
                    }
                }
                mapService.addRetrievalListener(new MappingComponentFeatureServiceListener((ServiceLayer)((Object)mapService), (PLayer)mapService.getPNode()));
            }
            p.setTransparency(mapService.getTranslucency());
            p.setVisible(mapService.isVisible());
            this.mapServicelayer.addChild(p);
        }
        catch (Exception e) {
            LOG.error((Object)("addMapService(" + mapService + "): Fehler beim hinzufuegen eines Layers: " + e.getMessage()), (Throwable)e);
        }
    }

    public void preparationSetMappingModel(MappingModel mm) {
        this.mappingModel = mm;
    }

    public void setMappingModel(MappingModel mm) {
        LOG.info((Object)"setMappingModel");
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            LOG.info((Object)"setDefaultUncaughtExceptionHandler");
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error((Object)"Error", e);
                }
            });
        }
        this.mappingModel = mm;
        Thread r = new Thread("MappingComponent setMappingModel()"){

            @Override
            public void run() {
                MappingComponent.this.mappingModel.addMappingModelListener(MappingComponent.this);
                TreeMap rs = MappingComponent.this.mappingModel.getRasterServices();
                MappingComponent.this.mapServicelayer.removeAllChildren();
                for (Object key : rs.keySet()) {
                    int rsi = (Integer)key;
                    Object o = rs.get(key);
                    if (!(o instanceof MapService)) continue;
                    MappingComponent.this.addMapService((MapService)o, rsi);
                }
                MappingComponent.this.adjustLayers();
            }
        };
        CismetThreadPool.execute((Runnable)new Thread((Runnable)r, "MappingComponent adjustLayers()"));
    }

    public MappingModel getMappingModel() {
        return this.mappingModel;
    }

    private void animateComponent(final JComponent c, final int toX, final int toY, int animationDuration, final boolean hideAfterAnimation) {
        if (animationDuration > 0) {
            int x = (int)c.getBounds().getX() - toX;
            int y = (int)c.getBounds().getY() - toY;
            int sx = x > 0 ? -1 : 1;
            int sy = y > 0 ? -1 : 1;
            int big = Math.abs(x) > Math.abs(y) ? Math.abs(x) : Math.abs(y);
            final int sleepy = animationDuration / big < 1 ? 1 : animationDuration / big;
            final int directionY = sy;
            final int directionX = sx;
            Thread timer = new Thread("MappingComponent timer"){

                @Override
                public void run() {
                    while (!this.isInterrupted()) {
                        try {
                            10.sleep(sleepy);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        EventQueue.invokeLater(new Thread("MappingComponent updateBounds"){

                            @Override
                            public void run() {
                                int currentY = (int)c.getBounds().getY();
                                int currentX = (int)c.getBounds().getX();
                                if (currentY != toY) {
                                    currentY += directionY;
                                }
                                if (currentX != toX) {
                                    currentX += directionX;
                                }
                                c.setBounds(currentX, currentY, c.getWidth(), c.getHeight());
                            }
                        });
                        if (c.getBounds().getY() != (double)toY || c.getBounds().getX() != (double)toX) continue;
                        if (!hideAfterAnimation) break;
                        EventQueue.invokeLater(new Thread("MappingComponent hide"){

                            @Override
                            public void run() {
                                c.setVisible(false);
                                c.hide();
                            }
                        });
                        break;
                    }
                }
            };
            timer.setPriority(5);
            timer.start();
        } else {
            c.setBounds(toX, toY, c.getWidth(), c.getHeight());
            if (hideAfterAnimation) {
                c.setVisible(false);
            }
        }
    }

    @Deprecated
    public NewSimpleInternalLayerWidget getInternalLayerWidget() {
        return (NewSimpleInternalLayerWidget)this.getInternalWidget(LAYERWIDGET);
    }

    public boolean addInternalWidget(String name, int position, JInternalFrame widget) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding internal widget '" + name + "' to position '" + position + "'"));
        }
        if (this.internalWidgets.containsKey(name)) {
            LOG.warn((Object)("widget '" + name + "' already added, removing old widget"));
            this.remove(this.getInternalWidget(name));
        } else if (this.internalWidgetPositions.containsValue(position)) {
            LOG.warn((Object)("widget position '" + position + "' already taken"));
            return false;
        }
        this.internalWidgets.put(name, widget);
        this.internalWidgetPositions.put(name, position);
        widget.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.add(widget);
        widget.pack();
        return true;
    }

    public boolean removeInternalWidget(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing internal widget '" + name + "'"));
        }
        if (!this.internalWidgets.containsKey(name)) {
            LOG.warn((Object)("widget '" + name + "' not found"));
            return false;
        }
        this.getInternalWidget(name).dispose();
        this.remove(this.getInternalWidget(name));
        this.internalWidgets.remove(name);
        this.internalWidgetPositions.remove(name);
        return true;
    }

    public boolean showInternalWidget(String name, boolean visible, int animationDuration) {
        int positionY;
        int positionX;
        JInternalFrame internalWidget = this.getInternalWidget(name);
        if (internalWidget == null) {
            return false;
        }
        int widgetPosition = this.getInternalWidgetPosition(name);
        boolean isHigher = this.getHeight() < internalWidget.getHeight() + 2 && this.getHeight() > 0;
        boolean isWider = this.getWidth() < internalWidget.getWidth() + 2 && this.getWidth() > 0;
        switch (widgetPosition) {
            case 1: {
                positionX = 1;
                positionY = 1;
                break;
            }
            case 2: {
                positionX = 1;
                positionY = isHigher ? 1 : this.getHeight() - internalWidget.getHeight() - 1;
                break;
            }
            case 4: {
                positionX = isWider ? 1 : this.getWidth() - internalWidget.getWidth() - 1;
                positionY = 1;
                break;
            }
            case 8: {
                positionX = isWider ? 1 : this.getWidth() - internalWidget.getWidth() - 1;
                positionY = isHigher ? 1 : this.getHeight() - internalWidget.getHeight() - 1;
                break;
            }
            default: {
                LOG.warn((Object)"unkown widget position?!");
                return false;
            }
        }
        if (visible) {
            int toY = widgetPosition == 1 || widgetPosition == 4 ? (isHigher ? this.getHeight() - 1 : positionY - internalWidget.getHeight() - 1) : (isHigher ? this.getHeight() + 1 : positionY + internalWidget.getHeight() + 1);
            internalWidget.setBounds(positionX, toY, isWider ? this.getWidth() - 2 : internalWidget.getWidth(), isHigher ? this.getHeight() - 2 : internalWidget.getHeight());
            internalWidget.setVisible(true);
            internalWidget.show();
            this.animateComponent(internalWidget, positionX, positionY, animationDuration, false);
        } else {
            internalWidget.setBounds(positionX, positionY, internalWidget.getWidth(), internalWidget.getHeight());
            int toY = positionY + internalWidget.getHeight() + 1;
            if (widgetPosition == 1 || widgetPosition == 4) {
                toY = positionY - internalWidget.getHeight() - 1;
            }
            this.animateComponent(internalWidget, positionX, toY, animationDuration, true);
        }
        return true;
    }

    @Deprecated
    public void showInternalLayerWidget(boolean visible, int animationDuration) {
        this.showInternalWidget(LAYERWIDGET, visible, animationDuration);
    }

    @Deprecated
    public boolean isInternalLayerWidgetVisible() {
        return this.getInternalLayerWidget().isVisible();
    }

    public boolean isInternalWidgetVisible(String name) {
        JInternalFrame widget = this.getInternalWidget(name);
        if (widget != null) {
            return widget.isVisible();
        }
        return false;
    }

    public void gotoInitialBoundingBox() {
        double x1 = this.getWtst().getScreenX(this.mappingModel.getInitialBoundingBox().getX1());
        double y1 = this.getWtst().getScreenY(this.mappingModel.getInitialBoundingBox().getY1());
        double x2 = this.getWtst().getScreenX(this.mappingModel.getInitialBoundingBox().getX2());
        double y2 = this.getWtst().getScreenY(this.mappingModel.getInitialBoundingBox().getY2());
        Rectangle2D.Double home = new Rectangle2D.Double();
        ((Rectangle2D)home).setRect(x1, y2, x2 - x1, y1 - y2);
        this.getCamera().setViewBounds((Rectangle2D)home);
        if (this.getCamera().getViewTransform().getScaleY() < 0.0) {
            LOG.fatal((Object)"gotoInitialBoundingBox: Problem :-( mit getViewTransform");
        }
        this.setNewViewBounds(home);
        this.queryServices();
    }

    public void queryServices() {
        if (this.newViewBounds != null) {
            this.addToHistory((Object)new PBoundsWithCleverToString(new PBounds(this.newViewBounds), this.wtst, this.mappingModel.getSrs().getCode()));
            this.queryServicesWithoutHistory();
            this.rescaleStickyNodes();
        }
    }

    public void refresh() {
        this.forceQueryServicesWithoutHistory();
    }

    private void forceQueryServicesWithoutHistory() {
        this.queryServicesWithoutHistory(true);
    }

    private void queryServicesWithoutHistory() {
        this.queryServicesWithoutHistory(false);
    }

    private void queryServicesWithoutHistory(final boolean forced) {
        if (forced && this.mainMappingComponent) {
            CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.reset", this));
        }
        if (!this.locked) {
            Thread r = new Thread("MappingComponent queryServicesWithoutHistory()"){

                @Override
                public void run() {
                    while (MappingComponent.this.getAnimating()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {}
                    }
                    CismapBroker.getInstance().fireMapBoundsChanged();
                    if (MappingComponent.this.isBackgroundEnabled()) {
                        Object o;
                        TreeMap rs = MappingComponent.this.mappingModel.getRasterServices();
                        TreeMap fs = MappingComponent.this.mappingModel.getFeatureServices();
                        for (Object key : rs.keySet()) {
                            int rsi = (Integer)key;
                            o = rs.get(key);
                            if (o instanceof MapService) {
                                MappingComponent.this.handleMapService(rsi, (MapService)o, forced);
                                continue;
                            }
                            LOG.warn((Object)("service is not of type MapService:" + o));
                        }
                        for (Object key : fs.keySet()) {
                            int fsi = (Integer)key;
                            o = fs.get(key);
                            if (o instanceof AbstractFeatureService) {
                                XBoundingBox currentBox;
                                AbstractFeatureService service = (AbstractFeatureService)o;
                                if (service.getBoundingBox() instanceof XBoundingBox) {
                                    currentBox = (XBoundingBox)service.getBoundingBox();
                                } else {
                                    Geometry g = service.getBoundingBox().getGeometry(CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
                                    currentBox = new XBoundingBox(g);
                                }
                                if (!service.isVisibleInBoundingBox(currentBox)) {
                                    service.getPNode().removeAllChildren();
                                    continue;
                                }
                            }
                            if (o instanceof MapService) {
                                MappingComponent.this.handleMapService(fsi, (MapService)o, forced);
                                continue;
                            }
                            LOG.warn((Object)("service is not of type MapService:" + o));
                        }
                    }
                    for (int i = 0; i < MappingComponent.this.rubberBandLayer.getChildrenCount(); ++i) {
                        PNode node = MappingComponent.this.rubberBandLayer.getChild(i);
                        if (!(node instanceof FixedPImage)) continue;
                        MappingComponent.this.rescaleStickyNode((FixedPImage)node);
                    }
                }
            };
            CismetThreadPool.execute((Runnable)new Thread((Runnable)r, "MappingComponent queryServicesWithoutHistory()"));
        }
    }

    public void queryServicesIndependentFromMap(final int width, final int height, final BoundingBox bb, final RetrievalListener rl) {
        Thread t = new Thread("Mappingcompoenent queryServicesIndependentFromMap()"){

            @Override
            public void run() {
                while (MappingComponent.this.getAnimating()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                if (MappingComponent.this.isBackgroundEnabled()) {
                    AbstractRetrievalService r;
                    WebFeatureService wfsClone;
                    Object o;
                    TreeMap rs = MappingComponent.this.mappingModel.getRasterServices();
                    TreeMap fs = MappingComponent.this.mappingModel.getFeatureServices();
                    for (Object key : rs.keySet()) {
                        int rsi = (Integer)key;
                        o = rs.get(key);
                        if (o instanceof AbstractRetrievalService && o instanceof ServiceLayer && ((ServiceLayer)o).isEnabled() && o instanceof RetrievalServiceLayer && ((RetrievalServiceLayer)o).getPNode().getVisible()) {
                            try {
                                if (o instanceof WebFeatureService) {
                                    wfsClone = (WebFeatureService)((WebFeatureService)o).clone();
                                    wfsClone.removeAllListeners();
                                    r = wfsClone;
                                } else {
                                    r = ((AbstractRetrievalService)o).cloneWithoutRetrievalListeners();
                                }
                                r.addRetrievalListener(rl);
                                ((ServiceLayer)((Object)r)).setLayerPosition(rsi);
                                MappingComponent.this.handleMapService(rsi, (MapService)((Object)r), width, height, bb, true);
                            }
                            catch (Exception t) {
                                LOG.error((Object)("could not clone service '" + o + "' for printing: " + t.getMessage()), (Throwable)t);
                            }
                            continue;
                        }
                        LOG.warn((Object)("ignoring service '" + o + "' for printing"));
                    }
                    for (Object key : fs.keySet()) {
                        int fsi = (Integer)key;
                        o = fs.get(key);
                        if (!(o instanceof AbstractRetrievalService)) continue;
                        if (o instanceof WebFeatureService) {
                            wfsClone = (WebFeatureService)((WebFeatureService)o).clone();
                            wfsClone.removeAllListeners();
                            r = (AbstractRetrievalService)o;
                        } else {
                            r = ((AbstractRetrievalService)o).cloneWithoutRetrievalListeners();
                        }
                        r.addRetrievalListener(rl);
                        ((ServiceLayer)((Object)r)).setLayerPosition(fsi);
                        MappingComponent.this.handleMapService(fsi, (MapService)((Object)r), 0, 0, bb, true);
                    }
                }
            }
        };
        CismetThreadPool.execute((Runnable)t);
    }

    public void handleMapService(int position, MapService service, boolean forced) {
        PBounds bounds = this.getCamera().getViewBounds();
        BoundingBox bb = new BoundingBox();
        double x1 = this.getWtst().getWorldX(bounds.getMinX());
        double y1 = this.getWtst().getWorldY(bounds.getMaxY());
        double x2 = this.getWtst().getWorldX(bounds.getMaxX());
        double y2 = this.getWtst().getWorldY(bounds.getMinY());
        if (((ServiceLayer)((Object)service)).getName().startsWith("prefetching")) {
            bb.setX1(x1 - (x2 - x1));
            bb.setY1(y1 - (y2 - y1));
            bb.setX2(x2 + (x2 - x1));
            bb.setY2(y2 + (y2 - y1));
        } else {
            bb.setX1(x1);
            bb.setY1(y1);
            bb.setX2(x2);
            bb.setY2(y2);
        }
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.handleMapService(position, service, this.getWidth(), this.getHeight(), bb, forced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMapService(int position, final MapService rs, int width, int height, final BoundingBox bb, final boolean forced) {
        rs.setSize(height, width);
        if (((ServiceLayer)((Object)rs)).isEnabled()) {
            Map<MapService, Future<?>> map = this.serviceFuturesMap;
            synchronized (map) {
                Future<?> sf = this.serviceFuturesMap.get(rs);
                if (sf == null || sf.isDone()) {
                    Thread serviceCall = new Thread("handleMapService"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                while (MappingComponent.this.getAnimating()) {
                                    try {
                                        Thread.currentThread();
                                        Thread.sleep(50L);
                                    }
                                    catch (Exception exception) {}
                                }
                                rs.setBoundingBox(bb);
                                if (rs instanceof FeatureAwareRasterService) {
                                    ((FeatureAwareRasterService)rs).setFeatureCollection(MappingComponent.this.featureCollection);
                                }
                                Crs currentCrs = CismapBroker.getInstance().getSrs();
                                int currentSrid = CrsTransformer.extractSridFromCrs(currentCrs.getCode());
                                boolean isMetric = currentCrs.isMetric();
                                XBoundingBox xbb = new XBoundingBox(bb.getGeometry(currentSrid), currentCrs.getCode(), isMetric);
                                if (!(rs instanceof AbstractFeatureService) || ((AbstractFeatureService)rs).isVisibleInBoundingBox(xbb)) {
                                    rs.retrieve(forced);
                                } else if (rs instanceof AbstractFeatureService && !((AbstractFeatureService)rs).isVisibleInBoundingBox(xbb)) {
                                    rs.getPNode().removeAllChildren();
                                }
                            }
                            finally {
                                MappingComponent.this.serviceFuturesMap.remove(rs);
                            }
                        }
                    };
                    Map<MapService, Future<?>> map2 = this.serviceFuturesMap;
                    synchronized (map2) {
                        this.serviceFuturesMap.put(rs, CismetThreadPool.submit((Runnable)serviceCall));
                    }
                } else {
                    LOG.warn((Object)("The wms request of the service \"" + rs.toString() + "\" was ignored. This can lead to a wrong service image in the map and should not happen. The ignored bbox was " + bb.toString()));
                }
            }
        } else {
            rs.setBoundingBox(bb);
        }
    }

    public WorldToScreenTransform getWtst() {
        try {
            if (this.wtst == null && this.mappingModel != null) {
                double y_real = this.mappingModel.getInitialBoundingBox().getY2() - this.mappingModel.getInitialBoundingBox().getY1();
                double x_real = this.mappingModel.getInitialBoundingBox().getX2() - this.mappingModel.getInitialBoundingBox().getX1();
                double x_screen = this.getWidth();
                double y_screen = this.getHeight();
                if (x_screen == 0.0) {
                    x_screen = 100.0;
                }
                if (y_screen == 0.0) {
                    y_screen = 100.0;
                }
                if (x_real / x_screen >= y_real / y_screen) {
                    double clip_height = x_screen * y_real / x_real;
                    double clip_width = x_screen;
                    this.clip_offset_y = 0.0;
                    this.clip_offset_x = 0.0;
                } else {
                    double clip_height = y_screen;
                    double clip_width = y_screen * x_real / y_real;
                    this.clip_offset_y = 0.0;
                    this.clip_offset_x = 0.0;
                }
                this.wtst = new WorldToScreenTransform(this.mappingModel.getInitialBoundingBox().getX1(), this.mappingModel.getInitialBoundingBox().getY2());
            }
            return this.wtst;
        }
        catch (Exception t) {
            LOG.error((Object)"Fehler in getWtst()", (Throwable)t);
            return null;
        }
    }

    public void resetWtst() {
        this.wtst = null;
    }

    public double getClip_offset_x() {
        return 0.0;
    }

    public void setClip_offset_x(double clip_offset_x) {
        this.clip_offset_x = clip_offset_x;
    }

    public double getClip_offset_y() {
        return 0.0;
    }

    public void setClip_offset_y(double clip_offset_y) {
        this.clip_offset_y = clip_offset_y;
    }

    public PLayer getRubberBandLayer() {
        return this.rubberBandLayer;
    }

    public void setRubberBandLayer(PLayer rubberBandLayer) {
        this.rubberBandLayer = rubberBandLayer;
    }

    public void setNewViewBounds(Rectangle2D r2d) {
        this.newViewBounds = r2d;
    }

    public Rectangle2D getViewBounds() {
        return this.newViewBounds;
    }

    @Override
    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        List allChildren = this.featureLayer.getChildrenReference();
        ArrayList<PFeature> all = new ArrayList<PFeature>();
        SelectionListener sl = (SelectionListener)this.getInputEventListener().get(SELECT);
        boolean selectionChangedBySelectionListener = false;
        if (this.selectionInProgress) {
            return;
        }
        if (sl != null) {
            selectionChangedBySelectionListener = sl.isSelectionInProgress();
        }
        for (Object o : new ArrayList(allChildren)) {
            if (o instanceof PFeature) {
                all.add((PFeature)o);
                continue;
            }
            if (!(o instanceof PLayer)) continue;
            all.addAll(((PLayer)o).getChildrenReference());
        }
        for (PFeature f : all) {
            f.setSelected(false);
            if (sl == null || selectionChangedBySelectionListener) continue;
            sl.removeSelectedFeature(f);
        }
        Collection<Feature> c = fce != null ? fce.getFeatureCollection().getSelectedFeatures() : this.featureCollection.getSelectedFeatures();
        HashSet<? extends Feature> selectionResult = new HashSet<Feature>();
        for (Feature feature : c) {
            if (feature instanceof FeatureGroup) {
                selectionResult.addAll(FeatureGroups.expandToLeafs((FeatureGroup)feature));
                continue;
            }
            selectionResult.add(feature);
        }
        c = selectionResult;
        for (Feature feature : c) {
            if (feature == null) continue;
            PFeature feature2 = this.getPFeatureHM().get(feature);
            if (feature2 != null) {
                if (feature2.getParent() != null) {
                    try {
                        feature2.getParent().moveToFront();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                feature2.setSelected(true);
                try {
                    feature2.moveToFront();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (sl != null && !selectionChangedBySelectionListener) {
                    sl.addSelectedFeature(feature2);
                }
                this.syncSelectedObjectPresenter(1000);
                continue;
            }
            try {
                this.handleLayer.removeAllChildren();
            }
            catch (Exception e) {
                LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
            }
        }
        this.showHandles(false);
    }

    @Override
    public void featuresChanged(FeatureCollectionEvent fce) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        list.addAll(fce.getEventFeatures());
        for (Feature elem : list) {
            this.reconsiderFeature(elem);
        }
        this.showHandles(false);
    }

    @Override
    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
        for (Feature f : fce.getEventFeatures()) {
            PFeature node;
            if (f == null || (node = this.pFeatureHM.get(f)) == null) continue;
            node.syncGeometry();
            node.refreshInfoNode();
            node.visualize();
            node.refreshDesign();
            node.resetInfoNodePosition();
            this.repaint();
        }
    }

    private void refreshAllInfoNodesRequested() {
        EventQueue.invokeLater(new Thread("Refresh pfeature names"){

            @Override
            public void run() {
                for (PFeature f : new ArrayList(MappingComponent.this.pFeatureHM.values())) {
                    if (f == null) continue;
                    f.refreshName();
                }
                MappingComponent.this.repaint();
            }
        });
    }

    @Override
    @Deprecated
    public void featuresAdded(FeatureCollectionEvent fce) {
    }

    @Override
    @Deprecated
    public void featureCollectionChanged() {
    }

    @Override
    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        for (PFeature feature : this.pFeatureHM.values()) {
            feature.cleanup();
        }
        this.stickyPNodes.clear();
        this.pFeatureHM.clear();
        this.featureLayer.removeAllChildren();
        for (PLayer layer : this.featureGrpLayerMap.values()) {
            layer.removeAllChildren();
            this.featureLayer.addChild((PNode)layer);
        }
        this.checkFeatureSupportingRasterServiceAfterFeatureRemoval(fce);
    }

    @Override
    public void featuresRemoved(final FeatureCollectionEvent fce) {
        this.removeFeatures(fce.getEventFeatures());
        this.checkFeatureSupportingRasterServiceAfterFeatureRemoval(fce);
        this.showHandles(false);
        this.refreshAllInfoNodesRequested();
        EventQueue.invokeLater(new Thread("MappingComponent featuresRemoved()"){

            @Override
            public void run() {
                MappingComponent.this.memUndo.featuresRemoved(fce.getEventFeatures());
                MappingComponent.this.memRedo.featuresRemoved(fce.getEventFeatures());
            }
        });
    }

    private void checkFeatureSupportingRasterServiceAfterFeatureRemoval(FeatureCollectionEvent fce) {
        FeatureAwareRasterService rs;
        HashSet<FeatureAwareRasterService> rasterServicesWhichShouldBeRemoved = new HashSet<FeatureAwareRasterService>();
        HashSet<FeatureAwareRasterService> rasterServicesWhichShouldBeRefreshed = new HashSet<FeatureAwareRasterService>();
        HashSet<FeatureAwareRasterService> rasterServices = new HashSet<FeatureAwareRasterService>();
        for (Feature f : this.getFeatureCollection().getAllFeatures()) {
            if (!(f instanceof RasterLayerSupportedFeature) || ((RasterLayerSupportedFeature)((Object)f)).getSupportingRasterService() == null) continue;
            rs = ((RasterLayerSupportedFeature)((Object)f)).getSupportingRasterService();
            rasterServices.add(rs);
        }
        for (Feature f : fce.getEventFeatures()) {
            MapService r;
            if (!(f instanceof RasterLayerSupportedFeature) || ((RasterLayerSupportedFeature)((Object)f)).getSupportingRasterService() == null) continue;
            rs = ((RasterLayerSupportedFeature)((Object)f)).getSupportingRasterService();
            if (rasterServices.contains(rs)) {
                for (Object o : this.getMappingModel().getRasterServices().values()) {
                    r = (MapService)o;
                    if (!r.equals(rs)) continue;
                    rasterServicesWhichShouldBeRefreshed.add((FeatureAwareRasterService)r);
                }
                continue;
            }
            for (Object o : this.getMappingModel().getRasterServices().values()) {
                r = (MapService)o;
                if (!r.equals(rs)) continue;
                rasterServicesWhichShouldBeRemoved.add((FeatureAwareRasterService)r);
            }
        }
        for (FeatureAwareRasterService frs : rasterServicesWhichShouldBeRemoved) {
            this.getMappingModel().removeLayer(frs);
        }
        for (FeatureAwareRasterService frs : rasterServicesWhichShouldBeRefreshed) {
            this.handleMapService(0, frs, true);
        }
    }

    public void setGroupLayerVisibility(String groupId, boolean visible) {
        PLayer layer = this.featureGrpLayerMap.get(groupId);
        if (layer != null) {
            layer.setVisible(visible);
        }
    }

    public void highlightFeature(Feature feature, int duration) {
        double local_clip_offset_y = this.clip_offset_y;
        double local_clip_offset_x = this.clip_offset_x;
        PFeature p = new PFeature(feature, this.getWtst(), local_clip_offset_x, local_clip_offset_y, this);
        Paint paint = p.getPaint();
        Color color = Color.BLACK;
        if (paint == null) {
            paint = p.getStrokePaint();
        }
        if (paint instanceof Color) {
            color = this.toHighlightingColor((Color)paint);
        }
        this.highlightFeature(feature, duration, color);
    }

    public void highlightFeature(Feature feature, int duration, Color highlightColor) {
        double local_clip_offset_y = this.clip_offset_y;
        double local_clip_offset_x = this.clip_offset_x;
        final PFeature p = new PFeature(feature, this.getWtst(), local_clip_offset_x, local_clip_offset_y, this);
        this.highlightingLayer.addChild((PNode)p);
        if (highlightColor != null) {
            if (p.getStrokePaint() != null) {
                p.setStrokePaint(highlightColor);
            }
            if (p.getPaint() != null) {
                p.setPaint(highlightColor);
            }
        }
        p.moveToFront();
        Point centroid = feature.getGeometry().getCentroid();
        centroid = CrsTransformer.transformToCurrentCrs(centroid);
        this.currentCrosshairPoint = new Coordinate(centroid.getX(), centroid.getY());
        this.crossHairPoint(this.currentCrosshairPoint, this.crossHairThickness);
        final Coordinate newCrosshairPoint = this.currentCrosshairPoint;
        Timer t = new Timer(duration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingComponent.this.highlightingLayer.removeChild((PNode)p);
                if (newCrosshairPoint.equals((Object)MappingComponent.this.currentCrosshairPoint)) {
                    MappingComponent.this.crossHairPoint((Coordinate)null);
                }
            }
        });
        t.setRepeats(false);
        t.start();
    }

    private Color toHighlightingColor(Color c) {
        int red = c.getRed() - 70;
        int green = c.getGreen() - 70;
        int blue = c.getBlue() - 70;
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        return new Color(red, green, blue);
    }

    public Collection<PFeature> addFeaturesToMap(final Feature[] features) {
        double local_clip_offset_y = this.clip_offset_y;
        double local_clip_offset_x = this.clip_offset_x;
        ArrayList<PFeature> newPFeatures = new ArrayList<PFeature>();
        for (int i = 0; i < features.length; ++i) {
            final Feature feature = features[i];
            final PFeature p = new PFeature(feature, this.getWtst(), local_clip_offset_x, local_clip_offset_y, this);
            newPFeatures.add(p);
            if (feature instanceof ChildNodesProvider) {
                p.addChildren(((ChildNodesProvider)((Object)feature)).provideChildren(p));
            }
            try {
                if (feature instanceof StyledFeature) {
                    p.setTransparency(((StyledFeature)feature).getTransparency());
                } else {
                    p.setTransparency(this.cismapPrefs.getLayersPrefs().getAppFeatureLayerTranslucency());
                }
                EventQueue.invokeLater(new Thread("MappingCompoenent addFeaturesToMap()"){

                    @Override
                    public void run() {
                        if (feature instanceof FeatureGroupMember) {
                            FeatureGroupMember fgm = (FeatureGroupMember)feature;
                            String groupId = fgm.getGroupId();
                            PLayer groupLayer = (PLayer)MappingComponent.this.featureGrpLayerMap.get(groupId);
                            if (groupLayer == null) {
                                groupLayer = new PLayer();
                                MappingComponent.this.featureLayer.addChild((PNode)groupLayer);
                                MappingComponent.this.featureGrpLayerMap.put(groupId, groupLayer);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("created layer for group " + groupId));
                                }
                            }
                            groupLayer.addChild((PNode)p);
                            if (fgm.getGeometry() != null) {
                                MappingComponent.this.pFeatureHM.put(fgm.getFeature(), p);
                                MappingComponent.this.pFeatureHM.put(fgm, p);
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("added feature to group " + groupId));
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                p.setTransparency(0.8f);
                LOG.info((Object)"Fehler beim Setzen der Transparenzeinstellungen", (Throwable)e);
            }
            if (feature instanceof FeatureGroupMember || feature.getGeometry() == null) continue;
            this.pFeatureHM.put(p.getFeature(), p);
            final int ii = i;
            EventQueue.invokeLater(new Thread("MappingComponent moveToFront after adding"){

                @Override
                public void run() {
                    MappingComponent.this.featureLayer.addChild((PNode)p);
                    if (!(features[ii].getGeometry() instanceof Point)) {
                        p.moveToFront();
                    }
                }
            });
        }
        this.refreshAllInfoNodesRequested();
        EventQueue.invokeLater(new Thread("MappingComponent movetofront search feature"){

            @Override
            public void run() {
                MappingComponent.this.rescaleStickyNodes();
                MappingComponent.this.repaint();
                MappingComponent.this.fireFeaturesAddedToMap(Arrays.asList(features));
                for (Feature feature : new ArrayList<Feature>(MappingComponent.this.featureCollection.getAllFeatures())) {
                    if (!(feature instanceof SearchFeature)) continue;
                    PFeature pFeature = (PFeature)MappingComponent.this.pFeatureHM.get(feature);
                    pFeature.moveToFront();
                }
            }
        });
        for (Feature f : features) {
            if (!(f instanceof RasterLayerSupportedFeature) || ((RasterLayerSupportedFeature)((Object)f)).getSupportingRasterService() == null) continue;
            FeatureAwareRasterService rs = ((RasterLayerSupportedFeature)((Object)f)).getSupportingRasterService();
            if (this.getMappingModel().getRasterServices().containsValue(rs)) continue;
            rs.setFeatureCollection(this.getFeatureCollection());
            this.getMappingModel().addLayer(rs);
        }
        this.showHandles(false);
        return newPFeatures;
    }

    private void fireFeaturesAddedToMap(Collection<Feature> cf) {
        for (MapListener curMapListener : this.mapListeners) {
            curMapListener.featuresAddedToMap(cf);
        }
    }

    private Envelope computeFeatureEnvelope(Feature[] features) {
        PNode root = new PNode();
        for (int i = 0; i < features.length; ++i) {
            PNode p = PNodeFactory.createPFeature(features[i], this);
            if (p == null) continue;
            root.addChild(p);
        }
        PBounds ext = root.getFullBounds();
        Envelope env = new Envelope(ext.x, ext.x + ext.width, ext.y, ext.y + ext.height);
        return env;
    }

    public void zoomToFullFeatureCollectionBounds() {
        this.zoomToFeatureCollection();
    }

    public void putCursor(String mode, Cursor cursor) {
        this.cursors.put(mode, cursor);
    }

    public Cursor getCursor(String mode) {
        return this.cursors.get(mode);
    }

    public void addInputListener(String mode, PBasicInputEventHandler listener) {
        PBasicInputEventHandler oldHandler = this.inputEventListener.get(mode);
        if (oldHandler != null) {
            this.removeInputEventListener((PInputEventListener)oldHandler);
        }
        this.inputEventListener.put(mode, listener);
    }

    public PInputEventListener getInputListener(String mode) {
        PBasicInputEventHandler o = this.inputEventListener.get(mode);
        if (o instanceof PInputEventListener) {
            return (PInputEventListener)o;
        }
        return null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        for (Feature f : this.featureCollection.getAllFeatures()) {
            f.setEditable(!readOnly);
        }
        this.readOnly = readOnly;
        this.handleLayer.repaint();
        try {
            this.handleLayer.removeAllChildren();
        }
        catch (Exception e) {
            LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
        }
        this.snapHandleLayer.removeAllChildren();
    }

    public String getHandleInteractionMode() {
        return this.handleInteractionMode;
    }

    public void setHandleInteractionMode(String handleInteractionMode) {
        this.handleInteractionMode = handleInteractionMode;
        this.showHandles(false);
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public void setBackgroundEnabled(boolean backgroundEnabled) {
        if (!backgroundEnabled && this.isBackgroundEnabled()) {
            this.featureServiceLayerVisible = this.featureServiceLayer.getVisible();
        }
        this.mapServicelayer.setVisible(backgroundEnabled);
        this.featureServiceLayer.setVisible(backgroundEnabled && this.featureServiceLayerVisible);
        for (int i = 0; i < this.featureServiceLayer.getChildrenCount(); ++i) {
            this.featureServiceLayer.getChild(i).setVisible(backgroundEnabled && this.featureServiceLayerVisible);
        }
        if (backgroundEnabled != this.isBackgroundEnabled() && !this.isBackgroundEnabled()) {
            this.queryServices();
        }
        this.backgroundEnabled = backgroundEnabled;
    }

    public PLayer getFeatureLayer() {
        return this.featureLayer;
    }

    public Map<String, PLayer> getFeatureGroupLayers() {
        return this.featureGrpLayerMap;
    }

    public void refreshHM(PFeature p) {
        this.pFeatureHM.put(p.getFeature(), p);
    }

    public PCanvas getSelectedObjectPresenter() {
        return this.selectedObjectPresenter;
    }

    public void reconsiderFeature(Feature f) {
        if (f != null) {
            this.featureCollection.reconsiderFeature(f);
        }
    }

    public void removeFeatures(Collection<Feature> fc) {
        this.featureLayer.setVisible(false);
        for (Feature elem : fc) {
            this.removeFromHM(elem);
        }
        this.featureLayer.setVisible(true);
    }

    public void removeFromHM(Feature f) {
        PFeature pf = this.pFeatureHM.get(f);
        if (pf != null) {
            pf.cleanup();
            pf.releaseResources();
            this.pFeatureHM.remove(f);
            this.stickyPNodes.remove(pf);
            try {
                LOG.info((Object)("Entferne Feature " + f));
                this.featureLayer.removeChild((PNode)pf);
                for (PLayer grpLayer : this.featureGrpLayerMap.values()) {
                    if (grpLayer.removeChild((PNode)pf) == null) continue;
                }
            }
            catch (Exception exception) {}
        } else {
            LOG.warn((Object)"Feature war nicht in pFeatureHM");
        }
    }

    public void zoomToSelectedNode() {
        this.zoomToSelection();
    }

    public void zoomToSelection() {
        Collection selection = this.featureCollection.getSelectedFeatures();
        this.zoomToAFeatureCollection(selection, true, false);
    }

    public void zoomToAFeatureCollection(Collection<? extends Feature> collection, boolean withHistory, boolean fixedScale) {
        try {
            this.handleLayer.removeAllChildren();
        }
        catch (Exception e) {
            LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
        }
        boolean first = true;
        Geometry g = null;
        for (Feature feature : collection) {
            if (first) {
                if (feature.getGeometry() == null) continue;
                g = CrsTransformer.transformToGivenCrs(feature.getGeometry(), this.mappingModel.getSrs().getCode()).getEnvelope();
                if (feature instanceof Bufferable && this.mappingModel.getSrs().isMetric()) {
                    g = g.buffer(((Bufferable)((Object)feature)).getBuffer() + 0.001);
                }
                first = false;
                continue;
            }
            if (feature.getGeometry() == null) continue;
            Geometry geometry = CrsTransformer.transformToGivenCrs(feature.getGeometry(), this.mappingModel.getSrs().getCode()).getEnvelope();
            if (feature instanceof Bufferable && this.mappingModel.getSrs().isMetric()) {
                geometry = geometry.buffer(((Bufferable)((Object)feature)).getBuffer() + 0.001);
            }
            g = g.getEnvelope().union(geometry);
        }
        if (g != null) {
            if (this.getHeight() == 0 || this.getWidth() == 0) {
                LOG.warn((Object)"DIVISION BY ZERO");
            }
            double hBuff = g.getEnvelopeInternal().getHeight() / (double)this.getHeight() * 10.0;
            double vBuff = g.getEnvelopeInternal().getWidth() / (double)this.getWidth() * 10.0;
            double buff = 0.0;
            buff = hBuff > vBuff ? hBuff : vBuff;
            if (buff == 0.0) {
                buff = this.mappingModel.getSrs().isMetric() ? 1.0 : 0.01;
            }
            g = g.buffer(buff);
            BoundingBox bb = new BoundingBox(g);
            boolean onlyOnePoint = collection.size() == 1 && ((Feature)collection.toArray()[0]).getGeometry() instanceof Point;
            this.gotoBoundingBox(bb, withHistory, !(fixedScale || onlyOnePoint && g.getArea() < 10.0), this.animationDuration);
        }
    }

    public void setSelectionInProgress(boolean selectionInProgress) {
        this.selectionInProgress = selectionInProgress;
    }

    public void showHandles(final boolean waitTillAllAnimationsAreComplete) {
        if (this.selectionInProgress) {
            return;
        }
        if (this.featureCollection.getSelectedFeatures().size() > 0) {
            Thread handle = new Thread("MappingComponent showHandles()"){

                @Override
                public void run() {
                    block8: {
                        EventQueue.invokeLater(new Thread("MappingComponent showHandles(animated)"){

                            @Override
                            public void run() {
                                try {
                                    MappingComponent.this.handleLayer.removeAllChildren();
                                }
                                catch (Exception e) {
                                    LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
                                }
                            }
                        });
                        while (MappingComponent.this.getAnimating() && waitTillAllAnimationsAreComplete) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(10L);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)"Unterbrechung bei getAnimating()", (Throwable)e);
                            }
                        }
                        if (!MappingComponent.this.featureCollection.areFeaturesEditable() || !MappingComponent.this.getInteractionMode().equals(MappingComponent.SELECT) && !MappingComponent.this.getInteractionMode().equals(MappingComponent.MOVE_POLYGON) && !MappingComponent.this.getInteractionMode().equals(MappingComponent.PRINTING_AREA_SELECTION) && !MappingComponent.this.getInteractionMode().equals(MappingComponent.LINEAR_REFERENCING) && !MappingComponent.this.getInteractionMode().equals(MappingComponent.PAN) && !MappingComponent.this.getInteractionMode().equals(MappingComponent.ZOOM) && !MappingComponent.this.getInteractionMode().equals(MappingComponent.ALKIS_PRINT) && !MappingComponent.this.getInteractionMode().equals(MappingComponent.SPLIT_POLYGON)) break block8;
                        if (MappingComponent.this.getHandleInteractionMode().equals(MappingComponent.ROTATE_POLYGON)) {
                            LinkedHashSet copy = new LinkedHashSet(MappingComponent.this.featureCollection.getSelectedFeatures());
                            for (final Feature selectedFeature : copy) {
                                if (!(selectedFeature instanceof Feature) || !selectedFeature.isEditable() || selectedFeature instanceof RequestForHidingHandles) continue;
                                EventQueue.invokeLater(new Thread("MappingComponent addRotationHandles"){

                                    @Override
                                    public void run() {
                                        if (MappingComponent.this.pFeatureHM.get(selectedFeature) != null && ((PFeature)MappingComponent.this.pFeatureHM.get(selectedFeature)).getVisible()) {
                                            ((PFeature)MappingComponent.this.pFeatureHM.get(selectedFeature)).addRotationHandles((PNode)MappingComponent.this.handleLayer);
                                        } else {
                                            LOG.warn((Object)("pFeatureHM.get(" + selectedFeature + ")==null"));
                                        }
                                    }
                                });
                            }
                        } else {
                            LinkedHashSet copy = new LinkedHashSet(MappingComponent.this.featureCollection.getSelectedFeatures());
                            int srid = CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
                            Geometry currentBoundingBoxGeometry = MappingComponent.this.getCurrentBoundingBoxFromCamera().getGeometry(srid);
                            for (final Feature selectedFeature : copy) {
                                if (selectedFeature == null || !selectedFeature.isEditable() || selectedFeature instanceof RequestForHidingHandles) continue;
                                if (MappingComponent.this.pFeatureHM.get(selectedFeature) != null && ((PFeature)MappingComponent.this.pFeatureHM.get(selectedFeature)).getVisible()) {
                                    if (selectedFeature.getGeometry() == null || !selectedFeature.getGeometry().getEnvelope().intersects(currentBoundingBoxGeometry)) continue;
                                    EventQueue.invokeLater(new Thread("MappingComponent addHandles"){

                                        @Override
                                        public void run() {
                                            try {
                                                PFeature feature = (PFeature)MappingComponent.this.pFeatureHM.get(selectedFeature);
                                                if (feature != null) {
                                                    feature.addHandles((PNode)MappingComponent.this.handleLayer);
                                                }
                                            }
                                            catch (Exception e) {
                                                LOG.error((Object)"Error bei addHandles: ", (Throwable)e);
                                            }
                                        }
                                    });
                                    continue;
                                }
                                LOG.warn((Object)("pFeatureHM.get(" + selectedFeature + ")==null"));
                            }
                        }
                    }
                }
            };
            CismetThreadPool.execute((Runnable)new Thread((Runnable)handle, "MappingCompoenent showHandles()"));
        } else {
            EventQueue.invokeLater(new Thread("MappingComponent removeAllChildren"){

                @Override
                public void run() {
                    try {
                        MappingComponent.this.handleLayer.removeAllChildren();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
                    }
                }
            });
        }
    }

    public PFeature getSolePureNewFeature() {
        int counter = 0;
        PFeature sole = null;
        ListIterator it = this.featureLayer.getChildrenIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof PFeature) || !(((PFeature)o).getFeature() instanceof PureNewFeature)) continue;
            ++counter;
            sole = (PFeature)o;
        }
        if (counter == 1) {
            return sole;
        }
        return null;
    }

    public PLayer getTmpFeatureLayer() {
        return this.tmpFeatureLayer;
    }

    public void setTmpFeatureLayer(PLayer tmpFeatureLayer) {
        this.tmpFeatureLayer = tmpFeatureLayer;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean gridEnabled) {
        this.gridEnabled = gridEnabled;
    }

    public static String getCoordinateString(double x, double y) {
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        return "(" + df.format(x) + "," + df.format(y) + ")";
    }

    public Point getPointGeometryFromPInputEvent(PInputEvent event) {
        double xCoord = this.getWtst().getSourceX(event.getPosition().getX() - this.getClip_offset_x());
        double yCoord = this.getWtst().getSourceY(event.getPosition().getY() - this.getClip_offset_y());
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(this.getMappingModel().getSrs().getCode()));
        return gf.createPoint(new Coordinate(xCoord, yCoord));
    }

    public PLayer getHandleLayer() {
        return this.handleLayer;
    }

    public void setHandleLayer(PLayer handleLayer) {
        this.handleLayer = handleLayer;
    }

    public boolean isVisualizeSnappingEnabled() {
        return this.visualizeSnappingEnabled;
    }

    public void setVisualizeSnappingEnabled(boolean visualizeSnappingEnabled) {
        this.visualizeSnappingEnabled = visualizeSnappingEnabled;
    }

    public boolean isVisualizeSnappingRectEnabled() {
        return this.visualizeSnappingRectEnabled;
    }

    public void setVisualizeSnappingRectEnabled(boolean visualizeSnappingRectEnabled) {
        this.visualizeSnappingRectEnabled = visualizeSnappingRectEnabled;
    }

    public int getSnappingRectSize() {
        return this.snappingRectSize;
    }

    public void setSnappingRectSize(int snappingRectSize) {
        this.snappingRectSize = snappingRectSize;
    }

    public PLayer getSnapHandleLayer() {
        return this.snapHandleLayer;
    }

    public void setSnapHandleLayer(PLayer snapHandleLayer) {
        this.snapHandleLayer = snapHandleLayer;
    }

    public boolean isSnappingEnabled() {
        return this.snappingMode != null && !SnappingMode.OFF.equals((Object)this.snappingMode);
    }

    @Deprecated
    public void setSnappingEnabled(boolean snappingEnabled) {
        this.setSnappingMode(snappingEnabled ? SnappingMode.POINT : SnappingMode.OFF);
    }

    public void setSnappingMode(SnappingMode snappingMode) {
        this.snappingMode = snappingMode != null ? snappingMode : SnappingMode.OFF;
        this.setVisualizeSnappingEnabled(this.isSnappingEnabled());
    }

    public SnappingMode getSnappingMode() {
        return this.snappingMode;
    }

    @Deprecated
    public boolean isSnappingOnLineEnabled() {
        return SnappingMode.LINE.equals((Object)this.getSnappingMode());
    }

    public void setSnappingOnLineEnabled(boolean snappingOnLineEnabled) {
        this.setSnappingMode(snappingOnLineEnabled ? SnappingMode.LINE : SnappingMode.POINT);
    }

    public PLayer getFeatureServiceLayer() {
        return this.featureServiceLayer;
    }

    public void setFeatureServiceLayer(PLayer featureServiceLayer) {
        this.featureServiceLayer = featureServiceLayer;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
    }

    @Deprecated
    public void setPreferences(CismapPreferences prefs) {
        TreeMap features;
        LOG.warn((Object)"involing deprecated operation setPreferences()");
        this.cismapPrefs = prefs;
        ActiveLayerModel mm = new ActiveLayerModel();
        LayersPreferences layersPrefs = prefs.getLayersPrefs();
        GlobalPreferences globalPrefs = prefs.getGlobalPrefs();
        this.setSnappingRectSize(globalPrefs.getSnappingRectSize());
        if (globalPrefs.getSnappingMode() != null) {
            this.setSnappingMode(globalPrefs.getSnappingMode());
        } else if (globalPrefs.isSnappingEnabled()) {
            this.setSnappingMode(SnappingMode.POINT);
        } else {
            this.setSnappingMode(SnappingMode.OFF);
        }
        this.setVisualizeSnappingEnabled(globalPrefs.isSnappingPreviewEnabled());
        this.setAnimationDuration(globalPrefs.getAnimationDuration());
        this.setInteractionMode(globalPrefs.getStartMode());
        mm.addHome(globalPrefs.getInitialBoundingBox());
        Crs crs = new Crs();
        crs.setCode(globalPrefs.getInitialBoundingBox().getSrs());
        crs.setName(globalPrefs.getInitialBoundingBox().getSrs());
        crs.setShortname(globalPrefs.getInitialBoundingBox().getSrs());
        mm.setSrs(crs);
        TreeMap raster = layersPrefs.getRasterServices();
        if (raster != null) {
            for (Object key : raster.keySet()) {
                Object o = raster.get(key);
                if (!(o instanceof MapService)) continue;
                mm.addLayer((RetrievalServiceLayer)o);
            }
        }
        if ((features = layersPrefs.getFeatureServices()) != null) {
            for (Object key : features.keySet()) {
                Object o = features.get(key);
                if (!(o instanceof MapService)) continue;
                mm.addLayer((RetrievalServiceLayer)o);
            }
        }
        this.setMappingModel(mm);
    }

    public CismapPreferences getCismapPrefs() {
        return this.cismapPrefs;
    }

    public void flash(int duration, int animationDuration, int what, int number) {
    }

    public PLayer getDragPerformanceImproverLayer() {
        return this.dragPerformanceImproverLayer;
    }

    public void setDragPerformanceImproverLayer(PLayer dragPerformanceImproverLayer) {
        this.dragPerformanceImproverLayer = dragPerformanceImproverLayer;
    }

    @Deprecated
    public PLayer getRasterServiceLayer() {
        return this.mapServicelayer;
    }

    public PLayer getMapServiceLayer() {
        return this.mapServicelayer;
    }

    public void setRasterServiceLayer(PLayer rasterServiceLayer) {
        this.mapServicelayer = rasterServiceLayer;
    }

    public void showGeometryInfoPanel(Feature f) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void fireActivityChanged() {
        this.propertyChangeSupport.firePropertyChange("activityChanged", null, null);
    }

    public boolean isRunning() {
        for (LayerControl lc : this.layerControls) {
            if (!lc.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void setInfoNodesVisible(boolean visible) {
        this.infoNodesVisible = visible;
        ListIterator it = this.featureLayer.getChildrenIterator();
        while (it.hasNext()) {
            Object elem = it.next();
            if (!(elem instanceof PFeature)) continue;
            ((PFeature)elem).setInfoNodeVisible(visible);
        }
        this.rescaleStickyNodes();
    }

    public void addToHistory(Object o) {
        this.historyModel.addToHistory(o);
    }

    public void removeHistoryModelListener(HistoryModelListener hml) {
        this.historyModel.removeHistoryModelListener(hml);
    }

    public void addHistoryModelListener(HistoryModelListener hml) {
        this.historyModel.addHistoryModelListener(hml);
    }

    public void setMaximumPossibilities(int max) {
        this.historyModel.setMaximumPossibilities(max);
    }

    public Object forward(boolean external) {
        PBounds fwd = (PBounds)this.historyModel.forward(external);
        if (external) {
            this.gotoBoundsWithoutHistory(fwd);
        }
        return fwd;
    }

    public Object back(boolean external) {
        PBounds back = (PBounds)this.historyModel.back(external);
        if (external) {
            this.gotoBoundsWithoutHistory(back);
        }
        return back;
    }

    public boolean isForwardPossible() {
        return this.historyModel.isForwardPossible();
    }

    public boolean isBackPossible() {
        return this.historyModel.isBackPossible();
    }

    public Vector getForwardPossibilities() {
        return this.historyModel.getForwardPossibilities();
    }

    public Object getCurrentElement() {
        return this.historyModel.getCurrentElement();
    }

    public Vector getBackPossibilities() {
        return this.historyModel.getBackPossibilities();
    }

    @Deprecated
    public boolean isInternalLayerWidgetAvailable() {
        return this.getInternalWidget(LAYERWIDGET) != null;
    }

    @Deprecated
    public void setInternalLayerWidgetAvailable(boolean internalLayerWidgetAvailable) {
        if (!internalLayerWidgetAvailable && this.getInternalWidget(LAYERWIDGET) != null) {
            this.removeInternalWidget(LAYERWIDGET);
        } else if (internalLayerWidgetAvailable && this.getInternalWidget(LAYERWIDGET) == null) {
            NewSimpleInternalLayerWidget simpleInternalLayerWidget = new NewSimpleInternalLayerWidget(this);
            this.addInternalWidget(LAYERWIDGET, 8, simpleInternalLayerWidget);
        }
    }

    @Override
    public void mapServiceLayerStructureChanged(MappingModelEvent mme) {
    }

    @Override
    public void mapServiceRemoved(MapService rasterService) {
        try {
            this.mapServicelayer.removeChild(rasterService.getPNode());
            if (rasterService.getPNode() != null) {
                for (int i = 0; i < rasterService.getPNode().getChildrenCount(); ++i) {
                    PNode node = rasterService.getPNode().getChild(i);
                    if (!(node instanceof PFeature)) continue;
                    ((PFeature)node).releaseResources();
                }
            }
            if (this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.removed", rasterService));
            }
            if (rasterService instanceof FeatureAwareRasterService) {
                ArrayList<Feature> lf = new ArrayList<Feature>();
                for (Feature f : this.getFeatureCollection().getAllFeatures()) {
                    RasterLayerSupportedFeature rlsf;
                    if (!(f instanceof RasterLayerSupportedFeature) || (rlsf = (RasterLayerSupportedFeature)((Object)f)).getSupportingRasterService() == null || !rlsf.getSupportingRasterService().equals(rasterService)) continue;
                    lf.add(f);
                }
                this.getFeatureCollection().removeFeatures(lf);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Fehler bei mapServiceRemoved", (Throwable)e);
        }
    }

    @Override
    public void mapServiceAdded(MapService mapService) {
        this.addMapService(mapService, this.mapServicelayer.getChildrenCount());
        if (mapService instanceof FeatureAwareRasterService) {
            ((FeatureAwareRasterService)mapService).setFeatureCollection(this.getFeatureCollection());
        }
        if (mapService instanceof ServiceLayer && ((ServiceLayer)((Object)mapService)).isEnabled() && !this.locked) {
            this.handleMapService(0, mapService, false);
        }
    }

    public double getCurrentOGCScale() {
        double realWorldWidth = this.getCamera().getViewBounds().getWidth();
        double realWorldHeight = this.getCamera().getViewBounds().getHeight();
        double windowWidthInPixel = this.getWidth();
        double windowHeightInPixel = this.getHeight();
        double h = realWorldHeight / windowHeightInPixel;
        double w = realWorldWidth / windowWidthInPixel;
        return Math.sqrt(h * h + w * w);
    }

    @Deprecated
    public BoundingBox getCurrentBoundingBox() {
        return this.getCurrentBoundingBoxFromCamera();
    }

    public BoundingBox getCurrentBoundingBoxFromCamera() {
        if (this.fixedBoundingBox != null) {
            return this.fixedBoundingBox;
        }
        try {
            PBounds bounds = this.getCamera().getViewBounds();
            double x1 = this.wtst.getWorldX(bounds.getX());
            double y1 = this.wtst.getWorldY(bounds.getY());
            double x2 = x1 + bounds.width;
            double y2 = y1 - bounds.height;
            Crs currentCrs = CismapBroker.getInstance().getSrs();
            return new XBoundingBox(x1, y1, x2, y2, currentCrs.getCode(), this.isInMetricSRS());
        }
        catch (Exception e) {
            LOG.error((Object)"cannot create bounding box from current view, return null", (Throwable)e);
            return null;
        }
    }

    public boolean isInMetricSRS() {
        Crs currentCrs = CismapBroker.getInstance().getSrs();
        if (CrsTransformer.getCurrentSrid() == 4326) {
            return false;
        }
        return currentCrs.isMetric();
    }

    public BoundingBox getFixedBoundingBox() {
        return this.fixedBoundingBox;
    }

    public void setFixedBoundingBox(BoundingBox fixedBoundingBox) {
        this.fixedBoundingBox = fixedBoundingBox;
    }

    public void outlineArea(BoundingBox bb) {
        this.outlineArea(bb, null);
    }

    public void outlineArea(PBounds b) {
        this.outlineArea(b, null);
    }

    public void outlineArea(BoundingBox bb, Paint fillingPaint) {
        PBounds pb = null;
        if (bb != null) {
            pb = new PBounds(this.wtst.getScreenX(bb.getX1()), this.wtst.getScreenY(bb.getY2()), bb.getX2() - bb.getX1(), bb.getY2() - bb.getY1());
        }
        this.outlineArea(pb, fillingPaint);
    }

    public void outlineArea(PBounds b, Paint fillingColor) {
        if (b == null) {
            if (this.highlightingLayer.getChildrenCount() > 0) {
                this.highlightingLayer.removeAllChildren();
            }
        } else {
            this.highlightingLayer.removeAllChildren();
            this.highlightingLayer.setTransparency(1.0f);
            PPath rectangle = new PPath();
            rectangle.setPaint(fillingColor);
            rectangle.setStroke((Stroke)new FixedWidthStroke());
            rectangle.setStrokePaint((Paint)new Color(100, 100, 100, 255));
            rectangle.setPathTo((Shape)b);
            this.highlightingLayer.addChild((PNode)rectangle);
        }
    }

    public void highlightArea(BoundingBox bb) {
        PBounds pb = null;
        if (bb != null) {
            pb = new PBounds(this.wtst.getScreenX(bb.getX1()), this.wtst.getScreenY(bb.getY2()), bb.getX2() - bb.getX1(), bb.getY2() - bb.getY1());
        }
        this.highlightArea(pb);
    }

    private void highlightArea(PBounds b) {
        if (b == null) {
            if (this.highlightingLayer.getChildrenCount() > 0) {
                // empty if block
            }
            this.highlightingLayer.animateToTransparency(0.0f, (long)this.animationDuration);
            this.highlightingLayer.removeAllChildren();
        } else {
            this.highlightingLayer.removeAllChildren();
            this.highlightingLayer.setTransparency(1.0f);
            PPath rectangle = new PPath();
            rectangle.setPaint((Paint)new Color(255, 255, 255, 100));
            rectangle.setStroke(null);
            rectangle.setPathTo((Shape)this.getCamera().getViewBounds());
            this.highlightingLayer.addChild((PNode)rectangle);
            rectangle.animateToBounds(b.x, b.y, b.width, b.height, (long)this.animationDuration);
        }
    }

    public void crossHairPoint(Coordinate c) {
        this.crossHairPoint(c, 1);
    }

    public void crossHairPoint(Coordinate c, int thickness) {
        java.awt.Point p = null;
        if (c != null) {
            this.wtst = null;
            p = new java.awt.Point((int)this.getWtst().getScreenX(c.x), (int)this.getWtst().getScreenY(c.y));
        }
        this.crossHairPoint(p, thickness);
    }

    public void crossHairPoint(java.awt.Point p) {
        this.crossHairPoint(p, 1);
    }

    public void crossHairPoint(java.awt.Point p, int thickness) {
        if (p == null) {
            if (this.crosshairLayer.getChildrenCount() > 0) {
                this.crosshairLayer.removeAllChildren();
            }
        } else {
            this.crosshairLayer.removeAllChildren();
            this.crosshairLayer.setTransparency(1.0f);
            PPath lineX = new PPath();
            PPath lineY = new PPath();
            lineX.setStroke((Stroke)new CustomFixedWidthStroke(thickness, this));
            lineX.setStrokePaint((Paint)this.crossHairColor);
            lineY.setStroke((Stroke)new CustomFixedWidthStroke(thickness, this));
            lineY.setStrokePaint((Paint)this.crossHairColor);
            PBounds current = this.getCamera().getViewBounds();
            PBounds x = new PBounds(current.x, (double)p.y, current.width, 1.0);
            PBounds y = new PBounds((double)p.x, current.y, 1.0, current.height);
            lineX.setPathTo((Shape)x);
            this.crosshairLayer.addChild((PNode)lineX);
            lineY.setPathTo((Shape)y);
            this.crosshairLayer.addChild((PNode)lineY);
        }
        this.repaint();
    }

    public Element getConfiguration() {
        PInputEventListener inputListener;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"writing configuration <cismapMappingPreferences>");
        }
        Element ret = new Element("cismapMappingPreferences");
        ret.setAttribute("interactionMode", this.getInteractionMode());
        ret.setAttribute("creationMode", ((CreateNewGeometryListener)this.getInputListener(NEW_POLYGON)).getMode());
        ret.setAttribute("handleInteractionMode", this.getHandleInteractionMode());
        ret.setAttribute("snapping", new Boolean(this.isSnappingEnabled()).toString());
        ret.setAttribute("snappingMode", this.getSnappingMode().toString());
        PInputEventListener selectionInputListener = this.getInputListener(SELECT);
        if (selectionInputListener instanceof SelectionListener) {
            SelectionListener listener = (SelectionListener)selectionInputListener;
            ret.setAttribute("createSelectionMode", listener.getMode());
        }
        if ((inputListener = this.getInputListener(CREATE_SEARCH_POLYGON)) instanceof CreateSearchGeometryListener) {
            CreateSearchGeometryListener listener = (CreateSearchGeometryListener)inputListener;
            ret.setAttribute("createSearchMode", listener.getMode());
        }
        Element currentPosition = new Element("Position");
        currentPosition.addContent((Content)this.getCurrentBoundingBoxFromCamera().getJDOMElement());
        currentPosition.setAttribute("CRS", this.mappingModel.getSrs().getCode());
        ret.addContent((Content)currentPosition);
        Element crsListElement = new Element("crsList");
        for (Crs tmp : this.crsList) {
            crsListElement.addContent((Content)tmp.getJDOMElement());
        }
        ret.addContent((Content)crsListElement);
        if (this.printingSettingsDialog != null) {
            ret.addContent((Content)this.printingSettingsDialog.getConfiguration());
        }
        if (CismapBroker.getInstance().getMinOpacityToStayEnabled() != null) {
            Element minOpacityToStayEnabled = new Element("minOpacityToStayEnabled");
            minOpacityToStayEnabled.addContent(CismapBroker.getInstance().getMinOpacityToStayEnabled().toString());
            ret.addContent((Content)minOpacityToStayEnabled);
        }
        Element multiFeaturePopupMenuEnabled = new Element("multiFeaturePopupMenuEnabled");
        multiFeaturePopupMenuEnabled.addContent(Boolean.toString(CismapBroker.getInstance().isMultiFeaturePopupMenuEnabled()));
        ret.addContent((Content)multiFeaturePopupMenuEnabled);
        Element widgets = new Element("InternalWidgets");
        for (String name : this.internalWidgets.keySet()) {
            Element widget = new Element("Widget");
            widget.setAttribute("name", name);
            widget.setAttribute("position", String.valueOf(this.internalWidgetPositions.get(name)));
            widget.setAttribute("visible", String.valueOf(this.getInternalWidget(name).isVisible()));
            widgets.addContent((Content)widget);
        }
        ret.addContent((Content)widgets);
        return ret;
    }

    public void masterConfigure(Element e) {
        Element prefs;
        block45: {
            Element capsList;
            Element variablesList;
            prefs = e.getChild("cismapMappingPreferences");
            try {
                List crsElements = prefs.getChild("crsList").getChildren("crs");
                boolean defaultCrsFound = false;
                this.crsList.clear();
                for (Object elem : crsElements) {
                    if (!(elem instanceof Element)) continue;
                    Crs s = new Crs((Element)elem);
                    this.crsList.add(s);
                    if (!s.isSelected() || !s.isMetric() && !s.isDefaultCrs()) continue;
                    try {
                        if (defaultCrsFound) {
                            LOG.warn((Object)"More than one default CRS is set. Please check your master configuration file.");
                        }
                        CismapBroker.getInstance().setDefaultCrs(s.getCode());
                        defaultCrsFound = true;
                        this.transformer = new CrsTransformer(s.getCode());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Cannot create a GeoTransformer for the crs " + s.getCode()), (Throwable)ex);
                    }
                }
            }
            catch (Exception skip) {
                LOG.error((Object)"Error while reading the crs list", (Throwable)skip);
            }
            if (CismapBroker.getInstance().getDefaultCrs() == null) {
                LOG.fatal((Object)"The default CRS is not set. This can lead to almost irreparable data errors. Keep in mind: The default CRS must be metric");
            }
            if (this.transformer == null) {
                LOG.error((Object)"No metric default crs found. Use EPSG:31466 as default crs");
                try {
                    this.transformer = new CrsTransformer("EPSG:31466");
                    CismapBroker.getInstance().setDefaultCrs("EPSG:31466");
                }
                catch (Exception ex) {
                    LOG.error((Object)"Cannot create a GeoTransformer for the crs EPSG:31466", (Throwable)ex);
                }
            }
            if ((variablesList = e.getChild("TextAliasList")) != null) {
                List aliasList = variablesList.getChildren("alias");
                HashMap<String, String> aliasVariables = new HashMap<String, String>();
                if (aliasList != null) {
                    for (Object elem : aliasList) {
                        if (!(elem instanceof Element)) continue;
                        String name = ((Element)elem).getAttributeValue("name");
                        String url = ((Element)elem).getTextTrim();
                        if (name == null || url == null) continue;
                        aliasVariables.put(name, url);
                    }
                }
                CismapBroker.getInstance().setVariableMapping(aliasVariables);
            }
            if ((capsList = e.getChild("capabilitiesAliasList")) != null) {
                List aliasList = capsList.getChildren("alias");
                HashMap<String, String> urlAliasMapping = new HashMap<String, String>();
                if (aliasList != null) {
                    for (Object elem : aliasList) {
                        if (!(elem instanceof Element)) continue;
                        String name = ((Element)elem).getAttributeValue("name");
                        String url = ((Element)elem).getTextTrim();
                        if (name == null || url == null) continue;
                        urlAliasMapping.put(name, url);
                    }
                }
                CismapBroker.getInstance().setUrlAliasMapping(urlAliasMapping);
            }
            try {
                if (!(this.getMappingModel() instanceof ActiveLayerModel)) break block45;
                ActiveLayerModel alm = (ActiveLayerModel)this.getMappingModel();
                for (Object elem : prefs.getChildren("home")) {
                    String srs = elem.getAttribute("srs").getValue();
                    boolean metric = false;
                    try {
                        metric = elem.getAttribute("metric").getBooleanValue();
                    }
                    catch (DataConversionException dce) {
                        LOG.warn((Object)"Metric hat falschen Syntax", (Throwable)dce);
                    }
                    boolean defaultVal = false;
                    try {
                        defaultVal = elem.getAttribute("default").getBooleanValue();
                    }
                    catch (DataConversionException dce) {
                        LOG.warn((Object)"default hat falschen Syntax", (Throwable)dce);
                    }
                    XBoundingBox xbox = new XBoundingBox((Element)elem, srs, metric);
                    alm.addHome(xbox);
                    if (!defaultVal) continue;
                    Crs crsObject = null;
                    for (Crs tmp : this.crsList) {
                        if (!tmp.getCode().equals(srs)) continue;
                        crsObject = tmp;
                        break;
                    }
                    if (crsObject == null) {
                        LOG.error((Object)("CRS " + srs + " from the default home is not found in the crs list"));
                        crsObject = new Crs(srs, srs, srs, true, false);
                        this.crsList.add(crsObject);
                    }
                    alm.setSrs(crsObject);
                    alm.setDefaultHomeSrs(crsObject);
                    CismapBroker.getInstance().setSrs(crsObject);
                    this.wtst = null;
                    this.getWtst();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim MasterConfigure der MappingComponent", (Throwable)ex);
            }
        }
        try {
            Element defaultCrs = prefs.getChild("defaultCrs");
            int defaultCrsInt = Integer.parseInt(defaultCrs.getAttributeValue("geometrySridAlias"));
            CismapBroker.getInstance().setDefaultCrsAlias(defaultCrsInt);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while reading the default crs alias from the master configuration file.", (Throwable)ex);
        }
        try {
            List scalesList = prefs.getChild("printing").getChildren("scale");
            this.scales.clear();
            for (Object elem : scalesList) {
                if (!(elem instanceof Element)) continue;
                Scale s = new Scale((Element)elem);
                this.scales.add(s);
            }
        }
        catch (Exception skip) {
            LOG.error((Object)"Fehler beim Lesen von Scale", (Throwable)skip);
        }
        Color fillingColor = null;
        Color lineColor = null;
        Integer lineWidth = null;
        Element measuringComponentElement = prefs.getChild("measuringComponent");
        if (measuringComponentElement != null) {
            Element lineColorElement;
            Element fillingColorElement = measuringComponentElement.getChild("fillingColor");
            if (fillingColorElement != null) {
                try {
                    Integer red = Integer.parseInt(fillingColorElement.getAttributeValue("red"));
                    Integer green = Integer.parseInt(fillingColorElement.getAttributeValue("green"));
                    Integer blue = Integer.parseInt(fillingColorElement.getAttributeValue("blue"));
                    Integer opacity = fillingColorElement.getAttributeValue("opacity") != null ? Integer.parseInt(fillingColorElement.getAttributeValue("opacity")) : 255;
                    fillingColor = new Color(red, green, blue, opacity);
                }
                catch (Exception ex) {
                    LOG.error((Object)"measuringComponent fillingColor is not defined properly.", (Throwable)ex);
                }
            }
            if ((lineColorElement = measuringComponentElement.getChild("lineColor")) != null) {
                try {
                    Integer red = Integer.parseInt(lineColorElement.getAttributeValue("red"));
                    Integer green = Integer.parseInt(lineColorElement.getAttributeValue("green"));
                    Integer blue = Integer.parseInt(lineColorElement.getAttributeValue("blue"));
                    Integer opacity = lineColorElement.getAttributeValue("opacity") != null ? Integer.parseInt(lineColorElement.getAttributeValue("opacity")) : 255;
                    lineColor = new Color(red, green, blue, opacity);
                }
                catch (Exception ex) {
                    LOG.error((Object)"measuringComponent lineColor is not defined properly.", (Throwable)ex);
                }
            }
            try {
                lineWidth = Integer.parseInt(measuringComponentElement.getChildText("lineWidth"));
            }
            catch (NumberFormatException ex) {
                LOG.error((Object)"measuringComponent lineWidth value is not a number.", (Throwable)ex);
            }
        }
        CismapBroker.getInstance().setMeasurementFillingColor(fillingColor);
        CismapBroker.getInstance().setMeasurementLineColor(lineColor);
        CismapBroker.getInstance().setMeasurementLineWidth(lineWidth);
        try {
            String minOpacity = prefs.getChildText("minOpacityToStayEnabled");
            if (minOpacity != null) {
                CismapBroker.getInstance().setMinOpacityToStayEnabled(Float.valueOf(Float.parseFloat(minOpacity)));
            }
        }
        catch (NumberFormatException ex) {
            LOG.error((Object)"The min opacity to stay enabled value is not a number.", (Throwable)ex);
        }
        try {
            String multiFeaturePopupMenuEnabled = prefs.getChildText("multiFeaturePopupMenuEnabled");
            if (multiFeaturePopupMenuEnabled != null) {
                CismapBroker.getInstance().setMultiFeaturePopupMenuEnabled(Boolean.parseBoolean(multiFeaturePopupMenuEnabled));
            }
        }
        catch (NumberFormatException ex) {
            LOG.error((Object)"The MultiFeaturePopupMenu stays disabled, value is not valid", (Throwable)ex);
        }
        this.initPrintingDialogs();
        this.printingSettingsDialog.masterConfigure(prefs);
    }

    public void configure(Element e) {
        CreateGeometryListenerInterface listener;
        SnappingMode[] inputListener;
        Element prefs = e.getChild("cismapMappingPreferences");
        try {
            List crsElements = prefs.getChild("crsList").getChildren("crs");
            for (Object elem : crsElements) {
                Crs s;
                if (!(elem instanceof Element) || this.crsList.contains(s = new Crs((Element)elem))) continue;
                this.crsList.add(s);
            }
        }
        catch (Exception skip) {
            LOG.warn((Object)"Error while reading the crs list", (Throwable)skip);
        }
        try {
            String interactMode = prefs.getAttribute("interactionMode").getValue();
            this.setInteractionMode(interactMode);
            if (interactMode.equals(NEW_POLYGON)) {
                try {
                    String creationMode = prefs.getAttribute("creationMode").getValue();
                    ((CreateNewGeometryListener)this.getInputListener(NEW_POLYGON)).setMode(creationMode);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Fehler beim Setzen des CreationInteractionMode", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim Setzen des InteractionMode", (Throwable)ex);
        }
        try {
            String createSearchMode = prefs.getAttribute("createSearchMode").getValue();
            inputListener = this.getInputListener(CREATE_SEARCH_POLYGON);
            if (inputListener instanceof CreateSearchGeometryListener && createSearchMode != null) {
                listener = (CreateSearchGeometryListener)inputListener;
                listener.setMode(createSearchMode);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim Setzen des CreateSearchMode", (Throwable)ex);
        }
        try {
            String selectionMode = prefs.getAttribute("createSelectionMode").getValue();
            inputListener = this.getInputListener(SELECT);
            if (inputListener instanceof SelectionListener && selectionMode != null) {
                listener = (SelectionListener)inputListener;
                ((SelectionListener)listener).setMode(selectionMode);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim Setzen des CreateSearchMode", (Throwable)ex);
        }
        try {
            String handleInterMode = prefs.getAttribute("handleInteractionMode").getValue();
            this.setHandleInteractionMode(handleInterMode);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim Setzen des HandleInteractionMode", (Throwable)ex);
        }
        try {
            String snappingModeValue = prefs.getAttribute("snappingMode").getValue();
            for (SnappingMode snappingMode : SnappingMode.values()) {
                if (!snappingMode.name().equalsIgnoreCase(snappingModeValue)) continue;
                this.setSnappingMode(snappingMode);
                break;
            }
            if (snappingModeValue == null) {
                boolean snapping = prefs.getAttribute("snapping").getBooleanValue();
                LOG.info((Object)("snapping=" + snapping));
                this.setSnappingMode(snapping ? SnappingMode.POINT : SnappingMode.OFF);
            }
            this.setInGlueIdenticalPointsMode(this.isSnappingEnabled());
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim setzen von snapping und Konsorten", (Throwable)ex);
        }
        try {
            Element pos = prefs.getChild("Position");
            BoundingBox b = new BoundingBox(pos);
            PBounds pb = b.getPBounds(this.getWtst());
            if (Double.isNaN(b.getX1()) || Double.isNaN(b.getX2()) || Double.isNaN(b.getY1()) || Double.isNaN(b.getY2())) {
                LOG.warn((Object)"BUGFINDER:Es war ein Wert in der BoundingBox NaN. Setze auf HOME");
                String crsCode = pos.getAttribute("CRS") != null ? pos.getAttribute("CRS").getValue() : null;
                this.addToHistory((Object)new PBoundsWithCleverToString(new PBounds(this.getMappingModel().getInitialBoundingBox().getPBounds(this.wtst)), this.wtst, crsCode));
            } else {
                Attribute crsAtt = pos.getAttribute("CRS");
                if (crsAtt != null) {
                    ActiveLayerModel alm;
                    String currentCrs = crsAtt.getValue();
                    Crs crsObject = null;
                    for (Crs tmp : this.crsList) {
                        if (!tmp.getCode().equals(currentCrs)) continue;
                        crsObject = tmp;
                        break;
                    }
                    if (crsObject == null) {
                        LOG.error((Object)("CRS " + currentCrs + " from the position element is not found in the crs list"));
                    }
                    if ((alm = (ActiveLayerModel)this.getMappingModel()) instanceof ActiveLayerModel) {
                        alm.setSrs(crsObject);
                    }
                    CismapBroker.getInstance().setSrs(crsObject);
                    this.wtst = null;
                    this.getWtst();
                }
                this.initialBoundingBox = b;
                this.gotoBoundingBox(b, true, true, 0, false);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim lesen der aktuellen Position", (Throwable)ex);
            this.gotoBoundingBox(this.getMappingModel().getInitialBoundingBox(), true, true, 0, false);
        }
        if (this.printingSettingsDialog != null) {
            this.printingSettingsDialog.configure(prefs);
        }
        try {
            Element widgets = prefs.getChild("InternalWidgets");
            if (widgets != null) {
                for (Object widget : widgets.getChildren()) {
                    String name = ((Element)widget).getAttribute("name").getValue();
                    boolean visible = ((Element)widget).getAttribute("visible").getBooleanValue();
                    this.showInternalWidget(name, visible, 0);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("could not enable internal widgets: " + ex), (Throwable)ex);
        }
        try {
            String minOpacity = prefs.getChildText("minOpacityToStayEnabled");
            if (minOpacity != null) {
                CismapBroker.getInstance().setMinOpacityToStayEnabled(Float.valueOf(Float.parseFloat(minOpacity)));
            }
        }
        catch (NumberFormatException ex) {
            LOG.error((Object)"The min opacity to stay enabled value is not a number.", (Throwable)ex);
        }
        try {
            String multiFeaturePopupMenuEnabled = prefs.getChildText("multiFeaturePopupMenuEnabled");
            if (multiFeaturePopupMenuEnabled != null) {
                CismapBroker.getInstance().setMultiFeaturePopupMenuEnabled(Boolean.parseBoolean(multiFeaturePopupMenuEnabled));
            }
        }
        catch (NumberFormatException ex) {
            LOG.error((Object)"The MultiFeaturePopupMenu stays disabled, value is not valid", (Throwable)ex);
        }
    }

    public void zoomToFeatureCollection(boolean fixedScale) {
        this.zoomToAFeatureCollection(this.featureCollection.getAllFeatures(), true, fixedScale);
    }

    public void zoomToFeatureCollection() {
        this.zoomToAFeatureCollection(this.featureCollection.getAllFeatures(), true, false);
    }

    public void gotoBoundingBox(BoundingBox bb, boolean history, boolean scaleToFit, int animationDuration) {
        this.gotoBoundingBox(bb, history, scaleToFit, animationDuration, true);
    }

    public void gotoBoundingBox(BoundingBox bb, final boolean history, final boolean scaleToFit, int animationDuration, final boolean queryServices) {
        if (bb != null && bb.isValid()) {
            try {
                this.handleLayer.removeAllChildren();
            }
            catch (Exception e) {
                LOG.warn((Object)"Fehler bei removeAllCHildren", (Throwable)e);
            }
            if (bb instanceof XBoundingBox && !((XBoundingBox)bb).getSrs().equals(this.mappingModel.getSrs().getCode())) {
                try {
                    CrsTransformer trans = new CrsTransformer(this.mappingModel.getSrs().getCode());
                    bb = trans.transformBoundingBox((XBoundingBox)bb);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Cannot transform the bounding box", (Throwable)e);
                }
            }
            final double x1 = this.getWtst().getScreenX(bb.getX1());
            final double y1 = this.getWtst().getScreenY(bb.getY1());
            final double x2 = this.getWtst().getScreenX(bb.getX2());
            final double y2 = this.getWtst().getScreenY(bb.getY2());
            final Rectangle2D.Double pos = new Rectangle2D.Double();
            ((Rectangle2D)pos).setRect(x1, y2, x2 - x1, y1 - y2);
            this.getCamera().animateViewToCenterBounds((Rectangle2D)pos, x1 != x2 && y1 != y2 && scaleToFit, (long)animationDuration);
            if (this.getCamera().getViewTransform().getScaleY() < 0.0) {
                LOG.warn((Object)"gotoBoundingBox: Problem :-( mit getViewTransform");
            }
            this.showHandles(true);
            Thread handle = new Thread("MappingComponent gotoBoundingBox()"){

                @Override
                public void run() {
                    while (MappingComponent.this.getAnimating()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(10L);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Unterbrechung bei getAnimating()", (Throwable)e);
                        }
                    }
                    if (history) {
                        if (x1 == x2 || y1 == y2 || !scaleToFit) {
                            MappingComponent.this.setNewViewBounds((Rectangle2D)MappingComponent.this.getCamera().getViewBounds());
                        } else {
                            MappingComponent.this.setNewViewBounds(pos);
                        }
                        if (queryServices) {
                            MappingComponent.this.queryServices();
                        }
                    } else if (queryServices) {
                        MappingComponent.this.queryServicesWithoutHistory();
                    }
                }
            };
            CismetThreadPool.execute((Runnable)handle);
        } else {
            LOG.warn((Object)("Seltsam: die BoundingBox war " + (bb == null ? "null" : "invalid")), (Throwable)new CurrentStackTrace());
        }
    }

    public void gotoBoundingBoxWithoutHistory(BoundingBox bb) {
        this.gotoBoundingBoxWithoutHistory(bb, this.animationDuration);
    }

    public void gotoBoundingBoxWithoutHistory(BoundingBox bb, int animationDuration) {
        this.gotoBoundingBox(bb, false, true, animationDuration);
    }

    public void gotoBoundingBoxWithHistory(BoundingBox bb) {
        this.gotoBoundingBox(bb, true, true, this.animationDuration);
    }

    public BoundingBox getBoundingBoxFromScale(double scaleDenominator) {
        return this.getScaledBoundingBox(scaleDenominator, this.getCurrentBoundingBoxFromCamera());
    }

    public BoundingBox getScaledBoundingBox(double scaleDenominator, BoundingBox bb) {
        double screenWidthInInch = (double)this.getWidth() / this.screenResolution;
        double screenWidthInMeter = screenWidthInInch * 0.0254;
        double screenHeightInInch = (double)this.getHeight() / this.screenResolution;
        double screenHeightInMeter = screenHeightInInch * 0.0254;
        double realWorldWidthInMeter = screenWidthInMeter * scaleDenominator * CrsTransformer.getCrsFactor(null);
        double realWorldHeightInMeter = screenHeightInMeter * scaleDenominator * CrsTransformer.getCrsFactor(null);
        BoundingBox xbb = bb;
        int metricSrid = 0;
        if (!this.mappingModel.getSrs().isMetric()) {
            try {
                int srid = CrsTransformer.extractSridFromCrs(this.mappingModel.getSrs().getCode());
                Geometry g = CrsTransformer.transformToMetricCrs(bb.getGeometry(srid));
                metricSrid = g.getSRID();
                xbb = new BoundingBox(g);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot transform the current bounding box.", (Throwable)e);
            }
        }
        double midX = xbb.getX1() + (xbb.getX2() - xbb.getX1()) / 2.0;
        double midY = xbb.getY1() + (xbb.getY2() - xbb.getY1()) / 2.0;
        BoundingBox scaledBox = new BoundingBox(midX - realWorldWidthInMeter / 2.0, midY - realWorldHeightInMeter / 2.0, midX + realWorldWidthInMeter / 2.0, midY + realWorldHeightInMeter / 2.0);
        if (!this.mappingModel.getSrs().isMetric()) {
            try {
                CrsTransformer trans = new CrsTransformer(this.mappingModel.getSrs().getCode());
                scaledBox = trans.transformBoundingBox(scaledBox, CrsTransformer.createCrsFromSrid(metricSrid));
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot transform the current bounding box.", (Throwable)e);
            }
        }
        return scaledBox;
    }

    public double getScaleDenominator() {
        BoundingBox boundingBox = this.getCurrentBoundingBoxFromCamera();
        double screenWidthInInch = (double)this.getWidth() / this.screenResolution;
        double screenWidthInMeter = screenWidthInInch * 0.0254;
        double screenHeightInInch = (double)this.getHeight() / this.screenResolution;
        double screenHeightInMeter = screenHeightInInch * 0.0254;
        if (!this.mappingModel.getSrs().isMetric()) {
            try {
                Geometry g = CrsTransformer.transformToMetricCrs(boundingBox.getGeometry(CrsTransformer.extractSridFromCrs(this.mappingModel.getSrs().getCode())));
                boundingBox = new BoundingBox(g);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot transform the current bounding box.", (Throwable)e);
            }
        }
        double realWorldWidthInMeter = boundingBox.getWidth();
        return realWorldWidthInMeter / screenWidthInMeter / CrsTransformer.getCrsFactor(null);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.isDropEnabled(dtde)) {
            try {
                MapDnDEvent mde = new MapDnDEvent();
                mde.setDte(dtde);
                java.awt.Point p = dtde.getLocation();
                this.getCamera().getViewTransform().inverseTransform((Point2D)p, (Point2D)p);
                mde.setXPos(this.getWtst().getWorldX(p.getX()));
                mde.setYPos(this.getWtst().getWorldY(p.getY()));
                CismapBroker.getInstance().fireDropOnMap(mde);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error in drop", (Throwable)ex);
            }
        }
    }

    private boolean isDropEnabled(DropTargetDropEvent dtde) {
        if (ALKIS_PRINT.equals(this.getInteractionMode())) {
            for (DataFlavor flavour : dtde.getTransferable().getTransferDataFlavors()) {
                if (!String.valueOf(flavour.getRepresentationClass()).endsWith(".DefaultMetaTreeNode")) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        try {
            MapDnDEvent mde = new MapDnDEvent();
            mde.setDte(dtde);
            java.awt.Point p = dtde.getLocation();
            this.getCamera().getViewTransform().inverseTransform((Point2D)p, (Point2D)p);
            mde.setXPos(this.getWtst().getWorldX(p.getX()));
            mde.setYPos(this.getWtst().getWorldY(p.getY()));
            CismapBroker.getInstance().fireDragOverMap(mde);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error in dragOver", (Throwable)ex);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public ConcurrentHashMap<Feature, PFeature> getPFeatureHM() {
        return this.pFeatureHM;
    }

    public boolean isFixedMapExtent() {
        return this.fixedMapExtent;
    }

    public void setFixedMapExtent(boolean fixedMapExtent) {
        this.fixedMapExtent = fixedMapExtent;
        if (this.mainMappingComponent) {
            CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("map.extent.fixed", this.fixedMapExtent));
        }
    }

    public boolean isFixedMapScale() {
        return this.fixedMapScale;
    }

    public void setFixedMapScale(boolean fixedMapScale) {
        this.fixedMapScale = fixedMapScale;
        if (this.mainMappingComponent) {
            CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("map.scale.fixed", this.fixedMapScale));
        }
    }

    public void selectPFeatureManually(PFeature one) {
        if (one != null) {
            this.featureCollection.select(one.getFeature());
        }
    }

    public PFeature getSelectedNode() {
        if (this.featureCollection.getSelectedFeatures().size() > 0) {
            Feature selF = (Feature)this.featureCollection.getSelectedFeatures().toArray()[0];
            if (selF == null) {
                return null;
            }
            return this.pFeatureHM.get(selF);
        }
        return null;
    }

    public boolean isInfoNodesVisible() {
        return this.infoNodesVisible;
    }

    public PrintingSettingsWidget getPrintingSettingsDialog() {
        return this.printingSettingsDialog;
    }

    public boolean isInGlueIdenticalPointsMode() {
        return this.inGlueIdenticalPointsMode;
    }

    public void setInGlueIdenticalPointsMode(boolean inGlueIdenticalPointsMode) {
        this.inGlueIdenticalPointsMode = inGlueIdenticalPointsMode;
    }

    public PLayer getHighlightingLayer() {
        return this.highlightingLayer;
    }

    public void setPointerAnnotation(PNode anno) {
        ((SimpleMoveListener)this.getInputListener(MOTION)).setPointerAnnotation(anno);
    }

    public void setPointerAnnotationVisibility(boolean visib) {
        if (this.getInputListener(MOTION) != null) {
            ((SimpleMoveListener)this.getInputListener(MOTION)).setAnnotationNodeVisible(visib);
        }
    }

    public boolean isPointerAnnotationVisible() {
        if (this.getInputListener(MOTION) != null) {
            return ((SimpleMoveListener)this.getInputListener(MOTION)).isAnnotationNodeVisible();
        }
        return false;
    }

    public List<Scale> getScales() {
        return this.scales;
    }

    public List<Crs> getCrsList() {
        return this.crsList;
    }

    public CrsTransformer getMetricTransformer() {
        return this.transformer;
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
        this.gotoBoundingBoxWithHistory(this.getInitialBoundingBox());
    }

    public void unlockWithoutReload() {
        this.locked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isMainMappingComponent() {
        return this.mainMappingComponent;
    }

    public MementoInterface getMemRedo() {
        return this.memRedo;
    }

    public MementoInterface getMemUndo() {
        return this.memUndo;
    }

    public Map<String, PBasicInputEventHandler> getInputEventListener() {
        return this.inputEventListener;
    }

    public void setInputEventListener(HashMap<String, PBasicInputEventHandler> inputEventListener) {
        this.inputEventListener.clear();
        this.inputEventListener.putAll(inputEventListener);
    }

    public void addGetFeatureInfoListener(GetFeatureInfoListener l) {
        ((GetFeatureInfoMultiGeomListener)this.inputEventListener.get(FEATURE_INFO_MULTI_GEOM)).addGetFeatureInfoListener(l);
    }

    public void removeGetFeatureInfoListener(GetFeatureInfoListener l) {
        ((GetFeatureInfoMultiGeomListener)this.inputEventListener.get(FEATURE_INFO_MULTI_GEOM)).removeGetFeatureInfoListener(l);
    }

    @Override
    public synchronized void crsChanged(final CrsChangedEvent event) {
        if (event.getFormerCrs() != null && this.fixedBoundingBox == null && !this.resetCrs) {
            if (this.locked) {
                return;
            }
            if (this.crsChangedWaitingDialog == null) {
                this.crsChangedWaitingDialog = new WaitDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), false, NbBundle.getMessage(MappingComponent.class, (String)"MappingComponent.crsChanged(CrsChangedEvent).wait"), null);
            }
            Thread r = new Thread("MappingComponent crsChanged()"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    final BoundingBox formerBBox = MappingComponent.this.getCurrentBoundingBoxFromCamera();
                    if (formerBBox instanceof XBoundingBox) {
                        ((XBoundingBox)formerBBox).setSrs(event.getFormerCrs().getCode());
                    }
                    try {
                        PNode node;
                        int i;
                        StaticSwingTools.showDialog((JDialog)MappingComponent.this.crsChangedWaitingDialog);
                        WorldToScreenTransform oldWtst = MappingComponent.this.getWtst();
                        BoundingBox bbox = MappingComponent.this.getCurrentBoundingBoxFromCamera();
                        CrsTransformer crsTransformer = new CrsTransformer(event.getCurrentCrs().getCode());
                        BoundingBox newBbox = crsTransformer.transformBoundingBox(bbox, event.getFormerCrs().getCode());
                        if (!newBbox.isValid()) {
                            throw new Exception("Transformation failed");
                        }
                        if (MappingComponent.this.getMappingModel() instanceof ActiveLayerModel) {
                            ActiveLayerModel alm = (ActiveLayerModel)MappingComponent.this.getMappingModel();
                            alm.setSrs(event.getCurrentCrs());
                        }
                        MappingComponent.this.wtst = null;
                        MappingComponent.this.getWtst();
                        MappingComponent.this.gotoBoundingBoxWithoutHistory(newBbox, 0);
                        ArrayList<Feature> list = new ArrayList<Feature>(MappingComponent.this.featureCollection.getAllFeatures());
                        for (Feature f : new ArrayList<Feature>(list)) {
                            if (!(f instanceof PrintTemplateFeature)) continue;
                            MappingComponent.this.featureCollection.unholdFeature(f);
                            list.remove(f);
                        }
                        MappingComponent.this.featureCollection.removeAllFeatures();
                        MappingComponent.this.featureCollection.addFeatures(list);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("debug features added: " + list.size()));
                        }
                        if (MappingComponent.this.getMappingModel() instanceof ActiveLayerModel) {
                            ActiveLayerModel alm = (ActiveLayerModel)MappingComponent.this.getMappingModel();
                            alm.refreshWebFeatureServices();
                            alm.refreshShapeFileLayer();
                        }
                        for (i = 0; i < MappingComponent.this.highlightingLayer.getChildrenCount(); ++i) {
                            node = MappingComponent.this.highlightingLayer.getChild(i);
                            CrsTransformer.transformPNodeToGivenCrs(node, event.getFormerCrs().getCode(), event.getCurrentCrs().getCode(), oldWtst, MappingComponent.this.getWtst());
                            if (!(node instanceof PSticky)) continue;
                            MappingComponent.this.rescaleStickyNode((PSticky)node);
                        }
                        for (i = 0; i < MappingComponent.this.rubberBandLayer.getChildrenCount(); ++i) {
                            node = MappingComponent.this.rubberBandLayer.getChild(i);
                            if (node instanceof FixedPImage && ((FixedPImage)node).getOriginalGeometry() != null) {
                                Point p = ((FixedPImage)node).getOriginalGeometry();
                                Point transformedP = crsTransformer.transformGeometry((Point)p.clone(), CrsTransformer.createCrsFromSrid(p.getSRID()));
                                MappingComponent.this.getWtst().getScreenX(transformedP.getX());
                                MappingComponent.this.getWtst().getScreenY(transformedP.getY());
                                node.setOffset(MappingComponent.this.getWtst().getScreenX(transformedP.getX()), MappingComponent.this.getWtst().getScreenY(transformedP.getY()));
                                if (!(node instanceof PSticky)) continue;
                                MappingComponent.this.rescaleStickyNode((PSticky)node);
                                continue;
                            }
                            CrsTransformer.transformPNodeToGivenCrs(node, event.getFormerCrs().getCode(), event.getCurrentCrs().getCode(), oldWtst, MappingComponent.this.getWtst());
                            if (!(node instanceof PSticky)) continue;
                            MappingComponent.this.rescaleStickyNode((PSticky)node);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Cannot transform the current bounding box to the CRS " + event.getCurrentCrs()), (Throwable)e);
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)MappingComponent.this)), NbBundle.getMessage(MappingComponent.class, (String)"MappingComponent.crsChanged(CrsChangedEvent).JOptionPane.message"), NbBundle.getMessage(MappingComponent.class, (String)"MappingComponent.crsChanged(CrsChangedEvent).JOptionPane.title"), 0);
                        EventQueue.invokeLater(new Thread("crsReset"){

                            @Override
                            public void run() {
                                MappingComponent.this.resetCrs = true;
                                ActiveLayerModel alm = (ActiveLayerModel)MappingComponent.this.getMappingModel();
                                alm.setSrs(event.getFormerCrs());
                                CismapBroker.getInstance().setSrs(event.getFormerCrs());
                                MappingComponent.this.wtst = null;
                                MappingComponent.this.getWtst();
                                MappingComponent.this.gotoBoundingBoxWithoutHistory(formerBBox, 0);
                            }
                        });
                    }
                    finally {
                        if (MappingComponent.this.crsChangedWaitingDialog != null) {
                            MappingComponent.this.crsChangedWaitingDialog.setVisible(false);
                            MappingComponent.this.crsChangedWaitingDialog.dispose();
                        } else {
                            LOG.error((Object)"crsChangedWaitingDialog == null");
                        }
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }
        this.resetCrs = false;
    }

    public JInternalFrame getInternalWidget(String name) {
        if (this.internalWidgets.containsKey(name)) {
            return this.internalWidgets.get(name);
        }
        LOG.warn((Object)("unknown internal widget '" + name + "'"));
        return null;
    }

    public int getInternalWidgetPosition(String name) {
        if (this.internalWidgetPositions.containsKey(name)) {
            return this.internalWidgetPositions.get(name);
        }
        LOG.warn((Object)("unknown position for '" + name + "'"));
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepaintListener(RepaintListener repaintListener) {
        ArrayList<RepaintListener> arrayList = this.repaintListeners;
        synchronized (arrayList) {
            this.repaintListeners.add(repaintListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepaintListener(RepaintListener repaintListener) {
        ArrayList<RepaintListener> arrayList = this.repaintListeners;
        synchronized (arrayList) {
            this.repaintListeners.remove(repaintListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRepaintStart(RepaintEvent e) {
        ArrayList<RepaintListener> arrayList = this.repaintListeners;
        synchronized (arrayList) {
            for (RepaintListener repaintListener : (ArrayList)this.repaintListeners.clone()) {
                repaintListener.repaintStart(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRepaintComplete(RepaintEvent e) {
        ArrayList<RepaintListener> arrayList = this.repaintListeners;
        synchronized (arrayList) {
            for (RepaintListener repaintListener : (ArrayList)this.repaintListeners.clone()) {
                repaintListener.repaintComplete(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRepaintError(RepaintEvent e) {
        ArrayList<RepaintListener> arrayList = this.repaintListeners;
        synchronized (arrayList) {
            for (RepaintListener repaintListener : (ArrayList)this.repaintListeners.clone()) {
                repaintListener.repaintError(e);
            }
        }
    }

    private synchronized void increaseRetrievalCompleteInProgressCount() {
        ++this.retrievalCompleteInProgressCount;
        this.rescaleStickyNodesEnabled = false;
    }

    private synchronized void decreaseRetrievalCompleteInProgressCount() {
        --this.retrievalCompleteInProgressCount;
        if (this.retrievalCompleteInProgressCount == 0) {
            this.rescaleStickyNodesEnabled = true;
        }
    }

    public double getFeaturePrintingDpi() {
        return this.featurePrintingDpi;
    }

    public void setFeaturePrintingDpi(double featurePrintingDpi) {
        this.featurePrintingDpi = featurePrintingDpi;
    }

    public String getViewTitle() {
        return NbBundle.getMessage(MappingComponent.class, (String)"MappingComponent.getViewTitle");
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/map.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }

    public void setMainMappingComponent(boolean mainMappingComponent) {
        this.mainMappingComponent = mainMappingComponent;
    }

    private class MappingComponentFeatureServiceListener
    implements RetrievalListener {
        private final transient Logger log = Logger.getLogger(this.getClass());
        private final transient ServiceLayer featureService;
        private final transient PLayer parent;
        private volatile long requestIdentifier;
        private Thread completionThread;

        public MappingComponentFeatureServiceListener(ServiceLayer featureService, PLayer parent) {
            this.featureService = featureService;
            this.parent = parent;
        }

        @Override
        public void retrievalStarted(RetrievalEvent e) {
            if (!e.isInitialisationEvent()) {
                this.requestIdentifier = e.getRequestIdentifier();
            }
            MappingComponent.this.fireActivityChanged();
            MappingComponent.this.fireRepaintStart(new RepaintEvent(e));
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.started", this.featureService));
            }
        }

        @Override
        public void retrievalProgress(RetrievalEvent e) {
            MappingComponent.this.fireActivityChanged();
        }

        @Override
        public void retrievalError(RetrievalEvent e) {
            this.log.error((Object)(this.featureService + "[" + e.getRequestIdentifier() + " (" + this.requestIdentifier + ")]: " + (e.isInitialisationEvent() ? "initialisation" : "retrieval") + " error"));
            MappingComponent.this.fireActivityChanged();
            MappingComponent.this.fireRepaintError(new RepaintEvent(e));
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.error", this.featureService));
            }
        }

        @Override
        public void retrievalComplete(final RetrievalEvent e) {
            if (e.isInitialisationEvent()) {
                this.log.info((Object)(this.featureService + "[" + e.getRequestIdentifier() + " (" + this.requestIdentifier + ")]: initialisation complete"));
                MappingComponent.this.fireActivityChanged();
                MappingComponent.this.fireRepaintError(new RepaintEvent(e));
                return;
            }
            if (this.completionThread != null && this.completionThread.isAlive() && !this.completionThread.isInterrupted()) {
                this.log.warn((Object)(this.featureService + "[" + e.getRequestIdentifier() + " (" + this.requestIdentifier + ")]: retrievalComplete: old completion thread still running, trying to interrupt thread"));
                if (e.getRequestIdentifier() != this.requestIdentifier) {
                    return;
                }
                this.completionThread.interrupt();
            }
            if (e.getRequestIdentifier() < this.requestIdentifier) {
                this.log.warn((Object)(this.featureService + "[" + e.getRequestIdentifier() + " (" + this.requestIdentifier + ")]: retrievalComplete: another retrieval process is still running, aborting retrievalComplete"));
                return;
            }
            int initialCapacity = this.parent.getChildrenReference().size();
            if (initialCapacity < 100) {
                initialCapacity = 100;
            }
            final ArrayList newFeatures = new ArrayList(initialCapacity);
            ((RetrievalServiceLayer)this.featureService).setProgress(-1);
            this.parent.setVisible(MappingComponent.this.isBackgroundEnabled() && this.featureService.isEnabled() && this.parent.getVisible());
            final ArrayList deletionCandidates = new ArrayList(this.parent.getChildrenReference().size());
            if (!e.isRefreshExisting()) {
                deletionCandidates.addAll(this.parent.getChildrenReference());
            }
            if (!e.isHasErrors() && e.getRetrievedObject() instanceof Collection) {
                this.completionThread = new Thread("completition"){

                    @Override
                    public void run() {
                        MappingComponent.this.increaseRetrievalCompleteInProgressCount();
                        ArrayList features = new ArrayList((Collection)e.getRetrievedObject());
                        int size = features.size();
                        int counter = 0;
                        Iterator it = features.iterator();
                        Feature[] deletionCandidatesFeature = new Feature[deletionCandidates.size()];
                        HashMap<Feature, PFeature> featureMap = new HashMap<Feature, PFeature>(deletionCandidates.size() * 1);
                        for (int i = 0; i < deletionCandidates.size(); ++i) {
                            PFeature pf = (PFeature)deletionCandidates.get(i);
                            deletionCandidatesFeature[i] = pf.getFeature();
                            featureMap.put(pf.getFeature(), pf);
                        }
                        PFeatureComparable comp = new PFeatureComparable();
                        Arrays.sort(deletionCandidatesFeature, comp);
                        while (MappingComponentFeatureServiceListener.this.requestIdentifier == e.getRequestIdentifier() && !this.isInterrupted() && it.hasNext()) {
                            ++counter;
                            Object o = it.next();
                            if (!(o instanceof Feature)) continue;
                            int index = Arrays.binarySearch(deletionCandidatesFeature, (Feature)o, comp);
                            if (index >= 0) {
                                PFeature noCand = (PFeature)featureMap.get(deletionCandidatesFeature[index]);
                                if (noCand.hasSameGeometry(((Feature)o).getGeometry())) {
                                    noCand.setFeature((Feature)o);
                                    noCand.refreshDesign();
                                    deletionCandidates.remove(noCand);
                                } else {
                                    PFeature p = new PFeature((Feature)o, MappingComponent.this.wtst, MappingComponent.this.clip_offset_x, MappingComponent.this.clip_offset_y, MappingComponent.this);
                                    newFeatures.add(p);
                                }
                            } else {
                                PFeature p = new PFeature((Feature)o, MappingComponent.this.wtst, MappingComponent.this.clip_offset_x, MappingComponent.this.clip_offset_y, MappingComponent.this);
                                newFeatures.add(p);
                            }
                            int currentProgress = (int)((double)counter / (double)size * 100.0);
                            if (((RetrievalServiceLayer)MappingComponentFeatureServiceListener.this.featureService).getProgress() == currentProgress || currentProgress < 10 || currentProgress % 10 != 0) continue;
                            ((RetrievalServiceLayer)MappingComponentFeatureServiceListener.this.featureService).setProgress(currentProgress);
                            MappingComponent.this.fireActivityChanged();
                        }
                        MappingComponent.this.decreaseRetrievalCompleteInProgressCount();
                        if (MappingComponentFeatureServiceListener.this.requestIdentifier == e.getRequestIdentifier() && !this.isInterrupted()) {
                            EventQueue.invokeLater(new Thread("MappingComponent retrievalComplete"){

                                @Override
                                public void run() {
                                    try {
                                        if (MappingComponentFeatureServiceListener.this.requestIdentifier != e.getRequestIdentifier()) {
                                            ((RetrievalServiceLayer)MappingComponentFeatureServiceListener.this.featureService).setProgress(100);
                                            MappingComponent.this.fireActivityChanged();
                                            return;
                                        }
                                        if (e.isRefreshExisting()) {
                                            MappingComponentFeatureServiceListener.this.parent.removeAllChildren();
                                        }
                                        for (Object o : newFeatures) {
                                            MappingComponentFeatureServiceListener.this.parent.addChild((PNode)o);
                                        }
                                        ((RetrievalServiceLayer)MappingComponentFeatureServiceListener.this.featureService).setProgress(100);
                                        MappingComponent.this.fireActivityChanged();
                                        MappingComponentFeatureServiceListener.this.parent.repaint();
                                        for (Object o : deletionCandidates) {
                                            if (!(o instanceof PFeature)) continue;
                                            PNode p = ((PFeature)o).getPrimaryAnnotationNode();
                                            if (p != null && p instanceof PSticky) {
                                                MappingComponent.this.removeStickyNode((PSticky)p);
                                            }
                                            ((PFeature)o).releaseResources();
                                        }
                                        MappingComponentFeatureServiceListener.this.parent.removeChildren((Collection)deletionCandidates);
                                        deletionCandidates.clear();
                                        if (LOG.isInfoEnabled()) {
                                            LOG.info((Object)(MappingComponentFeatureServiceListener.this.featureService + "[" + e.getRequestIdentifier() + " (" + MappingComponentFeatureServiceListener.this.requestIdentifier + ")]: " + MappingComponentFeatureServiceListener.this.parent.getChildrenCount() + " features retrieved or updated"));
                                        }
                                        MappingComponent.this.rescaleStickyNodes();
                                        MappingComponent.this.fireRepaintComplete(new RepaintEvent(e));
                                    }
                                    catch (Exception exception) {
                                        MappingComponentFeatureServiceListener.this.log.warn((Object)(MappingComponentFeatureServiceListener.this.featureService + "[" + e.getRequestIdentifier() + " (" + MappingComponentFeatureServiceListener.this.requestIdentifier + ")]: Fehler beim Aufr\u00e4umen"), (Throwable)exception);
                                        MappingComponent.this.fireRepaintError(new RepaintEvent(e));
                                    }
                                }
                            });
                        } else {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((RetrievalServiceLayer)MappingComponentFeatureServiceListener.this.featureService).setProgress(100);
                                    MappingComponent.this.fireActivityChanged();
                                    MappingComponent.this.fireRepaintError(new RepaintEvent(e));
                                }
                            });
                        }
                    }
                };
                this.completionThread.setPriority(5);
                if (this.requestIdentifier == e.getRequestIdentifier()) {
                    this.completionThread.start();
                } else {
                    MappingComponent.this.fireRepaintError(new RepaintEvent(e));
                }
            }
            MappingComponent.this.fireActivityChanged();
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.completed", this.featureService));
            }
        }

        @Override
        public void retrievalAborted(RetrievalEvent e) {
            this.log.warn((Object)(this.featureService + "[" + e.getRequestIdentifier() + " (" + this.requestIdentifier + ")]: aborted, TaskCounter:" + MappingComponent.this.taskCounter));
            if (this.completionThread != null) {
                this.completionThread.interrupt();
            }
            if (e.getRequestIdentifier() < this.requestIdentifier) {
                ((RetrievalServiceLayer)this.featureService).setProgress(-1);
            } else {
                ((RetrievalServiceLayer)this.featureService).setProgress(0);
            }
            MappingComponent.this.fireActivityChanged();
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.aborted", this.featureService));
            }
        }
    }

    private class DocumentProgressListener
    implements RetrievalListener {
        private final transient Logger log = Logger.getLogger(this.getClass());
        private final transient DocumentProgressWidget documentProgressWidget = new DocumentProgressWidget();
        private transient long requestId = -1L;

        public DocumentProgressListener() {
            this.documentProgressWidget.setVisible(false);
            if (MappingComponent.this.getInternalWidget(MappingComponent.PROGRESSWIDGET) == null) {
                MappingComponent.this.addInternalWidget(MappingComponent.PROGRESSWIDGET, 2, this.documentProgressWidget);
            }
        }

        @Override
        public void retrievalStarted(RetrievalEvent e) {
            if (!e.isInitialisationEvent()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalStarted aborted, no initialisation event"));
                return;
            }
            if (this.requestId != -1L) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalStarted: another initialisation thread is still running: " + this.requestId));
            }
            this.requestId = e.getRequestIdentifier();
            this.documentProgressWidget.setServiceName(e.getRetrievalService().toString());
            this.documentProgressWidget.setProgress(-1);
            MappingComponent.this.showInternalWidget(MappingComponent.PROGRESSWIDGET, true, 100);
        }

        @Override
        public void retrievalProgress(RetrievalEvent e) {
            if (!e.isInitialisationEvent()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalProgress, no initialisation event"));
                return;
            }
            if (this.requestId != e.getRequestIdentifier()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalProgress: another initialisation thread is still running: " + this.requestId));
            }
            this.documentProgressWidget.setProgress(e.getPercentageDone());
        }

        @Override
        public void retrievalComplete(RetrievalEvent e) {
            if (!e.isInitialisationEvent()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalComplete, no initialisation event"));
                return;
            }
            if (this.requestId != e.getRequestIdentifier()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalComplete: another initialisation thread is still running: " + this.requestId));
            }
            e.getRetrievalService().removeRetrievalListener(this);
            this.requestId = -1L;
            this.documentProgressWidget.setProgress(100);
            MappingComponent.this.showInternalWidget(MappingComponent.PROGRESSWIDGET, false, 200);
        }

        @Override
        public void retrievalAborted(RetrievalEvent e) {
            if (!e.isInitialisationEvent()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalAborted aborted, no initialisation event"));
                return;
            }
            if (this.requestId != e.getRequestIdentifier()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalAborted: another initialisation thread is still running: " + this.requestId));
            }
            this.requestId = -1L;
            this.documentProgressWidget.setProgress(0);
            MappingComponent.this.showInternalWidget(MappingComponent.PROGRESSWIDGET, false, 25);
        }

        @Override
        public void retrievalError(RetrievalEvent e) {
            if (!e.isInitialisationEvent()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalError aborted, no initialisation event"));
                return;
            }
            if (this.requestId != e.getRequestIdentifier()) {
                this.log.warn((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalError: another initialisation thread is still running: " + this.requestId));
            }
            this.requestId = -1L;
            e.getRetrievalService().removeRetrievalListener(this);
            this.documentProgressWidget.setProgress(0);
            MappingComponent.this.showInternalWidget(MappingComponent.PROGRESSWIDGET, false, 25);
        }

        public long getRequestId() {
            return this.requestId;
        }
    }

    private class MappingComponentRasterServiceListener
    implements RetrievalListener {
        private final transient Logger log = Logger.getLogger(this.getClass());
        private final transient ServiceLayer rasterService;
        private final XPImage pi;
        private int position = -1;

        public MappingComponentRasterServiceListener(int position, PNode pn, ServiceLayer rasterService) {
            this.position = position;
            this.rasterService = rasterService;
            this.pi = pn instanceof XPImage ? (XPImage)pn : null;
        }

        @Override
        public void retrievalStarted(RetrievalEvent e) {
            MappingComponent.this.fireActivityChanged();
            MappingComponent.this.fireRepaintStart(new RepaintEvent(e));
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.started", this.rasterService));
            }
        }

        @Override
        public void retrievalProgress(RetrievalEvent e) {
        }

        @Override
        public void retrievalError(RetrievalEvent e) {
            this.log.error((Object)(this.rasterService + ": Fehler beim Laden des Bildes! " + e.getErrorType() + " Errors: " + e.getErrors() + " Cause: " + e.getRetrievedObject()));
            MappingComponent.this.fireActivityChanged();
            MappingComponent.this.fireRepaintError(new RepaintEvent(e));
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.error", this.rasterService));
            }
        }

        @Override
        public void retrievalComplete(final RetrievalEvent e) {
            final Point2D localOrigin = MappingComponent.this.getCamera().getViewBounds().getOrigin();
            final double localScale = MappingComponent.this.getCamera().getViewScale();
            final PBounds localBounds = MappingComponent.this.getCamera().getViewBounds();
            final Object o = e.getRetrievedObject();
            Thread paintImageOnMap = new Thread("Mappingcompopnent retrievalComplete()"){

                @Override
                public void run() {
                    MappingComponent.this.fireActivityChanged();
                    if (o instanceof Image && !e.isHasErrors()) {
                        if (MappingComponent.this.isBackgroundEnabled()) {
                            Image i = (Image)o;
                            if (MappingComponentRasterServiceListener.this.rasterService.getName().startsWith("prefetching")) {
                                double x = localOrigin.getX() - localBounds.getWidth();
                                double y = localOrigin.getY() - localBounds.getHeight();
                                MappingComponentRasterServiceListener.this.pi.setImage(i, 0);
                                MappingComponentRasterServiceListener.this.pi.setScale(3.0 / localScale);
                                MappingComponentRasterServiceListener.this.pi.setOffset(x, y);
                            } else {
                                MappingComponentRasterServiceListener.this.pi.setImage(i, MappingComponent.this.animationDuration * 2);
                                MappingComponentRasterServiceListener.this.pi.setScale(1.0 / localScale);
                                MappingComponentRasterServiceListener.this.pi.setOffset(localOrigin);
                                MappingComponent.this.repaint();
                            }
                        }
                        MappingComponent.this.fireRepaintComplete(new RepaintEvent(e));
                    } else {
                        MappingComponent.this.fireRepaintError(new RepaintEvent(e));
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                paintImageOnMap.run();
            } else {
                EventQueue.invokeLater(paintImageOnMap);
            }
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.completed", this.rasterService));
            }
        }

        @Override
        public void retrievalAborted(RetrievalEvent e) {
            this.log.warn((Object)(this.rasterService + ": retrievalAborted: " + e.getRequestIdentifier()));
            MappingComponent.this.fireRepaintError(new RepaintEvent(e));
            if (MappingComponent.this.mainMappingComponent) {
                CismapBroker.getInstance().fireStatusValueChanged(new StatusEvent("retrieval.aborted", this.rasterService));
            }
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    public static enum SnappingMode {
        OFF,
        POINT,
        LINE,
        BOTH;

    }
}

