/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import java.awt.Component;
import java.util.Date;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXDatePicker;

public class DateCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JXDatePicker datePicker = new JXDatePicker();
    private boolean useSqlDate = true;

    @Override
    public Object getCellEditorValue() {
        if (this.useSqlDate) {
            return new java.sql.Date(this.datePicker.getDate().getTime());
        }
        return this.datePicker.getDate();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            this.useSqlDate = false;
            this.datePicker.setDate((Date)value);
        }
        if (value instanceof java.sql.Date) {
            this.useSqlDate = true;
            java.sql.Date date = (java.sql.Date)value;
            this.datePicker.setDate(new Date(date.getTime()));
        }
        return this.datePicker;
    }
}

