/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockingInterface;
import de.cismet.cismap.commons.gui.attributetable.LockAlreadyExistsException;
import de.cismet.cismap.commons.gui.attributetable.LockFromSameUserAlreadyExistsException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class H2FeatureServiceLocker
implements FeatureLockingInterface {
    private static final Logger LOG = Logger.getLogger(H2FeatureServiceLocker.class);

    @Override
    public Object lock(List<Feature> features, boolean multiLockForSameUserAllowed) throws LockAlreadyExistsException, Exception {
        ArrayList<Lock> locks = new ArrayList<Lock>();
        for (Feature f : features) {
            locks.add((Lock)this.lock(f, multiLockForSameUserAllowed));
        }
        return locks;
    }

    @Override
    public Object lock(Feature feature, boolean multiLockForSameUserAllowed) throws LockAlreadyExistsException, Exception {
        if (feature instanceof JDBCFeature && ((JDBCFeature)feature).getLayerProperties().getFeatureService() instanceof H2FeatureService) {
            JDBCFeature jdbcFeature = (JDBCFeature)feature;
            try {
                H2FeatureService service;
                block6: {
                    service = (H2FeatureService)jdbcFeature.getLayerProperties().getFeatureService();
                    try {
                        H2FeatureService.lockFeature(jdbcFeature.getId(), service.getTableName());
                    }
                    catch (LockFromSameUserAlreadyExistsException e) {
                        if (multiLockForSameUserAllowed) break block6;
                        throw e;
                    }
                }
                return new Lock(jdbcFeature.getId(), service.getTableName());
            }
            catch (LockAlreadyExistsException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while creating lock object", (Throwable)e);
                throw new Exception("Cannot lock object");
            }
        }
        throw new IllegalArgumentException("Only JDBCFeature from H2FeatureServices are supported");
    }

    @Override
    public Object lock(AbstractFeatureService service, boolean multiLockForSameUserAllowed) throws LockAlreadyExistsException, Exception {
        if (service instanceof H2FeatureService) {
            try {
                H2FeatureService h2Service;
                block6: {
                    h2Service = (H2FeatureService)service;
                    try {
                        H2FeatureService.lockFeature(null, h2Service.getTableName());
                    }
                    catch (LockFromSameUserAlreadyExistsException e) {
                        if (multiLockForSameUserAllowed) break block6;
                        throw e;
                    }
                }
                return new Lock(null, h2Service.getTableName());
            }
            catch (LockAlreadyExistsException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while creating lock object", (Throwable)e);
                throw new Exception("Cannot lock object");
            }
        }
        throw new IllegalArgumentException("Only H2FeatureServices are supported");
    }

    @Override
    public void unlock(Object unlockObject) throws Exception {
        if (unlockObject instanceof Lock) {
            try {
                Lock lock = (Lock)unlockObject;
                H2FeatureService.unlockFeature(lock.getFeatureId(), lock.getTableName());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while creating lock object", (Throwable)e);
                throw new Exception("Cannot lock object");
            }
        } else if (unlockObject instanceof List) {
            for (Object o : (List)unlockObject) {
                this.unlock(o);
            }
        } else {
            throw new IllegalArgumentException("No supported unlock object");
        }
    }

    @Override
    public Class[] getSupportedFeatureServiceClasses() {
        return new Class[]{H2FeatureService.class};
    }

    private class Lock {
        private final String tableName;
        private final Integer featureId;

        public Lock(Integer featureId, String tableName) {
            this.featureId = featureId;
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Integer getFeatureId() {
            return this.featureId;
        }
    }
}

