/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.capabilitywidget;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.LayerConfig;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.capabilities.AbstractCapabilitiesTreeModel;
import de.cismet.cismap.commons.capabilities.CapabilitiesCache;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFolderTreeCellRenderer;
import de.cismet.cismap.commons.featureservice.ShapeFolderTreeModel;
import de.cismet.cismap.commons.featureservice.WFSCapabilitiesTreeCellRenderer;
import de.cismet.cismap.commons.featureservice.WFSCapabilitiesTreeModel;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.gui.capabilitywidget.CidsLayerTransferable;
import de.cismet.cismap.commons.gui.capabilitywidget.SelectionAndCapabilities;
import de.cismet.cismap.commons.gui.capabilitywidget.StringFilter;
import de.cismet.cismap.commons.gui.capabilitywidget.TreeFolder;
import de.cismet.cismap.commons.gui.capabilitywidget.WFSSelectionAndCapabilities;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.MapBoundsListener;
import de.cismet.cismap.commons.interaction.events.CapabilityEvent;
import de.cismet.cismap.commons.internaldb.DBTableInformation;
import de.cismet.cismap.commons.internaldb.InternalDbTree;
import de.cismet.cismap.commons.preferences.CapabilitiesListTreeNode;
import de.cismet.cismap.commons.preferences.CapabilitiesPreferences;
import de.cismet.cismap.commons.preferences.CapabilityLink;
import de.cismet.cismap.commons.raster.wms.WMSCapabilitiesTreeCellRenderer;
import de.cismet.cismap.commons.raster.wms.WMSCapabilitiesTreeModel;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilitiesFactory;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.wms.capabilities.CoordinateSystem;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.LayerBoundingBox;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.commons.wms.capabilities.WMSCapabilitiesFactory;
import de.cismet.security.WebAccessManager;
import de.cismet.security.exceptions.RequestFailedException;
import de.cismet.security.handler.WSSAccessHandler;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.DefaultPopupMenuListener;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class CapabilityWidget
extends JPanel
implements DropTargetListener,
ChangeListener,
ActionListener,
Configurable,
MapBoundsListener,
GUIWindow {
    private static final Logger log = Logger.getLogger((String)"de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget");
    public static final String MASSSTABSBEGRENZUNG = "Ma\u00dfstabsbegrenzung:";
    int selectedIndex = -1;
    private int maxServerNameLength = 14;
    private ImageIcon icoConnect = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/connect.png"));
    private ImageIcon icoConnected = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/server.png"));
    private ImageIcon icoError = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/error.png"));
    private LinkedHashMap<LinkWithSubparent, JComponent> capabilityUrls = new LinkedHashMap();
    private LinkedHashMap<JComponent, LinkWithSubparent> capabilityUrlsReverse = new LinkedHashMap();
    private int acceptableActions = 3;
    private HashMap<Component, WMSCapabilities> wmsCapabilities = new HashMap();
    private HashMap<Component, JTree> wmsCapabilitiesTrees = new HashMap();
    private HashMap<Component, JTree> jdbcTrees = new HashMap();
    private HashMap<Component, JTree> cidsTrees = new HashMap();
    private HashMap<Component, WFSCapabilities> wfsCapabilities = new HashMap();
    private HashMap<Component, JTree> wfsCapabilitiesTrees = new HashMap();
    private HashMap<Component, JTree> shapeFolderTrees = new HashMap();
    private TreeSet<String> reverseAxisOrder = new TreeSet();
    private CapabilitiesPreferences preferences = new CapabilitiesPreferences();
    private JPopupMenu capabilityList = new JPopupMenu();
    private CapabilityWidget thisWidget = null;
    private Element serverElement;
    private JPopupMenu treePopMenu = new JPopupMenu();
    private String filterString = null;
    private JButton cmdAddByUrl;
    private JButton cmdAddFromList;
    private JButton cmdCollapse;
    private JButton cmdRefresh;
    private JButton cmdRemove;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JTabbedPane tbpCapabilities;
    private JTextField txtSearch;

    public CapabilityWidget() {
        this.thisWidget = this;
        this.initComponents();
        this.tbpCapabilities.addChangeListener(this);
        this.tbpCapabilities.putClientProperty("jgoodies.noContentBorder", Boolean.FALSE);
        this.tbpCapabilities.setRequestFocusEnabled(false);
        this.cmdAddFromList.setComponentPopupMenu(this.capabilityList);
        DropTarget dt = new DropTarget(this, this.acceptableActions, this);
        JMenuItem pmenuItem = new JMenuItem();
        pmenuItem.setAction(new AbstractAction(){
            {
                this.putValue("Name", NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.CapabilityWidget().pmenuItem.text"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTree tree = (JTree)CapabilityWidget.this.wmsCapabilitiesTrees.get(CapabilityWidget.this.tbpCapabilities.getSelectedComponent());
                if (tree == null) {
                    tree = (JTree)CapabilityWidget.this.wfsCapabilitiesTrees.get(CapabilityWidget.this.tbpCapabilities.getSelectedComponent());
                }
                if (tree == null) {
                    tree = (JTree)CapabilityWidget.this.jdbcTrees.get(CapabilityWidget.this.tbpCapabilities.getSelectedComponent());
                }
                if (tree == null) {
                    tree = (JTree)CapabilityWidget.this.cidsTrees.get(CapabilityWidget.this.tbpCapabilities.getSelectedComponent());
                }
                if (tree instanceof DragTree) {
                    CapabilityWidget.this.zoomToExtent((DragTree)tree);
                } else if (tree instanceof InternalDbTree) {
                    CapabilityWidget.this.zoomToExtent((InternalDbTree)tree);
                }
            }
        });
        this.treePopMenu.add(pmenuItem);
        this.txtSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check(CapabilityWidget.this.txtSearch.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.check(CapabilityWidget.this.txtSearch.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.check(CapabilityWidget.this.txtSearch.getText());
            }

            private void check(String text) {
                CapabilityWidget.this.filterString = text;
                CapabilityWidget.this.addFilterToActiveTree();
            }
        });
    }

    private void zoomToExtent(InternalDbTree iTree) {
        DBTableInformation[] infos = iTree.getDBTableInformationOfSelectionPath();
        Geometry geom = null;
        for (DBTableInformation dbInfo : infos) {
            try {
                H2FeatureService layer = new H2FeatureService(dbInfo.getName(), dbInfo.getDatabasePath(), dbInfo.getDatabaseTable(), null);
                layer.initAndWait();
                Geometry envelope = ((H2FeatureServiceFactory)layer.getFeatureFactory()).getEnvelope();
                if (envelope == null) continue;
                if (geom == null) {
                    geom = envelope;
                    continue;
                }
                geom = geom.union(envelope);
            }
            catch (Exception ex) {
                log.error((Object)"Error while creating H2FeatureService", (Throwable)ex);
            }
        }
        if (geom != null) {
            CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory(new XBoundingBox(geom));
        }
    }

    private void addFilterToActiveTree() {
        TreeModel model;
        JTree tree = this.getActiveTree();
        if (tree != null && (model = tree.getModel()) instanceof StringFilter) {
            ((StringFilter)((Object)model)).setFilterString(this.filterString);
            tree.updateUI();
        }
    }

    private void processUrl(final String link, final String subparent, final boolean interactive) {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"uncaught exception handler registered");
            }
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.error((Object)"uncaughtException: ", e);
                }
            });
        }
        log.info((Object)("processURL: " + link));
        String tabText = subparent != null && subparent.trim().length() > 0 ? subparent : (link.startsWith("http://") && link.length() > 21 ? link.substring(7, 21) + "..." : (link.length() > 14 ? link.substring(0, 14) + "..." : link));
        final JPanel load = this.getNewWaitingPanel(tabText);
        final JComponent test = this.capabilityUrls.get(new LinkWithSubparent(link, subparent));
        final String tabTextCopy = tabText;
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (test != null && test instanceof JComponent) {
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        CapabilityWidget.this.tbpCapabilities.setComponentAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent((JComponent)test), load);
                    }
                }
                LinkWithSubparent linkObject = new LinkWithSubparent(link, subparent);
                CapabilityWidget.this.capabilityUrls.put(linkObject, load);
                CapabilityWidget.this.capabilityUrlsReverse.put(load, linkObject);
                4 var2_3 = this;
                synchronized (var2_3) {
                    StaticSwingTools.jTabbedPaneWithVerticalTextAddTab((JTabbedPane)CapabilityWidget.this.tbpCapabilities, (String)tabTextCopy, (Icon)CapabilityWidget.this.icoConnect, (JComponent)load);
                }
                CapabilityWidget.this.tbpCapabilities.setSelectedComponent(load);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("link.toLowerCase().contains(service=wms)" + link.toLowerCase().contains("service=wms") + " link: " + link.toLowerCase()));
                }
                File shapeFolder = null;
                if (link.startsWith("file:")) {
                    File folderCandidate;
                    String uri = link;
                    if (uri.endsWith("\r")) {
                        uri = uri.substring(0, uri.length() - 1);
                    }
                    if ((folderCandidate = new File(link.substring(7).trim())).isDirectory()) {
                        shapeFolder = folderCandidate;
                    }
                }
                if (shapeFolder != null) {
                    CapabilityWidget.this.addShapeFolderCapabilitiesTree(link, load, interactive, subparent);
                } else if (link.toLowerCase().contains("service=wfs")) {
                    CapabilityWidget.this.addOGCWFSCapabilitiesTree(link, load, interactive);
                } else if (link.toLowerCase().contains("service=wms")) {
                    CapabilityWidget.this.addOGCWMSCapabilitiesTree(link, load, interactive, subparent);
                } else if (link.toLowerCase().contains("service=wss")) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"WSS Capabilties Link hinzugef\u00fcgt");
                        }
                        URL url = new URL(link.substring(0, link.indexOf(63)));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("URL des WSS: " + url.toString()));
                        }
                        if (!WebAccessManager.getInstance().isHandlerForURLRegistered(url)) {
                            WebAccessManager.getInstance().registerAccessHandler(url, AccessHandler.ACCESS_HANDLER_TYPES.WSS);
                        }
                        CapabilityWidget.this.addOGCCapabilitiesTree(link, load, interactive);
                    }
                    catch (MalformedURLException ex) {
                        log.error((Object)"Url is not wellformed no wss authentication possible", (Throwable)ex);
                    }
                } else if (link.toLowerCase().contains("service=cids")) {
                    CapabilityWidget.this.addCidsCapabilitesTree(link, load, subparent);
                } else if (link.toLowerCase().contains("service=internal_db")) {
                    CapabilityWidget.this.addInternalDBCapabilitesTree(link, load, subparent);
                } else {
                    log.info((Object)"service nicht spezifizierbar");
                    Object[] alternatives = new Object[]{"OGC-Web Mapping Service", "OGC-Web Feature Service", "OGC-Web Security Service"};
                    Object selectedValue = JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)CapabilityWidget.this), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.processUrl(String,String,boolean).JOptionPane.message", (Object[])new Object[]{link}), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.processUrl(String,String,boolean).JOptionPane.title"), 1, null, alternatives, alternatives[0]);
                    if (selectedValue == alternatives[0]) {
                        linkObject.setService("WMS");
                        CapabilityWidget.this.addOGCWMSCapabilitiesTree(link, load, interactive, subparent);
                    } else if (selectedValue == alternatives[1]) {
                        linkObject.setService("WFS");
                        CapabilityWidget.this.addOGCWFSCapabilitiesTree(link, load, interactive);
                    } else if (selectedValue == alternatives[2]) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"WSS Capabilties Link hinzugef\u00fcgt");
                            }
                            URL url = link.indexOf(63) != -1 ? new URL(link.substring(0, link.indexOf(63))) : new URL(link);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("URL des WSS: " + url.toString()));
                            }
                            if (!WebAccessManager.getInstance().isHandlerForURLRegistered(url)) {
                                WebAccessManager.getInstance().registerAccessHandler(url, AccessHandler.ACCESS_HANDLER_TYPES.WSS);
                            }
                            CapabilityWidget.this.addOGCCapabilitiesTree(link, load, interactive);
                        }
                        catch (MalformedURLException ex) {
                            log.error((Object)"Url is not wellformed no wss authentication possible", (Throwable)ex);
                        }
                    } else if (selectedValue == null) {
                        CapabilityWidget.this.tbpCapabilities.remove(load);
                        CapabilityWidget.this.capabilityUrls.remove(CapabilityWidget.this.capabilityUrlsReverse.get(load));
                        CapabilityWidget.this.capabilityUrlsReverse.remove(load);
                    } else {
                        CapabilityWidget.this.addOGCWMSCapabilitiesTree(null, load, interactive, null);
                    }
                }
            }
        });
    }

    public void processUrl(String link, String subparent) {
        this.processUrl(link, subparent, true);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.isDropOk(dtde)) {
            String link = this.getLink(dtde);
            this.processUrl(link, null);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.cmdCollapse = new JButton();
        this.cmdAddFromList = new JButton();
        this.cmdAddByUrl = new JButton();
        this.cmdRemove = new JButton();
        this.cmdRefresh = new JButton();
        this.txtSearch = new JTextField();
        this.tbpCapabilities = StaticSwingTools.jTabbedPaneWithVerticalTextCreator((int)2, (int)1);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setPreferredSize(new Dimension(200, 250));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.cmdCollapse.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/collapseTree.png")));
        this.cmdCollapse.setToolTipText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.cmdCollapse.toolTipText"));
        this.cmdCollapse.setMargin(new Insets(2, 1, 2, 1));
        this.cmdCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapabilityWidget.this.cmdCollapseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdCollapse);
        this.cmdAddFromList.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/addServerFromList.png")));
        this.cmdAddFromList.setToolTipText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.cmdAddFromList.toolTipText"));
        this.cmdAddFromList.setMargin(new Insets(2, 1, 2, 1));
        this.cmdAddFromList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapabilityWidget.this.cmdAddFromListActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdAddFromList);
        this.cmdAddByUrl.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/addServerFromUrl.png")));
        this.cmdAddByUrl.setToolTipText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.cmdAddByUrl.toolTipText"));
        this.cmdAddByUrl.setMargin(new Insets(2, 1, 2, 1));
        this.cmdAddByUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapabilityWidget.this.cmdAddByUrlActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdAddByUrl);
        this.cmdRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/tab_remove.png")));
        this.cmdRemove.setToolTipText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.cmdRemove.toolTipText"));
        this.cmdRemove.setMargin(new Insets(2, 1, 2, 1));
        this.cmdRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapabilityWidget.this.cmdRemoveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRemove);
        this.cmdRefresh.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/refresh.png")));
        this.cmdRefresh.setToolTipText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.cmdRefresh.toolTipText"));
        this.cmdRefresh.setMargin(new Insets(2, 1, 2, 1));
        this.cmdRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapabilityWidget.this.cmdRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRefresh);
        this.txtSearch.setToolTipText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.txtSearch.tooltip"));
        this.jToolBar1.add(this.txtSearch);
        this.jPanel1.add((Component)this.jToolBar1, "Center");
        this.add((Component)this.jPanel1, "North");
        this.tbpCapabilities.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.tbpCapabilities.setTabLayoutPolicy(1);
        this.tbpCapabilities.setPreferredSize(new Dimension(180, 400));
        this.tbpCapabilities.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CapabilityWidget.this.tbpCapabilitiesStateChanged(evt);
            }
        });
        this.add((Component)this.tbpCapabilities, "Center");
    }

    private void cmdAddFromListActionPerformed(ActionEvent evt) {
        this.capabilityList.show(this.cmdAddFromList, 0, this.cmdAddFromList.getHeight());
        this.capabilityList.setVisible(true);
    }

    private void cmdRefreshActionPerformed(ActionEvent evt) {
        JTree active = this.getActiveTree();
        if (active != null) {
            LinkWithSubparent link = this.capabilityUrlsReverse.get(this.tbpCapabilities.getSelectedComponent());
            this.addLinkManually(link);
        }
    }

    private void cmdAddByUrlActionPerformed(ActionEvent evt) {
        String input = JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.cmdAddByUrlActionPerformed().JOptionPane.message"), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.cmdAddByUrlActionPerformed().JOptionPane.title"), 1);
        if (input != null) {
            this.processUrl(input, null, true);
        }
    }

    private void cmdRemoveActionPerformed(ActionEvent evt) {
        this.removeActiveCapabilityTree();
    }

    private void removeActiveCapabilityTree() {
        JTree active = this.getActiveTree();
        if (active != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("active = " + active));
            }
            LinkWithSubparent link = this.capabilityUrlsReverse.get(this.tbpCapabilities.getSelectedComponent());
            this.capabilityUrls.remove(link);
            this.capabilityUrlsReverse.remove(this.tbpCapabilities.getSelectedComponent());
            if (this.wmsCapabilities.get(this.tbpCapabilities.getSelectedComponent()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Entferne WMSCapabilities-Tree");
                }
                this.wmsCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
                this.wmsCapabilitiesTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.tbpCapabilities.remove(this.tbpCapabilities.indexOfComponent(this.tbpCapabilities.getSelectedComponent()));
            } else if (this.wfsCapabilities.get(this.tbpCapabilities.getSelectedComponent()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Entferne WFSCapabilities-Tree");
                }
                this.wfsCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
                this.wfsCapabilitiesTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.tbpCapabilities.remove(this.tbpCapabilities.indexOfComponent(this.tbpCapabilities.getSelectedComponent()));
            } else if (this.jdbcTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
                this.jdbcTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.tbpCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
            } else if (this.cidsTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
                this.cidsTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.tbpCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
            } else if (this.shapeFolderTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
                this.shapeFolderTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.tbpCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
            } else {
                log.warn((Object)"Keine Component zum entfernen aktiv");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"kein Baum aktiv, entferne selektierten Reiter");
            }
            if (this.tbpCapabilities.getSelectedComponent() != null) {
                LinkWithSubparent link = this.capabilityUrlsReverse.get(this.tbpCapabilities.getSelectedComponent());
                this.capabilityUrls.remove(link);
                this.capabilityUrlsReverse.remove(this.tbpCapabilities.getSelectedComponent());
                this.wmsCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
                this.wfsCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
                this.jdbcTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.cidsTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.shapeFolderTrees.remove(this.tbpCapabilities.getSelectedComponent());
                this.tbpCapabilities.remove(this.tbpCapabilities.getSelectedComponent());
            } else {
                log.warn((Object)"The link was not removed from the capabilitiyURLs");
            }
        }
    }

    private void cmdCollapseActionPerformed(ActionEvent evt) {
        JTree active = this.getActiveTree();
        if (active != null) {
            for (int row = active.getRowCount() - 1; row > 0; --row) {
                active.collapseRow(row);
            }
        }
    }

    private void tbpCapabilitiesStateChanged(ChangeEvent evt) {
        this.addFilterToActiveTree();
    }

    private JTree getActiveTree() {
        if (this.wmsCapabilitiesTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
            return this.wmsCapabilitiesTrees.get(this.tbpCapabilities.getSelectedComponent());
        }
        if (this.wfsCapabilitiesTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
            return this.wfsCapabilitiesTrees.get(this.tbpCapabilities.getSelectedComponent());
        }
        if (this.jdbcTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
            return this.jdbcTrees.get(this.tbpCapabilities.getSelectedComponent());
        }
        if (this.cidsTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
            return this.cidsTrees.get(this.tbpCapabilities.getSelectedComponent());
        }
        if (this.shapeFolderTrees.get(this.tbpCapabilities.getSelectedComponent()) != null) {
            return this.shapeFolderTrees.get(this.tbpCapabilities.getSelectedComponent());
        }
        return null;
    }

    public void refreshJdbcTrees() {
        HashSet<Component> keys = new HashSet<Component>(this.jdbcTrees.keySet());
        for (Component key : keys) {
            JTree jdbcTree = this.jdbcTrees.get(key);
            if (!(jdbcTree instanceof InternalDbTree)) continue;
            ((InternalDbTree)jdbcTree).refresh();
        }
    }

    public static void main(String[] args) {
        try (InputStream configStream = ClassLoader.getSystemResourceAsStream("de/cismet/cismap/commons/demo/log4j.xml");){
            ConfigurationSource source = new ConfigurationSource(configStream);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.start((Configuration)new XmlConfiguration(context, source));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            log.warn((Object)"Error while setting LookAndFeel", (Throwable)e);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.getContentPane().add(new CapabilityWidget());
                f.pack();
                f.setVisible(true);
                f.setDefaultCloseOperation(3);
            }
        });
    }

    private boolean isDropOk(DropTargetDropEvent e) {
        return e.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor()) || e.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    private String getLink(DropTargetDropEvent dtde) {
        String link = null;
        try {
            dtde.acceptDrop(this.acceptableActions);
            if (dtde.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
                Object data = dtde.getTransferable().getTransferData(DataFlavor.getTextPlainUnicodeFlavor());
                if (data instanceof InputStream) {
                    InputStream input = (InputStream)data;
                    InputStreamReader isr = new InputStreamReader(input);
                    StringBuffer str = new StringBuffer();
                    int in = -1;
                    try {
                        while ((in = isr.read()) >= 0) {
                            if (in == 0) continue;
                            str.append((char)in);
                        }
                        link = str.toString();
                    }
                    catch (IOException ioe) {
                        System.err.println("cannot read" + ioe);
                        dtde.dropComplete(false);
                        String message = NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.getLink(DropTargetDropEvent).message", (Object[])new Object[]{ioe.getMessage()});
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), message, NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.getLink(DropTargetDropEvent).title"), 0);
                        return null;
                    }
                }
                try {
                    link = link.substring(0, link.indexOf("\n"));
                }
                catch (Exception input) {
                    // empty catch block
                }
                return link;
            }
            Object data = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            if (data instanceof List && ((List)data).size() > 0) {
                File f = (File)((List)data).get(0);
                link = "file://" + f.getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return link;
    }

    private JPanel getNewWaitingPanel(String tabTitle) {
        JPanel panLoad = new JPanel();
        JLabel lblWorld = new JLabel();
        JLabel lblLoading = new JLabel();
        JPanel panFillTop = new JPanel();
        JPanel panFillBottom = new JPanel();
        panLoad.setLayout(new GridBagLayout());
        panLoad.putClientProperty("tabTitle", tabTitle);
        lblWorld.setHorizontalAlignment(0);
        lblWorld.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/load.png")));
        lblWorld.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        panLoad.add((Component)lblWorld, gridBagConstraints);
        lblLoading.setText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.lblLoading.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        panLoad.add((Component)lblLoading, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        panLoad.add((Component)panFillTop, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        panLoad.add((Component)panFillBottom, gridBagConstraints);
        return panLoad;
    }

    private void addCidsCapabilitesTree(final String link, final JComponent comp, final String subparent) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> treeRendererClass = Class.forName("de.cismet.cismap.cidslayer.CidsCapabilitesTreeCellRenderer");
                    Class<?> treeModelClass = Class.forName("de.cismet.cismap.cidslayer.CidsLayerTreeModel");
                    String[] args = link.split("[=&]");
                    String domain = "";
                    String rootName = "";
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].equalsIgnoreCase("domain") && i + 1 < args.length) {
                            domain = args[i + 1];
                        }
                        if (!args[i].equalsIgnoreCase("title") || i + 1 >= args.length) continue;
                        rootName = args[i + 1];
                    }
                    if (domain.isEmpty()) {
                        CapabilityWidget.this.tbpCapabilities.remove(comp);
                        return;
                    }
                    final String title = rootName;
                    final TreeModel tm = (TreeModel)treeModelClass.getConstructor(String.class, String.class).newInstance(domain, title);
                    final TreeCellRenderer tcr = (TreeCellRenderer)treeRendererClass.newInstance();
                    final DragTree tree = new DragTree();
                    DropTarget dt = new DropTarget(tree, CapabilityWidget.this.acceptableActions, CapabilityWidget.this.thisWidget);
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            CapabilityWidget.this.addPopupMenu(tree);
                            tree.setModel(tm);
                            tree.setBorder(new EmptyBorder(1, 1, 1, 1));
                            tree.setCellRenderer(tcr);
                            JScrollPane sPane = new JScrollPane();
                            sPane.setViewportView(tree);
                            sPane.setBorder(new EmptyBorder(1, 1, 1, 1));
                            StaticSwingTools.setNiftyScrollBars((JScrollPane)sPane);
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                CapabilityWidget.this.tbpCapabilities.setComponentAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), sPane);
                            }
                            CapabilityWidget.this.cidsTrees.put(sPane, tree);
                            CapabilityWidget.this.stateChanged(null);
                            CapabilityWidget.this.capabilityUrls.put(new LinkWithSubparent(link, subparent), sPane);
                            CapabilityWidget.this.capabilityUrlsReverse.put(sPane, new LinkWithSubparent(link, subparent));
                            sPane.putClientProperty("tabTitle", title);
                            var2_2 = this;
                            synchronized (var2_2) {
                                StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)CapabilityWidget.this.tbpCapabilities, (String)title, (Icon)CapabilityWidget.this.icoConnect, (Color)Color.black, (JComponent)sPane);
                            }
                            CapabilityWidget.this.stateChanged(null);
                        }
                    });
                }
                catch (Exception ex) {
                    CapabilityWidget.this.tbpCapabilities.remove(comp);
                    JComponent jc = (JComponent)CapabilityWidget.this.capabilityUrls.get(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrls.remove(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrlsReverse.remove(jc);
                    log.error((Object)"Error while adding cids capabilites tree", (Throwable)ex);
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(r, "CapabilityWidget addCidsCapabilitesTree()"));
    }

    private void addInternalDBCapabilitesTree(final String link, final JComponent comp, final String subparent) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    int index = link.lastIndexOf("?");
                    String databasePath = link;
                    if (index != -1) {
                        databasePath = link.substring(0, index);
                    }
                    if (databasePath.startsWith("file://")) {
                        databasePath = databasePath.substring("file://".length());
                    }
                    final String title = NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addInternalDBCapabilitiesTree.title");
                    String dbPath = databasePath;
                    final InternalDbTree tree = new InternalDbTree(databasePath);
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            tree.setBorder(new EmptyBorder(1, 1, 1, 1));
                            JScrollPane sPane = new JScrollPane();
                            sPane.setViewportView(tree);
                            sPane.setBorder(new EmptyBorder(1, 1, 1, 1));
                            StaticSwingTools.setNiftyScrollBars((JScrollPane)sPane);
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                CapabilityWidget.this.tbpCapabilities.setComponentAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), sPane);
                            }
                            CapabilityWidget.this.jdbcTrees.put(sPane, tree);
                            CapabilityWidget.this.stateChanged(null);
                            CapabilityWidget.this.capabilityUrls.put(new LinkWithSubparent(link, subparent), sPane);
                            CapabilityWidget.this.capabilityUrlsReverse.put(sPane, new LinkWithSubparent(link, subparent));
                            sPane.putClientProperty("tabTitle", title);
                            var2_2 = this;
                            synchronized (var2_2) {
                                StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)CapabilityWidget.this.tbpCapabilities, (String)title, (Icon)CapabilityWidget.this.icoConnect, (Color)Color.black, (JComponent)sPane);
                            }
                            CapabilityWidget.this.stateChanged(null);
                        }
                    });
                }
                catch (Exception ex) {
                    CapabilityWidget.this.tbpCapabilities.remove(comp);
                    JComponent jc = (JComponent)CapabilityWidget.this.capabilityUrls.get(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrls.remove(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrlsReverse.remove(jc);
                    log.error((Object)"Error while adding internal db tree.", (Throwable)ex);
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(r, "CapabilityWidget addInternalDBCapabilitesTree()"));
    }

    private void addShapeFolderCapabilitiesTree(final String link, final JComponent comp, final boolean interactive, final String subparent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addShapeFolderCapabilitiesTree()");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    final DragTree trvCap = new DragTree();
                    final ShapeFolderTreeModel tm = new ShapeFolderTreeModel(link);
                    DropTarget dt = new DropTarget(trvCap, CapabilityWidget.this.acceptableActions, CapabilityWidget.this.thisWidget);
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            CapabilityWidget.this.addPopupMenu(trvCap);
                            trvCap.setModel(tm);
                            trvCap.setBorder(new EmptyBorder(1, 1, 1, 1));
                            trvCap.setCellRenderer(new ShapeFolderTreeCellRenderer());
                            JScrollPane sPane = new JScrollPane();
                            sPane.setViewportView(trvCap);
                            sPane.setBorder(new EmptyBorder(1, 1, 1, 1));
                            StaticSwingTools.setNiftyScrollBars((JScrollPane)sPane);
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                CapabilityWidget.this.tbpCapabilities.setComponentAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), sPane);
                            }
                            CapabilityWidget.this.shapeFolderTrees.put(sPane, trvCap);
                            CapabilityWidget.this.stateChanged(null);
                            CapabilityWidget.this.capabilityUrls.put(new LinkWithSubparent(link, subparent), sPane);
                            CapabilityWidget.this.capabilityUrlsReverse.put(sPane, new LinkWithSubparent(link, subparent));
                            String title = link.substring(link.lastIndexOf("/"));
                            if (subparent != null) {
                                title = subparent;
                            }
                            String titleOrig = title;
                            if (title.length() > 0) {
                                if (title.length() > CapabilityWidget.this.maxServerNameLength) {
                                    title = title.substring(0, CapabilityWidget.this.maxServerNameLength - 3) + "...";
                                }
                                sPane.putClientProperty("tabTitle", title);
                                1 var4_5 = this;
                                synchronized (var4_5) {
                                    StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)CapabilityWidget.this.tbpCapabilities, (String)title, (Icon)CapabilityWidget.this.icoConnected, (Color)Color.black, (JComponent)sPane);
                                }
                                var4_5 = this;
                                synchronized (var4_5) {
                                    CapabilityWidget.this.tbpCapabilities.setToolTipTextAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(sPane), titleOrig);
                                }
                                CapabilityWidget.this.stateChanged(null);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    log.error((Object)"Error while creating the ShapeFolder tree", e);
                    String message = "";
                    CapabilityWidget.this.tbpCapabilities.setIconAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), CapabilityWidget.this.icoError);
                    message = e instanceof RequestFailedException || e.getMessage() == null || e.getMessage().equals("null") ? e.getCause().getMessage() : e.getMessage();
                    if (interactive) {
                        ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addShapeFolderTree.JOptionPane.title"), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addShapeFolderTree.JOptionPane.message"), null, null, e, Level.SEVERE, null);
                        JXErrorPane.showDialog((Component)CapabilityWidget.this.thisWidget, (ErrorInfo)ei);
                    }
                    log.error((Object)("Error while loading Shape folder: " + message), e);
                    EventQueue.invokeLater(new Thread("RemoveShapeFolderCapabilitiesAfterError"){

                        @Override
                        public void run() {
                            CapabilityWidget.this.tbpCapabilities.remove(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp));
                        }
                    });
                    JComponent jc = (JComponent)CapabilityWidget.this.capabilityUrls.get(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrls.remove(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrlsReverse.remove(jc);
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(r, "CapabilityWidget addShapeFolderCapabilitiesTree()"));
    }

    private void addOGCWMSCapabilitiesTree(String link, JComponent comp, String subparent) {
        this.addOGCWMSCapabilitiesTree(link, comp, true, subparent);
    }

    private void addLinkManually(LinkWithSubparent link) {
        this.processUrl(link.getLink(), link.getSubparent(), false);
    }

    private void addOGCWMSCapabilitiesTree(final String link, final JComponent comp, final boolean interactive, final String subparent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addOGCWMSCapabilitiesTree()");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    final DragTree trvCap = new DragTree();
                    WMSCapabilitiesFactory capFact = new WMSCapabilitiesFactory((CalculationCache)CapabilitiesCache.getInstance());
                    CismapBroker broker = CismapBroker.getInstance();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Capability Widget: Creating WMScapabilities for URL: " + link));
                    }
                    final WMSCapabilities cap = capFact.createCapabilities(CismapBroker.getInstance().aliasToUrl(link));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"finished creating Capabilties");
                    }
                    trvCap.setWmsCapabilities(cap);
                    final WMSCapabilitiesTreeModel tm = new WMSCapabilitiesTreeModel(cap, subparent);
                    DropTarget dt = new DropTarget(trvCap, CapabilityWidget.this.acceptableActions, CapabilityWidget.this.thisWidget);
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            CapabilityWidget.this.addPopupMenu(trvCap);
                            trvCap.setModel(tm);
                            trvCap.setBorder(new EmptyBorder(1, 1, 1, 1));
                            trvCap.setCellRenderer(new WMSCapabilitiesTreeCellRenderer());
                            JScrollPane sPane = new JScrollPane();
                            sPane.setViewportView(trvCap);
                            sPane.setBorder(new EmptyBorder(1, 1, 1, 1));
                            StaticSwingTools.setNiftyScrollBars((JScrollPane)sPane);
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                CapabilityWidget.this.tbpCapabilities.setComponentAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), sPane);
                            }
                            CapabilityWidget.this.wmsCapabilities.put(sPane, cap);
                            CapabilityWidget.this.wmsCapabilitiesTrees.put(sPane, trvCap);
                            CapabilityWidget.this.stateChanged(null);
                            CapabilityWidget.this.capabilityUrls.put(new LinkWithSubparent(link, subparent), sPane);
                            CapabilityWidget.this.capabilityUrlsReverse.put(sPane, new LinkWithSubparent(link, subparent));
                            String title = cap.getLayer().getTitle().trim();
                            if (subparent != null) {
                                title = subparent;
                            }
                            String titleOrig = title;
                            if (title.length() > 0) {
                                if (title.length() > CapabilityWidget.this.maxServerNameLength) {
                                    title = title.substring(0, CapabilityWidget.this.maxServerNameLength - 3) + "...";
                                }
                                sPane.putClientProperty("tabTitle", title);
                                1 var4_5 = this;
                                synchronized (var4_5) {
                                    StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)CapabilityWidget.this.tbpCapabilities, (String)title, (Icon)CapabilityWidget.this.icoConnected, (Color)Color.black, (JComponent)sPane);
                                }
                                var4_5 = this;
                                synchronized (var4_5) {
                                    CapabilityWidget.this.tbpCapabilities.setToolTipTextAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(sPane), titleOrig);
                                }
                                CapabilityWidget.this.stateChanged(null);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    log.error((Object)"Fehler w\u00e4hrend dem Erstellen des WMSCapabilties Baums", e);
                    String message = "";
                    CapabilityWidget.this.tbpCapabilities.setIconAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), CapabilityWidget.this.icoError);
                    message = e instanceof RequestFailedException || e.getMessage() == null || e.getMessage().equals("null") ? (e.getCause() != null ? e.getCause().getMessage() : (e.getMessage() != null ? e.getMessage() : "e.getMessage() = null")) : e.getMessage();
                    if (interactive) {
                        ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addOGCWMSCapabilitiesTree.JOptionPane.title"), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addOGCWMSCapabilitiesTree.JOptionPane.message"), null, null, e, Level.SEVERE, null);
                        JXErrorPane.showDialog((Component)CapabilityWidget.this.thisWidget, (ErrorInfo)ei);
                    }
                    log.error((Object)("Error while loading server capabilities: " + message), e);
                    EventQueue.invokeLater(new Thread("RemoveWmsCapabilitiesAfterError"){

                        @Override
                        public void run() {
                            CapabilityWidget.this.tbpCapabilities.remove(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp));
                        }
                    });
                    JComponent jc = (JComponent)CapabilityWidget.this.capabilityUrls.get(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrls.remove(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrlsReverse.remove(jc);
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(r, "CapabilityWidget addOGCWMSCapabilitiesTree()"));
    }

    public void addOGCCapabilitiesTree(final String link, final JComponent comp, final boolean interactive) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addOGCCapabilitiesTree()");
        }
        Runnable r = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    AbstractCapabilitiesTreeModel capTreeModel;
                    WFSCapabilitiesFactory capFact;
                    final DragTree trvCap = new DragTree();
                    CapabilityWidget.this.addPopupMenu(trvCap);
                    URL getCapURL = new URL(link);
                    URL postURL = link.indexOf(63) > 0 ? new URL(link.substring(0, link.indexOf(63))) : getCapURL;
                    URL finalPostUrl = postURL;
                    DropTarget dt = new DropTarget(trvCap, CapabilityWidget.this.acceptableActions, CapabilityWidget.this.thisWidget);
                    AccessHandler handler = WebAccessManager.getInstance().getHandlerForURL(finalPostUrl);
                    String securedServiceType = ((WSSAccessHandler)handler).getSecuredServiceTypeForURL(finalPostUrl);
                    if (securedServiceType == null) {
                        log.warn((Object)"SecuredServiceType des WSS konnte nicht bestimmt werden");
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SecuredServiceType des WSS konnte bestimmt werden: " + securedServiceType));
                    }
                    if (securedServiceType.equals(WSSAccessHandler.SECURED_SERVICE_TYPE.WFS.toString())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Gesicheter Service ist ein: " + WSSAccessHandler.SECURED_SERVICE_TYPE.WFS));
                            log.debug((Object)("Capability Widget: Creating WFScapabilities for URL: " + finalPostUrl.toString()));
                        }
                        capFact = new WFSCapabilitiesFactory();
                        WFSCapabilities cap = capFact.createCapabilities(link);
                        String name = FeatureServiceUtilities.getServiceName(cap);
                        capTreeModel = new WFSCapabilitiesTreeModel(cap);
                        capTreeModel.setServiceName(name);
                    } else {
                        if (!securedServiceType.equals(WSSAccessHandler.SECURED_SERVICE_TYPE.WMS.toString())) {
                            if (!log.isDebugEnabled()) return;
                            log.debug((Object)"Gesicherter Service ist von unbekanntem Typ.");
                            return;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Gesicheter Service ist ein: " + WSSAccessHandler.SECURED_SERVICE_TYPE.WMS));
                        }
                        try {
                            capFact = new WMSCapabilitiesFactory((CalculationCache)CapabilitiesCache.getInstance());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Capability Widget: Creating WMScapabilities for URL: " + link));
                            }
                            WMSCapabilities capWMS = capFact.createCapabilities(CismapBroker.getInstance().aliasToUrl(link));
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Erstelle WMSCapabilitiesTreeModel");
                            }
                            capTreeModel = new WMSCapabilitiesTreeModel(capWMS);
                            capTreeModel.setServiceName(capWMS.getLayer().getTitle().trim());
                        }
                        catch (Exception ex) {
                            log.error((Object)"Exception during doRequest cause: ", (Throwable)ex);
                            return;
                        }
                    }
                    if (CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp) == -1) {
                        log.info((Object)"Ladepanel ist nicht mehr in TabbedPane --> retrieval wird abgebrochen");
                        LinkWithSubparent link2 = (LinkWithSubparent)CapabilityWidget.this.capabilityUrlsReverse.get(comp);
                        CapabilityWidget.this.capabilityUrls.remove(link2);
                        CapabilityWidget.this.capabilityUrlsReverse.remove(comp);
                        if (CapabilityWidget.this.wmsCapabilities.get(comp) != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Entferne WMSCapabilities-Tree");
                            }
                            CapabilityWidget.this.wmsCapabilities.remove(comp);
                            CapabilityWidget.this.wmsCapabilitiesTrees.remove(comp);
                            EventQueue.invokeLater(new Thread("RemoveOGCCapabilities"){

                                @Override
                                public void run() {
                                    CapabilityWidget.this.tbpCapabilities.remove(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp));
                                }
                            });
                            return;
                        }
                        if (CapabilityWidget.this.wfsCapabilities.get(comp) != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Entferne WFSCapabilities-Tree");
                            }
                            CapabilityWidget.this.wfsCapabilities.remove(comp);
                            CapabilityWidget.this.wfsCapabilitiesTrees.remove(comp);
                            CapabilityWidget.this.tbpCapabilities.remove(comp);
                            return;
                        }
                        if (CapabilityWidget.this.shapeFolderTrees.get(comp) != null) {
                            CapabilityWidget.this.shapeFolderTrees.remove(comp);
                            return;
                        }
                        log.warn((Object)"Keine Component zum entfernen aktiv");
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Capabilitespanel noch vorhanden --> stelle baum dar");
                    }
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            String title;
                            String name = capTreeModel.getServiceName();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("ServiceName: " + name));
                            }
                            trvCap.setModel(capTreeModel);
                            trvCap.setBorder(new EmptyBorder(1, 1, 1, 1));
                            JScrollPane sPane = new JScrollPane();
                            sPane.setViewportView(trvCap);
                            sPane.setBorder(new EmptyBorder(1, 1, 1, 1));
                            StaticSwingTools.setNiftyScrollBars((JScrollPane)sPane);
                            2 var3_3 = this;
                            synchronized (var3_3) {
                                CapabilityWidget.this.tbpCapabilities.setComponentAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), sPane);
                            }
                            if (capTreeModel instanceof WMSCapabilitiesTreeModel) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"WMSTree");
                                }
                                CapabilityWidget.this.wmsCapabilities.put(sPane, ((WMSCapabilitiesTreeModel)capTreeModel).getCapabilities());
                                CapabilityWidget.this.wmsCapabilitiesTrees.put(sPane, trvCap);
                                trvCap.setWmsCapabilities(((WMSCapabilitiesTreeModel)capTreeModel).getCapabilities());
                                trvCap.setCellRenderer(new WMSCapabilitiesTreeCellRenderer());
                                CapabilityWidget.this.stateChanged(null);
                            } else if (capTreeModel instanceof WFSCapabilitiesTreeModel) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"WFSTree");
                                }
                                CapabilityWidget.this.wfsCapabilities.put(sPane, ((WFSCapabilitiesTreeModel)capTreeModel).getCapabilities());
                                CapabilityWidget.this.wfsCapabilitiesTrees.put(sPane, trvCap);
                                trvCap.setCellRenderer(new WFSCapabilitiesTreeCellRenderer(name));
                                CapabilityWidget.this.stateChanged(null);
                            }
                            CapabilityWidget.this.capabilityUrls.put(new LinkWithSubparent(link, null), sPane);
                            CapabilityWidget.this.capabilityUrlsReverse.put(sPane, new LinkWithSubparent(link, null));
                            String titleOrig = title = name;
                            if (title.length() > 0) {
                                if (title.length() > CapabilityWidget.this.maxServerNameLength) {
                                    title = title.substring(0, CapabilityWidget.this.maxServerNameLength - 3) + "...";
                                }
                                sPane.putClientProperty("tabTitle", title);
                                2 var5_6 = this;
                                synchronized (var5_6) {
                                    StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)CapabilityWidget.this.tbpCapabilities, (String)title, (Icon)CapabilityWidget.this.icoConnected, (Color)Color.black, (JComponent)sPane);
                                }
                                var5_6 = this;
                                synchronized (var5_6) {
                                    CapabilityWidget.this.tbpCapabilities.setToolTipTextAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(sPane), titleOrig);
                                }
                                CapabilityWidget.this.stateChanged(null);
                            }
                        }
                    });
                    return;
                }
                catch (Throwable e) {
                    String message = "";
                    CapabilityWidget.this.tbpCapabilities.setIconAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), CapabilityWidget.this.icoError);
                    message = e.getMessage() == null || e.getMessage().equals("null") ? e.getCause().getMessage() : e.getMessage();
                    if (interactive) {
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CapabilityWidget.this.thisWidget), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addOGCCapabilitiesTree(String,JComponent,boolean).JOptionPane.message", (Object[])new Object[]{message}), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addOGCCapabilitiesTree(String,JComponent,boolean).JOptionPane.title"), 0);
                    }
                    log.error((Object)("Error during the loading of the capabilities of the server. " + message), e);
                    EventQueue.invokeLater(new Thread("RemoveOGCFolderCapabilitiesAfterError"){

                        @Override
                        public void run() {
                            CapabilityWidget.this.tbpCapabilities.remove(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp));
                        }
                    });
                    JComponent jc = (JComponent)CapabilityWidget.this.capabilityUrls.get(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrls.remove(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrlsReverse.remove(jc);
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(r, "CapabilityWidget addOGCCapabilitiesTree()"));
    }

    private void addOGCWFSCapabilitiesTree(final String link, final JComponent comp, final boolean interactive) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addOGCWFSCapabilitiesTree()");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    final DragTree trvCap = new DragTree();
                    URL getCapURL = new URL(link);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"try to parse WFSCapabilities");
                    }
                    URL postURL = link.indexOf(63) > 0 ? new URL(link.substring(0, link.indexOf(63))) : getCapURL;
                    URL finalPostUrl = postURL;
                    WFSCapabilitiesFactory capFact = new WFSCapabilitiesFactory();
                    final WFSCapabilities cap = capFact.createCapabilities(link);
                    trvCap.setWfsCapabilities(cap);
                    trvCap.setReverseOrder(CapabilityWidget.this.reverseAxisOrder.contains(link));
                    final String name = FeatureServiceUtilities.getServiceName(cap);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"create WFSCapabilitiesTreeModel");
                    }
                    final WFSCapabilitiesTreeModel tm = new WFSCapabilitiesTreeModel(cap);
                    DropTarget dt = new DropTarget(trvCap, CapabilityWidget.this.acceptableActions, CapabilityWidget.this.thisWidget);
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            String title;
                            CapabilityWidget.this.addPopupMenu(trvCap);
                            trvCap.setModel(tm);
                            trvCap.setBorder(new EmptyBorder(1, 1, 1, 1));
                            trvCap.setCellRenderer(new WFSCapabilitiesTreeCellRenderer(name));
                            JScrollPane sPane = new JScrollPane();
                            sPane.setViewportView(trvCap);
                            sPane.setBorder(new EmptyBorder(1, 1, 1, 1));
                            StaticSwingTools.setNiftyScrollBars((JScrollPane)sPane);
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                CapabilityWidget.this.tbpCapabilities.setComponentAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), sPane);
                            }
                            CapabilityWidget.this.wfsCapabilities.put(sPane, cap);
                            CapabilityWidget.this.wfsCapabilitiesTrees.put(sPane, trvCap);
                            CapabilityWidget.this.stateChanged(null);
                            CapabilityWidget.this.capabilityUrls.put(new LinkWithSubparent(link, null), sPane);
                            CapabilityWidget.this.capabilityUrlsReverse.put(sPane, new LinkWithSubparent(link, null));
                            String titleOrig = title = name;
                            if (title.length() > 0) {
                                if (title.length() > CapabilityWidget.this.maxServerNameLength) {
                                    title = title.substring(0, CapabilityWidget.this.maxServerNameLength - 3) + "...";
                                }
                                sPane.putClientProperty("tabTitle", title);
                                1 var4_5 = this;
                                synchronized (var4_5) {
                                    StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)CapabilityWidget.this.tbpCapabilities, (String)title, (Icon)CapabilityWidget.this.icoConnected, (Color)Color.black, (JComponent)sPane);
                                }
                                var4_5 = this;
                                synchronized (var4_5) {
                                    CapabilityWidget.this.tbpCapabilities.setToolTipTextAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(sPane), titleOrig);
                                }
                                CapabilityWidget.this.stateChanged(null);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    String message = "";
                    CapabilityWidget.this.tbpCapabilities.setIconAt(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp), CapabilityWidget.this.icoError);
                    if (e.getMessage() == null || e.getMessage().equals("null")) {
                        if (e.getCause() != null) {
                            message = e.getCause().getMessage();
                        }
                    } else {
                        message = e.getMessage();
                    }
                    if (interactive) {
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CapabilityWidget.this.thisWidget), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addOGCWFSCapabilitiesTree(String,JComponent,boolean).JOptionPane.message", (Object[])new Object[]{message}), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addOGCWFSCapabilitiesTree(String,JComponent,boolean).JOptionPane.title"), 0);
                    }
                    log.error((Object)("Loading of the server capabilities failed. " + message), e);
                    EventQueue.invokeLater(new Thread("RemoveWFSCapabilitiesAfterError"){

                        @Override
                        public void run() {
                            CapabilityWidget.this.tbpCapabilities.remove(CapabilityWidget.this.tbpCapabilities.indexOfComponent(comp));
                        }
                    });
                    JComponent jc = (JComponent)CapabilityWidget.this.capabilityUrls.get(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrls.remove(new LinkWithSubparent(link, null));
                    CapabilityWidget.this.capabilityUrlsReverse.remove(jc);
                }
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(r, "CapabilityWidget addOGCWFSCapabilitiesTree()"));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String t2;
        if (this.selectedIndex > -1) {
            try {
                this.tbpCapabilities.setForegroundAt(this.selectedIndex, null);
                t2 = (String)((JComponent)this.tbpCapabilities.getComponentAt(this.selectedIndex)).getClientProperty("tabTitle");
                if (t2 == null) {
                    t2 = "";
                }
                StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)this.tbpCapabilities, (String)t2, (Icon)this.icoConnected, (Color)Color.black, (JComponent)((JComponent)this.tbpCapabilities.getComponentAt(this.selectedIndex)));
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        this.selectedIndex = this.tbpCapabilities.getSelectedIndex();
        if (this.selectedIndex > -1) {
            t2 = (String)((JComponent)this.tbpCapabilities.getComponentAt(this.selectedIndex)).getClientProperty("tabTitle");
            if (t2 == null) {
                t2 = "";
            }
            this.tbpCapabilities.setForegroundAt(this.selectedIndex, Color.blue);
            StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText((JTabbedPane)this.tbpCapabilities, (String)t2, (Icon)this.icoConnected, (Color)Color.blue, (JComponent)((JComponent)this.tbpCapabilities.getComponentAt(this.selectedIndex)));
        }
        if (this.wmsCapabilities.get(this.tbpCapabilities.getSelectedComponent()) != null) {
            CismapBroker.getInstance().fireCapabilityServerChanged(new CapabilityEvent(this.wmsCapabilities.get(this.tbpCapabilities.getSelectedComponent())));
        } else if (this.wfsCapabilities.get(this.tbpCapabilities.getSelectedComponent()) != null) {
            CismapBroker.getInstance().fireCapabilityServerChanged(new CapabilityEvent(this.wfsCapabilities.get(this.tbpCapabilities.getSelectedComponent())));
        } else if (log.isDebugEnabled()) {
            log.debug(this.wmsCapabilities);
            log.debug(this.wfsCapabilities);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.error((Object)e);
    }

    public Element getConfiguration() {
        Element ret = new Element("cismapCapabilitiesPreferences");
        Set<LinkWithSubparent> wmsCapabilitiesSet = this.capabilityUrls.keySet();
        Iterator<LinkWithSubparent> it = wmsCapabilitiesSet.iterator();
        LinkWithSubparent selectedLink = this.capabilityUrlsReverse.get(this.tbpCapabilities.getSelectedComponent());
        while (it.hasNext()) {
            LinkWithSubparent link = it.next();
            String linkText = link.getLink();
            if (link.getService() != null) {
                linkText = linkText.contains("?") ? linkText + "&SERVICE=" + link.getService() : linkText + "?SERVICE=" + link.getService();
            }
            CapabilityLink cl = new CapabilityLink("OGC", linkText, this.reverseAxisOrder.contains(link.getLink()), link.equals(selectedLink), link.getSubparent(), link.getAlias());
            ret.addContent((Content)cl.getElement());
        }
        ret.setAttribute(new Attribute("searchPanelActivated", String.valueOf(this.isSearchEnabled())));
        return ret;
    }

    public void masterConfigure(Element e) {
        this.serverElement = e;
    }

    public void configure(Element e) {
        this.configure(e, false);
    }

    public void configure(Element e, boolean merge) {
        if (!merge) {
            this.preferences = new CapabilitiesPreferences(this.serverElement, e);
            this.configure(this.preferences, merge);
        } else {
            this.configure(new CapabilitiesPreferences(this.serverElement, e), merge);
        }
    }

    public void configure(CapabilitiesPreferences cp, boolean merge) {
        if (!merge) {
            this.removeAllServer();
        }
        Iterator<Integer> it = cp.getCapabilities().keySet().iterator();
        LinkWithSubparent activeLink = null;
        while (it.hasNext()) {
            Integer i = it.next();
            CapabilityLink cl = cp.getCapabilities().get(i);
            LinkWithSubparent link = new LinkWithSubparent(cl.getLink(), cl.getSubparent());
            if ((cl.getType().equals("OGC") || cl.getType().equals("OGC-WMS") || cl.getType().equals("cidsLayer") || cl.getType().equals("INTERNAL-DB")) && (!merge || this.capabilityUrls.get(new LinkWithSubparent(link.getLink(), link.getSubparent())) == null)) {
                this.addLinkManually(link);
            }
            if (!cl.isActive()) continue;
            activeLink = link;
        }
        if (activeLink != null && !merge) {
            final LinkWithSubparent componentToSelect = activeLink;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CapabilityWidget.this.tbpCapabilities.setSelectedComponent((Component)CapabilityWidget.this.capabilityUrls.get(componentToSelect));
                }
            });
        }
        if (!merge) {
            this.capabilityList.removeAll();
            JMenu menu = this.createCapabilitiesListSubmenu(cp.getCapabilitiesListTree());
            for (Component component : menu.getMenuComponents()) {
                this.capabilityList.add(component);
            }
            if (!merge) {
                this.setSearchEnabled(cp.isSearchActivated());
            }
        }
    }

    private JMenu createCapabilitiesListSubmenu(CapabilitiesListTreeNode node) {
        JMenu menu = new JMenu(node.getTitle());
        for (CapabilitiesListTreeNode subnode : node.getSubnodes()) {
            menu.add(this.createCapabilitiesListSubmenu(subnode));
        }
        for (final CapabilityLink cl : node.getCapabilitiesList().values()) {
            if (cl.getType().equals("OGC") || cl.getType().equals("OGC-WMS") || cl.getType().equals("cidsLayer") || cl.getType().equals("INTERNAL-DB")) {
                ListMenuItem lmi = new ListMenuItem("test", cl);
                if (cl.isReverseAxisOrder()) {
                    this.reverseAxisOrder.add(cl.getLink());
                }
                lmi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CapabilityWidget.this.addLinkManually(new LinkWithSubparent(cl.getLink(), cl.getSubparent()));
                    }
                });
                menu.add(lmi);
                continue;
            }
            if (!cl.getType().equals("SEPARATOR")) continue;
            menu.addSeparator();
        }
        return menu;
    }

    public void removeAllServer() {
        int mx = this.tbpCapabilities.getTabCount();
        for (int i = 0; i < mx; ++i) {
            this.removeActiveCapabilityTree();
        }
    }

    private void addSubmenuToMenu(final CapabilityLink cl) {
        ListMenuItem lmi = new ListMenuItem("test", cl);
        lmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CapabilityWidget.this.addLinkManually(new LinkWithSubparent(cl.getLink(), cl.getSubparent()));
            }
        });
        this.capabilityList.add(lmi);
    }

    @Override
    public void shownMapBoundsChanged() {
        JTree t = this.getActiveTree();
        if (t != null) {
            t.repaint();
        }
    }

    private void addPopupMenu(JTree trvCap) {
        trvCap.addMouseListener((MouseListener)new DefaultPopupMenuListener(this.treePopMenu));
        this.treePopMenu.addPopupMenuListener(new PopupMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object object = CapabilityWidget.this.treePopMenu.getTreeLock();
                synchronized (object) {
                    if (CapabilityWidget.this.treePopMenu.getInvoker() instanceof JTree) {
                        TreePath[] paths = ((JTree)CapabilityWidget.this.treePopMenu.getInvoker()).getSelectionPaths();
                        Component c = CapabilityWidget.this.treePopMenu.getComponent(0);
                        if (c instanceof JMenuItem) {
                            JMenuItem item = (JMenuItem)c;
                            item.setEnabled(true);
                            if (paths != null && paths.length == 1) {
                                if (paths[0].getLastPathComponent() instanceof TreeFolder || paths[0].getLastPathComponent() instanceof String) {
                                    item.setText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.addPopupMenu.popupMenuWillBecomeVisible"));
                                } else {
                                    Layer l;
                                    String abstr;
                                    item.setText(NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.CapabilityWidget().pmenuItem.text"));
                                    if (paths[0].getLastPathComponent() instanceof Layer && (abstr = (l = (Layer)paths[0].getLastPathComponent()).getAbstract()) != null && abstr.contains(CapabilityWidget.MASSSTABSBEGRENZUNG)) {
                                        item.setEnabled(false);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void addPopupMenu(JTree trvCap, JMenuItem[] additionalItems) {
        if (additionalItems == null || additionalItems.length == 0) {
            trvCap.addMouseListener((MouseListener)new DefaultPopupMenuListener(this.treePopMenu));
        } else {
            JPopupMenu menu = new JPopupMenu();
            for (int i = 0; i < this.treePopMenu.getComponentCount(); ++i) {
                Component c = this.treePopMenu.getComponent(i);
                if (!(c instanceof JMenuItem)) continue;
                menu.add(new JMenuItem(((JMenuItem)c).getAction()));
            }
            for (JMenuItem item : additionalItems) {
                menu.add(item);
            }
            trvCap.addMouseListener((MouseListener)new DefaultPopupMenuListener(menu));
        }
    }

    private void zoomToExtent(DragTree currentTrvCap) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"zoom to extent.");
        }
        if (currentTrvCap != null) {
            TreePath[] paths;
            String currentCrs = CismapBroker.getInstance().getSrs().getCode();
            WMSCapabilities wmsCap = currentTrvCap.getWmsCapabilities();
            Geometry bestGeom = null;
            if (wmsCap != null) {
                for (TreePath tp : paths = currentTrvCap.getSelectionPaths()) {
                    de.cismet.commons.wms.capabilities.Envelope e = null;
                    if (tp != null && tp.getLastPathComponent() instanceof Layer) {
                        e = CapabilityWidget.getEnvelopeForWmsLayer((Layer)tp.getLastPathComponent());
                    }
                    if (e == null) {
                        e = CapabilityWidget.getEnvelopeForWmsCaps(wmsCap);
                    }
                    if (e == null) continue;
                    bestGeom = bestGeom == null ? CapabilityWidget.createGeometryFromEnvelope(e) : bestGeom.union(CapabilityWidget.createGeometryFromEnvelope(e));
                }
            } else if (currentTrvCap.getWfsCapabilities() != null) {
                for (TreePath tp : paths = currentTrvCap.getSelectionPaths()) {
                    de.cismet.commons.wms.capabilities.Envelope e = null;
                    FeatureType selectedFeature = null;
                    if (tp != null && tp.getLastPathComponent() instanceof FeatureType) {
                        selectedFeature = (FeatureType)tp.getLastPathComponent();
                    } else {
                        try {
                            Iterator<FeatureType> it = currentTrvCap.getWfsCapabilities().getFeatureTypeList().iterator();
                            if (it.hasNext()) {
                                selectedFeature = it.next();
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)"Cannot receive the feature type list from the capabilities document", (Throwable)ex);
                        }
                    }
                    if (selectedFeature != null) {
                        e = CapabilityWidget.getEnvelopeFromFeatureType(selectedFeature);
                    }
                    if (e == null) continue;
                    if (bestGeom == null) {
                        bestGeom = CapabilityWidget.createGeometryFromEnvelope(e);
                        continue;
                    }
                    Geometry additionalGeom = CapabilityWidget.createGeometryFromEnvelope(e);
                    if (bestGeom.getSRID() != additionalGeom.getSRID()) {
                        additionalGeom = CrsTransformer.transformToGivenCrs(additionalGeom, CrsTransformer.createCrsFromSrid(bestGeom.getSRID()));
                    }
                    bestGeom = bestGeom.union(additionalGeom);
                }
            }
            if (bestGeom == null) {
                log.warn((Object)"no envelope found in the capabilities document");
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.thisWidget), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.zoomToExtent().JOptionPane.msg"), NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.zoomToExtent().JOptionPane.title"), 0);
            }
            if (bestGeom != null) {
                Geometry env = CrsTransformer.transformToCurrentCrs(bestGeom);
                XBoundingBox bb = new XBoundingBox(env);
                if (bb != null) {
                    CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory(bb);
                } else {
                    log.warn((Object)"no valid bounding box found.");
                }
            }
        }
    }

    public static de.cismet.commons.wms.capabilities.Envelope getEnvelopeForWmsLayer(Layer l) {
        de.cismet.commons.wms.capabilities.Envelope bestEnvelope = null;
        LayerBoundingBox[] boxes = l.getBoundingBoxes();
        String currentCrs = CismapBroker.getInstance().getSrs().getCode();
        if (boxes != null) {
            for (LayerBoundingBox tmp : boxes) {
                if (!tmp.getSRS().equals(currentCrs)) continue;
                bestEnvelope = tmp;
                break;
            }
        }
        if (bestEnvelope == null) {
            if (l.getLatLonBoundingBoxes() != null) {
                bestEnvelope = l.getLatLonBoundingBoxes();
            } else if (boxes != null && boxes.length > 0) {
                bestEnvelope = boxes[0];
            }
        }
        return bestEnvelope;
    }

    public static de.cismet.commons.wms.capabilities.Envelope getEnvelopeForWmsCaps(WMSCapabilities caps) {
        de.cismet.commons.wms.capabilities.Envelope bestEnvelope = null;
        if (caps != null) {
            LayerBoundingBox[] boxes = caps.getLayer().getBoundingBoxes();
            String currentCrs = CismapBroker.getInstance().getSrs().getCode();
            if (boxes != null) {
                for (LayerBoundingBox tmp : boxes) {
                    if (!tmp.getSRS().equals(currentCrs)) continue;
                    bestEnvelope = tmp;
                }
            }
            if (bestEnvelope == null) {
                if (caps.getLayer().getLatLonBoundingBoxes() != null) {
                    bestEnvelope = caps.getLayer().getLatLonBoundingBoxes();
                } else if (boxes != null && boxes.length > 0) {
                    bestEnvelope = boxes[0];
                }
            }
        }
        return bestEnvelope;
    }

    public static de.cismet.commons.wms.capabilities.Envelope getEnvelopeFromFeatureType(FeatureType feature) {
        de.cismet.commons.wms.capabilities.Envelope[] envs;
        de.cismet.commons.wms.capabilities.Envelope bestEnvelope = null;
        if (feature != null && (envs = feature.getWgs84BoundingBoxes()) != null && envs.length > 0) {
            bestEnvelope = envs[0];
        }
        return bestEnvelope;
    }

    public static Geometry createGeometryFromEnvelope(de.cismet.commons.wms.capabilities.Envelope env) {
        double x1 = env.getMin().getX();
        double x2 = env.getMax().getX();
        double y1 = env.getMin().getY();
        double y2 = env.getMax().getY();
        CoordinateSystem cs = env.getCoordinateSystem();
        String crs = null;
        if (cs != null) {
            crs = cs.getIdentifier();
        } else if (env instanceof LayerBoundingBox) {
            crs = ((LayerBoundingBox)env).getSRS();
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(crs));
        Envelope envelope = new Envelope(x1, x2, y1, y2);
        return factory.toGeometry(envelope);
    }

    public void setSearchEnabled(boolean enabled) {
        this.txtSearch.setVisible(enabled);
        if (!enabled) {
            this.txtSearch.setText("");
        }
    }

    public boolean isSearchEnabled() {
        return this.txtSearch.isVisible();
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public String getViewTitle() {
        return NbBundle.getMessage(CapabilityWidget.class, (String)"CapabilityWidget.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/server.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }

    class LinkWithSubparent {
        String link = null;
        String subparent = null;
        String service = null;
        String alias = null;

        public LinkWithSubparent(String link, String subparent) {
            this.link = link;
            this.subparent = subparent;
            this.alias = CismapBroker.getInstance().urlToAlias(link);
        }

        public String getLink() {
            if (this.alias != null && CismapBroker.getInstance().isAlias(this.alias)) {
                return CismapBroker.getInstance().aliasToUrl(this.alias);
            }
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getSubparent() {
            return this.subparent;
        }

        public void setSubparent(String subparent) {
            this.subparent = subparent;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LinkWithSubparent) {
                LinkWithSubparent tester = (LinkWithSubparent)obj;
                String t = tester.link + tester.subparent;
                String thisT = this.link + this.subparent;
                return t.equals(thisT);
            }
            return false;
        }

        public int hashCode() {
            String t = this.link + this.subparent;
            return t.hashCode();
        }
    }

    class DefaultTransferable
    implements Transferable {
        private DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "SelectionAndCapabilities");
        private Object o;

        public DefaultTransferable(Object o) {
            this.o = o;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.match(this.TREEPATH_FLAVOR);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.match(this.TREEPATH_FLAVOR)) {
                return this.o;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] ar = new DataFlavor[]{this.TREEPATH_FLAVOR};
            return ar;
        }
    }

    class DragTree
    extends JTree
    implements DragGestureListener,
    DragSourceListener {
        DragSource dragSource = DragSource.getDefaultDragSource();
        TreePath[] cachedTreePaths;
        private TreePath[] lastCachedTreePaths;
        private boolean autoSelection = false;
        private boolean valueChanged = false;
        private WMSCapabilities wmsCapabilities;
        private WFSCapabilities wfsCapabilities;
        private boolean reverseOrder;

        public DragTree() {
            this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!DragTree.this.valueChanged) {
                        DragTree.access$3802(DragTree.this, DragTree.this.cachedTreePaths);
                    }
                    DragTree.this.valueChanged = false;
                }
            });
            this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    if (DragTree.this.autoSelection) {
                        return;
                    }
                    ArrayList<TreePath> path = new ArrayList<TreePath>();
                    DragTree.this.valueChanged = true;
                    if (DragTree.this.cachedTreePaths != null) {
                        path.addAll(Arrays.asList(DragTree.this.cachedTreePaths));
                    }
                    for (TreePath tmpPath : e.getPaths()) {
                        if (e.isAddedPath(tmpPath)) {
                            path.add(tmpPath);
                            continue;
                        }
                        path.remove(tmpPath);
                    }
                    DragTree.access$3802(DragTree.this, DragTree.this.cachedTreePaths);
                    DragTree.this.cachedTreePaths = path.toArray(new TreePath[path.size()]);
                }
            });
            this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    if (DragTree.this.getSelectionPath() != null && (DragTree.this.getSelectionPath().getLastPathComponent() instanceof Layer || DragTree.this.getSelectionPath().getLastPathComponent() instanceof Element || DragTree.this.getSelectionPath().getLastPathComponent() instanceof FeatureType || DragTree.this.getSelectionPath().getLastPathComponent() instanceof File)) {
                        CismapBroker.getInstance().fireCapabilityLayerChanged(new CapabilityEvent(DragTree.this.getSelectionPath().getLastPathComponent()));
                    } else if (DragTree.this.getSelectionPath() != null) {
                        log.warn((Object)("getSelectionPath().getLastPathComponent()=" + DragTree.this.getSelectionPath().getLastPathComponent()));
                    }
                }
            });
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            this.getSelectionModel().setSelectionPaths(this.cachedTreePaths);
            TreePath selPath = this.getPathForLocation((int)e.getDragOrigin().getX(), (int)e.getDragOrigin().getY());
            this.autoSelection = true;
            int n = e.getTriggerEvent().getModifiers();
            e.getTriggerEvent();
            if ((n & 2) != 0) {
                this.getSelectionModel().setSelectionPaths(this.cachedTreePaths);
                this.getSelectionModel().addSelectionPath(selPath);
                this.cachedTreePaths = this.getSelectionModel().getSelectionPaths();
            } else {
                int n2 = e.getTriggerEvent().getModifiers();
                e.getTriggerEvent();
                if ((n2 & 1) != 0) {
                    this.getSelectionModel().addSelectionPaths(this.cachedTreePaths);
                    this.cachedTreePaths = this.getSelectionModel().getSelectionPaths();
                } else if (this.contains(this.lastCachedTreePaths, selPath)) {
                    this.getSelectionModel().setSelectionPaths(this.lastCachedTreePaths);
                    this.cachedTreePaths = this.lastCachedTreePaths;
                }
            }
            this.autoSelection = false;
            DefaultTransferable trans = null;
            if (this.getModel() instanceof WMSCapabilitiesTreeModel) {
                trans = new DefaultTransferable(new SelectionAndCapabilities(this.getSelectionModel().getSelectionPaths(), this.wmsCapabilities, ((LinkWithSubparent)CapabilityWidget.this.capabilityUrlsReverse.get(CapabilityWidget.this.tbpCapabilities.getSelectedComponent())).getLink()));
            } else if (this.getModel() instanceof WFSCapabilitiesTreeModel) {
                WFSCapabilitiesTreeModel model = (WFSCapabilitiesTreeModel)this.getModel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"create Transferable for WFS");
                }
                if (this.getSelectionModel().getSelectionPath().getLastPathComponent() instanceof FeatureType) {
                    TreePath[] paths = this.getSelectionModel().getSelectionPaths();
                    FeatureType[] features = new FeatureType[paths.length];
                    for (int i = 0; i < paths.length; ++i) {
                        features[i] = (FeatureType)paths[i].getLastPathComponent();
                    }
                    trans = new DefaultTransferable(new WFSSelectionAndCapabilities(features, this.reverseOrder));
                }
            } else if (this.getModel() instanceof ShapeFolderTreeModel) {
                TreePath[] paths = this.getSelectionModel().getSelectionPaths();
                ArrayList<File> files = new ArrayList<File>();
                for (TreePath path : paths) {
                    Object o = path.getLastPathComponent();
                    if (!(o instanceof File) || ((File)o).isDirectory()) continue;
                    files.add((File)o);
                }
                if (files.isEmpty()) {
                    return;
                }
                trans = new DefaultTransferable(files.toArray(new File[files.size()]));
            } else if (this.getModel().getClass().getName().equals("de.cismet.cismap.cidslayer.CidsLayerTreeModel")) {
                TreePath[] paths;
                ArrayList<CidsLayerTransferable> objects = new ArrayList<CidsLayerTransferable>();
                for (TreePath path : paths = this.getSelectionModel().getSelectionPaths()) {
                    Object o = path.getLastPathComponent();
                    if (o instanceof LayerConfig) {
                        objects.add(new CidsLayerTransferable((LayerConfig)o));
                        continue;
                    }
                    if (!(o instanceof TreeFolder)) continue;
                    objects.add(new CidsLayerTransferable((TreeFolder)o));
                }
                trans = new DefaultTransferable(objects.toArray(new CidsLayerTransferable[objects.size()]));
            }
            this.dragSource.startDrag(e, DragSource.DefaultCopyDrop, trans, this);
        }

        private boolean contains(TreePath[] list, TreePath path) {
            if (list == null) {
                return false;
            }
            for (TreePath tmpPath : list) {
                if (!tmpPath.equals(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }

        public WMSCapabilities getWmsCapabilities() {
            return this.wmsCapabilities;
        }

        public void setWmsCapabilities(WMSCapabilities wmsCapabilities) {
            this.wmsCapabilities = wmsCapabilities;
        }

        public WFSCapabilities getWfsCapabilities() {
            return this.wfsCapabilities;
        }

        public void setWfsCapabilities(WFSCapabilities wfsCapabilities) {
            this.wfsCapabilities = wfsCapabilities;
        }

        public void setReverseOrder(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        static /* synthetic */ TreePath[] access$3802(DragTree x0, TreePath[] x1) {
            x0.lastCachedTreePaths = x1;
            return x1;
        }
    }

    class ListMenuItem
    extends JMenuItem {
        private CapabilityLink capabilityLink;

        public ListMenuItem(String label, CapabilityLink cl) {
            super(cl.getTitle());
            this.capabilityLink = cl;
        }

        public CapabilityLink getCapabilityLink() {
            return this.capabilityLink;
        }

        public void setCapabilityLink(CapabilityLink capabilityLink) {
            this.capabilityLink = capabilityLink;
        }
    }
}

