/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.capabilitywidget;

import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import java.util.Vector;
import org.jdom.Element;

public class WFSSelectionAndCapabilities {
    private FeatureType feature;
    private FeatureType[] features;
    private boolean reverseAxisOrder = false;

    public WFSSelectionAndCapabilities(FeatureType feature) {
        this.feature = feature;
    }

    public WFSSelectionAndCapabilities(FeatureType[] features, boolean reverseAxisOrder) {
        this.features = features;
        this.reverseAxisOrder = reverseAxisOrder;
    }

    public FeatureType[] getFeatures() {
        return this.features;
    }

    public String getName() {
        if (this.feature != null) {
            return this.feature.getPrefixedNameString();
        }
        return this.getFeatures()[0].getPrefixedNameString();
    }

    public String getHost() {
        if (this.feature != null) {
            return this.feature.getWFSCapabilities().getURL().toString();
        }
        return this.getFeatures()[0].getWFSCapabilities().getURL().toString();
    }

    public Element getQuery() {
        if (this.feature != null) {
            return this.feature.getWFSQuery();
        }
        return this.getFeatures()[0].getWFSQuery();
    }

    public String getIdentifier() {
        return "";
    }

    public FeatureType getFeature() {
        if (this.feature != null) {
            return this.feature;
        }
        return this.getFeatures()[0];
    }

    public Vector<FeatureServiceAttribute> getAttributes() {
        if (this.feature != null) {
            return this.feature.getFeatureAttributes();
        }
        return this.getFeatures()[0].getFeatureAttributes();
    }

    public boolean isReverseAxisOrder() {
        return this.reverseAxisOrder;
    }

    public void setReverseAxisOrder(boolean reversedAxisOrder) {
        this.reverseAxisOrder = reversedAxisOrder;
    }
}

