/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.featureinfopanel;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.features.PermissionProvider;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.WMSFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockerFactory;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockingInterface;
import de.cismet.cismap.commons.gui.attributetable.LockAlreadyExistsException;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanelEvent;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanelListener;
import de.cismet.cismap.commons.gui.featureinfopanel.FeaturePanelAttributeSource;
import de.cismet.cismap.commons.gui.featureinfopanel.WMSGetFeatureInfoDescription;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoWidget;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerCombobox;
import de.cismet.cismap.commons.gui.layerwidget.LayerFilter;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToFeaturesWorker;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.GetFeatureInfoListener;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.GetFeatureInfoEvent;
import de.cismet.cismap.commons.interaction.events.MapClickedEvent;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.tools.gui.CellSpecificRenderedTable;
import de.cismet.tools.gui.DefaultPopupMenuListener;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.log4j.Logger;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.JTSAdapter;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.openide.util.NbBundle;

public class FeatureInfoPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(FeatureInfoPanel.class);
    private static final String REPORT_URL = "/de/cismet/cismap/commons/gui/featureinfopanel/InfoTableTemplate.jasper";
    private ActiveLayerModel layerModel;
    private MappingComponent mappingComonent;
    private ThemeLayerWidget themeLayerWidget;
    private LayerFilterTreeModel model;
    private FeatureInfoWidget featureInfo;
    private DefaultPopupMenuListener popupMenuListener;
    private List<FeatureServiceFeature> lockedFeatures = new ArrayList<FeatureServiceFeature>();
    private AttribueTableModel currentTableModel;
    private Map<Feature, Object> lockMap = new HashMap<Feature, Object>();
    private TreeSet<DefaultFeatureServiceFeature> modifiedFeature = new TreeSet();
    private List<FeatureInfoPanelListener> featureInfoPanelListeners = new ArrayList<FeatureInfoPanelListener>();
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTree jtFeatures;
    private LayerCombobox layerCombobox1;
    private JMenuItem miDelete;
    private JMenuItem miEdit;
    private JMenuItem miPrint;
    private JMenuItem miZoom;
    private JPopupMenu popupMenu;
    private JScrollPane sbAttributes;
    private JXTable tabAttributes;

    public FeatureInfoPanel() {
        this(null, null);
    }

    public FeatureInfoPanel(MappingComponent mappingComonent, ThemeLayerWidget themeLayerWidget) {
        this.layerModel = (ActiveLayerModel)mappingComonent.getMappingModel();
        this.mappingComonent = mappingComonent;
        this.themeLayerWidget = themeLayerWidget;
        this.initComponents();
        this.popupMenuListener = new DefaultPopupMenuListener(this.popupMenu);
        this.jtFeatures.addMouseListener((MouseListener)this.popupMenuListener);
        this.featureInfo = new FeatureInfoWidget();
        this.jtFeatures.getSelectionModel().setSelectionMode(1);
        this.jtFeatures.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (c instanceof JLabel) {
                    JLabel cl = (JLabel)c;
                    JLabel lab = new JLabel(cl.getText(), cl.getIcon(), cl.getHorizontalAlignment());
                    lab.setBackground(cl.getBackground());
                    lab.setBorder(cl.getBorder());
                    lab.setForeground(cl.getForeground());
                    if (sel) {
                        lab.setBackground(this.backgroundSelectionColor);
                        lab.setOpaque(true);
                    }
                    if (value instanceof MapService || value.equals(FeatureInfoPanel.this.jtFeatures.getModel().getRoot())) {
                        if (expanded) {
                            lab.setIcon(this.openIcon);
                        } else {
                            lab.setIcon(this.closedIcon);
                        }
                    } else if (value instanceof WMSGetFeatureInfoDescription || value instanceof WMSFeature) {
                        lab.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerOverlaywms.png")));
                    } else if (value instanceof DefaultFeatureServiceFeature) {
                        DefaultFeatureServiceFeature f = (DefaultFeatureServiceFeature)value;
                        lab.setIcon(f.getLayerProperties().getFeatureService().getLayerIcon(0));
                        if (f.isEditable()) {
                            Font boldFont = lab.getFont().deriveFont(1);
                            lab.setFont(boldFont);
                        } else {
                            Font plainFont = lab.getFont().deriveFont(0);
                            lab.setFont(plainFont);
                        }
                    }
                    return lab;
                }
                c.setBackground(this.backgroundSelectionColor);
                return c;
            }
        });
        this.model = new LayerFilterTreeModel(this.layerModel, mappingComonent);
        this.model.setLayerFilter((LayerFilter)this.layerCombobox1.getSelectedItem());
        this.layerCombobox1.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FeatureInfoPanel.this.expandAll(new TreePath(FeatureInfoPanel.this.model.getRoot()));
            }
        });
        this.jtFeatures.setModel(this.model);
        mappingComonent.addGetFeatureInfoListener(new GetFeatureInfoListener(){

            @Override
            public void getFeatureInfoRequest(GetFeatureInfoEvent evt) {
                boolean successful = FeatureInfoPanel.this.contentChanged();
                if (successful) {
                    FeatureInfoPanel.this.model.init(evt.getFeatures());
                    FeatureInfoPanel.this.expandAll(new TreePath(FeatureInfoPanel.this.model.getRoot()));
                }
            }
        });
        this.tabAttributes.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (FeatureInfoPanel.this.currentTableModel == null) {
                    return;
                }
                int col = FeatureInfoPanel.this.tabAttributes.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                col = FeatureInfoPanel.this.tabAttributes.convertColumnIndexToModel(col);
                FeatureServiceFeature fsf = FeatureInfoPanel.this.currentTableModel.getFeature();
                if (fsf != null && !fsf.isEditable() && col == 1 && FeatureInfoPanel.this.currentTableModel.tableRuleSet != null) {
                    int row = FeatureInfoPanel.this.tabAttributes.rowAtPoint(e.getPoint());
                    row = FeatureInfoPanel.this.tabAttributes.convertRowIndexToModel(row);
                    Object value = FeatureInfoPanel.this.currentTableModel.getValueAt(row, col);
                    String columnName = FeatureInfoPanel.this.currentTableModel.getAttributeNameForRow(row);
                    FeatureInfoPanel.this.currentTableModel.tableRuleSet.mouseClicked(fsf, columnName, value, e.getClickCount());
                }
            }
        });
    }

    private void expandAll(TreePath parent) {
        Object lastComponent = parent.getLastPathComponent();
        int childCount = this.model.getChildCount(lastComponent);
        this.jtFeatures.expandPath(parent);
        for (int i = 0; i < childCount; ++i) {
            if (this.model.isLeaf(this.model.getChild(lastComponent, i))) continue;
            TreePath newPath = parent.pathByAddingChild(this.model.getChild(lastComponent, i));
            this.expandAll(newPath);
        }
    }

    public void showAllFeatures() {
        for (int i = 0; i < this.layerCombobox1.getItemCount(); ++i) {
            if (!this.layerCombobox1.getItemAt(i).getClass().getName().endsWith("AllLayersFilter")) continue;
            this.layerCombobox1.setSelectedIndex(i);
            break;
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.miZoom = new JMenuItem();
        this.miPrint = new JMenuItem();
        this.miDelete = new JMenuItem();
        this.miEdit = new JMenuItem();
        this.layerCombobox1 = new LayerCombobox(this.layerModel, this.themeLayerWidget);
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jtFeatures = new JTree();
        this.sbAttributes = new JScrollPane();
        this.tabAttributes = new CellSpecificRenderedTable();
        this.miZoom.setText(NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miZoom.text"));
        this.miZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureInfoPanel.this.miZoomActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.miZoom);
        this.miPrint.setText(NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miPrint.text"));
        this.miPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureInfoPanel.this.miPrintActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.miPrint);
        this.miDelete.setText(NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miDelete.text"));
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureInfoPanel.this.miDeleteActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.miDelete);
        this.miEdit.setText(NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miEdit.text"));
        this.miEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureInfoPanel.this.miEditActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.miEdit);
        this.setLayout(new GridBagLayout());
        this.layerCombobox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FeatureInfoPanel.this.layerCombobox1ItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        this.add((Component)this.layerCombobox1, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 15);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jtFeatures.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                FeatureInfoPanel.this.jtFeaturesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jtFeatures);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.sbAttributes.setViewportView((Component)this.tabAttributes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.sbAttributes, gridBagConstraints);
    }

    private void layerCombobox1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.model != null) {
            this.model.setLayerFilter((LayerFilter)evt.getItem());
            this.expandAll(new TreePath(this.model.getRoot()));
        }
    }

    private void jtFeaturesValueChanged(TreeSelectionEvent evt) {
        TreePath tp = this.jtFeatures.getSelectionPath();
        this.createPopupMenu();
        if (tp == null) {
            this.tabAttributes.setModel((TableModel)new DefaultTableModel(0, 0));
            return;
        }
        Object selectedComp = tp.getLastPathComponent();
        if (selectedComp instanceof DefaultFeatureServiceFeature) {
            DefaultFeatureServiceFeature selectedFeature = (DefaultFeatureServiceFeature)selectedComp;
            this.currentTableModel = new AttribueTableModel(selectedFeature);
            this.tabAttributes.setModel((TableModel)this.currentTableModel);
            this.enableAttributeTable(true);
            Geometry highlightingGeometry = selectedFeature.getGeometry();
            if (highlightingGeometry.getCoordinates().length > 25000) {
                highlightingGeometry = TopologyPreservingSimplifier.simplify((Geometry)highlightingGeometry, (double)30.0);
            }
            PureNewFeature highligtingFeature = new PureNewFeature(highlightingGeometry){

                @Override
                public Stroke getLineStyle() {
                    return new CustomFixedWidthStroke(3.0f);
                }
            };
            highligtingFeature.setFillingPaint(Color.decode("#EEC506"));
            this.mappingComonent.highlightFeature(highligtingFeature, 1500, Color.RED);
        } else if (selectedComp instanceof WMSGetFeatureInfoDescription) {
            this.enableAttributeTable(false);
            WMSGetFeatureInfoDescription description = (WMSGetFeatureInfoDescription)selectedComp;
            ActiveLayerEvent e = new ActiveLayerEvent();
            this.mappingComonent.highlightFeature(description, 1500);
            description.getLayer().setLayerQuerySelected(true);
            e.setLayer(description.getLayer());
            this.featureInfo.layerAdded(e);
            this.featureInfo.clickedOnMap(new MapClickedEvent("FEATURE_INFO_CLICK", description.getpInputEvent()));
        } else {
            this.enableAttributeTable(true);
            this.tabAttributes.setModel((TableModel)new DefaultTableModel(0, 0));
        }
    }

    private void miZoomActionPerformed(ActionEvent evt) {
        TreePath[] tps = this.jtFeatures.getSelectionPaths();
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        for (TreePath tp : tps) {
            Object o = tp.getLastPathComponent();
            if (o instanceof Feature) {
                Feature fsf = (Feature)o;
                featureList.add(fsf);
                continue;
            }
            if (!(o instanceof MapService)) continue;
            for (int i = 0; i < this.model.getChildCount(o); ++i) {
                Object featureObject = this.model.getChild(o, i);
                if (!(featureObject instanceof Feature)) continue;
                featureList.add((Feature)featureObject);
            }
        }
        ZoomToFeaturesWorker worker = new ZoomToFeaturesWorker(featureList.toArray(new Feature[featureList.size()]), 10);
        worker.execute();
    }

    private void miEditActionPerformed(ActionEvent evt) {
        TreePath[] tps = this.jtFeatures.getSelectionPaths();
        boolean editModeStopped = false;
        for (TreePath tp : tps) {
            Object o = tp.getLastPathComponent();
            ArrayList<DefaultFeatureServiceFeature> allFeatures = new ArrayList<DefaultFeatureServiceFeature>();
            boolean setEditable = true;
            if (o instanceof AbstractFeatureService) {
                for (int i = 0; i < this.model.getChildCount(o); ++i) {
                    Object child = this.model.getChild(o, i);
                    if (!(child instanceof DefaultFeatureServiceFeature)) continue;
                    allFeatures.add((DefaultFeatureServiceFeature)child);
                    if (!((DefaultFeatureServiceFeature)child).isEditable()) continue;
                    setEditable = false;
                }
            } else if (o instanceof DefaultFeatureServiceFeature) {
                allFeatures.add((DefaultFeatureServiceFeature)o);
                setEditable = !((DefaultFeatureServiceFeature)o).isEditable();
            }
            for (DefaultFeatureServiceFeature feature : allFeatures) {
                DefaultFeatureServiceFeature f;
                if (feature != null && !feature.isEditable() && setEditable) {
                    DefaultFeatureServiceFeature fsf = feature;
                    this.startEditMode(fsf);
                    continue;
                }
                if (feature == null || !feature.isEditable() || setEditable || !this.stopEditMode(f = feature)) continue;
                this.fireFeatureSaved();
                editModeStopped = true;
            }
        }
        this.repaint();
        if (editModeStopped) {
            this.mappingComonent.refresh();
        }
        this.createPopupMenu();
    }

    private void miPrintActionPerformed(ActionEvent evt) {
        final TreePath tps = this.jtFeatures.getSelectionPath();
        WaitingDialogThread<JasperPrint> wdt = new WaitingDialogThread<JasperPrint>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrintActionPerformed.WaitingDialogThread"), null, 500){

            protected JasperPrint doInBackground() throws Exception {
                Object o = tps.getLastPathComponent();
                DefaultFeatureServiceFeature feature = (DefaultFeatureServiceFeature)o;
                FeaturePanelAttributeSource ds = new FeaturePanelAttributeSource(new AttribueTableModel(feature));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("ds", ds);
                map.put("title", feature.toString());
                map.put("key", NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.jtFeaturesValueChanged.name"));
                map.put("value", NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.jtFeaturesValueChanged.value"));
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(FeatureInfoPanel.REPORT_URL));
                return JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)ds);
            }

            protected void done() {
                try {
                    JasperPrint jasperPrint = (JasperPrint)this.get();
                    JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating report", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void miDeleteActionPerformed(ActionEvent evt) {
        Object o = this.jtFeatures.getSelectionPath().getLastPathComponent();
        DefaultFeatureServiceFeature feature = (DefaultFeatureServiceFeature)o;
        if (feature instanceof ModifiableFeature) {
            try {
                Object lockingObject;
                ((ModifiableFeature)((Object)feature)).delete();
                AttributeTable table = AttributeTableFactory.getInstance().getAttributeTable(feature.getLayerProperties().getFeatureService());
                FeatureLockingInterface locker = FeatureLockerFactory.getInstance().getLockerForFeatureService(feature.getLayerProperties().getFeatureService());
                if (this.tabAttributes.getEditingColumn() != -1 && this.tabAttributes.getEditingRow() != -1) {
                    this.tabAttributes.getCellEditor(this.tabAttributes.getEditingRow(), this.tabAttributes.getEditingColumn()).stopCellEditing();
                }
                if (locker != null && (lockingObject = this.lockMap.get(feature)) != null) {
                    locker.unlock(lockingObject);
                    this.lockMap.remove(feature);
                    this.lockedFeatures.remove(feature);
                }
                this.modifiedFeature.remove(feature);
                if (feature.getLayerProperties().getFeatureService() != null && feature.getLayerProperties().getFeatureService().getBoundingBox() != null) {
                    feature.getLayerProperties().getFeatureService().retrieve(true);
                }
                feature.setEditable(false);
                if (table != null) {
                    table.removeFeatureFromModel(feature);
                }
                this.model.removeFeature(feature);
                SelectionManager.getInstance().removeSelectedFeatures(feature);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot delete feature", (Throwable)e);
            }
        }
    }

    private void startEditMode(FeatureServiceFeature fsf) {
        if (fsf.getLayerProperties().getFeatureService().isEditable()) {
            if (fsf instanceof PermissionProvider && !((PermissionProvider)((Object)fsf)).hasWritePermissions()) {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.makeFeatureEditable.noPermissions.text"), NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.makeFeatureEditable.noPermissions.title"), 0);
                return;
            }
            FeatureLockingInterface locker = FeatureLockerFactory.getInstance().getLockerForFeatureService(fsf.getLayerProperties().getFeatureService());
            try {
                if (locker != null) {
                    this.lockMap.put(fsf, locker.lock(fsf, false));
                    if (!this.lockedFeatures.contains(fsf)) {
                        this.lockedFeatures.add(fsf);
                    }
                }
                Geometry g = fsf.getGeometry();
                fsf.setEditable(true);
                if (g != null && fsf.getGeometry() != null && g.distance(fsf.getGeometry()) > 2.0) {
                    XBoundingBox boundingBox = new XBoundingBox(g.union(fsf.getGeometry()));
                    boundingBox.increase(10);
                    CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory(boundingBox);
                }
            }
            catch (LockAlreadyExistsException ex) {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miEditActionPerformed().lockexists.message", (Object)fsf.getId(), (Object)ex.getLockMessage()), NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miEditActionPerformed().lockexists.title"), 0);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while locking feature.", (Throwable)ex);
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miEditActionPerformed().exception.message", (Object)ex.getMessage()), NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miEditActionPerformed().exception.title"), 0);
            }
        }
    }

    private boolean stopEditMode(DefaultFeatureServiceFeature f) {
        try {
            Object lockingObject;
            FeatureLockingInterface locker = FeatureLockerFactory.getInstance().getLockerForFeatureService(f.getLayerProperties().getFeatureService());
            AttributeTableRuleSet tableRuleSet = f.getLayerProperties().getAttributeTableRuleSet();
            if (tableRuleSet != null && !tableRuleSet.prepareForSave(this.lockedFeatures)) {
                return false;
            }
            if (tableRuleSet != null && this.isFeatureModified(f)) {
                tableRuleSet.beforeSave(f);
            }
            if (this.tabAttributes.getEditingColumn() != -1 && this.tabAttributes.getEditingRow() != -1) {
                this.tabAttributes.getCellEditor(this.tabAttributes.getEditingRow(), this.tabAttributes.getEditingColumn()).stopCellEditing();
            }
            if (this.isFeatureModified(f)) {
                f.saveChanges();
            }
            f.setEditable(false);
            if (locker != null && (lockingObject = this.lockMap.get(f)) != null) {
                locker.unlock(lockingObject);
                this.lockMap.remove(f);
                this.lockedFeatures.remove(f);
            }
            this.modifiedFeature.remove(f);
            if (tableRuleSet != null && this.isFeatureModified(f)) {
                tableRuleSet.afterSave(null);
            }
            if (f.getLayerProperties().getFeatureService() != null && f.getLayerProperties().getFeatureService().getBoundingBox() != null) {
                f.getLayerProperties().getFeatureService().retrieve(true);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving feature", (Throwable)e);
        }
        return true;
    }

    private boolean isFeatureModified(FeatureServiceFeature f) {
        return this.modifiedFeature.contains(f) || this.lockedFeatures.contains(f) && f instanceof ModifiableFeature && ((ModifiableFeature)((Object)f)).isFeatureChanged();
    }

    private boolean contentChanged() {
        if (!this.modifiedFeature.isEmpty() || !this.lockedFeatures.isEmpty()) {
            FeatureServiceFeature feature = !this.modifiedFeature.isEmpty() ? (FeatureServiceFeature)this.modifiedFeature.first() : this.lockedFeatures.get(0);
            int ans = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.contentChanged().text", (Object)feature.getLayerProperties().getFeatureService().getName()), NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.contentChanged().title"), 1);
            if (ans == 0) {
                this.saveFeatureChanges(feature);
            } else if (ans == 1) {
                this.unlockAll();
            } else {
                return false;
            }
        }
        this.disableEditMode();
        return true;
    }

    private void disableEditMode() {
        for (MapService key : this.model.data.keySet()) {
            List features = (List)this.model.data.get(key);
            if (features == null) continue;
            for (Feature f : features) {
                if (!f.isEditable()) continue;
                f.setEditable(false);
            }
        }
    }

    public boolean dispose() {
        boolean successful = this.contentChanged();
        if (successful) {
            this.unlockAll();
            this.model.init(new ArrayList());
        }
        this.fireDispose();
        return successful;
    }

    private void saveFeatureChanges(FeatureServiceFeature f) {
        DefaultFeatureServiceFeature feature;
        ArrayList<DefaultFeatureServiceFeature> savedFeatureList = new ArrayList<DefaultFeatureServiceFeature>();
        if (f instanceof DefaultFeatureServiceFeature && this.stopEditMode(feature = (DefaultFeatureServiceFeature)f)) {
            savedFeatureList.add(feature);
        }
        this.fireFeatureSaved();
    }

    private void unlockAll() {
        boolean allLocksRemoved = true;
        ArrayList<DefaultFeatureServiceFeature> unlockedFeatureList = new ArrayList<DefaultFeatureServiceFeature>();
        for (Feature feature : this.lockMap.keySet()) {
            if (!(feature instanceof DefaultFeatureServiceFeature)) continue;
            DefaultFeatureServiceFeature feature2 = (DefaultFeatureServiceFeature)feature;
            FeatureLockingInterface locker = FeatureLockerFactory.getInstance().getLockerForFeatureService(feature2.getLayerProperties().getFeatureService());
            if (locker != null) {
                try {
                    locker.unlock(this.lockMap.get(feature2));
                    feature2.setEditable(false);
                    unlockedFeatureList.add(feature2);
                }
                catch (Exception e) {
                    LOG.error((Object)"Locking object can't be removed.", (Throwable)e);
                    allLocksRemoved = false;
                }
                continue;
            }
            LOG.error((Object)"No suitable locker object found");
            allLocksRemoved = false;
        }
        if (!allLocksRemoved) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.unlockAll().message"), NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.unlockAll().title"), 0);
        }
        for (DefaultFeatureServiceFeature defaultFeatureServiceFeature : unlockedFeatureList) {
            this.lockMap.remove(defaultFeatureServiceFeature);
            this.lockedFeatures.remove(defaultFeatureServiceFeature);
        }
        this.modifiedFeature.clear();
    }

    private void createPopupMenu() {
        TreePath tp = this.jtFeatures.getSelectionPath();
        if (tp == null) {
            return;
        }
        Object c = tp.getLastPathComponent();
        this.popupMenu.removeAll();
        if (c instanceof DefaultFeatureServiceFeature) {
            this.popupMenu.add(this.miZoom);
            this.popupMenu.add(this.miPrint);
            if (((DefaultFeatureServiceFeature)c).getLayerProperties().getFeatureService() != null && ((DefaultFeatureServiceFeature)c).getLayerProperties().getFeatureService().isEditable()) {
                boolean noEdit = false;
                if (c instanceof PermissionProvider) {
                    boolean bl = noEdit = !((PermissionProvider)c).hasWritePermissions();
                }
                if (!noEdit) {
                    if (((DefaultFeatureServiceFeature)c).isEditable()) {
                        this.miEdit.setText(NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miEdit.text.editable"));
                        this.popupMenu.add(this.miDelete);
                    } else {
                        this.miEdit.setText(NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.miEdit.text"));
                    }
                    if (this.lockedFeatures.contains((DefaultFeatureServiceFeature)c) || this.lockedFeatures.isEmpty()) {
                        this.popupMenu.add(this.miEdit);
                    }
                }
            }
        }
    }

    private void enableAttributeTable(boolean enable) {
        this.sbAttributes.getViewport().remove((Component)this.tabAttributes);
        this.sbAttributes.getViewport().remove(this.featureInfo);
        if (enable) {
            this.sbAttributes.getViewport().add((Component)this.tabAttributes);
        } else {
            this.sbAttributes.getViewport().add(this.featureInfo);
        }
    }

    public FeatureServiceFeature getSelectedFeature() {
        AttribueTableModel tabModel = (AttribueTableModel)this.tabAttributes.getModel();
        if (tabModel != null) {
            return tabModel.getFeature();
        }
        return null;
    }

    public void addFeatureInfoPanelListeners(FeatureInfoPanelListener featureInfoPanelListener) {
        this.featureInfoPanelListeners.add(featureInfoPanelListener);
    }

    public void removeFeatureInfoPanelListeners(FeatureInfoPanelListener featureInfoPanelListener) {
        this.featureInfoPanelListeners.remove(featureInfoPanelListener);
    }

    private void fireDispose() {
        FeatureInfoPanelEvent evt = new FeatureInfoPanelEvent(this);
        ArrayList<FeatureInfoPanelListener> listeners = new ArrayList<FeatureInfoPanelListener>(this.featureInfoPanelListeners);
        for (FeatureInfoPanelListener featureInfoPanelListener : listeners) {
            featureInfoPanelListener.dispose(evt);
        }
    }

    private void fireFeatureSaved() {
        FeatureInfoPanelEvent evt = new FeatureInfoPanelEvent(this);
        ArrayList<FeatureInfoPanelListener> listeners = new ArrayList<FeatureInfoPanelListener>(this.featureInfoPanelListeners);
        for (FeatureInfoPanelListener featureInfoPanelListener : listeners) {
            featureInfoPanelListener.featureSaved(evt);
        }
    }

    class AttribueTableModel
    implements TableModel {
        private final DefaultFeatureServiceFeature feature;
        private final AttributeTableRuleSet tableRuleSet;
        private String[] attributeAlias;
        private String[] attributeNames;
        private Map<String, FeatureServiceAttribute> featureServiceAttributes;
        private List<String> orderedFeatureServiceAttributes;
        private final List<TableModelListener> listener = new ArrayList<TableModelListener>();

        public AttribueTableModel(DefaultFeatureServiceFeature feature) {
            this.feature = feature;
            this.tableRuleSet = feature.getLayerProperties().getAttributeTableRuleSet();
            this.initModel();
            this.initTable();
        }

        private void initModel() {
            if (this.feature instanceof WMSFeature) {
                HashMap props = this.feature.getProperties();
                this.orderedFeatureServiceAttributes = new ArrayList(props.keySet());
                this.featureServiceAttributes = new HashMap<String, FeatureServiceAttribute>();
                for (String key : props.keySet()) {
                    FeatureServiceAttribute attr = new FeatureServiceAttribute(key, "String", false);
                    this.featureServiceAttributes.put(key, attr);
                }
            } else {
                AbstractFeatureService service = this.feature.getLayerProperties().getFeatureService();
                this.orderedFeatureServiceAttributes = service.getOrderedFeatureServiceAttributes();
                this.featureServiceAttributes = service.getFeatureServiceAttributes();
            }
            this.fillHeaderArrays();
        }

        private void initTable() {
            ((CellSpecificRenderedTable)FeatureInfoPanel.this.tabAttributes).removeAllCellEditors();
            ((CellSpecificRenderedTable)FeatureInfoPanel.this.tabAttributes).removeAllCellRenderers();
            AttributeTableCellRenderer defaultRenderer = new AttributeTableCellRenderer();
            FeatureInfoPanel.this.tabAttributes.setDefaultRenderer(Object.class, (TableCellRenderer)defaultRenderer);
            FeatureInfoPanel.this.tabAttributes.setHighlighters(new Highlighter[]{new CustomColorHighlighter((JTable)FeatureInfoPanel.this.tabAttributes)});
            if (this.tableRuleSet != null) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    String columnName = this.attributeNames[i];
                    TableCellEditor editor = this.tableRuleSet.getCellEditor(columnName);
                    TableCellRenderer renderer = this.tableRuleSet.getCellRenderer(columnName);
                    if (editor != null) {
                        ((CellSpecificRenderedTable)FeatureInfoPanel.this.tabAttributes).addCellEditor(1, i, editor);
                    }
                    if (renderer == null) continue;
                    ((CellSpecificRenderedTable)FeatureInfoPanel.this.tabAttributes).addCellRenderer(1, i, renderer);
                }
            }
        }

        public FeatureServiceFeature getFeature() {
            return this.feature;
        }

        private void fillHeaderArrays() {
            int index = 0;
            this.attributeNames = new String[this.attributeCount()];
            this.attributeAlias = new String[this.attributeCount()];
            for (String attributeName : this.orderedFeatureServiceAttributes) {
                String alias;
                FeatureServiceAttribute fsa = this.featureServiceAttributes.get(attributeName);
                if (fsa != null && !fsa.isVisible()) continue;
                this.attributeNames[index] = attributeName;
                String aliasName = attributeName;
                if (fsa != null && !fsa.getAlias().equals("") && (alias = fsa.getAlias()) != null) {
                    aliasName = alias;
                }
                if (aliasName.startsWith("app:")) {
                    this.attributeAlias[index++] = aliasName.substring(4);
                    continue;
                }
                this.attributeAlias[index++] = aliasName;
            }
        }

        private int attributeCount() {
            int count = 0;
            for (String key : this.orderedFeatureServiceAttributes) {
                FeatureServiceAttribute fsa = this.featureServiceAttributes.get(key);
                if (!fsa.isVisible()) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 1 && row < this.attributeNames.length) {
                if (this.tableRuleSet != null) {
                    return this.feature.isEditable() && this.tableRuleSet.isColumnEditable(this.attributeNames[row]) && this.feature.getLayerProperties().getFeatureService().isEditable();
                }
                return this.feature.isEditable() && this.feature.getLayerProperties().getFeatureService().isEditable();
            }
            return false;
        }

        @Override
        public int getRowCount() {
            return this.attributeNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.jtFeaturesValueChanged.name");
            }
            return NbBundle.getMessage(FeatureInfoPanel.class, (String)"FeatureInfoPanel.jtFeaturesValueChanged.value");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = columnIndex == 0 ? this.attributeAlias[rowIndex] : this.feature.getProperty(this.attributeNames[rowIndex]);
            if (value instanceof Geometry) {
                value = ((Geometry)value).getGeometryType();
            } else if (value instanceof org.deegree.model.spatialschema.Geometry) {
                org.deegree.model.spatialschema.Geometry geom = (org.deegree.model.spatialschema.Geometry)value;
                try {
                    value = JTSAdapter.export((org.deegree.model.spatialschema.Geometry)geom).getGeometryType();
                }
                catch (GeometryException e) {
                    LOG.error((Object)"Error while transforming deegree geometry to jts geometry.", (Throwable)e);
                }
            }
            return value;
        }

        public String getAttributeNameForRow(int rowIndex) {
            return this.attributeNames[rowIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                Object valueWithType;
                String attrName = this.attributeNames[rowIndex];
                FeatureServiceAttribute attr = this.featureServiceAttributes.get(attrName);
                Class<?> cl = FeatureTools.getClass(attr);
                Object object = valueWithType = aValue.equals("") ? null : FeatureTools.convertObjectToClass(aValue, cl);
                if (this.tableRuleSet != null) {
                    valueWithType = this.tableRuleSet.afterEdit(this.feature, attrName, -1, this.feature.getProperty(attrName), valueWithType);
                }
                this.feature.setProperty(attrName, valueWithType);
                if (!FeatureInfoPanel.this.modifiedFeature.contains(this.feature)) {
                    FeatureInfoPanel.this.modifiedFeature.add(this.feature);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot determine the required object type", (Throwable)e);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        private void fireContentsChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener tmp : this.listener) {
                tmp.tableChanged(e);
            }
        }

        private void fireContentsChanged(TableModelEvent e) {
            for (TableModelListener tmp : this.listener) {
                tmp.tableChanged(e);
            }
        }

        private class CustomColorHighlighter
        extends AbstractHighlighter {
            private final JTable table;

            public CustomColorHighlighter(JTable table) {
                this.table = table;
            }

            protected Component doHighlight(Component cmpnt, ComponentAdapter ca) {
                int row = this.table.convertRowIndexToModel(ca.row);
                if (AttribueTableModel.this.feature.isEditable() && row < AttribueTableModel.this.attributeNames.length && AttribueTableModel.this.tableRuleSet != null && !AttribueTableModel.this.tableRuleSet.isColumnEditable(AttribueTableModel.this.attributeNames[row])) {
                    cmpnt.setForeground(Color.LIGHT_GRAY);
                }
                return cmpnt;
            }
        }

        private class AttributeTableCellRenderer
        extends DefaultTableCellRenderer {
            private DecimalFormat format = new DecimalFormat();

            public AttributeTableCellRenderer() {
                this.format.setGroupingUsed(false);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object formattedValue = value;
                int modelRow = table.convertRowIndexToModel(row);
                int modelColumn = table.convertColumnIndexToModel(column);
                if (modelColumn == 1) {
                    String key = AttribueTableModel.this.attributeNames[modelRow];
                    FeatureServiceAttribute attr = (FeatureServiceAttribute)AttribueTableModel.this.featureServiceAttributes.get(key);
                    Class<?> cl = FeatureTools.getClass(attr);
                    if (value != null) {
                        if (Date.class.isAssignableFrom(cl) && value instanceof Date) {
                            formattedValue = DateFormat.getDateInstance().format((Date)value);
                        } else if (Double.class.isAssignableFrom(cl) && value instanceof Double) {
                            formattedValue = this.format.format(value);
                        }
                    }
                }
                Component c = super.getTableCellRendererComponent(table, formattedValue, isSelected, hasFocus, row, column);
                if (AttribueTableModel.this.feature.isEditable() && modelRow < AttribueTableModel.this.attributeNames.length && AttribueTableModel.this.tableRuleSet != null && !AttribueTableModel.this.tableRuleSet.isColumnEditable(AttribueTableModel.this.attributeNames[modelRow])) {
                    JLabel lab = new JLabel(((JLabel)c).getText(), ((JLabel)c).getIcon(), ((JLabel)c).getHorizontalAlignment());
                    lab.setBackground(((JLabel)c).getBackground());
                    lab.setForeground(Color.LIGHT_GRAY);
                    lab.setOpaque(true);
                    return lab;
                }
                return c;
            }
        }
    }

    private class LayerFilterTreeModel
    implements TreeModel {
        List<Feature> lastFeatures;
        private final MappingComponent mappingComponent;
        private final ActiveLayerModel layerModel;
        private LayerFilter filter;
        private final String root = NbBundle.getMessage(LayerFilterTreeModel.class, (String)"FeatureInfoPanel.LayerFilterTreeModel.root");
        private final Map<MapService, List<Feature>> data = new HashMap<MapService, List<Feature>>();
        private final List<MapService> orderedDataKeys = new ArrayList<MapService>();
        private final List<TreeModelListener> listener = new ArrayList<TreeModelListener>();

        public LayerFilterTreeModel(ActiveLayerModel layerModel, MappingComponent mappingComponent) {
            this.layerModel = layerModel;
            this.mappingComponent = mappingComponent;
        }

        public void featureExchange(MapService service, Feature f, TreePath tp) {
            List<Feature> featureList = this.data.get(service);
            int index = featureList.indexOf(f);
            if (index != -1) {
                featureList.set(index, f);
            }
            if ((index = this.lastFeatures.indexOf(f)) != -1) {
                this.lastFeatures.set(index, f);
            }
            for (TreeModelListener l : this.listener) {
                l.treeStructureChanged(new TreeModelEvent((Object)this, tp));
            }
        }

        public void setLayerFilter(LayerFilter filter) {
            this.filter = filter;
            if (this.lastFeatures != null) {
                this.init(this.lastFeatures);
            }
        }

        private void init(List<Feature> features) {
            MapService service;
            final TreeMap<Integer, MapService> treeMap = this.layerModel.getMapServices();
            ArrayList<MapService> allowedMapServices = new ArrayList<MapService>();
            ArrayList<AbstractFeatureService> allowedFeatureServices = new ArrayList<AbstractFeatureService>();
            this.lastFeatures = features;
            this.data.clear();
            this.orderedDataKeys.clear();
            for (Integer serviceKey : treeMap.keySet()) {
                service = treeMap.get(serviceKey);
                if (!this.filter.isLayerAllowed(service)) continue;
                if (service instanceof AbstractFeatureService) {
                    allowedFeatureServices.add((AbstractFeatureService)service);
                    continue;
                }
                allowedMapServices.add(service);
            }
            if (features.size() == 1 && !(features.get(0) instanceof WMSFeature) && features.get(0) instanceof FeatureServiceFeature) {
                Feature f = features.get(0);
                AbstractFeatureService service2 = ((FeatureServiceFeature)f).getLayerProperties().getFeatureService();
                if (f instanceof FeatureServiceFeature && !allowedMapServices.contains(service2) && this.filter.isLayerAllowed(service2)) {
                    allowedFeatureServices.add(service2);
                }
            }
            for (Feature feature : features) {
                service = null;
                if (feature instanceof WMSGetFeatureInfoDescription) {
                    WMSGetFeatureInfoDescription gfid = (WMSGetFeatureInfoDescription)feature;
                    service = this.getMapServiceOfWMSServiceLayer(allowedMapServices, gfid.getService());
                } else if (feature instanceof WMSFeature) {
                    WMSFeature wmsFeature = (WMSFeature)feature;
                    service = this.getMapServiceOfWMSServiceLayer(allowedMapServices, wmsFeature.getWMSServiceLayer());
                } else if (feature instanceof FeatureServiceFeature) {
                    service = this.getFeatureServiceOfFeature(allowedFeatureServices, (FeatureServiceFeature)feature);
                }
                if (service == null) continue;
                List<Feature> featureList = this.data.get(service);
                if (featureList == null) {
                    featureList = new ArrayList<Feature>();
                    this.data.put(service, featureList);
                    this.orderedDataKeys.add(service);
                }
                featureList.add(feature);
            }
            Collections.sort(this.orderedDataKeys, new Comparator<MapService>(){
                Map<MapService, Integer> serviceOrderMap = new HashMap<MapService, Integer>();
                {
                    for (Integer serviceOrder : treeMap.keySet()) {
                        MapService service = (MapService)treeMap.get(serviceOrder);
                        this.serviceOrderMap.put(service, serviceOrder);
                    }
                }

                @Override
                public int compare(MapService o1, MapService o2) {
                    Integer order1 = this.serviceOrderMap.get(o1);
                    Integer order2 = this.serviceOrderMap.get(o2);
                    if (order1 == null && order2 == null) {
                        return 0;
                    }
                    if (order1 == null) {
                        return 1;
                    }
                    if (order2 == null) {
                        return -1;
                    }
                    return -1 * order1.compareTo(order2);
                }
            });
            this.fireTreeStructureChanged();
        }

        private AbstractFeatureService getFeatureServiceOfFeature(List<AbstractFeatureService> serviceList, FeatureServiceFeature feature) {
            for (AbstractFeatureService service : serviceList) {
                if (service.getLayerProperties() != feature.getLayerProperties()) continue;
                return service;
            }
            return null;
        }

        private MapService getMapServiceOfWMSServiceLayer(List<MapService> serviceList, WMSServiceLayer featureService) {
            for (MapService service : serviceList) {
                if (service != featureService) continue;
                return service;
            }
            return null;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.root) {
                return this.orderedDataKeys.get(index);
            }
            if (parent instanceof MapService) {
                return this.data.get((MapService)parent).get(index);
            }
            return null;
        }

        public void removeFeature(FeatureServiceFeature f) {
            this.lastFeatures.remove(f);
            this.init(this.lastFeatures);
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.root) {
                return this.orderedDataKeys.size();
            }
            if (parent instanceof MapService) {
                return this.data.get((MapService)parent).size();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == this.root) {
                return this.orderedDataKeys.isEmpty();
            }
            if (node instanceof MapService) {
                return this.data.get((MapService)node).isEmpty();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.root) {
                return this.orderedDataKeys.indexOf(child);
            }
            if (parent instanceof MapService) {
                return this.data.get((MapService)parent).indexOf(child);
            }
            LOG.error((Object)("parent is of type " + parent.getClass().getName() + ". This should never happen"));
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listener.remove(l);
        }

        private void fireTreeStructureChanged() {
            for (TreeModelListener l : this.listener) {
                l.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
            }
        }
    }
}

