/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.infowidgets;

import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.featureservice.factory.WFSFeatureFactory;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CapabilityListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.CapabilityEvent;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.deegree.DeegreeFeatureType;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.GUIWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class LayerInfo
extends JPanel
implements CapabilityListener,
ActiveLayerListener,
GUIWindow {
    private static final String DE = "--DE";
    private static final String EN = "--EN";
    private static final String[] LANGUAGES = new String[]{"--DE", "--EN"};
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JLabel lblFeatureInfo;
    private JLabel lblName;
    private JList lstSrs;
    private JPanel panMain;
    private JScrollPane scpAbstract;
    private JSplitPane sppMain;
    private JTextArea txtAbstract;
    private final Logger log = Logger.getLogger(this.getClass());
    private boolean splitPaneInitialized = false;
    private ResourceBundle srsMapping = null;
    private HashMap<String, String> srsMap = new HashMap();

    public LayerInfo() {
        this.initComponents();
        this.sppMain.setDividerLocation(0.75);
        try {
            this.srsMapping = ResourceBundle.getBundle("cismapCrsMapping", Locale.getDefault());
            Enumeration<String> en = this.srsMapping.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = this.srsMapping.getString(key);
                if (value == null) continue;
                this.srsMap.put(key, value);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot open the resource bundle for the crs mapping.", (Throwable)e);
        }
        CismapBroker.getInstance().addCapabilityListener(this);
        CismapBroker.getInstance().addActiveLayerListener(this);
    }

    @Override
    public void serverChanged(CapabilityEvent e) {
    }

    public void initDividerLocation() {
        this.sppMain.setDividerLocation(0.75);
    }

    @Override
    public void layerChanged(CapabilityEvent e) {
        if (e.getCapabilityObject() instanceof Layer) {
            this.setValues((Layer)e.getCapabilityObject());
        } else if (e.getCapabilityObject() instanceof DeegreeFeatureType) {
            this.setValues((FeatureType)e.getCapabilityObject());
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.panMain = new JPanel();
        this.sppMain = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.scpAbstract = new JScrollPane();
        this.txtAbstract = new JTextArea();
        this.lblName = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.lblFeatureInfo = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstSrs = new JList();
        this.jLabel1.setText(null);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                LayerInfo.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                LayerInfo.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.panMain.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.panMain.setLayout(new BorderLayout());
        this.sppMain.setDividerLocation(200);
        this.sppMain.setOrientation(0);
        this.sppMain.setResizeWeight(0.5);
        this.jPanel1.setLayout(new BorderLayout());
        this.scpAbstract.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.scpAbstract.setViewportBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.txtAbstract.setBackground(this.panMain.getBackground());
        this.txtAbstract.setColumns(20);
        this.txtAbstract.setLineWrap(true);
        this.txtAbstract.setRows(3);
        this.txtAbstract.setWrapStyleWord(true);
        this.scpAbstract.setViewportView(this.txtAbstract);
        this.jPanel1.add((Component)this.scpAbstract, "Center");
        this.lblName.setFont(new Font("Tahoma", 1, 14));
        this.lblName.setText(null);
        this.jPanel1.add((Component)this.lblName, "First");
        this.sppMain.setTopComponent(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel3.setText(null);
        this.lblFeatureInfo.setFont(new Font("DejaVu Sans", 1, 13));
        this.lblFeatureInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/layerInfo.png")));
        this.lblFeatureInfo.setText(NbBundle.getMessage(LayerInfo.class, (String)"lblFeatureInfo.text"));
        this.lstSrs.setBackground(this.panMain.getBackground());
        this.jScrollPane2.setViewportView(this.lstSrs);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 420, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 408, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblFeatureInfo).addPreferredGap(0, 174, -2)).add((Component)this.jLabel3, -1, 408, Short.MAX_VALUE)).addContainerGap())));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 226, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblFeatureInfo).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 173, Short.MAX_VALUE).addContainerGap())));
        this.sppMain.setRightComponent(this.jPanel2);
        this.panMain.add((Component)this.sppMain, "Center");
        this.add((Component)this.panMain, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void setValues(Layer layer) {
        Values v = new Values();
        try {
            v.title = layer.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.name = layer.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.description = layer.getAbstract();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.featureInfo = layer.isQueryable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.srs = layer.getSrs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValues(v);
    }

    private void setValues(FeatureType feature) {
        Values v = new Values();
        try {
            v.title = feature.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.name = WFSFeatureFactory.convertFeatureQnameToName(feature.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.description = feature.getAbstract();
        }
        catch (Exception exception) {
            // empty catch block
        }
        v.featureInfo = false;
        try {
            v.srs = feature.getSupportedSRS();
            if (feature.getDefaultSRS() != null && !this.contains(v.srs, feature.getDefaultSRS())) {
                if (v.srs == null) {
                    v.srs = new String[0];
                }
                String[] tmp = new String[v.srs.length + 1];
                System.arraycopy(v.srs, 0, tmp, 0, v.srs.length);
                tmp[v.srs.length] = feature.getDefaultSRS();
                v.srs = tmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValues(v);
    }

    private boolean contains(String[] ar, String val) {
        if (ar == null) {
            return false;
        }
        for (String tmp : ar) {
            if (!tmp.equals(val)) continue;
            return true;
        }
        return false;
    }

    private void setValues(Values v) {
        if (v.title != null) {
            this.lblName.setText(v.title);
        } else {
            this.lblName.setText("-");
        }
        if (v.name != null) {
            this.lblName.setToolTipText(v.name);
        } else {
            this.lblName.setToolTipText(null);
        }
        if (v.description != null && v.description.length() > 0) {
            this.scpAbstract.setVisible(true);
            String s = v.description;
            this.txtAbstract.setText(this.getGDILanguageString(v.description));
        } else {
            this.scpAbstract.setVisible(false);
        }
        this.lblFeatureInfo.setEnabled(v.featureInfo);
        if (v.srs != null && v.srs.length > 0) {
            ArrayList<String> srs = new ArrayList<String>();
            this.lstSrs.setVisible(true);
            for (String s : v.srs) {
                if (srs.contains(s = this.getSrsDescription(s))) continue;
                srs.add(s);
            }
            this.lstSrs.setModel(new DefaultComboBoxModel<Object>(srs.toArray()));
        } else {
            this.lstSrs.setVisible(false);
        }
    }

    private String getSrsDescription(String srs) {
        String srsName = this.srsMap.get(srs);
        if (srsName != null) {
            return srs + " (" + srsName + ")";
        }
        return srs;
    }

    @Override
    public void layerVisibilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerAvailabilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerSelectionChanged(ActiveLayerEvent e) {
        if (e.getLayer() instanceof WMSServiceLayer) {
            Object o;
            List v = ((WMSServiceLayer)e.getLayer()).getWMSLayers();
            if (v.size() == 1 && (o = v.get(0)) instanceof WMSLayer) {
                this.setValues(((WMSLayer)o).getOgcCapabilitiesLayer());
            }
        } else if (e.getLayer() instanceof WebFeatureService) {
            this.setValues(((WebFeatureService)e.getLayer()).getFeature());
        }
    }

    @Override
    public void layerRemoved(ActiveLayerEvent e) {
    }

    @Override
    public void layerPositionChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerInformationStatusChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerAdded(ActiveLayerEvent e) {
    }

    public String getGDILanguageString(String text) {
        String ret = "";
        try {
            for (String lan : LANGUAGES) {
                if (!text.contains(lan)) continue;
                int from = text.indexOf(lan);
                int to = text.indexOf("--", from + lan.length());
                if (from < 0) break;
                if (to < 0) {
                    to = text.length();
                }
                ret = text.substring(from + lan.length(), to);
                return ret.trim();
            }
            return text;
        }
        catch (Exception e) {
            this.log.warn((Object)"Error while checking the GDI String", (Throwable)e);
            return text;
        }
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public String getViewTitle() {
        return NbBundle.getMessage(LayerInfo.class, (String)"LayerInfo.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/layerInfo.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }

    class Values {
        String title;
        String name;
        String description;
        boolean featureInfo;
        String[] srs;

        Values() {
        }
    }
}

