/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.infowidgets;

import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.simple.SimpleLegendProvider;
import de.cismet.cismap.commons.rasterservice.ImageRetrieval;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class Legend
extends JPanel
implements ActiveLayerListener,
StatusListener,
GUIWindow {
    private int maxWidth = 0;
    private final Logger log = Logger.getLogger(this.getClass());
    private HashMap<String, WMSCapabilities> wmsCapabilities = new HashMap();
    private LegendModel tableModel = new LegendModel();
    private JScrollPane scpLegends;
    private JTable tblLegends;

    public Legend() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.tblLegends.setModel(this.tableModel);
        this.tblLegends.setTableHeader(null);
        this.tblLegends.setDefaultRenderer(LegendPanel.class, new CustomCellRenderer());
        this.tblLegends.setShowHorizontalLines(false);
        this.tblLegends.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tblLegends.setSelectionMode(0);
        this.tblLegends.setAutoResizeMode(0);
        this.scpLegends = new JScrollPane(this.tblLegends);
        StaticSwingTools.setNiftyScrollBars((JScrollPane)this.scpLegends);
        this.add((Component)this.scpLegends, "Center");
        CismapBroker.getInstance().addActiveLayerListener(this);
        CismapBroker.getInstance().addStatusListener(this);
    }

    public void addLegend(String url, String layername) {
        this.tableModel.addLegend(url, layername);
    }

    public void removeLegendByUrl(String layerurl, String name) {
        this.tableModel.removeLegendByUrl(layerurl, name);
    }

    public void scrollToLegend(String url) {
        int pos = this.tableModel.getPosition(url);
        if (pos != -1) {
            StaticSwingTools.jTableScrollToVisible((JTable)this.tblLegends, (int)pos, (int)0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.tblLegends.getSelectionModel().getValueIsAdjusting());
            }
            if (!this.tblLegends.getSelectionModel().isSelectedIndex(pos)) {
                this.tblLegends.getSelectionModel().setSelectionInterval(pos, pos);
            }
        } else {
            this.tblLegends.getSelectionModel().clearSelection();
        }
    }

    @Override
    public void layerVisibilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerAvailabilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerRemoved(ActiveLayerEvent e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"layerRemoved() fired");
        }
        if (e.getLayer() instanceof WMSServiceLayer) {
            this.removeWmsServiceLayer((WMSServiceLayer)e.getLayer());
        } else if (e.getLayer() instanceof WMSLayer) {
            this.removeWMSLayer((WMSLayer)e.getLayer());
        } else if (e.getLayer() instanceof SimpleLegendProvider) {
            SimpleLegendProvider slp = (SimpleLegendProvider)e.getLayer();
            this.removeLegendByUrl(slp.getLegendUrl(), slp.getLegendIdentifier());
        } else if (e.getLayer() instanceof SlidableWMSServiceLayerGroup) {
            WMSServiceLayer elem;
            SlidableWMSServiceLayerGroup wmsLayer = (SlidableWMSServiceLayerGroup)e.getLayer();
            List<WMSServiceLayer> v = wmsLayer.getLayers();
            Iterator<WMSServiceLayer> it = v.iterator();
            if (it.hasNext() && (elem = it.next()) instanceof WMSServiceLayer) {
                this.removeWmsServiceLayer(elem);
            }
        } else {
            this.log.warn((Object)("For this type no legend can be created. " + e.getLayer()));
        }
    }

    private void removeWmsServiceLayer(WMSServiceLayer wmsLayer) {
        List v = wmsLayer.getWMSLayers();
        for (Object elem : v) {
            if (!(elem instanceof WMSLayer)) continue;
            WMSLayer wl = (WMSLayer)elem;
            this.removeWMSLayer(wl);
        }
    }

    private void removeWMSLayer(WMSLayer wl) {
        assert (wl != null);
        if (wl.getOgcCapabilitiesLayer() == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"in removeWMSLayer waren die capabilities null. kann die Legende nicht entferenen. Wahrscheinlich war deshalb auch gar keine drin. ");
            }
        } else {
            String url;
            String name;
            block7: {
                String title = wl.getOgcCapabilitiesLayer().getTitle();
                name = wl.getOgcCapabilitiesLayer().getName();
                url = null;
                try {
                    URL[] lua = wl.getSelectedStyle().getLegendURL();
                    url = this.getValidUrlString(lua[0]);
                }
                catch (Exception t) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)("Could not find a legend for " + title), (Throwable)t);
                }
            }
            if (url != null) {
                this.removeLegendByUrl(url, name);
            }
        }
    }

    @Override
    public void layerSelectionChanged(ActiveLayerEvent e) {
        block12: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"layerSelectionChanged() fired");
            }
            if (e.getLayer() instanceof WMSLayer || e.getLayer() instanceof WMSServiceLayer || e.getLayer() instanceof SlidableWMSServiceLayerGroup) {
                WMSServiceLayer sLayer;
                WMSLayer layer = null;
                if (e.getLayer() instanceof WMSLayer) {
                    layer = (WMSLayer)e.getLayer();
                } else if (e.getLayer() instanceof WMSServiceLayer && ((WMSServiceLayer)e.getLayer()).getWMSLayers().size() == 1) {
                    layer = (WMSLayer)((WMSServiceLayer)e.getLayer()).getWMSLayers().get(0);
                } else if (e.getLayer() instanceof SlidableWMSServiceLayerGroup && ((SlidableWMSServiceLayerGroup)e.getLayer()).getLayers().size() > 0 && (sLayer = ((SlidableWMSServiceLayerGroup)e.getLayer()).getLayers().get(0)).getWMSLayers().size() == 1) {
                    layer = (WMSLayer)sLayer.getWMSLayers().get(0);
                }
                try {
                    if (!layer.isDummy()) {
                        this.scrollToLegend(this.getValidUrlString(layer.getSelectedStyle().getLegendURL()[0]));
                    }
                    break block12;
                }
                catch (Exception ex) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Cannot scroll to legend of " + e.getLayer()), (Throwable)ex);
                    }
                    break block12;
                }
            }
            if (e.getLayer() instanceof SimpleLegendProvider) {
                SimpleLegendProvider slp = (SimpleLegendProvider)e.getLayer();
                this.scrollToLegend(slp.getLegendUrl());
            }
        }
    }

    @Override
    public void layerPositionChanged(ActiveLayerEvent e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"layerPositionChanged() fired");
        }
    }

    @Override
    public void layerAdded(ActiveLayerEvent e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"layerAdded() fired");
        }
        if (e.getLayer() instanceof WMSServiceLayer) {
            this.addWmsServiceLayer((WMSServiceLayer)e.getLayer());
        } else if (e.getLayer() instanceof SimpleLegendProvider) {
            SimpleLegendProvider slp = (SimpleLegendProvider)e.getLayer();
            this.addLegend(slp.getLegendUrl(), slp.getLegendIdentifier());
        } else if (e.getLayer() instanceof SlidableWMSServiceLayerGroup) {
            WMSServiceLayer elem;
            SlidableWMSServiceLayerGroup wmsLayer = (SlidableWMSServiceLayerGroup)e.getLayer();
            List<WMSServiceLayer> v = wmsLayer.getLayers();
            Iterator<WMSServiceLayer> it = v.iterator();
            if (it.hasNext() && (elem = it.next()) instanceof WMSServiceLayer) {
                this.addWmsServiceLayer(elem);
            }
        } else {
            this.log.warn((Object)("For this type no legend can be created. " + e.getLayer()));
        }
    }

    private void addWmsServiceLayer(WMSServiceLayer wmsLayer) {
        if (!wmsLayer.isDummy()) {
            List v = wmsLayer.getWMSLayers();
            for (Object elem : v) {
                String url;
                String name;
                block4: {
                    if (!(elem instanceof WMSLayer)) continue;
                    WMSLayer wl = (WMSLayer)elem;
                    String title = wl.getOgcCapabilitiesLayer().getTitle();
                    name = wl.getOgcCapabilitiesLayer().getName();
                    url = null;
                    try {
                        URL[] lua = wl.getSelectedStyle().getLegendURL();
                        url = this.getValidUrlString(lua[0]);
                    }
                    catch (Exception t) {
                        if (!this.log.isDebugEnabled()) break block4;
                        this.log.debug((Object)("Could not find legend for " + title), (Throwable)t);
                    }
                }
                if (url == null) continue;
                this.wmsCapabilities.put(url, wmsLayer.getWmsCapabilities());
                this.addLegend(url, name);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("added legend:" + name + "=" + url));
            }
        }
    }

    private String getValidUrlString(URL url) throws Exception {
        String urlString;
        block4: {
            urlString = null;
            try {
                urlString = url.toURI().toASCIIString();
            }
            catch (Exception t) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Cannot convert legend url to ascii string", (Throwable)t);
                }
                if (!(urlString = url.toString()).contains("?")) break block4;
                String param = urlString.substring(urlString.indexOf("?") + 1);
                urlString = urlString.substring(0, urlString.indexOf("?")) + "?";
                StringTokenizer stParam = new StringTokenizer(param, "&");
                while (stParam.hasMoreTokens()) {
                    StringTokenizer stKeyVal = new StringTokenizer(stParam.nextToken(), "=");
                    if (stKeyVal.countTokens() != 2) continue;
                    urlString = urlString + "&" + stKeyVal.nextToken() + "=" + URLEncoder.encode(stKeyVal.nextToken(), "UTF-8");
                }
            }
        }
        return urlString;
    }

    @Override
    public void layerInformationStatusChanged(ActiveLayerEvent e) {
    }

    private void initComponents() {
        this.scpLegends = new JScrollPane();
        this.tblLegends = new JTable();
        this.scpLegends.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scpLegends.setHorizontalScrollBarPolicy(32);
        this.scpLegends.setVerticalScrollBarPolicy(22);
        this.scpLegends.setDoubleBuffered(true);
        this.tblLegends.setBackground(new Color(236, 233, 216));
        this.tblLegends.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 1, 5, 1));
    }

    @Override
    public void statusValueChanged(StatusEvent e) {
        if (e.getName().equals("awaked.from.dummy") && e.getValue() instanceof WMSServiceLayer) {
            this.addWmsServiceLayer((WMSServiceLayer)e.getValue());
        }
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public String getViewTitle() {
        return NbBundle.getMessage(Legend.class, (String)"Legend.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/res/legend.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }

    private class LegendModel
    extends AbstractTableModel {
        private List<LegendPanel> panels = new ArrayList<LegendPanel>();
        private HashMap<String, LegendPanel> panelsByUrl = new HashMap();
        private HashMap<String, TreeSet<String>> urlByLayername = new HashMap();

        private LegendModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return LegendPanel.class;
        }

        @Override
        public int getRowCount() {
            return this.panels.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.panels.get(this.panels.size() - 1 - row);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        public void addLegend(String url, String name) {
            TreeSet<String> allLayers;
            LegendPanel lp = new LegendPanel(url);
            if (!this.panels.contains(lp)) {
                this.panels.add(lp);
                this.panelsByUrl.put(url, lp);
            }
            if ((allLayers = this.urlByLayername.get(url)) == null) {
                TreeSet<String> names = new TreeSet<String>();
                names.add(name);
                this.urlByLayername.put(url, names);
            } else {
                allLayers.add(name);
            }
            if (EventQueue.isDispatchThread()) {
                this.fireTableStructureChanged();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LegendModel.super.fireTableStructureChanged();
                    }
                });
            }
        }

        public void removeLegendByUrl(String url, String name) {
            LegendPanel lp;
            if (this.panelsByUrl.containsKey(url) && this.panels.contains(lp = new LegendPanel(url))) {
                TreeSet<String> names = this.urlByLayername.get(url);
                boolean removeUrl = true;
                if (names != null) {
                    names.remove(name);
                    if (names.size() > 0) {
                        removeUrl = false;
                    } else {
                        this.urlByLayername.remove(url);
                    }
                }
                if (removeUrl) {
                    int index = this.panels.indexOf(lp);
                    this.panels.remove(lp);
                    this.panelsByUrl.remove(url);
                    super.fireTableRowsDeleted(index, index);
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public int getPosition(String url) {
            LegendPanel lp = this.panelsByUrl.get(url);
            return this.panels.size() - 1 - this.panels.indexOf(lp);
        }
    }

    private class CustomCellRenderer
    implements TableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = (Component)value;
            if (isSelected) {
                component.setBackground(Color.white);
                component.setForeground(Legend.this.getForeground());
            } else {
                component.setBackground(Legend.this.getBackground());
                component.setForeground(Legend.this.getForeground());
            }
            if (table.getRowHeight(row) != (int)component.getPreferredSize().getHeight()) {
                table.setRowHeight(row, (int)component.getPreferredSize().getHeight());
            }
            return component;
        }
    }

    private class LegendPanel
    extends JPanel
    implements RetrievalListener {
        JLabel lblImage = new JLabel();
        private String url = "";

        public LegendPanel() {
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.setLayout(new BorderLayout());
            this.add((Component)this.lblImage, "Center");
            this.lblImage.setHorizontalAlignment(10);
            this.lblImage.setVerticalAlignment(0);
        }

        public LegendPanel(String url) {
            this();
            this.url = url;
            this.refresh();
        }

        private void dispatch(Runnable r) {
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }

        public final void refresh() {
            ImageRetrieval ir = new ImageRetrieval(this);
            ir.setUrl(this.url);
            ir.setWMSCapabilities((WMSCapabilities)Legend.this.wmsCapabilities.get(this.url));
            ir.setPriority(5);
            ir.start();
        }

        @Override
        public void retrievalStarted(RetrievalEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LegendPanel.this.lblImage.setIcon(null);
                    LegendPanel.this.lblImage.setText("...");
                    if (Legend.this.maxWidth > 0) {
                        Legend.this.tblLegends.getColumnModel().getColumn(0).setPreferredWidth(Legend.this.maxWidth);
                    }
                    Legend.this.tableModel.fireTableDataChanged();
                }
            };
            this.dispatch(r);
        }

        @Override
        public void retrievalProgress(RetrievalEvent e) {
        }

        @Override
        public void retrievalError(RetrievalEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LegendPanel.this.lblImage.setText("");
                    Legend.this.log.error((Object)"Error while loading legend.");
                    Legend.this.tableModel.fireTableDataChanged();
                }
            };
            this.dispatch(r);
        }

        @Override
        public void retrievalComplete(RetrievalEvent e) {
            if (e.getRetrievedObject() instanceof Image) {
                final Image image = (Image)e.getRetrievedObject();
                final ImageIcon ii = new ImageIcon(image);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LegendPanel.this.lblImage.setText("");
                        LegendPanel.this.lblImage.setIcon(ii);
                        Legend.this.tableModel.fireTableDataChanged();
                        int newWidth = image.getWidth(null) + 10;
                        if (newWidth < ((Legend)Legend.this).tblLegends.getPreferredSize().width) {
                            newWidth = ((Legend)Legend.this).tblLegends.getPreferredSize().width;
                        } else {
                            Legend.this.maxWidth = newWidth;
                        }
                        Legend.this.tblLegends.getColumnModel().getColumn(0).setPreferredWidth(newWidth);
                    }
                };
                this.dispatch(r);
            }
        }

        @Override
        public void retrievalAborted(RetrievalEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LegendPanel.this.lblImage.setText("");
                }
            };
            this.dispatch(r);
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object tester) {
            if (tester instanceof LegendPanel) {
                LegendPanel t = (LegendPanel)tester;
                return t.url.equals(this.url);
            }
            return false;
        }
    }
}

