/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.ModeLayer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.featureservice.GMLFeatureService;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.SimplePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.IconType;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.commons.wms.capabilities.Layer;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class ActiveLayerTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final int SINGLE = 4;
    private static final int MULTI = 8;
    private static final int INFO = 16;
    private static final int DL = 32;
    private static final int SUPPORTER = 32;
    private static final int ASCII = 64;
    private static final int GML = 96;
    private static final int POSTGIS = 160;
    private static final int SHAPE = 192;
    private static final int SIMPLEWMS = 224;
    private static final int WFS = 256;
    private static final int WFST = 288;
    private static final int H2 = 300;
    private final Logger LOG = Logger.getLogger(this.getClass());
    private final HashMap icons = new HashMap();

    public ActiveLayerTreeCellRenderer() {
        this.icons.put(new IconType(4, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layer.png")));
        this.icons.put(new IconType(36, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerOverlaywms.png")));
        this.icons.put(new IconType(36, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerOverlaywmsInvisible.png")));
        this.icons.put(new IconType(20, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerInfo.png")));
        this.icons.put(new IconType(52, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerInfoDL.png")));
        this.icons.put(new IconType(52, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerInfoDLinvisible.png")));
        this.icons.put(new IconType(8, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layers.png")));
        this.icons.put(new IconType(40, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layersDL.png")));
        this.icons.put(new IconType(40, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layersDLinvisible.png")));
        this.icons.put(new IconType(32, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/featureSupporter.png")));
        this.icons.put(new IconType(32, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/featureSupporterInvisible.png")));
        this.icons.put(new IconType(32, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/featureSupporter.png")));
        this.icons.put(new IconType(32, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/featureSupporterInvisible.png")));
        this.icons.put(new IconType(4, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layer.png")));
        this.icons.put(new IconType(36, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerOverlaywms.png")));
        this.icons.put(new IconType(36, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerOverlaywmsInvisible.png")));
        this.icons.put(new IconType(20, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerInfo.png")));
        this.icons.put(new IconType(52, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerInfoDL.png")));
        this.icons.put(new IconType(52, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerInfoDLinvisible.png")));
        this.icons.put(new IconType(8, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layers.png")));
        this.icons.put(new IconType(40, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layersDL.png")));
        this.icons.put(new IconType(40, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layersDLinvisible.png")));
        this.icons.put(new IconType(64, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerAscii.png")));
        this.icons.put(new IconType(64, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerAsciiInvisible.png")));
        this.icons.put(new IconType(64, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerAscii.png")));
        this.icons.put(new IconType(64, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerAsciiInvisible.png")));
        this.icons.put(new IconType(160, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerPostgis.png")));
        this.icons.put(new IconType(160, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerPostgisInvisible.png")));
        this.icons.put(new IconType(160, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerPostgis.png")));
        this.icons.put(new IconType(160, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerPostgisInvisible.png")));
        this.icons.put(new IconType(224, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerSimplewms.png")));
        this.icons.put(new IconType(224, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerSimplewmsInvisible.png")));
        this.icons.put(new IconType(224, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerSimplewms.png")));
        this.icons.put(new IconType(224, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerSimplewmsInvisible.png")));
        this.icons.put(new IconType(288, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfst.png")));
        this.icons.put(new IconType(288, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfstInvisible.png")));
        this.icons.put(new IconType(288, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfst.png")));
        this.icons.put(new IconType(288, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfstInvisible.png")));
        this.icons.put(new IconType(256, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfs.png")));
        this.icons.put(new IconType(256, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfsInvisible.png")));
        this.icons.put(new IconType(256, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfs.png")));
        this.icons.put(new IconType(256, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfsInvisible.png")));
        this.icons.put(new IconType(96, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerGml.png")));
        this.icons.put(new IconType(96, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerGmlInvisible.png")));
        this.icons.put(new IconType(96, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerGml.png")));
        this.icons.put(new IconType(96, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerGmlInvisible.png")));
        this.icons.put(new IconType(288, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfst.png")));
        this.icons.put(new IconType(288, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerWfstInvisible.png")));
        this.icons.put(new IconType(288, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfst.png")));
        this.icons.put(new IconType(288, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerWfstInvisible.png")));
        this.icons.put(new IconType(192, true, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShape.png")));
        this.icons.put(new IconType(192, false, true), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShapeInvisible.png")));
        this.icons.put(new IconType(192, true, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShape.png")));
        this.icons.put(new IconType(192, false, false), new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShapeInvisible.png")));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel ret;
        block35: {
            if (value instanceof ModeLayer) {
                return this.getTreeCellRendererComponent(tree, ((ModeLayer)value).getCurrentLayer(), isSelected, expanded, leaf, row, hasFocus);
            }
            ret = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            ret.setText(value.toString());
            if (value instanceof RetrievalServiceLayer) {
                RetrievalServiceLayer layer = (RetrievalServiceLayer)value;
                ret.setText(layer.toString());
                if (value instanceof WMSServiceLayer) {
                    WMSServiceLayer wmsLayer = (WMSServiceLayer)layer;
                    if (wmsLayer.getWMSLayers().size() == 1) {
                        if (!wmsLayer.isDummy() && ((WMSLayer)wmsLayer.getWMSLayers().get(0)).getOgcCapabilitiesLayer().isQueryable()) {
                            ret.setIcon(this.getRightIcon(52, wmsLayer.getPNode().getVisible(), layer.isEnabled()));
                        } else {
                            ret.setIcon(this.getRightIcon(36, wmsLayer.getPNode().getVisible(), layer.isEnabled()));
                        }
                    }
                    if (wmsLayer.getWMSLayers().size() > 1) {
                        ret.setIcon(this.getRightIcon(40, layer.getPNode().getVisible(), layer.isEnabled()));
                    }
                } else if (value instanceof SimpleWMS) {
                    ret.setIcon(this.getRightIcon(224, layer.getPNode().getVisible(), layer.isEnabled()));
                } else if (value instanceof WebFeatureService) {
                    ret.setIcon(this.getRightIcon(256, layer.getPNode().getVisible(), layer.isEnabled()));
                } else if (value instanceof GMLFeatureService) {
                    ret.setIcon(this.getRightIcon(96, layer.getPNode().getVisible(), layer.isEnabled()));
                } else if (value instanceof ShapeFileFeatureService) {
                    ret.setIcon(this.getRightIcon(192, layer.getPNode().getVisible(), layer.isEnabled()));
                } else if (value instanceof SimplePostgisFeatureService) {
                    ret.setIcon(this.getRightIcon(160, layer.getPNode().getVisible(), layer.isEnabled()));
                } else if (value instanceof H2FeatureService) {
                    int type = layer.getPNode().getVisible() ? (layer.isEnabled() ? 0 : 1) : (layer.isEnabled() ? 2 : 3);
                    ret.setIcon(((H2FeatureService)value).getLayerIcon(type));
                } else {
                    ret.setIcon(this.getRightIcon(32, layer.getPNode().getVisible(), layer.isEnabled()));
                }
            } else if (value instanceof WMSLayer) {
                boolean queryable = !((WMSLayer)value).isDummy() ? ((WMSLayer)value).getOgcCapabilitiesLayer().isQueryable() : ((WMSLayer)value).isQueryable();
                if (queryable) {
                    ret.setIcon(this.getRightIcon(20, true, ((WMSLayer)value).isEnabled()));
                } else {
                    ret.setIcon(this.getRightIcon(4, true, ((WMSLayer)value).isEnabled()));
                }
            } else if (value instanceof SimpleWMS) {
                ret.setIcon(this.getRightIcon(224, true, ((SimpleWMS)value).isEnabled()));
            }
            Color fg = this.getForeground();
            try {
                Layer tmpLayer = null;
                if (value instanceof WMSServiceLayer && ((WMSServiceLayer)value).getWMSLayers().size() == 1) {
                    tmpLayer = ((WMSLayer)((WMSServiceLayer)value).getWMSLayers().get(0)).getOgcCapabilitiesLayer();
                } else if (value instanceof WMSLayer) {
                    tmpLayer = ((WMSLayer)value).getOgcCapabilitiesLayer();
                }
                if (tmpLayer != null) {
                    boolean rightScale = true;
                    double mxScale = tmpLayer.getScaleDenominationMax();
                    double mnScale = tmpLayer.getScaleDenominationMin();
                    double scale = CismapBroker.getInstance().getMappingComponent().getCurrentOGCScale();
                    if (scale < mnScale || scale > mxScale) {
                        if (!isSelected) {
                            ret.setForeground(Color.GRAY);
                        } else {
                            ret.setForeground(fg);
                        }
                        rightScale = false;
                    }
                }
            }
            catch (Exception e) {
                if (!this.LOG.isDebugEnabled()) break block35;
                this.LOG.debug((Object)"Fehler bei der ScaleHint Verarbeitung.Kein Problem", (Throwable)e);
            }
        }
        return ret;
    }

    private ImageIcon getRightIcon(int type, boolean visible, boolean enabled) {
        Object o = this.icons.get(new IconType(type, visible, enabled));
        if (o != null && o instanceof ImageIcon) {
            return (ImageIcon)o;
        }
        this.LOG.warn((Object)"Icon not found, used default icon.");
        return (ImageIcon)this.icons.get(new IconType(4, true, true));
    }
}

