/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerFilter;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.cismap.commons.rasterservice.MapService;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openide.util.NbBundle;

public class LayerCombobox
extends JComboBox {
    private LayerComboboxModel model;

    public LayerCombobox() {
    }

    public LayerCombobox(ActiveLayerModel layerModel) {
        this(layerModel, null);
    }

    public LayerCombobox(ActiveLayerModel layerModel, ThemeLayerWidget themeLayerWidget) {
        this.model = new LayerComboboxModel(layerModel, themeLayerWidget);
        super.setModel(this.model);
        super.setRenderer(new CustomRenderer());
    }

    private class SingleLayerFilter
    extends DefaultLayerFilter {
        private final Object layer;
        private final int depth;

        public SingleLayerFilter(Object layer, int depth) {
            super(layer.toString());
            super.setIcon(this.getIcon(layer));
            this.layer = layer;
            this.depth = depth;
        }

        @Override
        public boolean isLayerAllowed(MapService layer) {
            return this.layer.equals(layer);
        }

        private Icon getIcon(Object layer) {
            return new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layer.png"));
        }

        public int getDepth() {
            return this.depth;
        }
    }

    private class AllLayersFilter
    extends DefaultLayerFilter {
        public AllLayersFilter() {
            super(NbBundle.getMessage(AllLayersFilter.class, (String)"LayerCombobox.AllLayersFilter"));
        }

        @Override
        public boolean isLayerAllowed(MapService layer) {
            return true;
        }
    }

    private class SelectedLayerFilter
    extends DefaultLayerFilter {
        private final List<MapService> selectedLayer;
        private final ThemeLayerWidget themeLayer;

        public SelectedLayerFilter(ThemeLayerWidget themeLayer) {
            super(NbBundle.getMessage(SelectedLayerFilter.class, (String)"LayerCombobox.SelectedLayerFilter"));
            this.selectedLayer = new ArrayList<MapService>();
            this.themeLayer = themeLayer;
            this.setSelectedLayers();
            themeLayer.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SelectedLayerFilter.this.setSelectedLayers();
                    LayerCombobox.this.model.initModel();
                }
            });
        }

        private void setSelectedLayers() {
            TreePath[] selectionPath = this.themeLayer.getSelectionPath();
            this.selectedLayer.clear();
            if (selectionPath != null) {
                for (TreePath path : selectionPath) {
                    Object o = path.getLastPathComponent();
                    if (!(o instanceof MapService)) continue;
                    this.selectedLayer.add((MapService)o);
                }
            }
        }

        @Override
        public boolean isLayerAllowed(MapService layer) {
            return this.selectedLayer.contains(layer);
        }
    }

    private class SelectableLayersFilter
    extends DefaultLayerFilter {
        private final List<MapService> selectableLayer;
        private final ActiveLayerModel model;

        public SelectableLayersFilter(ActiveLayerModel model) {
            super(NbBundle.getMessage(VisibleLayersFilter.class, (String)"LayerCombobox.SelectableLayersFilter"));
            this.selectableLayer = new ArrayList<MapService>();
            this.model = model;
            this.setSelectableLayerFilterLayer();
            model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    SelectableLayersFilter.this.setSelectableLayerFilterLayer();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    SelectableLayersFilter.this.setSelectableLayerFilterLayer();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    SelectableLayersFilter.this.setSelectableLayerFilterLayer();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    SelectableLayersFilter.this.setSelectableLayerFilterLayer();
                }
            });
        }

        private void setSelectableLayerFilterLayer() {
            TreeMap<Integer, MapService> map = this.model.getMapServices();
            this.selectableLayer.clear();
            for (Integer key : map.keySet()) {
                MapService service = map.get(key);
                if (!(service instanceof AbstractFeatureService) || !((AbstractFeatureService)service).isSelectable()) continue;
                this.selectableLayer.add(service);
            }
        }

        @Override
        public boolean isLayerAllowed(MapService layer) {
            return this.selectableLayer.contains(layer);
        }
    }

    private class VisibleLayersFilter
    extends DefaultLayerFilter {
        private final List<MapService> visibleLayer;
        private final ActiveLayerModel model;

        public VisibleLayersFilter(ActiveLayerModel model) {
            super(NbBundle.getMessage(VisibleLayersFilter.class, (String)"LayerCombobox.VisibleLayersFilter"));
            this.visibleLayer = new ArrayList<MapService>();
            this.model = model;
            this.setVisibleLayerFilterLayer();
            model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    VisibleLayersFilter.this.setVisibleLayerFilterLayer();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    VisibleLayersFilter.this.setVisibleLayerFilterLayer();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    VisibleLayersFilter.this.setVisibleLayerFilterLayer();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    VisibleLayersFilter.this.setVisibleLayerFilterLayer();
                }
            });
        }

        private void setVisibleLayerFilterLayer() {
            TreeMap<Integer, MapService> map = this.model.getMapServices();
            this.visibleLayer.clear();
            for (Integer key : map.keySet()) {
                MapService service = map.get(key);
                if (!service.getPNode().getVisible()) continue;
                this.visibleLayer.add(service);
            }
        }

        @Override
        public boolean isLayerAllowed(MapService layer) {
            return this.visibleLayer.contains(layer);
        }
    }

    private class TopMostLayerFilter
    extends DefaultLayerFilter {
        private MapService topMostLayer;
        private final ActiveLayerModel model;

        public TopMostLayerFilter(ActiveLayerModel model) {
            super(NbBundle.getMessage(TopMostLayerFilter.class, (String)"LayerCombobox.TopMostLayerFilter"));
            this.model = model;
            this.setTopMostLayer();
            model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    TopMostLayerFilter.this.setTopMostLayer();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TopMostLayerFilter.this.setTopMostLayer();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TopMostLayerFilter.this.setTopMostLayer();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    TopMostLayerFilter.this.setTopMostLayer();
                }
            });
        }

        private void setTopMostLayer() {
            TreeMap<Integer, MapService> map = this.model.getMapServices();
            if (!map.keySet().isEmpty()) {
                Integer[] keys = new Integer[map.keySet().size()];
                int i = 0;
                for (Integer key : map.keySet()) {
                    keys[i++] = key;
                }
                Arrays.sort(keys, Collections.reverseOrder());
                this.topMostLayer = map.get(keys[0]);
            } else {
                this.topMostLayer = null;
            }
        }

        @Override
        public boolean isLayerAllowed(MapService layer) {
            if (this.topMostLayer != null) {
                return layer.equals(this.topMostLayer);
            }
            return false;
        }
    }

    private abstract class DefaultLayerFilter
    implements LayerFilter {
        private final String name;
        private Icon icon;

        public DefaultLayerFilter(String name) {
            this.name = name;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.name;
        }
    }

    private class LayerComboboxModel
    extends DefaultComboBoxModel {
        private final ActiveLayerModel layerModel;
        private final ThemeLayerWidget themeLayerWidget;
        private final List<LayerFilter> filter = new ArrayList<LayerFilter>();

        public LayerComboboxModel(ActiveLayerModel layerModel, ThemeLayerWidget themeLayerWidget) {
            this.layerModel = layerModel;
            this.themeLayerWidget = themeLayerWidget;
            layerModel.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    LayerComboboxModel.this.initModel();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    LayerComboboxModel.this.initModel();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    LayerComboboxModel.this.initModel();
                }
            });
            this.initModel();
        }

        private void initModel() {
            ArrayList<LayerFilter> entryList = new ArrayList<LayerFilter>();
            Object selectedObject = this.getSelectedItem();
            if (this.filter.isEmpty()) {
                if (this.themeLayerWidget != null) {
                    this.filter.add(new SelectedLayerFilter(this.themeLayerWidget));
                }
                this.filter.add(new SelectableLayersFilter(this.layerModel));
                this.filter.add(new TopMostLayerFilter(this.layerModel));
                this.filter.add(new VisibleLayersFilter(this.layerModel));
                this.filter.add(new AllLayersFilter());
            }
            for (LayerFilter lf : this.filter) {
                entryList.add(lf);
            }
            TreeMap<Integer, Object> map = this.layerModel.getMapServicesAndCollections();
            Integer[] keys = new Integer[map.keySet().size()];
            int i = 0;
            for (Integer n : map.keySet()) {
                keys[i++] = n;
            }
            Arrays.sort(keys, Collections.reverseOrder());
            for (Integer key : keys) {
                Object layer = map.get(key);
                if (layer instanceof Collection) {
                    entryList.addAll(this.getLayersFromCollection((Collection)layer, 1));
                    continue;
                }
                entryList.add(new SingleLayerFilter(layer, 0));
            }
            this.removeAllElements();
            for (Object e : entryList) {
                this.addElement(e);
            }
            if (entryList.contains(selectedObject)) {
                this.setSelectedItem(selectedObject);
            }
        }

        private List<LayerFilter> getLayersFromCollection(Collection layer, int depth) {
            ArrayList<LayerFilter> entryList = new ArrayList<LayerFilter>();
            entryList.add(new SingleLayerFilter(layer, depth - 1));
            for (Object subLayer : layer) {
                if (subLayer instanceof Collection) {
                    entryList.addAll(this.getLayersFromCollection((Collection)subLayer, depth + 1));
                    continue;
                }
                entryList.add(new SingleLayerFilter(subLayer, depth));
            }
            return entryList;
        }
    }

    private class CustomRenderer
    extends DefaultListCellRenderer {
        private int indent = UIManager.getInt("Tree.leftChildIndent");

        private CustomRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel) {
                DefaultLayerFilter lf;
                JLabel lbl = (JLabel)c;
                if (value instanceof DefaultLayerFilter && (lf = (DefaultLayerFilter)value).getIcon() != null) {
                    lbl.setIcon(lf.getIcon());
                }
                if (value instanceof SingleLayerFilter && ((SingleLayerFilter)(lf = (SingleLayerFilter)value)).getDepth() > 0) {
                    lbl.setBorder(new EmptyBorder(0, ((SingleLayerFilter)lf).getDepth() * this.indent, 0, 0));
                }
            }
            return c;
        }
    }
}

