/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModelWrapperWithoutProgress;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTreeCellRenderer;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ReadOnlyThemeLayerWidget
extends JPanel {
    private Logger log = Logger.getLogger(ThemeLayerWidget.class);
    private ActiveLayerModel layerModel;
    private TreeModel model;
    private Map<Object, Boolean> serviceStateMap = new HashMap<Object, Boolean>();
    private JScrollPane jScrollPane1;
    private JTree tree;

    public ReadOnlyThemeLayerWidget() {
        this.initComponents();
        this.tree.setCellRenderer(new CheckBoxNodeRenderer());
        this.tree.setEditable(false);
    }

    public void setMappingModel(ActiveLayerModel mappingModel) {
        this.setMappingModel(mappingModel, null);
    }

    public void setMappingModel(ActiveLayerModel mappingModel, Class[] classes) {
        this.layerModel = mappingModel;
        this.model = new ActiveLayerModelWrapperWithoutProgress(this.layerModel);
        if (classes != null) {
            this.model = new FilterTreeModelWrapper(this.model, classes);
        }
        this.tree.setModel(this.model);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() == 1) {
                    int x = e.getX();
                    int y = e.getY();
                    TreePath tp = ReadOnlyThemeLayerWidget.this.tree.getPathForLocation(x, y);
                    if (tp != null) {
                        int pathCount = tp.getPathCount() - 1;
                        int minX = pathCount * 20;
                        int maxX = minX + 15;
                        if (x >= minX && x <= maxX) {
                            ReadOnlyThemeLayerWidget.this.changeState(tp.getLastPathComponent(), !ReadOnlyThemeLayerWidget.this.getState(tp.getLastPathComponent()));
                            ReadOnlyThemeLayerWidget.this.tree.repaint();
                        }
                    }
                }
            }
        });
    }

    public List<Object> getSelectedServices() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object key : this.serviceStateMap.keySet()) {
            Boolean selected = this.serviceStateMap.get(key);
            if (!selected.booleanValue()) continue;
            result.add(key);
        }
        return result;
    }

    private void changeState(Object objectToChange, boolean newState) {
        Boolean currentState;
        if (objectToChange.equals(this.model.getRoot())) {
            for (int i = 0; i < this.model.getChildCount(this.model.getRoot()); ++i) {
                this.changeState(this.model.getChild(this.model.getRoot(), i), newState);
            }
        } else if (objectToChange instanceof LayerCollection) {
            LayerCollection lc = (LayerCollection)objectToChange;
            for (int i = 0; i < lc.size(); ++i) {
                this.changeState(lc.get(i), newState);
            }
        } else if (objectToChange instanceof ServiceLayer && (currentState = this.serviceStateMap.get(objectToChange)) != null) {
            this.serviceStateMap.put(objectToChange, newState);
        }
    }

    private boolean getState(Object value) {
        if (value.equals(this.model.getRoot())) {
            boolean isSelected = true;
            for (int i = 0; i < this.model.getChildCount(this.model.getRoot()); ++i) {
                if (this.getState(this.model.getChild(this.model.getRoot(), i))) continue;
                isSelected = false;
            }
            return isSelected;
        }
        if (value instanceof LayerCollection) {
            boolean isSelected = true;
            LayerCollection lc = (LayerCollection)value;
            for (int i = 0; i < lc.size(); ++i) {
                if (this.getState(lc.get(i))) continue;
                isSelected = false;
            }
            return isSelected;
        }
        if (value instanceof ServiceLayer) {
            Boolean state = this.serviceStateMap.get(value);
            if (state == null) {
                state = Boolean.FALSE;
                this.serviceStateMap.put(value, state);
            }
            return state;
        }
        return false;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.tree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private class FilterTreeModelWrapper
    implements TreeModel {
        private TreeModel model;
        private Class[] supportedClasses;

        public FilterTreeModelWrapper(TreeModel model, Class[] supportedClasses) {
            this.model = model;
            this.supportedClasses = supportedClasses;
        }

        @Override
        public Object getRoot() {
            return this.model.getRoot();
        }

        @Override
        public Object getChild(Object parent, int index) {
            int counter = 0;
            for (int i = 0; i < this.model.getChildCount(parent); ++i) {
                Object child = this.model.getChild(parent, i);
                if (!this.isInstanceOfSupportedClass(child)) continue;
                if (counter == index) {
                    return child;
                }
                ++counter;
            }
            ReadOnlyThemeLayerWidget.this.log.error((Object)"No child found. This should never happen.");
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            int counter = 0;
            for (int i = 0; i < this.model.getChildCount(parent); ++i) {
                if (!this.isInstanceOfSupportedClass(this.model.getChild(parent, i))) continue;
                ++counter;
            }
            return counter;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.model.isLeaf(node);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            this.model.valueForPathChanged(path, newValue);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int counter = 0;
            if (parent == null || child == null) {
                return -1;
            }
            for (int i = 0; i < this.model.getChildCount(parent); ++i) {
                Object originChild = this.model.getChild(parent, i);
                if (!this.isInstanceOfSupportedClass(originChild)) continue;
                if (child == originChild) {
                    return counter;
                }
                ++counter;
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.model.addTreeModelListener(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.model.removeTreeModelListener(l);
        }

        private boolean isInstanceOfSupportedClass(Object o) {
            for (Class c : this.supportedClasses) {
                if (!c.isAssignableFrom(o.getClass())) continue;
                return true;
            }
            return false;
        }
    }

    class CheckBoxNodeRenderer
    extends ActiveLayerTreeCellRenderer {
        protected Color selectionBorderColor;
        protected Color selectionForeground;
        protected Color selectionBackground;
        protected Color textForeground;
        protected Color textBackground;
        protected Boolean drawsFocusBorderAroundIcon;
        protected Font fontValue = UIManager.getFont("Tree.font");

        public CheckBoxNodeRenderer() {
            this.drawsFocusBorderAroundIcon = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon");
            this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel lab;
            Object object = ReadOnlyThemeLayerWidget.this.getTreeLock();
            synchronized (object) {
                Component ret = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                JLabel retLab = (JLabel)ret;
                lab = new JLabel(retLab.getText(), retLab.getIcon(), retLab.getHorizontalAlignment());
            }
            JPanel pan = new JPanel();
            JCheckBox leafRenderer = new JCheckBox();
            pan.setLayout(new GridBagLayout());
            if (this.fontValue != null) {
                leafRenderer.setFont(this.fontValue);
            }
            leafRenderer.setFocusPainted(this.drawsFocusBorderAroundIcon != null && this.drawsFocusBorderAroundIcon != false);
            leafRenderer.setEnabled(tree.isEnabled());
            if (selected) {
                leafRenderer.setForeground(this.selectionForeground);
                leafRenderer.setBackground(this.selectionBackground);
                pan.setForeground(this.selectionForeground);
                pan.setBackground(this.selectionBackground);
            } else {
                leafRenderer.setForeground(this.textForeground);
                leafRenderer.setBackground(this.textBackground);
                pan.setForeground(this.textForeground);
                pan.setBackground(this.textBackground);
            }
            if (value instanceof ShapeFileFeatureService && ((ShapeFileFeatureService)value).isFileNotFound()) {
                lab.setForeground(Color.GRAY);
            } else if (value instanceof H2FeatureService && ((H2FeatureService)value).isTableNotFound()) {
                lab.setForeground(Color.GRAY);
            }
            leafRenderer.setSelected(ReadOnlyThemeLayerWidget.this.getState(value));
            pan.add(leafRenderer);
            pan.add(lab);
            pan.doLayout();
            pan.repaint();
            return pan;
        }
    }
}

