/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.GMLFeatureService;
import de.cismet.cismap.commons.featureservice.JDBCFeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.featureservice.factory.GMLFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.JDBCFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.ShapeFeatureFactory;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.rasterservice.ImageRasterService;
import de.cismet.commons.wms.capabilities.Envelope;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ZoomToLayerWorker
extends SwingWorker<Geometry, Geometry> {
    private static final Logger LOG = Logger.getLogger(ZoomToLayerWorker.class);
    private TreePath[] tps;
    private int buffer = 0;

    public ZoomToLayerWorker(TreePath[] tps) {
        this(tps, 0);
    }

    public ZoomToLayerWorker(TreePath[] tps, int buffer) {
        ArrayList<TreePath> tpl = new ArrayList<TreePath>();
        this.buffer = buffer;
        for (TreePath tmp : tps) {
            Object layer = tmp.getLastPathComponent();
            if (layer instanceof LayerCollection) {
                tpl.addAll(this.getAllServices(tmp.getParentPath(), (LayerCollection)layer));
                continue;
            }
            tpl.add(tmp);
        }
        this.tps = tpl.toArray(new TreePath[tpl.size()]);
    }

    private List<TreePath> getAllServices(TreePath parent, LayerCollection lc) {
        ArrayList<TreePath> tpl = new ArrayList<TreePath>();
        TreePath parentWithCollection = parent.pathByAddingChild(lc);
        for (Object o : lc) {
            if (o instanceof LayerCollection) {
                tpl.addAll(this.getAllServices(parentWithCollection, (LayerCollection)o));
                continue;
            }
            if (o == null) continue;
            tpl.add(parentWithCollection.pathByAddingChild(o));
        }
        return tpl;
    }

    @Override
    protected Geometry doInBackground() throws Exception {
        Geometry geom = null;
        for (TreePath path : this.tps) {
            Geometry g = null;
            RetrievalServiceLayer rsl = null;
            if (path != null && path.getLastPathComponent() instanceof RetrievalServiceLayer) {
                rsl = (RetrievalServiceLayer)path.getLastPathComponent();
            } else if (path != null && path.getParentPath().getLastPathComponent() instanceof RetrievalServiceLayer) {
                rsl = (RetrievalServiceLayer)path.getParentPath().getLastPathComponent();
            }
            if (rsl != null) {
                g = ZoomToLayerWorker.getServiceBounds(rsl);
            }
            if (g == null) continue;
            if (geom == null) {
                geom = g.getEnvelope();
                geom.setSRID(g.getSRID());
                continue;
            }
            if (geom.getSRID() != g.getSRID()) {
                g = CrsTransformer.transformToGivenCrs(g, CrsTransformer.createCrsFromSrid(geom.getSRID()));
            }
            Geometry ge = g.getEnvelope();
            ge.setSRID(geom.getSRID());
            geom = geom.union(g);
        }
        return geom;
    }

    public static Geometry getServiceBounds(RetrievalServiceLayer rsl) {
        AbstractFeatureService sffs;
        Object l;
        AbstractFeatureService afs;
        Geometry g = null;
        if (rsl instanceof AbstractFeatureService && !(afs = (AbstractFeatureService)rsl).isInitialized()) {
            try {
                afs.initAndWait();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initialising feature service", (Throwable)e);
            }
        }
        if (rsl instanceof WMSServiceLayer) {
            l = ((WMSServiceLayer)rsl).getLayerInformation();
            Envelope envelope = null;
            if (l != null) {
                envelope = CapabilityWidget.getEnvelopeForWmsLayer((Layer)l);
            } else {
                WMSCapabilities caps = ((WMSServiceLayer)rsl).getWmsCapabilities();
                if (caps != null) {
                    envelope = CapabilityWidget.getEnvelopeForWmsCaps(caps);
                }
            }
            if (envelope != null) {
                g = CapabilityWidget.createGeometryFromEnvelope(envelope);
            }
        } else if (rsl instanceof WebFeatureService) {
            l = (WebFeatureService)rsl;
            Envelope envelope = CapabilityWidget.getEnvelopeFromFeatureType(((WebFeatureService)l).getFeature());
            if (envelope != null) {
                g = CapabilityWidget.createGeometryFromEnvelope(envelope);
            }
        } else if (rsl instanceof SlidableWMSServiceLayerGroup) {
            Envelope envelope;
            l = ((SlidableWMSServiceLayerGroup)rsl).getLayerInformation();
            if (l != null && (envelope = CapabilityWidget.getEnvelopeForWmsLayer((Layer)l)) != null) {
                g = CapabilityWidget.createGeometryFromEnvelope(envelope);
            }
        } else if (rsl instanceof SimpleWMS) {
            Envelope envelope;
            SimpleWMS wms = (SimpleWMS)rsl;
            Layer l2 = wms.getLayerInformation();
            if (l2 != null && (envelope = CapabilityWidget.getEnvelopeForWmsLayer(l2)) != null) {
                g = CapabilityWidget.createGeometryFromEnvelope(envelope);
            }
        } else if (rsl instanceof ShapeFileFeatureService) {
            sffs = (ShapeFileFeatureService)rsl;
            g = ((ShapeFeatureFactory)sffs.getFeatureFactory()).getEnvelope();
        } else if (rsl instanceof JDBCFeatureService) {
            sffs = (JDBCFeatureService)rsl;
            g = ((JDBCFeatureFactory)sffs.getFeatureFactory()).getEnvelope();
        } else if (rsl.getClass().getName().equals("de.cismet.cismap.cidslayer.CidsLayer")) {
            try {
                Method getFeatureFactory = rsl.getClass().getMethod("getFeatureFactory", new Class[0]);
                Object o = getFeatureFactory.invoke((Object)rsl, new Object[0]);
                Method getEnvelope = o.getClass().getMethod("getEnvelope", new Class[0]);
                getEnvelope.setAccessible(true);
                g = (Geometry)getEnvelope.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while getting the envelope.", (Throwable)e);
            }
        } else if (rsl instanceof GMLFeatureService) {
            sffs = (GMLFeatureService)rsl;
            g = ((GMLFeatureFactory)sffs.getFeatureFactory()).getEnvelope();
        } else if (rsl instanceof ImageRasterService) {
            ImageRasterService irs = (ImageRasterService)rsl;
            g = irs.getEnvelope();
        }
        return g;
    }

    @Override
    protected void done() {
        try {
            Geometry geom = (Geometry)this.get();
            if (geom != null) {
                XBoundingBox boundingBox = new XBoundingBox(geom);
                if (this.buffer != 0) {
                    boundingBox.increase(this.buffer);
                }
                CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory(boundingBox);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while zooming to extend", (Throwable)e);
        }
    }
}

