/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget.test;

import de.cismet.cismap.commons.gui.layerwidget.test.CArrowImage;
import de.cismet.cismap.commons.gui.layerwidget.test.CTransferableTreePath;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openide.util.NbBundle;

public class CTree
extends JTree
implements DragSourceListener,
DragGestureListener,
Autoscroll,
TreeModelListener {
    private static final int AUTOSCROLL_MARGIN = 12;
    private TreePath _pathSource;
    private BufferedImage _imgGhost;
    private Point _ptOffset = new Point();

    public CTree() {
        this.putClientProperty("JTree.lineStyle", "Angled");
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        DropTarget dropTarget = new DropTarget(this, new CDropTargetListener());
        dropTarget.setDefaultActions(3);
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        CTree tree = new CTree();
        tree.setPreferredSize(new Dimension(300, 300));
        JScrollPane scrollPane = new JScrollPane(tree);
        JFrame frame = new JFrame(NbBundle.getMessage(CTree.class, (String)"CTree.main(String[]).frame.title"));
        frame.getContentPane().add((Component)scrollPane, "Center");
        frame.pack();
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimFrame = frame.getSize();
        frame.setLocation((dimScreen.width - dimFrame.width) / 2, (dimScreen.height - dimFrame.height) / 2);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.show();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point ptDragOrigin = e.getDragOrigin();
        TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
        if (path == null) {
            return;
        }
        if (this.isRootPath(path)) {
            return;
        }
        Rectangle raPath = this.getPathBounds(path);
        this._ptOffset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        JLabel lbl = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
        lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
        this._imgGhost = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
        Graphics2D g2 = this._imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        lbl.paint(g2);
        Icon icon = lbl.getIcon();
        int nStartOfText = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
        g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
        g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        g2.fillRect(nStartOfText, 0, this.getWidth(), this._imgGhost.getHeight());
        g2.dispose();
        this.setSelectionPath(path);
        System.out.println("DRAGGING: " + path.getLastPathComponent());
        CTransferableTreePath transferable = new CTransferableTreePath(path);
        this._pathSource = path;
        e.startDrag(null, this._imgGhost, new Point(5, 5), transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        int nAction;
        if (e.getDropSuccess() && (nAction = e.getDropAction()) == 2) {
            System.out.println("REMOVING: " + this._pathSource.getLastPathComponent());
            this._pathSource = null;
        }
    }

    @Override
    public void autoscroll(Point pt) {
        int nRow = this.getRowForLocation(pt.x, pt.y);
        if (nRow < 0) {
            return;
        }
        Rectangle raOuter = this.getBounds();
        nRow = pt.y + raOuter.y <= 12 ? (nRow <= 0 ? 0 : nRow - 1) : (nRow < this.getRowCount() - 1 ? nRow + 1 : nRow);
        this.scrollRowToVisible(nRow);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle raOuter = this.getBounds();
        Rectangle raInner = this.getParent().getBounds();
        return new Insets(raInner.y - raOuter.y + 12, raInner.x - raOuter.x + 12, raOuter.height - raInner.height - raInner.y + raOuter.y + 12, raOuter.width - raInner.width - raInner.x + raOuter.x + 12);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        System.out.println("treeNodesChanged");
        this.sayWhat(e);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        System.out.println("treeNodesInserted ");
        this.sayWhat(e);
        int nChildIndex = e.getChildIndices()[0];
        TreePath pathParent = e.getTreePath();
        this.setSelectionPath(this.getChildPath(pathParent, nChildIndex));
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        System.out.println("treeNodesRemoved ");
        this.sayWhat(e);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        System.out.println("treeStructureChanged ");
        this.sayWhat(e);
    }

    private TreePath getChildPath(TreePath pathParent, int nChildIndex) {
        TreeModel model = this.getModel();
        return pathParent.pathByAddingChild(model.getChild(pathParent.getLastPathComponent(), nChildIndex));
    }

    private boolean isRootPath(TreePath path) {
        return this.isRootVisible() && this.getRowForPath(path) == 0;
    }

    private void sayWhat(TreeModelEvent e) {
        System.out.println(e.getTreePath().getLastPathComponent());
        int[] nIndex = e.getChildIndices();
        for (int i = 0; i < nIndex.length; ++i) {
            System.out.println(i + ". " + nIndex[i]);
        }
    }

    class CDropTargetListener
    implements DropTargetListener {
        private TreePath _pathLast = null;
        private Rectangle2D _raCueLine = new Rectangle2D.Float();
        private Rectangle2D _raGhost = new Rectangle2D.Float();
        private Color _colorCueLine;
        private Point _ptLast = new Point();
        private Timer _timerHover;
        private int _nLeftRight = 0;
        private BufferedImage _imgRight = new CArrowImage(15, 15, 3);
        private BufferedImage _imgLeft = new CArrowImage(15, 15, 2);
        private int _nShift = 0;

        public CDropTargetListener() {
            this._colorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
            this._timerHover = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CDropTargetListener.this._nLeftRight = 0;
                    if (CTree.this.isRootPath(CDropTargetListener.this._pathLast)) {
                        return;
                    }
                    if (CTree.this.isExpanded(CDropTargetListener.this._pathLast)) {
                        CTree.this.collapsePath(CDropTargetListener.this._pathLast);
                    } else {
                        CTree.this.expandPath(CDropTargetListener.this._pathLast);
                    }
                }
            });
            this._timerHover.setRepeats(false);
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            if (!DragSource.isDragImageSupported()) {
                CTree.this.repaint(this._raGhost.getBounds());
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            Point pt = e.getLocation();
            if (pt.equals(this._ptLast)) {
                return;
            }
            int nDeltaLeftRight = pt.x - this._ptLast.x;
            if (this._nLeftRight > 0 && nDeltaLeftRight < 0 || this._nLeftRight < 0 && nDeltaLeftRight > 0) {
                this._nLeftRight = 0;
            }
            this._nLeftRight += nDeltaLeftRight;
            this._ptLast = pt;
            Graphics2D g2 = (Graphics2D)CTree.this.getGraphics();
            if (!DragSource.isDragImageSupported()) {
                CTree.this.paintImmediately(this._raGhost.getBounds());
                this._raGhost.setRect(pt.x - ((CTree)CTree.this)._ptOffset.x, pt.y - ((CTree)CTree.this)._ptOffset.y, CTree.this._imgGhost.getWidth(), CTree.this._imgGhost.getHeight());
                g2.drawImage(CTree.this._imgGhost, AffineTransform.getTranslateInstance(this._raGhost.getX(), this._raGhost.getY()), null);
            } else {
                CTree.this.paintImmediately(this._raCueLine.getBounds());
            }
            TreePath path = CTree.this.getClosestPathForLocation(pt.x, pt.y);
            if (path != this._pathLast) {
                this._nLeftRight = 0;
                this._pathLast = path;
                this._timerHover.restart();
            }
            Rectangle raPath = CTree.this.getPathBounds(path);
            this._raCueLine.setRect(0.0, raPath.y + (int)raPath.getHeight(), CTree.this.getWidth(), 2.0);
            g2.setColor(this._colorCueLine);
            g2.fill(this._raCueLine);
            if (this._nLeftRight > 20) {
                g2.drawImage(this._imgRight, AffineTransform.getTranslateInstance(pt.x - ((CTree)CTree.this)._ptOffset.x, pt.y - ((CTree)CTree.this)._ptOffset.y), null);
                this._nShift = 1;
            } else if (this._nLeftRight < -20) {
                g2.drawImage(this._imgLeft, AffineTransform.getTranslateInstance(pt.x - ((CTree)CTree.this)._ptOffset.x, pt.y - ((CTree)CTree.this)._ptOffset.y), null);
                this._nShift = -1;
            } else {
                this._nShift = 0;
            }
            this._raGhost = this._raGhost.createUnion(this._raCueLine);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            this._timerHover.stop();
            if (!this.isDropAcceptable(e)) {
                e.rejectDrop();
                return;
            }
            e.acceptDrop(e.getDropAction());
            Transferable transferable = e.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = e.getLocation();
                    TreePath pathTarget = CTree.this.getClosestPathForLocation(pt.x, pt.y);
                    TreePath pathSource = (TreePath)transferable.getTransferData(flavor);
                    System.out.println("DROPPING: " + pathSource.getLastPathComponent());
                    TreeModel model = CTree.this.getModel();
                    TreePath pathNewChild = null;
                    if (pathNewChild == null) break;
                    CTree.this.setSelectionPath(pathNewChild);
                    break;
                }
                catch (UnsupportedFlavorException ufe) {
                    System.out.println(ufe);
                    e.dropComplete(false);
                    return;
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    e.dropComplete(false);
                    return;
                }
            }
            e.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            if ((e.getDropAction() & 3) == 0) {
                return false;
            }
            return e.isDataFlavorSupported(CTransferableTreePath.TREEPATH_FLAVOR);
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            if ((e.getDropAction() & 3) == 0) {
                return false;
            }
            return e.isDataFlavorSupported(CTransferableTreePath.TREEPATH_FLAVOR);
        }
    }
}

