/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.LinearReferencedPointInfoPanel;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateLinearReferencedMarksListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import pswing.PSwing;

public class LinearReferencedPointMarkPHandle
extends PPath {
    private static final Logger LOG = Logger.getLogger(LinearReferencedPointMarkPHandle.class);
    public static final double DEFAULT_HANDLE_SIZE = 8.0;
    public static final Shape DEFAULT_HANDLE_SHAPE = new Ellipse2D.Double(0.0, 0.0, 8.0, 8.0);
    public static final Color DEFAULT_COLOR = Color.BLUE;
    private PLocator locator;
    private MappingComponent mc = null;
    private LinearReferencedPointInfoPanel measurementPanel;
    private CreateLinearReferencedMarksListener measurementListener;
    private PSwing pswingComp;

    public LinearReferencedPointMarkPHandle(PLocator locator, CreateLinearReferencedMarksListener listener, MappingComponent mc) {
        super(DEFAULT_HANDLE_SHAPE);
        this.mc = mc;
        this.locator = locator;
        this.measurementListener = listener;
        this.installEventListener();
        this.setPaint(DEFAULT_COLOR);
        this.installHandleEventHandlers();
        this.startResizeBounds();
        this.initPanel();
        this.relocateHandle();
    }

    public void setInfoPanelTransparency(float zeroToOne) {
        this.pswingComp.setTransparency(zeroToOne);
    }

    private void installEventListener() {
        PBasicInputEventHandler moveAndClickListener = new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                LinearReferencedPointMarkPHandle.this.handleClicked(pInputEvent);
            }

            public void mouseEntered(PInputEvent pInputEvent) {
                LinearReferencedPointMarkPHandle.this.measurementListener.getPLayer().removeChild((PNode)LinearReferencedPointMarkPHandle.this);
                LinearReferencedPointMarkPHandle.this.measurementListener.getPLayer().addChild((PNode)LinearReferencedPointMarkPHandle.this);
            }
        };
        this.addInputEventListener((PInputEventListener)moveAndClickListener);
    }

    private void handleClicked(PInputEvent pInputEvent) {
        if (pInputEvent.isRightMouseButton()) {
            MouseEvent swingEvent = (MouseEvent)pInputEvent.getSourceSwingEvent();
            this.measurementListener.setSelectedMark(this);
            this.measurementListener.getContextMenu().show(this.pswingComp.getComponent(), swingEvent.getX(), swingEvent.getY());
        }
    }

    private void initPanel() {
        this.measurementPanel = new LinearReferencedPointInfoPanel();
        this.pswingComp = new PSwing(this.mc, this.measurementPanel);
        this.measurementPanel.setPNodeParent(this.pswingComp);
        this.addChild(this.pswingComp);
    }

    public void setMarkPosition(double mark) {
        String info = new DecimalFormat("0.00").format(mark);
        this.measurementPanel.setLengthInfo(info);
        this.relocateHandle();
        this.repaint();
    }

    protected void installHandleEventHandlers() {
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinearReferencedPointMarkPHandle.this.relocateHandle();
            }
        });
    }

    public PLocator getLocator() {
        return this.locator;
    }

    public void setLocator(PLocator locator) {
        this.locator = locator;
        this.invalidatePaint();
        this.relocateHandle();
    }

    public void setParent(PNode newParent) {
        super.setParent(newParent);
        this.relocateHandle();
    }

    public void parentBoundsChanged() {
        this.relocateHandle();
    }

    public void relocateHandle() {
        if (this.locator != null) {
            PBounds b = this.getBoundsReference();
            Point2D aPoint = this.locator.locatePoint(null);
            this.mc.getCamera().viewToLocal(aPoint);
            double newCenterX = aPoint.getX();
            double newCenterY = aPoint.getY();
            this.pswingComp.setOffset(newCenterX + 8.0, newCenterY - this.pswingComp.getHeight() / 2.0);
            if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
                this.setBounds(0.0, 0.0, 8.0, 8.0);
                this.centerBoundsOnPoint(newCenterX, newCenterY);
            }
        }
    }
}

