/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import Sirius.util.collections.MultiMap;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.AnnotatedFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.DrawingFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureRenderer;
import de.cismet.cismap.commons.features.FeatureRendererAwareFeature;
import de.cismet.cismap.commons.features.FeatureSimplifier;
import de.cismet.cismap.commons.features.Highlightable;
import de.cismet.cismap.commons.features.InfoNodeAwareFeature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.RasterDocumentFeature;
import de.cismet.cismap.commons.features.RequestForRotatingPivotLock;
import de.cismet.cismap.commons.features.SLDStyledFeature;
import de.cismet.cismap.commons.features.ScaleAwareFeatureRenderer;
import de.cismet.cismap.commons.features.Selectable;
import de.cismet.cismap.commons.features.SplittedNewFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.CustomSelectionStyleFeature;
import de.cismet.cismap.commons.gui.piccolo.EllipsePHandle;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.InfoPanel;
import de.cismet.cismap.commons.gui.piccolo.LinearReferencedPointPHandle;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import de.cismet.cismap.commons.gui.piccolo.PSticky;
import de.cismet.cismap.commons.gui.piccolo.PaintWrapper;
import de.cismet.cismap.commons.gui.piccolo.ParentNodeIsAPFeature;
import de.cismet.cismap.commons.gui.piccolo.PivotPHandle;
import de.cismet.cismap.commons.gui.piccolo.RotationPHandle;
import de.cismet.cismap.commons.gui.piccolo.SelectionAwareTexturePaint;
import de.cismet.cismap.commons.gui.piccolo.ShowAlsoOnPolygons;
import de.cismet.cismap.commons.gui.piccolo.TransformationPHandle;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DrawSelectionFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.HandleAddAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.HandleDeleteAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CurrentStackTrace;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import pswing.PSwing;

public class PFeature
extends PPath
implements Highlightable,
Selectable,
Refreshable {
    private static final Logger LOG = Logger.getLogger(PFeature.class);
    private static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final Stroke FIXED_WIDTH_STROKE = new FixedWidthStroke();
    private static ImageIcon pushpinIco = new ImageIcon(PFeature.class.getResource("/de/cismet/cismap/commons/gui/res/pushpin.png"));
    private static ImageIcon pushpinSelectedIco = new ImageIcon(PFeature.class.getResource("/de/cismet/cismap/commons/gui/res/pushpinSelected.png"));
    private static final Map<String, SoftReference<Image>> IMAGE_CACHE = Collections.synchronizedMap(new HashMap());
    public ArrayList<PPath> sldStyledPolygon = new ArrayList();
    public ArrayList<PTextWithDisplacement> sldStyledText = new ArrayList();
    public ArrayList<PImage> sldStyledImage = new ArrayList();
    public ArrayList<PImage> sldStyledSelectedImage = new ArrayList();
    ArrayList splitHandlesBetween = new ArrayList();
    PHandle splitLineAtHandle = null;
    PHandle splitPolygonFromHandle = null;
    PHandle splitPolygonToHandle = null;
    PHandle ellipseHandle = null;
    PFeature selectedOriginal = null;
    PPath splitPolygonLine;
    Point2D lineSplitPoint = null;
    List<Point2D> splitPoints = new ArrayList<Point2D>();
    Image origin = null;
    private Feature feature;
    private WorldToScreenTransform wtst;
    private double x_offset = 0.0;
    private double y_offset = 0.0;
    private PNode stickyChild = null;
    private PNode secondStickyChild = null;
    private PNode infoNode = null;
    private Point2D mid = null;
    private PHandle pivotHandle = null;
    private boolean selected = false;
    private Paint nonSelectedPaint = null;
    private boolean highlighted = false;
    private Paint nonHighlightingPaint = null;
    private Coordinate[][][] entityRingCoordArr = null;
    private float[][][] entityRingXArr = null;
    private float[][][] entityRingYArr = null;
    private MappingComponent viewer;
    private Stroke stroke = null;
    private Paint strokePaint = null;
    private boolean ignoreStickyFeature = false;
    private InfoPanel infoPanel;
    private JComponent infoComponent;
    private PSwing pswingComp;
    private PText primaryAnnotation = null;
    private FeatureAnnotationSymbol pi = null;
    private FeatureAnnotationSymbol piSelected;
    private boolean snappable = true;
    private int selectedEntity = -1;
    private boolean selectedPiEdited = false;
    private boolean wasSelected = false;
    private transient PImage rdfImage;
    private PropertyChangeListener annotationListener;
    private TexturePaintPropertyChangeListener tPropertyChange;

    public PFeature(Feature feature, MappingComponent viewer) {
        this(feature, viewer.getWtst(), 0.0, 0.0, viewer);
    }

    public PFeature(Feature feature, WorldToScreenTransform wtst, double x_offset, double y_offset, MappingComponent viewer) {
        this(feature, wtst, x_offset, y_offset, viewer, false);
    }

    @Deprecated
    public PFeature(Point2D[] canvasPoints, WorldToScreenTransform wtst, double x_offset, double y_offset, MappingComponent viewer) {
        this(new PureNewFeature(canvasPoints, wtst), wtst, 0.0, 0.0, viewer);
    }

    @Deprecated
    public PFeature(Coordinate[] coordArr, WorldToScreenTransform wtst, double x_offset, double y_offset, MappingComponent viewer) {
        this(new PureNewFeature(coordArr, wtst), wtst, 0.0, 0.0, viewer);
    }

    @Deprecated
    public PFeature(Feature feature, WorldToScreenTransform wtst, double x_offset, double y_offset, final MappingComponent viewer, boolean ignoreStickyfeature) {
        try {
            this.setFeature(feature);
            this.ignoreStickyFeature = ignoreStickyfeature;
            this.wtst = wtst;
            this.x_offset = 0.0;
            this.y_offset = 0.0;
            this.viewer = viewer;
            this.visualize();
            this.addInfoNode();
            this.refreshDesign();
            FeatureRenderer renderer = this.getFeatureRenderer();
            if (feature instanceof StyledFeature && ((StyledFeature)feature).getFillingPaint() instanceof SelectionAwareTexturePaint) {
                this.tPropertyChange = new TexturePaintPropertyChangeListener();
                viewer.getCamera().addPropertyChangeListener("viewTransform", (PropertyChangeListener)this.tPropertyChange);
            }
            if (renderer instanceof ScaleAwareFeatureRenderer && viewer != null && viewer.getCamera() != null) {
                viewer.getCamera().addPropertyChangeListener("viewTransform", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (!PFeature.this.drawFeature()) {
                            if (PFeature.this.pi != null) {
                                viewer.removeStickyNode(PFeature.this.pi);
                            }
                            if (PFeature.this.piSelected != null) {
                                viewer.removeStickyNode(PFeature.this.piSelected);
                            }
                            if (PFeature.this.stickyChild instanceof PSticky) {
                                viewer.removeStickyNode((PSticky)PFeature.this.stickyChild);
                            }
                            PFeature.this.removeAllChildren();
                        }
                        PFeature.this.visualize();
                    }
                });
            }
            this.stroke = this.getStroke();
            this.strokePaint = this.getStrokePaint();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error in constructor of PFeature", t);
        }
    }

    public PNode getPrimaryAnnotationNode() {
        return this.primaryAnnotation;
    }

    public PBounds boundsFromRectPolygonGeom(Geometry g) {
        Polygon poly;
        if (g instanceof Polygon && (poly = (Polygon)g).isRectangle()) {
            Coordinate[] coords = poly.getCoordinates();
            Coordinate first = coords[0];
            PBounds b = new PBounds();
            double x1 = first.x;
            double x2 = first.x;
            double y1 = first.y;
            double y2 = first.y;
            for (int i = 0; i < coords.length; ++i) {
                Coordinate c = coords[i];
                if (c.x < x1) {
                    x1 = c.x;
                }
                if (c.x > x2) {
                    x2 = c.x;
                }
                if (c.y < y1) {
                    y1 = c.y;
                }
                if (!(c.y > y1)) continue;
                y2 = c.y;
            }
            return new PBounds(this.wtst.getScreenX(x1), this.wtst.getScreenY(y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
        }
        throw new IllegalArgumentException("Geometry is not a rectangle polygon!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visualize() {
        FeatureSimplifier simplifier;
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"visualize()", (Throwable)new CurrentStackTrace());
        }
        Geometry geom = null;
        geom = this.feature instanceof DefaultFeatureServiceFeature ? ((simplifier = ((DefaultFeatureServiceFeature)this.feature).getLayerProperties().getFeatureSimplifier()) != null ? CrsTransformer.transformToGivenCrs(simplifier.simplify(this.feature), this.getViewerCrs().getCode()) : CrsTransformer.transformToGivenCrs(this.feature.getGeometry(), this.getViewerCrs().getCode())) : CrsTransformer.transformToGivenCrs(this.feature.getGeometry(), this.getViewerCrs().getCode());
        if (this.feature instanceof RasterDocumentFeature) {
            block22: {
                RasterDocumentFeature rdf = (RasterDocumentFeature)this.feature;
                try {
                    PBounds bounds = this.boundsFromRectPolygonGeom(geom);
                    PImage pImage = new PImage((Image)rdf.getRasterDocument());
                    PFeature pFeature = this;
                    synchronized (pFeature) {
                        if (this.rdfImage != null && this.indexOfChild((PNode)this.rdfImage) != -1) {
                            this.removeChild((PNode)this.rdfImage);
                        }
                        this.rdfImage = pImage;
                    }
                    pImage.setBounds((Rectangle2D)bounds);
                    this.addChild((PNode)pImage);
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isInfoEnabled()) break block22;
                    LOG.info((Object)"rasterdocumentfeature is no rectangle, we'll draw the geometry without raster image", (Throwable)e);
                }
            }
            this.doGeometry(geom);
        } else {
            this.doGeometry(geom);
            if (this.feature instanceof StyledFeature) {
                if (this.pi == null || this.pi != null && this.pi.equals(((StyledFeature)this.feature).getPointAnnotationSymbol())) {
                    this.setFeatureAnnotationSymbols();
                } else if (this.pi != null && this.getFeature() != null && this.getFeature() instanceof StyledFeature && ((StyledFeature)this.getFeature()).getPointAnnotationSymbol() != null) {
                    FeatureAnnotationSymbol piOrig = ((StyledFeature)this.getFeature()).getPointAnnotationSymbol();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("newSweetSpotx: " + piOrig.getSweetSpotX()));
                    }
                    double sweetSpotX = piOrig.getSweetSpotX();
                    double sweetSpotY = piOrig.getSweetSpotY();
                    if (piOrig.getSelectedFeatureAnnotationSymbol() == null) {
                        double sweetX = (10.0 + (double)piOrig.getImage().getWidth(null) * sweetSpotX) / (double)this.piSelected.getImage().getWidth(null);
                        double sweetY = (10.0 + (double)piOrig.getImage().getHeight(null) * sweetSpotY) / (double)this.piSelected.getImage().getHeight(null);
                        this.pi.setImage(piOrig.getImage());
                        this.pi.setSweetSpotX(sweetX);
                        this.pi.setSweetSpotY(sweetY);
                        this.piSelected.setImage(this.highlightImageAsSelected(piOrig.getImage(), new Color(0.3f, 0.3f, 1.0f, 0.4f), new Color(0.2f, 0.2f, 1.0f, 0.8f), 10));
                        this.piSelected.setSweetSpotX(sweetX);
                        this.piSelected.setSweetSpotY(sweetY);
                    } else {
                        this.pi.setImage(piOrig.getImage());
                        this.pi.setSweetSpotX(piOrig.getSweetSpotX());
                        this.pi.setSweetSpotY(piOrig.getSweetSpotY());
                        this.piSelected.setImage(piOrig.getSelectedFeatureAnnotationSymbol().getImage());
                        this.piSelected.setSweetSpotX(piOrig.getSweetSpotX());
                        this.piSelected.setSweetSpotY(piOrig.getSweetSpotY());
                    }
                }
            } else if (this.pi == null) {
                this.setFeatureAnnotationSymbols();
            }
            if (geom instanceof Polygon) {
                if (this.pi instanceof ShowAlsoOnPolygons) {
                    Point p = ((Polygon)geom).getInteriorPoint();
                    this.addAnnotation(p.getX(), p.getY());
                }
            } else if (!(geom instanceof LineString || geom instanceof MultiLineString || geom instanceof MultiPolygon || !(geom instanceof Point) && !(geom instanceof MultiPoint))) {
                this.addAnnotation(this.entityRingCoordArr[0][0][0].x, this.entityRingCoordArr[0][0][0].y);
            }
            this.setSelected(this.isSelected());
        }
    }

    private void setFeatureAnnotationSymbols() {
        FeatureAnnotationSymbol piOrig = null;
        if (!this.drawFeature()) {
            return;
        }
        if (this.getFeature() instanceof StyledFeature) {
            piOrig = ((StyledFeature)this.getFeature()).getPointAnnotationSymbol();
        }
        if (piOrig == null || piOrig.getImage() == null) {
            this.pi = new FeatureAnnotationSymbol(pushpinIco.getImage());
            this.piSelected = new FeatureAnnotationSymbol(pushpinSelectedIco.getImage());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No PointAnnotationSymbol found use PushPinIcons");
            }
            this.pi.setSweetSpotX(0.46);
            this.pi.setSweetSpotY(0.9);
            this.piSelected.setSweetSpotX(0.46);
            this.piSelected.setSweetSpotY(0.9);
        } else {
            Image iconImage;
            double sweetSpotX = ((StyledFeature)this.getFeature()).getPointAnnotationSymbol().getSweetSpotX();
            double sweetSpotY = ((StyledFeature)this.getFeature()).getPointAnnotationSymbol().getSweetSpotY();
            if (piOrig != null && piOrig.getSelectedFeatureAnnotationSymbol() == null) {
                if (!this.selectedPiEdited) {
                    this.selectedPiEdited = true;
                    iconImage = piOrig.getImage();
                    this.piSelected = new FeatureAnnotationSymbol(this.highlightImageAsSelected(iconImage, new Color(0.3f, 0.3f, 1.0f, 0.4f), new Color(0.2f, 0.2f, 1.0f, 0.8f), 10));
                    double sweetX = (10.0 + (double)piOrig.getImage().getWidth(null) * sweetSpotX) / (double)this.piSelected.getImage().getWidth(null);
                    double sweetY = (10.0 + (double)piOrig.getImage().getHeight(null) * sweetSpotY) / (double)this.piSelected.getImage().getHeight(null);
                    this.piSelected.setSweetSpotX(sweetX);
                    this.piSelected.setSweetSpotY(sweetY);
                }
            } else {
                this.piSelected = piOrig.getSelectedFeatureAnnotationSymbol();
            }
            if (this.pi == null) {
                this.pi = new FeatureAnnotationSymbol();
                iconImage = piOrig.getImage();
                BufferedImage img = new BufferedImage(iconImage.getWidth(null), iconImage.getHeight(null), 2);
                Graphics g = img.getGraphics();
                g.drawImage(iconImage, 0, 0, null);
                if (piOrig.getSelectedFeatureAnnotationSymbol() == null) {
                    this.pi.setImage(this.highlightImageAsSelected(img, TRANSPARENT, TRANSPARENT, 10));
                    double sweetX = (10.0 + (double)piOrig.getImage().getWidth(null) * sweetSpotX) / (double)this.piSelected.getImage().getWidth(null);
                    double sweetY = (10.0 + (double)piOrig.getImage().getHeight(null) * sweetSpotY) / (double)this.piSelected.getImage().getHeight(null);
                    this.pi.setSweetSpotX(sweetX);
                    this.pi.setSweetSpotY(sweetY);
                } else {
                    this.pi.setImage(img);
                    this.pi.setSweetSpotX(piOrig.getSweetSpotX());
                    this.pi.setSweetSpotY(piOrig.getSweetSpotY());
                }
            }
            this.pi.setSelectedFeatureAnnotationSymbol(this.piSelected);
        }
        if (this.annotationListener != null && this.pi != null) {
            this.pi.addPropertyChangeListener(this.annotationListener);
        }
        if (this.annotationListener != null && this.piSelected != null) {
            this.piSelected.addPropertyChangeListener(this.annotationListener);
        }
    }

    private void addAnnotation(double real_x, double real_y) {
        if (!this.drawFeature()) {
            return;
        }
        if (!this.ignoreStickyFeature && this.drawFeature()) {
            this.viewer.addStickyNode(this.pi);
            this.viewer.addStickyNode(this.piSelected);
        }
        if (this.stickyChild == null) {
            this.stickyChild = this.pi;
        } else if (this.stickyChild instanceof StickyPText) {
            this.secondStickyChild = this.pi;
        }
        this.addChild((PNode)this.piSelected);
        this.piSelected.setOffset(this.wtst.getScreenX(real_x), this.wtst.getScreenY(real_y));
        this.addChild((PNode)this.pi);
        this.pi.setOffset(this.wtst.getScreenX(real_x), this.wtst.getScreenY(real_y));
    }

    public boolean duplicateCoordinate(int entityPosition, int ringPosition, int coordPosition) {
        Coordinate[] origCoordArr = this.entityRingCoordArr[entityPosition][ringPosition];
        float[] origXArr = this.entityRingXArr[entityPosition][ringPosition];
        float[] origYArr = this.entityRingYArr[entityPosition][ringPosition];
        Geometry geometry = this.getFeature().getGeometry();
        if (geometry instanceof Polygon && origCoordArr != null && origCoordArr.length - 1 > coordPosition || geometry instanceof LineString && origCoordArr != null && origCoordArr.length > coordPosition && origCoordArr.length > 2) {
            int i;
            Coordinate[] newCoordArr = new Coordinate[origCoordArr.length + 1];
            float[] newXArr = new float[origXArr.length + 1];
            float[] newYArr = new float[origYArr.length + 1];
            for (i = 0; i <= coordPosition; ++i) {
                newCoordArr[i] = origCoordArr[i];
                newXArr[i] = origXArr[i];
                newYArr[i] = origYArr[i];
            }
            newCoordArr[coordPosition + 1] = (Coordinate)origCoordArr[coordPosition].clone();
            newXArr[coordPosition + 1] = origXArr[coordPosition];
            newYArr[coordPosition + 1] = origYArr[coordPosition];
            for (i = coordPosition + 1; i < origCoordArr.length; ++i) {
                newCoordArr[i + 1] = origCoordArr[i];
                newXArr[i + 1] = origXArr[i];
                newYArr[i + 1] = origYArr[i];
            }
            if (coordPosition == 0 && geometry instanceof Polygon) {
                newCoordArr[newCoordArr.length - 1] = newCoordArr[0];
                newXArr[newXArr.length - 1] = newXArr[0];
                newYArr[newXArr.length - 1] = newYArr[0];
            }
            return this.setNewCoordinates(entityPosition, ringPosition, newXArr, newYArr, newCoordArr);
        }
        return false;
    }

    public Object clone() {
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"clone()", (Throwable)new CurrentStackTrace());
        }
        PFeature p = new PFeature(this.feature, this.wtst, this.x_offset, this.y_offset, this.viewer);
        p.splitPolygonFromHandle = this.splitPolygonFromHandle;
        p.splitPolygonToHandle = this.splitPolygonToHandle;
        return p;
    }

    private static Point createPoint(Coordinate coord, GeometryFactory geometryFactory) {
        return geometryFactory.createPoint(coord);
    }

    private static MultiPoint createMultiPoint(Coordinate[] coordArray, GeometryFactory geometryFactory) {
        return geometryFactory.createMultiPoint(coordArray);
    }

    private static LineString createLineString(Coordinate[] coordArray, GeometryFactory geometryFactory) {
        return geometryFactory.createLineString(coordArray);
    }

    private static Polygon createPolygon(Coordinate[][] ringCoordArray, GeometryFactory geometryFactory) {
        LinearRing shell = geometryFactory.createLinearRing(ringCoordArray[0]);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int ringIndex = 1; ringIndex < ringCoordArray.length; ++ringIndex) {
            LinearRing holeShell = geometryFactory.createLinearRing(ringCoordArray[ringIndex]);
            holes.add(holeShell);
        }
        Polygon polygon = geometryFactory.createPolygon(shell, holes.toArray(new LinearRing[0]));
        return polygon;
    }

    public void syncGeometry() {
        try {
            if (this.getFeature().isEditable()) {
                GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(this.getViewerCrs().getCode()));
                if (this.getFeature().getGeometry() instanceof MultiPolygon || this.getFeature().getGeometry() instanceof Polygon && this.entityRingCoordArr.length > 1) {
                    ArrayList<Polygon> polygons = new ArrayList<Polygon>(this.entityRingCoordArr.length);
                    for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
                        Polygon polygon = PFeature.createPolygon(this.entityRingCoordArr[entityIndex], geometryFactory);
                        polygons.add(polygon);
                    }
                    MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(polygons.toArray(new Polygon[0]));
                    this.assignSynchronizedGeometry((Geometry)multiPolygon);
                } else if (this.getFeature().getGeometry() instanceof MultiPoint) {
                    MultiPoint multiPoint = geometryFactory.createMultiPoint(this.entityRingCoordArr[0][0]);
                    this.assignSynchronizedGeometry((Geometry)multiPoint);
                } else {
                    boolean isSingle;
                    boolean bl = isSingle = this.entityRingCoordArr.length == 1;
                    if (isSingle) {
                        if (this.entityRingCoordArr[0][0] == null) {
                            LOG.warn((Object)"coordArr==null");
                        } else {
                            boolean isLineString;
                            boolean isPoint = this.entityRingCoordArr[0][0].length == 1;
                            boolean isPolygon = this.entityRingCoordArr[0][0].length > 3 && this.entityRingCoordArr[0][0][0].equals((Object)this.entityRingCoordArr[0][0][this.entityRingCoordArr[0][0].length - 1]);
                            boolean bl2 = isLineString = !isPoint && (!isPolygon || this.getFeature().getGeometry() instanceof LineString);
                            if (isPoint) {
                                this.assignSynchronizedGeometry((Geometry)PFeature.createPoint(this.entityRingCoordArr[0][0][0], geometryFactory));
                            } else if (isLineString) {
                                this.assignSynchronizedGeometry((Geometry)PFeature.createLineString(this.entityRingCoordArr[0][0], geometryFactory));
                            } else if (isPolygon) {
                                this.assignSynchronizedGeometry((Geometry)PFeature.createPolygon(this.entityRingCoordArr[0], geometryFactory));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while synchronising PFeature with feature.", (Throwable)e);
        }
    }

    private void assignSynchronizedGeometry(Geometry newGeom) {
        Geometry oldGeom = this.feature.getGeometry();
        String oldCrs = CrsTransformer.createCrsFromSrid(oldGeom.getSRID());
        String newCrs = CrsTransformer.createCrsFromSrid(newGeom.getSRID());
        if (newGeom.getSRID() == oldGeom.getSRID() || CrsTransformer.isDefaultCrs(oldCrs) && CrsTransformer.isDefaultCrs(newCrs)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"feature and pfeature geometry differ, but have the same crs and will be synchronized.");
            }
            if (CrsTransformer.isDefaultCrs(newCrs)) {
                newGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            }
            this.feature.setGeometry(newGeom);
        } else {
            try {
                CrsTransformer transformer = new CrsTransformer(newCrs);
                Geometry oldGeomWithNewSrid = transformer.transformGeometry(oldGeom, oldCrs);
                if (!oldGeomWithNewSrid.equalsExact(newGeom)) {
                    CrsTransformer reverseTransformer = new CrsTransformer(oldCrs);
                    Geometry newGeomWithOldSrid = reverseTransformer.fastTransformGeometry(newGeom, newCrs);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"feature and pfeature geometry differ and will be synchronized.");
                    }
                    if (CrsTransformer.isDefaultCrs(oldCrs)) {
                        newGeomWithOldSrid.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                    }
                    this.feature.setGeometry(newGeomWithOldSrid);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"feature and pfeature geometry do not differ.");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot synchronize feature.", (Throwable)e);
            }
        }
    }

    private void doGeometry(Geometry geom) {
        this.entityRingCoordArr = this.getCoordinateArray(geom);
        if (geom != null && this.drawFeature()) {
            this.updateXpAndYp();
            this.updatePath();
        } else {
            this.entityRingXArr = null;
            this.entityRingYArr = null;
            this.getPathReference().reset();
        }
        this.refreshDesign();
        this.syncGeometry();
    }

    private boolean drawFeature() {
        FeatureRenderer renderer = this.getFeatureRenderer();
        if (renderer instanceof ScaleAwareFeatureRenderer) {
            double scale;
            int minScale = ((ScaleAwareFeatureRenderer)((Object)renderer)).getMinScale();
            int maxScale = ((ScaleAwareFeatureRenderer)((Object)renderer)).getMaxScale();
            return (double)maxScale <= (scale = this.viewer.getScaleDenominator()) && (double)minScale >= scale;
        }
        return true;
    }

    private FeatureRenderer getFeatureRenderer() {
        if (this.feature instanceof FeatureRendererAwareFeature) {
            FeatureRenderer renderer = ((FeatureRendererAwareFeature)((Object)this.feature)).getFeatureRenderer();
            if (renderer == null) {
                renderer = ((FeatureRendererAwareFeature)((Object)this.feature)).getParentFeatureRenderer();
            }
            return renderer;
        }
        return null;
    }

    private Coordinate[][][] getCoordinateArray(Geometry geom) {
        Coordinate[][][] otherCoords;
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    otherCoords = null;
                                    if (!(geom instanceof Point)) break block5;
                                    Point point = (Point)geom;
                                    otherCoords = new Coordinate[][][]{{{point.getCoordinate()}}};
                                    break block6;
                                }
                                if (!(geom instanceof LineString)) break block7;
                                LineString lineString = (LineString)geom;
                                otherCoords = new Coordinate[][][]{{lineString.getCoordinates()}};
                                break block6;
                            }
                            if (!(geom instanceof Polygon)) break block8;
                            Polygon polygon = (Polygon)geom;
                            int numOfHoles = polygon.getNumInteriorRing();
                            otherCoords = new Coordinate[1][1 + numOfHoles][];
                            otherCoords[0][0] = polygon.getExteriorRing().getCoordinates();
                            for (int ringIndex = 1; ringIndex < otherCoords[0].length; ++ringIndex) {
                                otherCoords[0][ringIndex] = polygon.getInteriorRingN(ringIndex - 1).getCoordinates();
                            }
                            break block6;
                        }
                        if (geom instanceof LinearRing) break block6;
                        if (!(geom instanceof MultiPoint)) break block9;
                        otherCoords = new Coordinate[][][]{{((MultiPoint)geom).getCoordinates()}};
                        break block6;
                    }
                    if (!(geom instanceof MultiLineString)) break block10;
                    MultiLineString multiLineString = (MultiLineString)geom;
                    int numOfGeoms = multiLineString.getNumGeometries();
                    otherCoords = new Coordinate[numOfGeoms][][];
                    for (int entityIndex = 0; entityIndex < numOfGeoms; ++entityIndex) {
                        Coordinate[] coordSubArr = ((LineString)multiLineString.getGeometryN(entityIndex)).getCoordinates();
                        otherCoords[entityIndex] = new Coordinate[][]{coordSubArr};
                    }
                    break block6;
                }
                if (!(geom instanceof MultiPolygon)) break block11;
                MultiPolygon multiPolygon = (MultiPolygon)geom;
                int numOfEntities = multiPolygon.getNumGeometries();
                otherCoords = new Coordinate[numOfEntities][][];
                for (int entityIndex = 0; entityIndex < numOfEntities; ++entityIndex) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(entityIndex);
                    int numOfHoles = polygon.getNumInteriorRing();
                    otherCoords[entityIndex] = new Coordinate[1 + numOfHoles][];
                    otherCoords[entityIndex][0] = polygon.getExteriorRing().getCoordinates();
                    for (int ringIndex = 1; ringIndex < otherCoords[entityIndex].length; ++ringIndex) {
                        otherCoords[entityIndex][ringIndex] = polygon.getInteriorRingN(ringIndex - 1).getCoordinates();
                    }
                }
                break block6;
            }
            if (!(geom instanceof GeometryCollection)) break block6;
            GeometryCollection gc = (GeometryCollection)geom;
            int numOfGeoms = gc.getNumGeometries();
            otherCoords = new Coordinate[numOfGeoms][][];
            for (int entityIndex = 0; entityIndex < numOfGeoms; ++entityIndex) {
                Coordinate[][][] coordSubArr = this.getCoordinateArray(gc.getGeometryN(entityIndex));
                otherCoords[entityIndex] = coordSubArr[0];
            }
        }
        return otherCoords;
    }

    public boolean hasSameGeometry(Geometry geom) {
        Coordinate[][][] otherCoords = this.getCoordinateArray(geom);
        return Arrays.deepEquals((Object[])otherCoords, (Object[])this.entityRingCoordArr);
    }

    private void updateXpAndYp() {
        this.entityRingXArr = new float[this.entityRingCoordArr.length][][];
        this.entityRingYArr = new float[this.entityRingCoordArr.length][][];
        for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
            this.entityRingXArr[entityIndex] = new float[this.entityRingCoordArr[entityIndex].length][];
            this.entityRingYArr[entityIndex] = new float[this.entityRingCoordArr[entityIndex].length][];
            for (int ringIndex = 0; ringIndex < this.entityRingCoordArr[entityIndex].length; ++ringIndex) {
                Coordinate[] transformedCoordArr = this.transformCoordinateArr(this.entityRingCoordArr[entityIndex][ringIndex]);
                int length = transformedCoordArr.length;
                this.entityRingXArr[entityIndex][ringIndex] = new float[length];
                this.entityRingYArr[entityIndex][ringIndex] = new float[length];
                for (int coordIndex = 0; coordIndex < length; ++coordIndex) {
                    this.entityRingXArr[entityIndex][ringIndex][coordIndex] = (float)transformedCoordArr[coordIndex].x;
                    this.entityRingYArr[entityIndex][ringIndex][coordIndex] = (float)transformedCoordArr[coordIndex].y;
                }
            }
        }
    }

    public Coordinate[] getCoordArr(int entityPosition, int ringPosition) {
        return this.entityRingCoordArr[entityPosition][ringPosition];
    }

    public float[] getXp(int entityPosition, int ringPosition) {
        return this.entityRingXArr[entityPosition][ringPosition];
    }

    public float[] getYp(int entityPosition, int ringPosition) {
        return this.entityRingYArr[entityPosition][ringPosition];
    }

    private void addLinearRing(Coordinate[] coordinateArr) {
        Coordinate[] points = this.transformCoordinateArr(coordinateArr);
        GeneralPath gp = new GeneralPath();
        gp.reset();
        if (points.length > 0) {
            gp.moveTo((float)points[0].x, (float)points[0].y);
            for (int i = 1; i < points.length; ++i) {
                gp.lineTo((float)points[i].x, (float)points[i].y);
            }
        }
        this.getPathReference().append(gp, false);
    }

    private Coordinate[] transformCoordinateArr(Coordinate[] coordinateArr) {
        Coordinate[] points = new Coordinate[coordinateArr.length];
        for (int i = 0; i < coordinateArr.length; ++i) {
            points[i] = new Coordinate();
            if (this.wtst == null) {
                points[i].x = (float)(coordinateArr[i].x + this.x_offset);
                points[i].y = (float)(coordinateArr[i].y + this.y_offset);
                continue;
            }
            points[i].x = (float)(this.wtst.getDestX(coordinateArr[i].x) + this.x_offset);
            points[i].y = (float)(this.wtst.getDestY(coordinateArr[i].y) + this.y_offset);
        }
        return points;
    }

    public void refreshDesign() {
        if (this.primaryAnnotation != null) {
            if (this.indexOfChild((PNode)this.primaryAnnotation) != -1) {
                this.removeChild((PNode)this.primaryAnnotation);
            }
            this.viewer.removeStickyNode((StickyPText)this.primaryAnnotation);
        }
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"refreshDesign()", (Throwable)new CurrentStackTrace());
        }
        if (this.getFeature().isHidden() && !this.getFeature().isEditable()) {
            this.setStroke(null);
            this.setPaint(null);
        } else {
            Stroke overridingstroke = null;
            if (this.getFeature() instanceof XStyledFeature) {
                XStyledFeature xsf = (XStyledFeature)this.getFeature();
                overridingstroke = xsf.getLineStyle();
            }
            if (this.getFeature() instanceof RasterDocumentFeature) {
                overridingstroke = FIXED_WIDTH_STROKE;
            }
            if (this.getFeature() instanceof StyledFeature && overridingstroke == null) {
                StyledFeature sf = (StyledFeature)this.getFeature();
                if (sf.getLineWidth() <= 1) {
                    this.setStroke(FIXED_WIDTH_STROKE);
                } else {
                    CustomFixedWidthStroke old = new CustomFixedWidthStroke(sf.getLineWidth(), this.viewer);
                    this.setStroke(old);
                }
                if (sf.getLinePaint() == null) {
                    this.setStroke(null);
                }
            }
            if (overridingstroke != null) {
                this.setStroke(overridingstroke);
            }
            if (this.getFeature().getGeometry() instanceof LineString || this.getFeature().getGeometry() instanceof MultiLineString) {
                Paint linePaint;
                if (this.feature instanceof StyledFeature && (linePaint = ((StyledFeature)this.feature).getLinePaint()) != null) {
                    this.setStrokePaint(linePaint);
                }
            } else if (this.feature instanceof StyledFeature) {
                Paint paint = ((StyledFeature)this.feature).getFillingPaint();
                Paint linePaint = ((StyledFeature)this.feature).getLinePaint();
                if (paint != null) {
                    if (paint instanceof SelectionAwareTexturePaint) {
                        ((SelectionAwareTexturePaint)paint).setScale(this.viewer.getCamera().getViewScale(), CrsTransformer.transformToGivenCrs(this.feature.getGeometry(), this.getViewerCrs().getCode()));
                        this.setPaint(((SelectionAwareTexturePaint)paint).getPaint());
                    } else if (paint instanceof PaintWrapper) {
                        this.setPaint(((PaintWrapper)((Object)paint)).getPaint());
                    } else {
                        this.setPaint(paint);
                    }
                    this.nonHighlightingPaint = paint;
                }
                if (linePaint != null) {
                    this.setStrokePaint(linePaint);
                }
            }
            if (this.feature instanceof SLDStyledFeature) {
                ((SLDStyledFeature)this.feature).applyStyle(this, this.wtst);
                this.nonHighlightingPaint = this.getPaint();
            }
            this.stroke = this.getStroke();
            this.strokePaint = this.getStrokePaint();
            this.setSelected(this.isSelected());
            if (this.feature instanceof AnnotatedFeature && ((AnnotatedFeature)((Object)this.feature)).isPrimaryAnnotationVisible() && ((AnnotatedFeature)((Object)this.feature)).getPrimaryAnnotation() != null && this.drawFeature()) {
                final AnnotatedFeature af = (AnnotatedFeature)((Object)this.feature);
                this.primaryAnnotation = new StickyPText(" " + af.getPrimaryAnnotation() + " ");
                this.primaryAnnotation.setJustification(af.getPrimaryAnnotationJustification());
                if (af.isAutoscale() && !(this.getFeature().getGeometry() instanceof Point)) {
                    this.stickyChild = this.primaryAnnotation;
                }
                this.viewer.getCamera().addPropertyChangeListener("viewTransform", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        PFeature.this.setVisibility(PFeature.this.primaryAnnotation, af);
                    }
                });
                if (af.getPrimaryAnnotationPaint() != null) {
                    this.primaryAnnotation.setTextPaint(af.getPrimaryAnnotationPaint());
                } else {
                    this.primaryAnnotation.setTextPaint((Paint)Color.BLACK);
                }
                if (af.getPrimaryAnnotationHalo() != null) {
                    this.primaryAnnotation.setPaint((Paint)af.getPrimaryAnnotationHalo());
                }
                if (af.getPrimaryAnnotationScaling() > 0.0) {
                    this.primaryAnnotation.setScale(af.getPrimaryAnnotationScaling());
                }
                if (af.getPrimaryAnnotationFont() != null) {
                    this.primaryAnnotation.setFont(af.getPrimaryAnnotationFont());
                }
                boolean vis = this.primaryAnnotation.getVisible();
                Point intPoint = CrsTransformer.transformToGivenCrs(this.feature.getGeometry(), this.getViewerCrs().getCode()).getInteriorPoint();
                if (this.stickyChild != null && (double)af.getPrimaryAnnotationJustification() == 0.0 && this.getFeature().getGeometry() instanceof Point && this.annotationListener == null) {
                    this.annotationListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            PFeature.this.justifyAnnotations((PNode)evt.getSource(), af.isAutoscale());
                        }
                    };
                    if (this.primaryAnnotation != this.stickyChild) {
                        this.stickyChild.addPropertyChangeListener("fullBounds", this.annotationListener);
                    }
                    if (this.pi != null) {
                        this.pi.addPropertyChangeListener("fullBounds", this.annotationListener);
                    }
                    if (this.piSelected != null) {
                        this.piSelected.addPropertyChangeListener("fullBounds", this.annotationListener);
                    }
                }
                this.primaryAnnotation.setOffset(this.wtst.getScreenX(intPoint.getX()), this.wtst.getScreenY(intPoint.getY()));
                this.addChild((PNode)this.primaryAnnotation);
                if (!this.ignoreStickyFeature && af.isAutoscale()) {
                    this.viewer.addStickyNode((StickyPText)this.primaryAnnotation);
                    this.viewer.rescaleStickyNode((StickyPText)this.primaryAnnotation);
                }
                this.setVisibility(this.primaryAnnotation, af);
            }
        }
    }

    private void justifyAnnotations(PNode source, boolean autoScale) {
        if (this.primaryAnnotation != null && source != null) {
            Point intPoint = CrsTransformer.transformToGivenCrs(this.feature.getGeometry(), this.getViewerCrs().getCode()).getInteriorPoint();
            PBounds bounds = source.getFullBoundsReference();
            if (autoScale) {
                this.primaryAnnotation.setScale(source.getScale());
            }
            if (this.feature instanceof DrawingFeature) {
                this.primaryAnnotation.setOffset(this.wtst.getScreenX(intPoint.getX()), this.wtst.getScreenY(intPoint.getY()));
            } else {
                this.primaryAnnotation.setOffset(this.wtst.getScreenX(intPoint.getX()) + bounds.getWidth() / 2.0, this.wtst.getScreenY(intPoint.getY()) - bounds.getHeight() / 2.0);
            }
        }
    }

    private void setVisibility(PText ptext, AnnotatedFeature af) {
        double denom = this.viewer.getScaleDenominator();
        if (af.getMaxScaleDenominator() == null || af.getMinScaleDenominator() == null || (double)af.getMaxScaleDenominator().intValue() > denom && (double)af.getMinScaleDenominator().intValue() < denom) {
            ptext.setVisible(true);
        } else {
            ptext.setVisible(false);
        }
    }

    public void insertCoordinate(int entityPosition, int ringPosition, int coordPosition, float newValueX, float newValueY) {
        this.insertCoordinate(entityPosition, ringPosition, coordPosition, newValueX, newValueY, true);
    }

    public void insertCoordinate(int entityPosition, int ringPosition, int coordPosition, float newValueX, float newValueY, boolean addUndo) {
        this.insertCoordinateToPosition(entityPosition, ringPosition, coordPosition, newValueX, newValueY, addUndo);
        if (this.viewer.isSnappingEnabled() && (this.getFeature().getGeometry() instanceof LineString || this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon)) {
            float[] xp = this.getXp(entityPosition, ringPosition);
            float[] yp = this.getYp(entityPosition, ringPosition);
            LineSegment segment = coordPosition > 0 ? new LineSegment((double)xp[coordPosition - 1], (double)yp[coordPosition - 1], (double)xp[coordPosition + 1], (double)yp[coordPosition + 1]) : new LineSegment((double)xp[xp.length - 1], (double)yp[yp.length - 1], (double)xp[1], (double)yp[1]);
            for (Feature otherFeature : this.viewer.getFeatureCollection().getAllFeatures()) {
                Geometry geometry;
                PFeature otherPFeature = this.viewer.getPFeatureHM().get(otherFeature);
                if (otherPFeature == null || !otherPFeature.getFeature().isEditable() || !((geometry = otherPFeature.getFeature().getGeometry()) instanceof Polygon) && !(geometry instanceof LineString) && !(geometry instanceof MultiPolygon)) continue;
                for (int entityIndex = 0; entityIndex < otherPFeature.getNumOfEntities(); ++entityIndex) {
                    for (int ringIndex = 0; ringIndex < otherPFeature.getNumOfRings(entityIndex); ++ringIndex) {
                        float[] otherXp = otherPFeature.getXp(entityIndex, ringIndex);
                        float[] otherYp = otherPFeature.getYp(entityIndex, ringIndex);
                        for (int coordIndex = otherXp.length - 1; coordIndex > 0; --coordIndex) {
                            LineSegment otherSegment = new LineSegment((double)otherXp[coordIndex - 1], (double)otherYp[coordIndex - 1], (double)otherXp[coordIndex], (double)otherYp[coordIndex]);
                            if (!otherSegment.equalsTopo(segment)) continue;
                            otherPFeature.insertCoordinateToPosition(entityIndex, ringIndex, coordIndex, newValueX, newValueY, addUndo);
                        }
                    }
                }
            }
        }
    }

    private boolean insertCoordinateToPosition(int entityPosition, int ringPosition, int coordPosition, float newValueX, float newValueY, boolean addUndo) {
        Coordinate[] originalCoordArr = this.entityRingCoordArr[entityPosition][ringPosition];
        float[] originalXArr = this.entityRingXArr[entityPosition][ringPosition];
        float[] originalYArr = this.entityRingYArr[entityPosition][ringPosition];
        if ((this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) && originalXArr != null && originalXArr.length - 1 >= coordPosition || this.getFeature().getGeometry() instanceof LineString && originalXArr != null && originalXArr.length > coordPosition && originalXArr.length >= 2) {
            int i;
            Coordinate[] newCoordArr = new Coordinate[originalCoordArr.length + 1];
            float[] newXArr = new float[originalXArr.length + 1];
            float[] newYArr = new float[originalYArr.length + 1];
            for (i = 0; i < coordPosition; ++i) {
                newCoordArr[i] = originalCoordArr[i];
                newXArr[i] = originalXArr[i];
                newYArr[i] = originalYArr[i];
            }
            newCoordArr[coordPosition] = new Coordinate(this.viewer.getWtst().getSourceX(newValueX), this.viewer.getWtst().getSourceY(newValueY));
            newXArr[coordPosition] = newValueX;
            newYArr[coordPosition] = newValueY;
            for (i = coordPosition; i < originalCoordArr.length; ++i) {
                newCoordArr[i + 1] = originalCoordArr[i];
                newXArr[i + 1] = originalXArr[i];
                newYArr[i + 1] = originalYArr[i];
            }
            if ((this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) && (coordPosition == 0 || coordPosition == originalCoordArr.length - 1)) {
                newCoordArr[newCoordArr.length - 1] = newCoordArr[0];
                newXArr[newXArr.length - 1] = newXArr[0];
                newYArr[newYArr.length - 1] = newYArr[0];
            }
            if (this.setNewCoordinates(entityPosition, ringPosition, newXArr, newYArr, newCoordArr)) {
                if (addUndo) {
                    this.viewer.getMemUndo().addAction(new HandleDeleteAction(this.viewer, this.feature, entityPosition, ringPosition, coordPosition, newValueX, newValueY));
                }
                return true;
            }
        }
        return false;
    }

    public void removeCoordinate(int entityPosition, int ringPosition, int coordPosition) {
        this.removeCoordinate(entityPosition, ringPosition, coordPosition, true);
    }

    public boolean removeCoordinate(int entityPosition, int ringPosition, int coordPosition, boolean addUndo) {
        Coordinate[] originalCoordArr = this.entityRingCoordArr[entityPosition][ringPosition];
        float[] originalXArr = this.entityRingXArr[entityPosition][ringPosition];
        float[] originalYArr = this.entityRingYArr[entityPosition][ringPosition];
        if ((this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) && originalCoordArr != null && originalCoordArr.length - 1 > coordPosition || this.getFeature().getGeometry() instanceof LineString && originalCoordArr != null && originalCoordArr.length > coordPosition && originalCoordArr.length > 2) {
            Coordinate[] newCoordArr = new Coordinate[originalCoordArr.length - 1];
            float[] newXArr = new float[originalXArr.length - 1];
            float[] newYArr = new float[originalYArr.length - 1];
            for (int i = 0; i < coordPosition; ++i) {
                newCoordArr[i] = originalCoordArr[i];
                newXArr[i] = originalXArr[i];
                newYArr[i] = originalYArr[i];
            }
            float removedX = originalXArr[coordPosition];
            float removedY = originalYArr[coordPosition];
            for (int i = coordPosition; i < newCoordArr.length; ++i) {
                newCoordArr[i] = originalCoordArr[i + 1];
                newXArr[i] = originalXArr[i + 1];
                newYArr[i] = originalYArr[i + 1];
            }
            if (coordPosition == 0 && this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) {
                newCoordArr[newCoordArr.length - 1] = newCoordArr[0];
                newXArr[newXArr.length - 1] = newXArr[0];
                newXArr[newYArr.length - 1] = newYArr[0];
            }
            if (this.setNewCoordinates(entityPosition, ringPosition, newXArr, newYArr, newCoordArr)) {
                if (addUndo) {
                    this.viewer.getMemUndo().addAction(new HandleAddAction(this.viewer, this.getFeature(), entityPosition, ringPosition, coordPosition, removedX, removedY));
                }
                return true;
            }
        }
        return false;
    }

    public void addHandles(PNode handleLayer) {
        if (this.getFeature() instanceof LinearReferencedPointFeature) {
            this.addLinearReferencedPointPHandle(handleLayer);
        } else if (this.getFeature() instanceof AbstractNewFeature && ((AbstractNewFeature)this.getFeature()).getGeometryType() == AbstractNewFeature.geomTypes.ELLIPSE) {
            this.addEllipseHandle(handleLayer);
        } else {
            for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
                for (int ringIndex = 0; ringIndex < this.entityRingCoordArr[entityIndex].length; ++ringIndex) {
                    Coordinate[] coordArr = this.entityRingCoordArr[entityIndex][ringIndex];
                    int length = coordArr.length;
                    Geometry geometry = this.getFeature().getGeometry();
                    if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
                        --length;
                    }
                    for (int coordIndex = 0; coordIndex < length; ++coordIndex) {
                        this.addHandle(handleLayer, entityIndex, ringIndex, coordIndex);
                    }
                }
            }
        }
    }

    public void addHandle(PNode handleLayer, int entityPosition, int ringPosition, int coordPosition) {
        int positionInArray = coordPosition;
        TransformationPHandle h = new TransformationPHandle(this, entityPosition, ringPosition, positionInArray);
        handleLayer.addChild((PNode)h);
        h.addClientProperty("coordinate", this.entityRingCoordArr[entityPosition][ringPosition][coordPosition]);
        h.addClientProperty("coordinate_position_entity", new Integer(entityPosition));
        h.addClientProperty("coordinate_position_ring", new Integer(ringPosition));
        h.addClientProperty("coordinate_position_coord", new Integer(coordPosition));
    }

    public MultiMap checkforGlueCoords(int entityPosition, int ringPosition, int coordPosition) {
        GeometryFactory gf = new GeometryFactory();
        MultiMap glueCoords = new MultiMap();
        List<Feature> allFeatures = this.getViewer().getFeatureCollection().getAllFeatures();
        for (Feature f : allFeatures) {
            if (f.equals(this.getFeature())) continue;
            Geometry fgeo = CrsTransformer.transformToGivenCrs(f.getGeometry(), this.getViewerCrs().getCode());
            Geometry thisGeo = CrsTransformer.transformToGivenCrs(this.getFeature().getGeometry(), this.getViewerCrs().getCode());
            if (!fgeo.buffer(0.01).intersects(thisGeo.buffer(0.01))) continue;
            Coordinate coord = this.entityRingCoordArr[entityPosition][ringPosition][coordPosition];
            Point p = gf.createPoint(coord);
            Coordinate[] ca = fgeo.getCoordinates();
            for (int i = 0; i < ca.length; ++i) {
                Point p2 = gf.createPoint(ca[i]);
                double abstand = p.distance((Geometry)p2);
                if (abstand < 0.01) {
                    glueCoords.put((Object)this.getViewer().getPFeatureHM().get(f), (Object)i);
                    if (!this.viewer.isFeatureDebugging() || !LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("checkforGlueCoords() Abstand kleiner als 1cm: " + abstand + " :: " + f));
                    continue;
                }
                if (!this.viewer.isFeatureDebugging() || !LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("checkforGlueCoords() Abstand: " + abstand));
            }
        }
        return glueCoords;
    }

    public void addRotationHandles(PNode handleLayer) {
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("addRotationHandles(): PFeature:" + this));
        }
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("PivotHandle==" + (Object)((Object)this.pivotHandle)));
        }
        if (this.pivotHandle == null) {
            this.addPivotHandle(handleLayer);
        } else {
            boolean contains = false;
            for (Object o : handleLayer.getChildrenReference()) {
                if (o != this.pivotHandle) continue;
                contains = true;
                break;
            }
            if (!contains) {
                handleLayer.addChild((PNode)this.pivotHandle);
            }
        }
        for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
            for (int ringIndex = 0; ringIndex < this.entityRingCoordArr[entityIndex].length; ++ringIndex) {
                Coordinate[] coordArr = this.entityRingCoordArr[entityIndex][ringIndex];
                int length = coordArr.length;
                Geometry geometry = this.getFeature().getGeometry();
                if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
                    --length;
                }
                for (int coordIndex = 0; coordIndex < length; ++coordIndex) {
                    this.addRotationHandle(handleLayer, entityIndex, ringIndex, coordIndex);
                }
            }
        }
    }

    private void addRotationHandle(PNode handleLayer, int entityPosition, int ringPosition, int coordPosition) {
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("addRotationHandles():add from " + coordPosition + ". RotationHandle"));
        }
        RotationPHandle rotHandle = new RotationPHandle(this, entityPosition, ringPosition, coordPosition, this.mid, this.pivotHandle);
        rotHandle.setPaint(new Color(1.0f, 1.0f, 0.0f, 0.7f));
        handleLayer.addChild((PNode)rotHandle);
        rotHandle.addClientProperty("coordinate", this.entityRingCoordArr[entityPosition][ringPosition][coordPosition]);
        rotHandle.addClientProperty("coordinate_position_entity", new Integer(entityPosition));
        rotHandle.addClientProperty("coordinate_position_ring", new Integer(ringPosition));
        rotHandle.addClientProperty("coordinate_position_coord", new Integer(coordPosition));
    }

    public void addPivotHandle(PNode handleLayer) {
        Collection selArr;
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"addPivotHandle()");
        }
        PBounds allBounds = null;
        if (this.getViewer().getFeatureCollection() instanceof DefaultFeatureCollection) {
            Collection selectedFeatures = this.getViewer().getFeatureCollection().getSelectedFeatures();
            Rectangle2D tmpBounds = this.getBounds().getBounds2D();
            for (Object o : selectedFeatures) {
                PFeature pf = this.getViewer().getPFeatureHM().get(o);
                if (pf == null || selectedFeatures.contains(pf)) continue;
                tmpBounds = pf.getBounds().getBounds2D().createUnion(tmpBounds);
            }
            allBounds = new PBounds(tmpBounds);
        }
        if (allBounds != null && (selArr = this.getViewer().getFeatureCollection().getSelectedFeatures()) != null) {
            PFeature pf;
            for (Object o : selArr) {
                pf = this.getViewer().getPFeatureHM().get(o);
                if (pf != null) {
                    pf.setPivotPoint(allBounds.getCenter2D());
                }
                this.mid = allBounds.getCenter2D();
            }
            if (this.mid != null && !(this.getFeature() instanceof RequestForRotatingPivotLock)) {
                this.pivotHandle = new PivotPHandle(this, this.mid);
                this.pivotHandle.setPaint(new Color(0.0f, 0.0f, 0.0f, 0.6f));
                handleLayer.addChild((PNode)this.pivotHandle);
                for (Object o : selArr) {
                    pf = this.getViewer().getPFeatureHM().get(o);
                    pf.pivotHandle = this.pivotHandle;
                }
            }
        }
    }

    public void addLinearReferencedPointPHandle(PNode handleLayer) {
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"addLinearReferencingHandle()");
        }
        LinearReferencedPointPHandle h = new LinearReferencedPointPHandle(this);
        handleLayer.addChild((PNode)h);
    }

    public void addEllipseHandle(PNode handleLayer) {
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"addEllipseHandle()");
        }
        this.ellipseHandle = new EllipsePHandle(this);
        this.ellipseHandle.setPaint(new Color(0.0f, 0.0f, 0.0f, 0.6f));
        handleLayer.addChild((PNode)this.ellipseHandle);
    }

    public void setPivotPoint(Point2D newPivot) {
        this.mid = newPivot;
    }

    public void rotateAllPoints(double rad, Point2D tempMid) {
        double sin;
        double cos;
        double[][] matrix = new double[2][2];
        if (rad > 0.0) {
            cos = Math.cos(rad);
            sin = Math.sin(rad);
            matrix[0][0] = cos;
            matrix[0][1] = sin * -1.0;
            matrix[1][0] = sin;
            matrix[1][1] = cos;
        } else {
            cos = Math.cos(rad *= -1.0);
            sin = Math.sin(rad);
            matrix[0][0] = cos;
            matrix[0][1] = sin;
            matrix[1][0] = sin * -1.0;
            matrix[1][1] = cos;
        }
        if (tempMid == null) {
            tempMid = this.mid;
        }
        for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
            for (int ringIndex = 0; ringIndex < this.entityRingCoordArr[entityIndex].length; ++ringIndex) {
                for (int coordIndex = this.entityRingCoordArr[entityIndex][ringIndex].length - 1; coordIndex >= 0; --coordIndex) {
                    double dx = (double)this.entityRingXArr[entityIndex][ringIndex][coordIndex] - tempMid.getX();
                    double dy = (double)this.entityRingYArr[entityIndex][ringIndex][coordIndex] - tempMid.getY();
                    float resultX = new Double(tempMid.getX() + (dx * matrix[0][0] + dy * matrix[0][1])).floatValue();
                    float resultY = new Double(tempMid.getY() + (dx * matrix[1][0] + dy * matrix[1][1])).floatValue();
                    this.moveCoordinateToNewPiccoloPosition(entityIndex, ringIndex, coordIndex, resultX, resultY, false);
                }
            }
        }
        this.updatePath();
    }

    public double calculateDrag(PInputEvent event, float x, float y) {
        Point2D mousePos = event.getPosition();
        double[] mv = new double[]{mousePos.getX() - this.mid.getX(), mousePos.getY() - this.mid.getY()};
        double[] hv = new double[]{(double)x - this.mid.getX(), (double)y - this.mid.getY()};
        double cosm = mv[0] / Math.hypot(mv[0], mv[1]);
        double cosh = hv[0] / Math.hypot(hv[0], hv[1]);
        double resH = Math.acos(cosh);
        double resM = Math.acos(cosm);
        double res = 0.0;
        if (mousePos.getY() - this.mid.getY() > 0.0 && (double)y - this.mid.getY() > 0.0) {
            res = resM - resH;
        } else if (mousePos.getY() - this.mid.getY() > 0.0 && (double)y - this.mid.getY() < 0.0) {
            res = resM - resH * -1.0;
        } else if ((double)y - this.mid.getY() < 0.0) {
            res = resH - resM;
        } else if (mousePos.getY() - this.mid.getY() < 0.0 && (double)y - this.mid.getY() > 0.0) {
            res = resH * -1.0 - resM;
        }
        return res;
    }

    public void moveCoordinateToNewPiccoloPosition(int entityPosition, int ringPosition, int coordPosition, float newX, float newY) {
        this.moveCoordinateToNewPiccoloPosition(entityPosition, ringPosition, coordPosition, newX, newY, true);
    }

    public void moveCoordinateToNewPiccoloPosition(int entityPosition, int ringPosition, int coordPosition, float newX, float newY, boolean doUpdatePath) {
        Coordinate[] origCoordArr = this.entityRingCoordArr[entityPosition][ringPosition];
        float[] origXArr = this.entityRingXArr[entityPosition][ringPosition];
        float[] origYArr = this.entityRingYArr[entityPosition][ringPosition];
        Coordinate[] newCoordArr = new Coordinate[origCoordArr.length];
        System.arraycopy(origCoordArr, 0, newCoordArr, 0, newCoordArr.length);
        newCoordArr[coordPosition] = new Coordinate(this.wtst.getSourceX((double)newX - this.x_offset), this.wtst.getSourceY((double)newY - this.y_offset));
        Geometry geometry = this.getFeature().getGeometry();
        if (coordPosition == 0 && (geometry instanceof Polygon || geometry instanceof MultiPolygon)) {
            newCoordArr[origXArr.length - 1] = newCoordArr[0];
        }
        origXArr[coordPosition] = newX;
        origYArr[coordPosition] = newY;
        origCoordArr[coordPosition] = newCoordArr[coordPosition];
        if (coordPosition == 0 && (geometry instanceof Polygon || geometry instanceof MultiPolygon)) {
            origXArr[origXArr.length - 1] = origXArr[0];
            origYArr[origYArr.length - 1] = origYArr[0];
            origCoordArr[origXArr.length - 1] = origCoordArr[0];
        }
        if (doUpdatePath) {
            this.updatePath();
        }
    }

    public boolean moveCoordinate(int entityPosition, int ringPosition, int coordPosition, Coordinate coordinate, boolean doUpdatePath) {
        Coordinate[] origCoordArr = this.entityRingCoordArr[entityPosition][ringPosition];
        Coordinate[] newCoordArr = new Coordinate[origCoordArr.length];
        System.arraycopy(origCoordArr, 0, newCoordArr, 0, newCoordArr.length);
        newCoordArr[coordPosition] = coordinate;
        Geometry geometry = this.getFeature().getGeometry();
        if (coordPosition == 0 && (geometry instanceof Polygon || geometry instanceof MultiPolygon)) {
            newCoordArr[origCoordArr.length - 1] = newCoordArr[0];
        }
        if (this.isValidWithThisCoordinates(entityPosition, ringPosition, newCoordArr)) {
            origCoordArr[coordPosition] = newCoordArr[coordPosition];
            if (coordPosition == 0 && (geometry instanceof Polygon || geometry instanceof MultiPolygon)) {
                origCoordArr[origCoordArr.length - 1] = origCoordArr[0];
            }
            this.updateXpAndYp();
            if (doUpdatePath) {
                this.updatePath();
            }
            return true;
        }
        return false;
    }

    private void resetSplitLine() {
        this.removeAllChildren();
        this.splitPolygonLine = new PPath();
        this.splitPoints = new ArrayList<Point2D>();
        this.splitPoints.add(this.getFirstSplitHandle());
        this.splitPolygonLine.setStroke(FIXED_WIDTH_STROKE);
        this.addChild((PNode)this.splitPolygonLine);
    }

    public void addSplitHandle(PHandle p) {
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"addSplitHandle()");
        }
        if (this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) {
            if (this.splitPolygonFromHandle == p) {
                this.splitPolygonFromHandle = null;
                p.setSelected(false);
            } else if (this.splitPolygonToHandle == p) {
                this.splitPolygonToHandle = null;
                p.setSelected(false);
            } else if (this.splitPolygonFromHandle == null) {
                this.splitPolygonFromHandle = p;
                p.setSelected(true);
                this.resetSplitLine();
                if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("after addSplitHandle: splitPolygonFromHandle=" + (Object)((Object)this.splitPolygonFromHandle)));
                    LOG.debug((Object)("in addSplitHandle this=" + this));
                }
            } else if (this.splitPolygonToHandle == null) {
                this.splitPolygonToHandle = p;
                p.setSelected(true);
                this.splitPoints.add(new Point2D.Double(this.splitPolygonToHandle.getLocator().locateX(), this.splitPolygonToHandle.getLocator().locateY()));
            } else {
                p.setSelected(false);
            }
        } else if (this.getFeature().getGeometry() instanceof LineString) {
            if (this.splitLineAtHandle == p) {
                this.splitLineAtHandle = null;
                p.setSelected(false);
            } else if (this.splitLineAtHandle == null) {
                this.splitLineAtHandle = p;
                p.setSelected(true);
                this.lineSplitPoint = new Point2D.Double(this.splitLineAtHandle.getLocator().locateX(), this.splitLineAtHandle.getLocator().locateY());
            } else {
                p.setSelected(false);
            }
        }
    }

    public Point2D getFirstSplitHandle() {
        if (this.splitPolygonFromHandle != null && this.splitPolygonFromHandle.getClientProperty("coordinate") instanceof Coordinate) {
            Coordinate c = (Coordinate)this.splitPolygonFromHandle.getClientProperty("coordinate");
            Point2D.Double ret = new Point2D.Double(this.splitPolygonFromHandle.getLocator().locateX(), this.splitPolygonFromHandle.getLocator().locateY());
            return ret;
        }
        return null;
    }

    public boolean inSplitProgress() {
        CurrentStackTrace cst = new CurrentStackTrace();
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("splitPolygonFromHandle:" + (Object)((Object)this.splitPolygonFromHandle)), (Throwable)cst);
            LOG.debug((Object)("splitPolygonToHandle:" + (Object)((Object)this.splitPolygonToHandle)), (Throwable)cst);
            LOG.debug((Object)("inSplitProgress=" + (this.splitPolygonFromHandle != null && this.splitPolygonToHandle == null)));
            LOG.debug((Object)("in inSplitProgress this=" + this));
        }
        if (this.getFeature() == null) {
            return false;
        }
        if (this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) {
            return this.splitPolygonFromHandle != null && this.splitPolygonToHandle == null;
        }
        return false;
    }

    public Feature[] split() {
        if (this.isSplittable()) {
            Feature[] splittedFeatureArr = new SplittedNewFeature[2];
            Coordinate[] coordArrOrig = this.entityRingCoordArr[0][0];
            if (this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) {
                Coordinate splitCoord;
                Point2D splitPoint;
                int i;
                Coordinate splitCoord2;
                Point2D splitPoint2;
                int i2;
                boolean swapped;
                int from = (Integer)this.splitPolygonFromHandle.getClientProperty("coordinate_position_coord");
                int to = (Integer)this.splitPolygonToHandle.getClientProperty("coordinate_position_coord");
                this.splitPolygonToHandle = null;
                this.splitPolygonFromHandle = null;
                boolean bl = swapped = from > to;
                if (swapped) {
                    int swap = from;
                    from = to;
                    to = swap;
                }
                if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ErstesPolygon" + (to - from + this.splitPoints.size())));
                }
                Coordinate[] coordArr1 = new Coordinate[to - from + this.splitPoints.size()];
                int counter = 0;
                for (i2 = from; i2 <= to; ++i2) {
                    coordArr1[counter] = (Coordinate)coordArrOrig[i2].clone();
                    ++counter;
                }
                if (swapped) {
                    if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SWAPPED");
                    }
                    for (i2 = 1; i2 < this.splitPoints.size() - 1; ++i2) {
                        splitPoint2 = this.splitPoints.get(i2);
                        coordArr1[counter] = splitCoord2 = new Coordinate(this.wtst.getSourceX(splitPoint2.getX()), this.wtst.getSourceY(splitPoint2.getY()));
                        ++counter;
                    }
                } else {
                    if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"NOT_SWAPPED");
                    }
                    for (i2 = this.splitPoints.size() - 2; i2 > 0; --i2) {
                        splitPoint2 = this.splitPoints.get(i2);
                        coordArr1[counter] = splitCoord2 = new Coordinate(this.wtst.getSourceX(splitPoint2.getX()), this.wtst.getSourceY(splitPoint2.getY()));
                        ++counter;
                    }
                }
                coordArr1[counter] = (Coordinate)coordArrOrig[from].clone();
                Coordinate[] coordArr2 = new Coordinate[coordArrOrig.length - (to - from + 1) + this.splitPoints.size()];
                counter = 0;
                for (i = 0; i <= from; ++i) {
                    coordArr2[counter] = (Coordinate)coordArrOrig[i].clone();
                    ++counter;
                }
                if (swapped) {
                    if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SWAPPED");
                    }
                    for (i = this.splitPoints.size() - 2; i > 0; --i) {
                        splitPoint = this.splitPoints.get(i);
                        coordArr2[counter] = splitCoord = new Coordinate(this.wtst.getSourceX(splitPoint.getX()), this.wtst.getSourceY(splitPoint.getY()));
                        ++counter;
                    }
                } else {
                    if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"NOT_SWAPPED");
                    }
                    for (i = 1; i < this.splitPoints.size() - 1; ++i) {
                        splitPoint = this.splitPoints.get(i);
                        coordArr2[counter] = splitCoord = new Coordinate(this.wtst.getSourceX(splitPoint.getX()), this.wtst.getSourceY(splitPoint.getY()));
                        ++counter;
                    }
                }
                for (i = to; i < coordArrOrig.length; ++i) {
                    coordArr2[counter] = (Coordinate)coordArrOrig[i].clone();
                    ++counter;
                }
                splittedFeatureArr[0] = new SplittedNewFeature(coordArr1, this.wtst, this);
                ((DefaultStyledFeature)splittedFeatureArr[0]).setEditable(true);
                splittedFeatureArr[1] = new SplittedNewFeature(coordArr2, this.wtst, this);
                ((DefaultStyledFeature)splittedFeatureArr[1]).setEditable(true);
            } else if (this.getFeature().getGeometry() instanceof LineString) {
                int at = (Integer)this.splitLineAtHandle.getClientProperty("coordinate_position_coord");
                this.splitLineAtHandle = null;
                Coordinate[] coordArrSplit2 = new Coordinate[coordArrOrig.length - at];
                Coordinate[] coordArrSplit1 = new Coordinate[coordArrOrig.length - coordArrSplit2.length + 1];
                for (int i = 0; i < coordArrOrig.length; ++i) {
                    if (i <= at) {
                        coordArrSplit1[i] = (Coordinate)coordArrOrig[i].clone();
                    }
                    if (i < at) continue;
                    coordArrSplit2[i - at] = (Coordinate)coordArrOrig[i].clone();
                }
                splittedFeatureArr[0] = new SplittedNewFeature(coordArrSplit1, this.wtst, this);
                ((DefaultStyledFeature)splittedFeatureArr[0]).setEditable(true);
                splittedFeatureArr[1] = new SplittedNewFeature(coordArrSplit2, this.wtst, this);
                ((DefaultStyledFeature)splittedFeatureArr[1]).setEditable(true);
            }
            return splittedFeatureArr;
        }
        return null;
    }

    public void moveFeature(PDimension dim) {
        try {
            double scale = this.viewer.getCamera().getViewScale();
            if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scale=" + scale));
            }
            for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
                for (int ringIndex = 0; ringIndex < this.entityRingCoordArr[entityIndex].length; ++ringIndex) {
                    for (int coordIndex = 0; coordIndex < this.entityRingCoordArr[entityIndex][ringIndex].length; ++coordIndex) {
                        Coordinate[] coordArr = this.entityRingCoordArr[entityIndex][ringIndex];
                        float[] xArr = this.entityRingXArr[entityIndex][ringIndex];
                        float[] yArr = this.entityRingYArr[entityIndex][ringIndex];
                        xArr[coordIndex] = xArr[coordIndex] + (float)(dim.getWidth() / (double)((float)scale));
                        yArr[coordIndex] = yArr[coordIndex] + (float)(dim.getHeight() / (double)((float)scale));
                        coordArr[coordIndex].x = this.wtst.getSourceX(xArr[coordIndex]);
                        coordArr[coordIndex].y = this.wtst.getSourceY(yArr[coordIndex]);
                    }
                }
            }
            this.updatePath();
            this.syncGeometry();
            this.resetInfoNodePosition();
            this.visualize();
            this.refreshDesign();
        }
        catch (NullPointerException npe) {
            LOG.warn((Object)"error at moveFeature:", (Throwable)npe);
        }
    }

    public void resetInfoNodePosition() {
        if (this.stickyChild != null) {
            Geometry geom = CrsTransformer.transformToGivenCrs(this.getFeature().getGeometry(), this.getViewerCrs().getCode());
            if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("getFeature().getGeometry():" + geom));
            }
            if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("getFeature().getGeometry().getInteriorPoint().getY():" + geom.getInteriorPoint().getY()));
            }
            this.stickyChild.setOffset(this.wtst.getScreenX(geom.getInteriorPoint().getX()), this.wtst.getScreenY(geom.getInteriorPoint().getY()));
        }
    }

    public void refreshInfoNode() {
        if (this.stickyChild == this.infoNode && this.infoNode != null) {
            this.stickyChild = null;
            if (this.indexOfChild(this.infoNode) != -1) {
                this.removeChild(this.infoNode);
            }
        } else if (this.stickyChild != null && this.infoNode != null && this.stickyChild.indexOfChild(this.infoNode) != -1) {
            this.stickyChild.removeChild(this.infoNode);
        }
        this.addInfoNode();
    }

    @Override
    public void refresh() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"refreshInfoNode");
                }
                PFeature.this.refreshInfoNode();
            }
        });
    }

    public void refreshName() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"refreshInfoNodeName");
        }
        if ((!(this.feature instanceof InfoNodeAwareFeature) || this.feature instanceof InfoNodeAwareFeature && ((InfoNodeAwareFeature)((Object)this.feature)).hasInfoNode()) && this.feature instanceof XStyledFeature && this.infoPanel != null) {
            this.infoPanel.setTitleText(((XStyledFeature)this.feature).getName());
        }
    }

    public void addInfoNode() {
        block17: {
            try {
                if (this.getFeature() instanceof InfoNodeAwareFeature && (!(this.getFeature() instanceof InfoNodeAwareFeature) || !((InfoNodeAwareFeature)((Object)this.getFeature())).hasInfoNode()) || !(this.getFeature() instanceof XStyledFeature)) break block17;
                XStyledFeature xsf = (XStyledFeature)this.getFeature();
                if (this.infoComponent == null) {
                    this.infoComponent = xsf.getInfoComponent(this);
                }
                if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ADD INFONODE3");
                }
                if (this.infoPanel != null) {
                    this.viewer.getSwingWrapper().remove(this.infoPanel);
                }
                this.infoPanel = new InfoPanel(this.infoComponent);
                this.infoPanel.setPfeature(this);
                this.infoPanel.setTitleText(xsf.getName());
                this.infoPanel.setTitleIcon(xsf.getIconImage());
                this.pswingComp = new PSwing(this.viewer, this.infoPanel);
                this.pswingComp.resetBounds();
                this.pswingComp.setOffset(0.0, 0.0);
                final StickyPPath p = new StickyPPath(new Rectangle(0, 0, 1, 1));
                p.setStroke(null);
                p.setPaint(new Color(250, 0, 0, 0));
                p.setStrokePaint(null);
                this.infoPanel.setPNodeParent((PNode)p);
                this.infoPanel.setPSwing(this.pswingComp);
                p.addChild(this.pswingComp);
                this.pswingComp.setOffset(0.0, 0.0);
                if (this.stickyChild != null) {
                    this.stickyChild.addChild((PNode)p);
                    p.setOffset(this.stickyChild.getWidth(), 0.0);
                } else if (this.getFeature().getGeometry() != null) {
                    this.syncGeometry();
                    Geometry geom = CrsTransformer.transformToGivenCrs(this.getFeature().getGeometry(), this.getViewerCrs().getCode());
                    Point interiorPoint = null;
                    try {
                        interiorPoint = geom.getInteriorPoint();
                    }
                    catch (TopologyException e) {
                        LOG.warn((Object)"Interior point of geometry couldn't be calculated. Try to use buffering.");
                    }
                    if (interiorPoint == null) {
                        GeometryFactory factory = new GeometryFactory();
                        GeometryCollection collection = factory.createGeometryCollection(new Geometry[]{geom});
                        Geometry union = collection.buffer(0.0);
                        interiorPoint = union.getInteriorPoint();
                    }
                    p.setOffset(this.wtst.getScreenX(interiorPoint.getX()), this.wtst.getScreenY(interiorPoint.getY()));
                    this.addChild((PNode)p);
                    p.setWidth(this.pswingComp.getWidth());
                    p.setHeight(this.pswingComp.getHeight());
                    this.stickyChild = p;
                    if (!this.ignoreStickyFeature) {
                        this.viewer.addStickyNode(p);
                        this.viewer.rescaleStickyNodes();
                    }
                    if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"addInfoNode()");
                    }
                }
                this.infoNode = p;
                if (this.viewer != null && this.infoNode != null) {
                    this.infoNode.setVisible(this.viewer.isInfoNodesVisible());
                    if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"addInfoNode()");
                    }
                    this.viewer.rescaleStickyNodes();
                    p.setWidth(this.pswingComp.getWidth());
                    p.setHeight(this.pswingComp.getHeight());
                } else if (this.infoNode != null) {
                    this.infoNode.setVisible(false);
                }
                this.pswingComp.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        p.setWidth(PFeature.this.pswingComp.getWidth());
                        p.setHeight(PFeature.this.pswingComp.getHeight());
                    }
                });
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in AddInfoNode", t);
            }
        }
    }

    public void cleanup() {
        if (this.infoPanel != null) {
            this.infoPanel.setVisible(false);
            this.viewer.getSwingWrapper().remove(this.infoPanel);
        }
        this.setVisible(false);
        if (this.tPropertyChange != null && this.viewer != null) {
            this.viewer.getCamera().removePropertyChangeListener("viewTransform", (PropertyChangeListener)this.tPropertyChange);
        }
    }

    public void ensureFullVisibility() {
        PBounds all = this.viewer.getCamera().getViewBounds();
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("getViewBounds()" + all));
        }
        PBounds newBounds = new PBounds();
        newBounds.setRect(this.getFullBounds().createUnion(all.getBounds2D()));
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("getFullBounds()" + this.getFullBounds()));
        }
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("newBounds" + newBounds));
        }
        this.viewer.getCamera().animateViewToCenterBounds(newBounds.getBounds2D(), true, (long)this.viewer.getAnimationDuration());
        this.viewer.refresh();
    }

    public boolean isInfoNodeExpanded() {
        return this.infoPanel != null && this.infoPanel.isExpanded();
    }

    public void setInfoNodeExpanded(boolean expanded) {
        if (this.infoPanel != null) {
            this.infoPanel.setExpanded(expanded, false);
        }
    }

    public void setSelectedOriginal(PFeature selectedOriginal) {
        this.selectedOriginal = selectedOriginal;
    }

    public PFeature getSelectedOriginal() {
        return this.selectedOriginal;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public PPath getSplitLine() {
        return this.splitPolygonLine;
    }

    public List<Point2D> getSplitPoints() {
        return this.splitPoints;
    }

    public boolean isSplittable() {
        if (this.getFeature() == null) {
            return false;
        }
        if (this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) {
            return this.splitPolygonFromHandle != null && this.splitPolygonToHandle != null;
        }
        if (this.getFeature().getGeometry() instanceof LineString) {
            return this.splitLineAtHandle != null;
        }
        return false;
    }

    @Override
    public void setHighlighting(boolean highlighting) {
        boolean highlightingEnabledIfStyledFeature;
        boolean bl = highlightingEnabledIfStyledFeature = this.getFeature() != null && !(this.getFeature() instanceof StyledFeature) || this.getFeature() != null && ((StyledFeature)this.getFeature()).isHighlightingEnabled();
        if (!this.isSelected() && this.getPaint() != null && highlightingEnabledIfStyledFeature) {
            this.highlighted = highlighting;
            if (this.highlighted) {
                if (!(this.nonHighlightingPaint instanceof PaintWrapper)) {
                    this.nonHighlightingPaint = this.getPaint();
                }
                if (this.nonHighlightingPaint instanceof Color) {
                    Color c = (Color)this.nonHighlightingPaint;
                    this.setPaintOnAllFeatures(PFeature.getHighlightingColorFromColor(c));
                } else if (this.nonHighlightingPaint instanceof SelectionAwareTexturePaint) {
                    SelectionAwareTexturePaint texturePaint = (SelectionAwareTexturePaint)this.nonHighlightingPaint;
                    SelectionAwareTexturePaint highlightingPaint = (SelectionAwareTexturePaint)texturePaint.clone();
                    highlightingPaint.setMode(SelectionAwareTexturePaint.SelectionMode.HIGHLIGHTED);
                    this.setPaintOnAllFeatures(highlightingPaint.getPaint());
                } else if (this.nonHighlightingPaint instanceof PaintWrapper) {
                    this.setPaintOnAllFeatures(((PaintWrapper)((Object)this.nonHighlightingPaint)).getPaint());
                } else {
                    this.setPaintOnAllFeatures(new Color(1.0f, 1.0f, 1.0f, 0.6f));
                }
            } else if (this.nonHighlightingPaint instanceof PaintWrapper) {
                this.setPaintOnAllFeatures(((PaintWrapper)((Object)this.nonHighlightingPaint)).getPaint());
            } else {
                this.setPaintOnAllFeatures(this.nonHighlightingPaint);
            }
            this.repaint();
        }
    }

    public static Color getHighlightingColorFromColor(Color c) {
        int red = c.getRed() + 70;
        int green = c.getGreen() + 70;
        int blue = c.getBlue() + 70;
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return new Color(red, green, blue, c.getAlpha());
    }

    public void setPaintOnAllFeatures(Paint newPaint) {
        if (this.feature instanceof SLDStyledFeature) {
            if (this.sldStyledPolygon == null || this.sldStyledPolygon.isEmpty()) {
                super.setPaint(newPaint);
            } else {
                for (int i = 0; i < this.sldStyledPolygon.size(); ++i) {
                    this.sldStyledPolygon.get(i).setPaint(newPaint);
                }
            }
        } else {
            super.setPaint(newPaint);
        }
    }

    public void setStrokeOnAllFeatures(Stroke newStroke) {
        if (this.feature instanceof SLDStyledFeature) {
            if (this.sldStyledPolygon == null || this.sldStyledPolygon.isEmpty()) {
                super.setStroke(newStroke);
            } else {
                for (int i = 0; i < this.sldStyledPolygon.size(); ++i) {
                    this.sldStyledPolygon.get(i).setStroke(this.stroke);
                }
            }
        } else {
            super.setStroke(newStroke);
        }
    }

    @Override
    public boolean getHighlighting() {
        return this.highlighted;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.viewer.isFeatureDebugging() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSelected(" + selected + ")"));
        }
        this.selected = selected;
        this.selectedEntity = -1;
        boolean showSelected = true;
        if (this.getFeature() instanceof DrawSelectionFeature) {
            showSelected = ((DrawSelectionFeature)((Object)this.getFeature())).isDrawingSelection();
        }
        if (showSelected) {
            this.showSelected(selected);
        }
    }

    private void showSelected(boolean selected) {
        this.splitPolygonFromHandle = null;
        this.splitPolygonToHandle = null;
        if (this.selected && !selected) {
            this.pivotHandle = null;
        }
        this.selected = selected;
        if (this.getFeature().getGeometry() instanceof Point) {
            if (this.pi != null && this.piSelected != null) {
                this.piSelected.setVisible(selected);
                this.pi.setVisible(!selected);
                if (this.sldStyledImage != null && this.sldStyledImage.size() > 0) {
                    if (selected) {
                        for (PNode pNode : this.sldStyledImage) {
                            if (this.indexOfChild(pNode) <= -1) continue;
                            this.removeChild(pNode);
                        }
                        for (PNode pNode : this.sldStyledSelectedImage) {
                            this.addChild(pNode);
                        }
                    } else {
                        for (PNode pNode : this.sldStyledSelectedImage) {
                            if (this.indexOfChild(pNode) <= -1) continue;
                            this.removeChild(pNode);
                        }
                        for (PNode pNode : this.sldStyledImage) {
                            this.addChild(pNode);
                        }
                    }
                }
                if (selected) {
                    this.wasSelected = true;
                    if (this.infoNode != null) {
                        if (this.pi.indexOfChild(this.infoNode) != -1) {
                            this.pi.removeChild(this.infoNode);
                        }
                        this.piSelected.removeAllChildren();
                        this.piSelected.addChild(this.infoNode);
                    }
                } else if (this.wasSelected) {
                    this.wasSelected = false;
                    if (this.infoNode != null) {
                        if (this.piSelected.indexOfChild(this.infoNode) != -1) {
                            this.piSelected.removeChild(this.infoNode);
                        }
                        this.pi.addChild(this.infoNode);
                    }
                }
                this.viewer.rescaleStickyNode(this.pi);
                this.viewer.rescaleStickyNode(this.piSelected);
            }
        } else if (this.feature.getGeometry() instanceof LineString || this.feature.getGeometry() instanceof MultiLineString) {
            if (selected) {
                CustomFixedWidthStroke fws = new CustomFixedWidthStroke(5.0f, this.viewer);
                this.setStroke(fws);
                Color color = UIManager.getDefaults().getColor("Cismap.featureSelectionForeground");
                if (color != null) {
                    this.setStrokePaint(color);
                } else {
                    this.setStrokePaint(UIManager.getDefaults().getColor("Table.selectionBackground"));
                }
                this.setPaintOnAllFeatures(null);
            } else {
                this.setStroke(this.stroke);
                this.setStrokePaint(this.strokePaint);
            }
        } else {
            if (this.stroke != null) {
                this.setStroke(this.stroke);
            } else {
                this.setStroke(FIXED_WIDTH_STROKE);
            }
            if (selected) {
                if (this.feature instanceof CustomSelectionStyleFeature) {
                    this.moveToFront();
                    this.setPaint(((CustomSelectionStyleFeature)((Object)this.feature)).getSelectionFillingPaint());
                    this.setStrokePaint(((CustomSelectionStyleFeature)((Object)this.feature)).getSelectionLinePaint());
                    int lineWidth = ((CustomSelectionStyleFeature)((Object)this.feature)).getSelectionLineWidth();
                    if (lineWidth <= 1) {
                        this.setStroke(FIXED_WIDTH_STROKE);
                    } else {
                        CustomFixedWidthStroke customFixedWidthStroke = new CustomFixedWidthStroke(lineWidth, this.viewer);
                        this.setStroke(customFixedWidthStroke);
                    }
                } else {
                    this.nonSelectedPaint = this.getPaint();
                    if (this.nonSelectedPaint instanceof Color && this.nonHighlightingPaint instanceof Color) {
                        Color c = (Color)this.nonHighlightingPaint;
                        if (c != null) {
                            Color selectionColor;
                            Stroke stroke;
                            block44: {
                                stroke = this.getStroke();
                                selectionColor = null;
                                try {
                                    selectionColor = UIManager.getDefaults().getColor("Cismap.featureSelectionForeground");
                                }
                                catch (Exception e) {
                                    if (!LOG.isDebugEnabled()) break block44;
                                    LOG.debug((Object)"Error when getting javax.swing.UIManager.getDefaults().getColor(\"Cismap.featureSelectionForeground\")", (Throwable)e);
                                }
                            }
                            if (selectionColor == null) {
                                selectionColor = UIManager.getDefaults().getColor("Table.selectionBackground");
                            }
                            int red = selectionColor.getRed();
                            int green = selectionColor.getGreen();
                            int blue = selectionColor.getBlue();
                            this.setPaintOnAllFeatures(new Color(red, green, blue, c.getAlpha() / 2));
                            this.setStrokeOnAllFeatures(stroke);
                        }
                    } else if (this.nonHighlightingPaint instanceof SelectionAwareTexturePaint) {
                        SelectionAwareTexturePaint texturePaint = (SelectionAwareTexturePaint)this.nonHighlightingPaint;
                        SelectionAwareTexturePaint selectionAwareTexturePaint = (SelectionAwareTexturePaint)texturePaint.clone();
                        selectionAwareTexturePaint.setMode(SelectionAwareTexturePaint.SelectionMode.SELECTED);
                        this.setPaintOnAllFeatures(selectionAwareTexturePaint.getPaint());
                    } else if (this.nonHighlightingPaint instanceof PaintWrapper) {
                        this.setPaintOnAllFeatures(((PaintWrapper)((Object)this.nonHighlightingPaint)).getPaint());
                    } else {
                        this.setPaintOnAllFeatures(new Color(172, 210, 248, 178));
                    }
                }
            } else if (this.nonHighlightingPaint instanceof PaintWrapper) {
                this.setPaintOnAllFeatures(((PaintWrapper)((Object)this.nonHighlightingPaint)).getPaint());
            } else {
                this.setPaintOnAllFeatures(this.nonHighlightingPaint);
            }
        }
        this.repaint();
    }

    public void setStroke(Stroke s) {
        super.setStroke(s);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void addEntity(Polygon polygon) {
        if (this.getFeature().isEditable()) {
            int numOfHoles = polygon.getNumInteriorRing();
            Coordinate[][][] origEntityCoordArr = this.entityRingCoordArr;
            Coordinate[][][] newEntityCoordArr = new Coordinate[origEntityCoordArr.length + 1][][];
            System.arraycopy(origEntityCoordArr, 0, newEntityCoordArr, 0, origEntityCoordArr.length);
            Coordinate[][] newRingCoordArr = new Coordinate[1 + numOfHoles][];
            newRingCoordArr[0] = polygon.getExteriorRing().getCoordinates();
            for (int ringIndex = 1; ringIndex < newRingCoordArr.length; ++ringIndex) {
                newRingCoordArr[ringIndex] = polygon.getInteriorRingN(ringIndex - 1).getCoordinates();
            }
            newEntityCoordArr[origEntityCoordArr.length] = newRingCoordArr;
            this.entityRingCoordArr = newEntityCoordArr;
            this.syncGeometry();
            this.updateXpAndYp();
            this.updatePath();
        }
    }

    public Polygon getEntityByPosition(int entityPosition) {
        Coordinate[][] coords = this.entityRingCoordArr[entityPosition];
        int srid = CrsTransformer.extractSridFromCrs(this.getViewerCrs().getCode());
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        CoordinateSequence cs = factory.getCoordinateSequenceFactory().create(coords[0]);
        LinearRing shell = new LinearRing(cs, factory);
        LinearRing[] holes = new LinearRing[coords.length - 1];
        for (int i = 1; i < coords.length; ++i) {
            cs = factory.getCoordinateSequenceFactory().create(coords[i]);
            holes[i - 1] = new LinearRing(cs, factory);
        }
        return factory.createPolygon(shell, holes);
    }

    public LineString getHoleByPosition(int entityPosition, int holePosition) {
        Coordinate[][] entityCoords = this.entityRingCoordArr[entityPosition];
        Coordinate[] holeCoords = entityCoords[holePosition];
        int srid = CrsTransformer.extractSridFromCrs(this.getViewerCrs().getCode());
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        return factory.createLineString(holeCoords);
    }

    public void removeEntity(int entityPosition) {
        if (this.getFeature().isEditable()) {
            boolean isInBounds;
            Coordinate[][][] origEntityCoordArr = this.entityRingCoordArr;
            boolean bl = isInBounds = entityPosition >= 0 && entityPosition < origEntityCoordArr.length;
            if (isInBounds) {
                if (origEntityCoordArr.length == 1) {
                    this.entityRingCoordArr = new Coordinate[0][][];
                } else {
                    Coordinate[][][] newEntityCoordArr = new Coordinate[origEntityCoordArr.length - 1][][];
                    System.arraycopy(origEntityCoordArr, 0, newEntityCoordArr, 0, entityPosition);
                    System.arraycopy(origEntityCoordArr, entityPosition + 1, newEntityCoordArr, entityPosition, newEntityCoordArr.length - entityPosition);
                    this.entityRingCoordArr = newEntityCoordArr;
                }
                this.syncGeometry();
                this.updateXpAndYp();
                this.updatePath();
            }
        }
    }

    public void addHoleToEntity(int entityPosition, LineString lineString) {
        if (this.getFeature().isEditable()) {
            boolean isInBounds;
            boolean bl = isInBounds = entityPosition >= 0 && entityPosition < this.entityRingCoordArr.length;
            if (isInBounds) {
                Coordinate[][] origRingCoordArr = this.entityRingCoordArr[entityPosition];
                int origLength = origRingCoordArr.length;
                Coordinate[][] newRingCoordArr = new Coordinate[origLength + 1][];
                System.arraycopy(origRingCoordArr, 0, newRingCoordArr, 0, origLength);
                newRingCoordArr[origLength] = lineString.getCoordinates();
                this.entityRingCoordArr[entityPosition] = newRingCoordArr;
            }
            this.syncGeometry();
            this.updateXpAndYp();
            this.updatePath();
        }
    }

    private List<Integer> getEntitiesPositionsUnderPoint(Point point) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Geometry geometry = this.getFeature().getGeometry();
        for (int entityIndex = 0; entityIndex < geometry.getNumGeometries(); ++entityIndex) {
            Geometry envelope = geometry.getEnvelope();
            if (!envelope.covers((Geometry)point)) continue;
            positions.add(entityIndex);
        }
        return positions;
    }

    public void removeHoleUnderPoint(Point point) {
        boolean isEntityInBounds;
        int entityPosition = this.getMostInnerEntityUnderPoint(point);
        boolean bl = isEntityInBounds = entityPosition >= 0 && entityPosition < this.entityRingCoordArr.length;
        if (isEntityInBounds) {
            Polygon entityPolygon;
            Geometry holeGeometry;
            boolean isRingInBounds;
            Coordinate[][] origRingCoordArr = this.entityRingCoordArr[entityPosition];
            int holePosition = this.getHolePositionUnderPoint(point, entityPosition);
            boolean bl2 = isRingInBounds = holePosition >= 0 && holePosition < origRingCoordArr.length;
            if (isRingInBounds && !this.hasEntitiesInGeometry(holeGeometry = (entityPolygon = (Polygon)this.getFeature().getGeometry().getGeometryN(entityPosition)).getInteriorRingN(holePosition - 1).getEnvelope())) {
                Coordinate[][] newRingCoordArr = new Coordinate[origRingCoordArr.length - 1][];
                System.arraycopy(origRingCoordArr, 0, newRingCoordArr, 0, holePosition);
                System.arraycopy(origRingCoordArr, holePosition + 1, newRingCoordArr, holePosition, newRingCoordArr.length - holePosition);
                this.entityRingCoordArr[entityPosition] = newRingCoordArr;
                this.syncGeometry();
                this.updateXpAndYp();
                this.updatePath();
            }
        }
    }

    public int getHolePositionUnderPoint(Point point, int entityPosition) {
        Polygon polygon;
        boolean isInBounds;
        Geometry geometry = this.getFeature().getGeometry();
        boolean bl = isInBounds = entityPosition >= 0 && entityPosition < geometry.getNumGeometries();
        if (isInBounds && (polygon = (Polygon)geometry.getGeometryN(entityPosition)).getNumInteriorRing() > 0) {
            for (int ringIndex = 0; ringIndex < polygon.getNumInteriorRing(); ++ringIndex) {
                Geometry envelope = polygon.getInteriorRingN(ringIndex).getEnvelope();
                if (!envelope.covers((Geometry)point)) continue;
                return ringIndex + 1;
            }
        }
        return -1;
    }

    public int getMostInnerEntityUnderPoint(Point point) {
        List<Integer> entityPositions = this.getEntitiesPositionsUnderPoint(point);
        ArrayList<Integer> entityPositionsWithHoles = new ArrayList<Integer>();
        for (int position : entityPositions) {
            if (this.entityRingCoordArr[position].length <= 1) continue;
            entityPositionsWithHoles.add(position);
        }
        Geometry geometry = this.getFeature().getGeometry();
        if (entityPositionsWithHoles.size() == 1) {
            return (Integer)entityPositionsWithHoles.get(0);
        }
        for (int indexA = 0; indexA < entityPositionsWithHoles.size(); ++indexA) {
            int entityPositionA = (Integer)entityPositionsWithHoles.get(indexA);
            Geometry envelopeA = geometry.getGeometryN(entityPositionA).getEnvelope();
            boolean containsAnyOtherRing = false;
            for (int indexB = 0; indexB < entityPositionsWithHoles.size(); ++indexB) {
                int entityPositionB;
                Geometry envelopeB;
                if (indexA == indexB || !envelopeA.covers(envelopeB = geometry.getGeometryN(entityPositionB = ((Integer)entityPositionsWithHoles.get(indexB)).intValue()).getEnvelope())) continue;
                containsAnyOtherRing = true;
            }
            if (containsAnyOtherRing) continue;
            return entityPositionA;
        }
        return -1;
    }

    public int getEntityPositionUnderPoint(Point point) {
        for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
            Geometry geometry = this.getFeature().getGeometry().getGeometryN(entityIndex);
            if (!geometry.covers((Geometry)point)) continue;
            return entityIndex;
        }
        return -1;
    }

    public boolean hasEntitiesInGeometry(Geometry geometry) {
        for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
            Geometry entityGeometry = this.getFeature().getGeometry().getGeometryN(entityIndex);
            if (!geometry.covers(entityGeometry)) continue;
            return true;
        }
        return false;
    }

    public void setSelectedEntity(int entityPosition) {
        boolean isInBounds = entityPosition >= 0 && entityPosition < this.entityRingCoordArr.length;
        this.selectedEntity = isInBounds ? entityPosition : -1;
    }

    private Image highlightImageAsSelected(Image toSelect, Color colFill, Color colEdge, int insetSize) {
        SoftReference<Image> selectedImageRef;
        if (colFill == null) {
            colFill = TRANSPARENT;
        }
        if (colEdge == null) {
            colEdge = TRANSPARENT;
        }
        if ((selectedImageRef = IMAGE_CACHE.get(toSelect.toString() + colFill + colEdge)) != null && selectedImageRef.get() != null) {
            return selectedImageRef.get();
        }
        if (toSelect != null) {
            int doubleInset = 2 * insetSize;
            BufferedImage tint = new BufferedImage(toSelect.getWidth(null) + doubleInset, toSelect.getHeight(null) + doubleInset, 2);
            Graphics2D g2d = (Graphics2D)tint.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setPaint(colFill);
            g2d.fillRoundRect(0, 0, toSelect.getWidth(null) - 1 + doubleInset, toSelect.getHeight(null) - 1 + doubleInset, 10, 10);
            g2d.setPaint(colEdge);
            g2d.drawRoundRect(0, 0, toSelect.getWidth(null) - 1 + doubleInset, toSelect.getHeight(null) - 1 + doubleInset, 10, 10);
            g2d.drawImage(toSelect, insetSize, insetSize, null);
            IMAGE_CACHE.put(toSelect.toString() + colFill + colEdge, new SoftReference<BufferedImage>(tint));
            return tint;
        }
        return toSelect;
    }

    public void setInfoNodeVisible(boolean visible) {
        if (this.infoNode != null) {
            this.infoNode.setVisible(visible);
        }
    }

    public MappingComponent getViewer() {
        return this.viewer;
    }

    public void setViewer(MappingComponent viewer) {
        this.viewer = viewer;
    }

    private Crs getViewerCrs() {
        return this.viewer.getMappingModel().getSrs();
    }

    public MappingComponent getMappingComponent() {
        return this.viewer;
    }

    public Paint getNonSelectedPaint() {
        return this.nonSelectedPaint;
    }

    public void setNonSelectedPaint(Paint nonSelectedPaint) {
        this.nonSelectedPaint = nonSelectedPaint;
    }

    public Paint getNonHighlightingPaint() {
        return this.nonHighlightingPaint;
    }

    public void setNonHighlightingPaint(Paint nonHighlightingPaint) {
        this.nonHighlightingPaint = nonHighlightingPaint;
    }

    private boolean setNewCoordinates(int entityPosition, int ringPosition, float[] xp, float[] yp, Coordinate[] coordArr) {
        if (this.isValidWithThisCoordinates(entityPosition, ringPosition, coordArr)) {
            this.entityRingCoordArr[entityPosition][ringPosition] = coordArr;
            this.entityRingXArr[entityPosition][ringPosition] = xp;
            this.entityRingYArr[entityPosition][ringPosition] = yp;
            this.syncGeometry();
            this.updatePath();
            this.getViewer().showHandles(false);
            ArrayList<Feature> features = new ArrayList<Feature>();
            features.add(this.getFeature());
            ((DefaultFeatureCollection)this.getViewer().getFeatureCollection()).fireFeaturesChanged(features);
            return true;
        }
        return false;
    }

    public boolean isValid(int entityPosition, int ringPosition) {
        return this.isValidWithThisCoordinates(entityPosition, ringPosition, this.getCoordArr(entityPosition, ringPosition));
    }

    private boolean isValidWithThisEntity(int entityPosition, Coordinate[][] ringCoordArr) {
        try {
            Polygon newGeometry;
            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(this.getViewerCrs().getCode()));
            if (this.getFeature().getGeometry() instanceof Polygon || this.getFeature().getGeometry() instanceof MultiPolygon) {
                newGeometry = PFeature.createPolygon(ringCoordArr, geometryFactory);
            } else if (this.getFeature().getGeometry() instanceof LineString || this.getFeature().getGeometry() instanceof MultiLineString) {
                newGeometry = PFeature.createLineString(ringCoordArr[0], geometryFactory);
            } else if (this.getFeature().getGeometry() instanceof Point || this.getFeature().getGeometry() instanceof MultiPoint) {
                newGeometry = PFeature.createPoint(ringCoordArr[0][0], geometryFactory);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"unknown geometry type");
                }
                return false;
            }
            if (!newGeometry.isValid()) {
                return false;
            }
            Geometry geometry = this.getFeature().getGeometry();
            for (int entityIndex = 0; entityIndex < geometry.getNumGeometries(); ++entityIndex) {
                Geometry otherGeometry;
                if (entityPosition >= 0 && entityIndex == entityPosition || !newGeometry.intersects(otherGeometry = geometry.getGeometryN(entityIndex))) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"invalid geometry", (Throwable)ex);
            }
            return false;
        }
    }

    public boolean isValidWithThisNewEntityCoordinates(Coordinate[] coordArr) {
        Coordinate[][] tempRingCoordArr = new Coordinate[][]{coordArr};
        return this.isValidWithThisEntity(-1, tempRingCoordArr);
    }

    public boolean isValidWithThisNewHoleCoordinates(int entityPosition, Coordinate[] coordArr) {
        Coordinate[][] tempRingCoordArr = new Coordinate[this.entityRingCoordArr[entityPosition].length + 1][];
        System.arraycopy(this.entityRingCoordArr[entityPosition], 0, tempRingCoordArr, 0, this.entityRingCoordArr[entityPosition].length);
        tempRingCoordArr[this.entityRingCoordArr[entityPosition].length] = coordArr;
        return this.isValidWithThisEntity(entityPosition, tempRingCoordArr);
    }

    public boolean isValidWithThisCoordinates(int entityPosition, int ringPosition, Coordinate[] coordArr) {
        Coordinate[][] tempRingCoordArr = new Coordinate[this.entityRingCoordArr[entityPosition].length][];
        System.arraycopy(this.entityRingCoordArr[entityPosition], 0, tempRingCoordArr, 0, this.entityRingCoordArr[entityPosition].length);
        tempRingCoordArr[ringPosition] = coordArr;
        return this.isValidWithThisEntity(entityPosition, tempRingCoordArr);
    }

    public void updatePath() {
        this.getPathReference().reset();
        Geometry geom = this.feature.getGeometry();
        if (geom instanceof Point) {
            this.setPathToPolyline(new float[]{this.entityRingXArr[0][0][0], this.entityRingXArr[0][0][0]}, new float[]{this.entityRingYArr[0][0][0], this.entityRingYArr[0][0][0]});
        } else if (geom instanceof LineString || geom instanceof MultiPoint) {
            this.setPathToPolyline(this.entityRingXArr[0][0], this.entityRingYArr[0][0]);
        } else if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            this.getPathReference().setWindingRule(0);
            for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
                for (int ringIndex = 0; ringIndex < this.entityRingCoordArr[entityIndex].length; ++ringIndex) {
                    Coordinate[] coordArr = this.entityRingCoordArr[entityIndex][ringIndex];
                    this.addLinearRing(coordArr);
                }
            }
            this.firePropertyChange(262144, "path", null, this.getPathReference());
            this.updateBoundsFromPath();
            this.invalidatePaint();
        } else if (geom instanceof MultiLineString) {
            for (int entityIndex = 0; entityIndex < this.entityRingCoordArr.length; ++entityIndex) {
                for (int ringIndex = 0; ringIndex < this.entityRingCoordArr[entityIndex].length; ++ringIndex) {
                    Coordinate[] coordArr = this.entityRingCoordArr[entityIndex][ringIndex];
                    this.addLinearRing(coordArr);
                }
            }
            this.firePropertyChange(262144, "path", null, this.getPathReference());
            this.updateBoundsFromPath();
            this.invalidatePaint();
        }
    }

    public PNode getInfoNode() {
        return this.infoNode;
    }

    public PNode getStickyChild() {
        return this.stickyChild;
    }

    public boolean hasSecondStickyChild() {
        return this.secondStickyChild != null;
    }

    public boolean hasHole() {
        int polygons = this.entityRingCoordArr.length;
        for (int i = 0; i < polygons; ++i) {
            int rings = this.entityRingCoordArr[i].length;
            if (rings <= 1) continue;
            return true;
        }
        return false;
    }

    public PNode getSecondStickyChild() {
        return this.secondStickyChild;
    }

    public boolean isSnappable() {
        return this.snappable;
    }

    public void setSnappable(boolean snappable) {
        this.snappable = snappable;
    }

    public void setCoordArr(Coordinate[] coordArr) {
        this.entityRingCoordArr = new Coordinate[][][]{{coordArr}};
        this.updateXpAndYp();
    }

    public void setCoordArr(int entityPosition, int ringPosition, Coordinate[] coordArr) {
        this.entityRingCoordArr[entityPosition][ringPosition] = coordArr;
        this.updateXpAndYp();
    }

    public int getNumOfEntities() {
        return this.entityRingCoordArr.length;
    }

    public int getNumOfRings(int entityIndex) {
        return this.entityRingCoordArr[entityIndex].length;
    }

    public int getNumOfCoordinates(int entityIndex, int ringIndex) {
        return this.entityRingCoordArr[entityIndex][ringIndex].length;
    }

    public Coordinate getCoordinate(int entityIndex, int ringIndex, int coordinateIndex) {
        return this.entityRingCoordArr[entityIndex][ringIndex][coordinateIndex];
    }

    public void releaseResources() {
        if (this.pi != null) {
            this.viewer.removeStickyNode(this.pi);
        }
        if (this.piSelected != null) {
            this.viewer.removeStickyNode(this.piSelected);
        }
        if (this.stickyChild != null && this.stickyChild instanceof PSticky) {
            this.viewer.removeStickyNode((PSticky)this.stickyChild);
        }
        if (this.secondStickyChild != null && this.stickyChild instanceof PSticky) {
            this.viewer.removeStickyNode((PSticky)this.secondStickyChild);
        }
        if (this.sldStyledImage != null) {
            for (PImage i : this.sldStyledImage) {
                if (!(i instanceof PSticky)) continue;
                this.viewer.removeStickyNode((PSticky)i);
            }
        }
        if (this.sldStyledSelectedImage != null) {
            for (PImage i : this.sldStyledSelectedImage) {
                if (!(i instanceof PSticky)) continue;
                this.viewer.removeStickyNode((PSticky)i);
            }
        }
        if (this.sldStyledText != null) {
            for (PTextWithDisplacement text : this.sldStyledText) {
                if (!(text instanceof PSticky)) continue;
                this.viewer.removeStickyNode(text);
            }
        }
        if (this.tPropertyChange != null && this.viewer != null) {
            this.viewer.getCamera().removePropertyChangeListener("viewTransform", (PropertyChangeListener)this.tPropertyChange);
        }
    }

    public class PTextWithDisplacement
    extends PText
    implements PSticky {
        double displacementX;
        double displacementY;
        private SLDStyledFeature.UOM uom;
        private double anchorPointX;
        private double anchorPointY;
        private WorldToScreenTransform wtst;
        private double scaledDisplacementX;
        private double scaledDisplacementY;

        @Override
        public void setScale(double scale) {
            this.offset(-this.scaledDisplacementX, -this.scaledDisplacementY);
            super.setScale(scale);
            this.scaledDisplacementX = (this.displacementX + -this.anchorPointX * this.getWidth()) * scale;
            this.scaledDisplacementY = (this.displacementY + this.anchorPointY * this.getHeight()) * scale;
            this.offset(this.scaledDisplacementX, this.scaledDisplacementY);
        }

        public void setDisplacement(SLDStyledFeature.UOM uomFromDeegree, double displacementX, double displacementY, double anchorPointX, double anchorPointY, WorldToScreenTransform wtst) {
            this.uom = uomFromDeegree;
            this.displacementX = displacementX;
            this.displacementY = displacementY;
            this.anchorPointX = anchorPointX;
            this.anchorPointY = anchorPointY;
            this.wtst = wtst;
        }
    }

    public class StickyPText
    extends PText
    implements ParentNodeIsAPFeature,
    PSticky {
        public StickyPText() {
        }

        public StickyPText(String text) {
            super(text);
        }
    }

    class StickyPPath
    extends PPath
    implements ParentNodeIsAPFeature,
    PSticky {
        int transparency;
        Color c;

        public StickyPPath(Shape s) {
            super(s);
            this.transparency = 0;
            this.c = null;
        }
    }

    class TexturePaintPropertyChangeListener
    implements PropertyChangeListener {
        double scale = 0.0;

        TexturePaintPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.scale != PFeature.this.viewer.getCamera().getViewScale()) {
                if (PFeature.this.nonHighlightingPaint instanceof SelectionAwareTexturePaint) {
                    ((SelectionAwareTexturePaint)PFeature.this.nonHighlightingPaint).setScale(PFeature.this.viewer.getCamera().getViewScale(), CrsTransformer.transformToGivenCrs(PFeature.this.feature.getGeometry(), PFeature.this.getViewerCrs().getCode()));
                    PFeature.this.repaint();
                }
                this.scale = PFeature.this.viewer.getCamera().getViewScale();
            }
        }
    }
}

