/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.cismap.commons.gui.MappingComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.log4j.Logger;

public class PHandle
extends PPath {
    public static final double DEFAULT_HANDLE_SIZE = 8.0;
    public static final Shape DEFAULT_HANDLE_SHAPE = new Ellipse2D.Double(0.0, 0.0, 8.0, 8.0);
    public static final Color DEFAULT_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.4f);
    public static final Color DEFAULT_SELECTED_COLOR = Color.red;
    private static PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    boolean inDragOperation = false;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private PLocator locator;
    private PDragSequenceEventHandler handleDragger;
    private boolean selected = false;
    private MappingComponent mc = null;

    public PHandle(PLocator aLocator, MappingComponent mc) {
        super(DEFAULT_HANDLE_SHAPE);
        this.mc = mc;
        this.locator = aLocator;
        this.setPaint(this.getDefaultColor());
        this.installHandleEventHandlers();
        this.startResizeBounds();
        this.relocateHandle();
    }

    protected Color getDefaultColor() {
        return DEFAULT_COLOR;
    }

    protected Color getDefaultSelectedColor() {
        return DEFAULT_SELECTED_COLOR;
    }

    public void removeHandle() {
    }

    public void duplicateHandle() {
    }

    protected void installHandleEventHandlers() {
        this.handleDragger = new PDragSequenceEventHandler(){

            protected void startDrag(PInputEvent event) {
                if (PHandle.this.log.isDebugEnabled()) {
                    PHandle.this.log.debug((Object)"Handle Start Drag");
                }
                super.startDrag(event);
                PHandle.this.inDragOperation = true;
                PHandle.this.startHandleDrag(event.getPositionRelativeTo((PNode)PHandle.this), event);
            }

            protected void drag(PInputEvent event) {
                if (PHandle.this.log.isDebugEnabled()) {
                    PHandle.this.log.debug((Object)"Handle Drag");
                }
                super.drag(event);
                PDimension aDelta = event.getDeltaRelativeTo((PNode)PHandle.this);
                if (aDelta.getWidth() != 0.0 || aDelta.getHeight() != 0.0) {
                    PHandle.this.dragHandle(aDelta, event);
                }
            }

            protected void endDrag(PInputEvent event) {
                if (PHandle.this.log.isDebugEnabled()) {
                    PHandle.this.log.debug((Object)"Handle End Drag");
                }
                super.endDrag(event);
                PHandle.this.inDragOperation = false;
                PHandle.this.endHandleDrag(event.getPositionRelativeTo((PNode)PHandle.this), event);
            }
        };
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PHandle.this.relocateHandle();
            }
        });
        this.handleDragger.setEventFilter(new PInputEventFilter(16));
        this.handleDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.handleDragger.getEventFilter().setAcceptsMouseEntered(false);
        this.handleDragger.getEventFilter().setAcceptsMouseExited(false);
        this.handleDragger.getEventFilter().setAcceptsMouseMoved(false);
        this.addInputEventListener((PInputEventListener)this.handleDragger);
        PBasicInputEventHandler moveAndClickListener = new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                if (PHandle.this.log.isDebugEnabled()) {
                    PHandle.this.log.debug((Object)"Handle Mouse Clicked");
                }
                PHandle.this.handleClicked(pInputEvent);
            }

            public void mouseMoved(PInputEvent pInputEvent) {
                if (!PHandle.this.inDragOperation) {
                    PHandle.this.mouseMovedNotInDragOperation(pInputEvent);
                }
            }
        };
        this.addInputEventListener((PInputEventListener)moveAndClickListener);
    }

    public PDragSequenceEventHandler getHandleDraggerHandler() {
        return this.handleDragger;
    }

    public PLocator getLocator() {
        return this.locator;
    }

    public void setLocator(PLocator aLocator) {
        this.locator = aLocator;
        this.invalidatePaint();
        this.relocateHandle();
    }

    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
    }

    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
    }

    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
    }

    public void handleClicked(PInputEvent pInputEvent) {
    }

    public void mouseMovedNotInDragOperation(PInputEvent pInputEvent) {
    }

    public void setParent(PNode newParent) {
        super.setParent(newParent);
        this.relocateHandle();
    }

    public void parentBoundsChanged() {
        this.relocateHandle();
    }

    public void relocateHandle() {
        if (this.locator != null) {
            PBounds b = this.getBoundsReference();
            Point2D aPoint = this.locator.locatePoint(null);
            this.mc.getCamera().viewToLocal(aPoint);
            double newCenterX = aPoint.getX();
            double newCenterY = aPoint.getY();
            if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
                this.setBounds(0.0, 0.0, 8.0, 8.0);
                this.centerBoundsOnPoint(newCenterX, newCenterY);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.installHandleEventHandlers();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setPaint(this.getDefaultSelectedColor());
        } else {
            this.setPaint(this.getDefaultColor());
        }
        this.repaint();
    }
}

