/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AbstractBindingListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class RectangleFromLineDialog
extends JDialog {
    public static final int STATUS_NONE = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCELED = 1;
    private final transient Logger log = Logger.getLogger(this.getClass());
    private double length = 0.0;
    private NumberFormat format = NumberFormat.getInstance();
    private int returnStatus = -1;
    private LinkedList<ChangeListener> widthChangedListeners = new LinkedList();
    private JButton btnCancel;
    private JButton btnOK;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JSeparator jSeparator2;
    private JLabel lblLength;
    private JPanel panButtons;
    private JPanel panParams;
    private JPanel panSide;
    private JTextField txtSurface;
    private JTextField txtWidth;
    private BindingGroup bindingGroup;

    public RectangleFromLineDialog(Frame parent, boolean modal, double length) {
        super(parent, modal);
        this.format.setGroupingUsed(false);
        this.format.setMinimumFractionDigits(2);
        this.format.setMaximumFractionDigits(2);
        this.initComponents();
        this.lblLength.setText(this.format.format(length));
        this.length = length;
        this.bindingGroup.addBindingListener((BindingListener)new AbstractBindingListener(){

            public void synced(Binding bndng) {
                RectangleFromLineDialog.this.fireStateChanged();
            }
        });
        this.jRadioButton1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                RectangleFromLineDialog.this.fireStateChanged();
            }
        });
        this.getRootPane().setDefaultButton(this.btnOK);
        StaticSwingTools.doClickButtonOnKeyStroke((JButton)this.btnOK, (KeyStroke)KeyStroke.getKeyStroke(10, 0), (JRootPane)this.getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke((JButton)this.btnCancel, (KeyStroke)KeyStroke.getKeyStroke(27, 0), (JRootPane)this.getRootPane());
    }

    private void fireStateChanged() {
        for (ChangeListener cl : this.widthChangedListeners) {
            cl.stateChanged(new ChangeEvent(this));
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.panParams = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtSurface = new JFormattedTextField(this.format);
        this.txtWidth = new JFormattedTextField(this.format);
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.panSide = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.lblLength = new JLabel();
        this.panButtons = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.jSeparator2 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.panParams.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.05;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jLabel2, gridBagConstraints);
        this.txtSurface.setHorizontalAlignment(11);
        this.txtSurface.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.txtSurface.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.txtSurface, gridBagConstraints);
        this.txtWidth.setHorizontalAlignment(11);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.txtSurface, (Property)ELProperty.create((String)"${text}"), (Object)this.txtWidth, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"0,00");
        binding.setSourceUnreadableValue((Object)"0,00");
        binding.setConverter((Converter)new WidthToSurfaceConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.txtWidth, gridBagConstraints);
        this.jLabel3.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.025;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jLabel4, gridBagConstraints);
        this.panSide.setLayout(new FlowLayout(1, 25, 0));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jRadioButton1.text"));
        this.panSide.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jRadioButton2.text_3"));
        this.panSide.add(this.jRadioButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.panSide, gridBagConstraints);
        this.jLabel5.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jLabel6, gridBagConstraints);
        this.lblLength.setHorizontalAlignment(11);
        this.lblLength.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.lblLength.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.lblLength, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panParams, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 0, 5, 0));
        this.btnCancel.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.btnCancel.text_2"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RectangleFromLineDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnCancel);
        this.btnOK.setText(NbBundle.getMessage(RectangleFromLineDialog.class, (String)"RectangleFromLineDialog.btnOK.text_2"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RectangleFromLineDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnOK);
        this.panButtons.add(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.panButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    public void addWidthChangedListener(ChangeListener cl) {
        this.widthChangedListeners.add(cl);
    }

    public double getRectangleWidth() {
        return RectangleFromLineDialog.convertStringToDouble(this.txtWidth.getText());
    }

    public boolean isLefty() {
        return this.jRadioButton1.isSelected();
    }

    private double convertWidthToSurface(double width) {
        return width * this.length;
    }

    private double convertSurfaceToWidth(double surface) {
        if (this.length == 0.0) {
            return 0.0;
        }
        return surface / this.length;
    }

    private static double convertStringToDouble(String surfaceString) {
        try {
            return Double.parseDouble(surfaceString.replace(',', '.'));
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnStatus = 1;
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RectangleFromLineDialog dialog = new RectangleFromLineDialog((Frame)new JFrame(), true, 0.0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class WidthToSurfaceConverter
    extends Converter<String, String> {
        WidthToSurfaceConverter() {
        }

        public String convertForward(String surfaceString) {
            double surface = RectangleFromLineDialog.convertStringToDouble(surfaceString);
            return RectangleFromLineDialog.this.format.format(RectangleFromLineDialog.this.convertSurfaceToWidth(surface));
        }

        public String convertReverse(String widthString) {
            double width = RectangleFromLineDialog.convertStringToDouble(widthString);
            return RectangleFromLineDialog.this.format.format(RectangleFromLineDialog.this.convertWidthToSurface(width));
        }
    }
}

