/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureRotateAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Component;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class RotationPHandle
extends PHandle {
    private static final String DIALOG_TEXT = "Aktion r\u00fcckg\u00e4ngig machen?";
    private static final String DIALOG_TITLE = "\u00dcberschneidung entdeckt";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private final PFeature pfeature;
    private final int entityPosition;
    private final int ringPosition;
    private final int coordPosition;
    private double rotation = 0.0;
    private PHandle pivotHandle;
    private Point2D mid;

    public RotationPHandle(final PFeature pfeature, final int entityPosition, final int ringPosition, final int coordPosition, Point2D mid, PHandle pivotHandle) {
        super(new PLocator(){

            public double locateX() {
                return pfeature.getXp(entityPosition, ringPosition)[coordPosition];
            }

            public double locateY() {
                return pfeature.getYp(entityPosition, ringPosition)[coordPosition];
            }
        }, pfeature.getViewer());
        this.mid = mid;
        this.pfeature = pfeature;
        this.entityPosition = entityPosition;
        this.ringPosition = ringPosition;
        this.coordPosition = coordPosition;
        this.pivotHandle = pivotHandle;
    }

    @Override
    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
        this.pfeature.getViewer().getCamera().localToView((Dimension2D)aLocalDimension);
        double dragRot = this.pfeature.calculateDrag(aEvent, this.pfeature.getXp(this.entityPosition, this.ringPosition)[this.coordPosition], this.pfeature.getYp(this.entityPosition, this.ringPosition)[this.coordPosition]);
        if (this.pfeature.getViewer().getFeatureCollection() instanceof DefaultFeatureCollection && ((DefaultFeatureCollection)this.pfeature.getViewer().getFeatureCollection()).getSelectedFeatures().size() > 1) {
            for (Object o : this.pfeature.getViewer().getFeatureCollection().getSelectedFeatures()) {
                PFeature pf = this.pfeature.getViewer().getPFeatureHM().get((Feature)o);
                if (!pf.getFeature().isEditable()) continue;
                pf.rotateAllPoints(dragRot, null);
                this.relocateHandle();
            }
        } else {
            this.pfeature.rotateAllPoints(dragRot, null);
            this.relocateHandle();
        }
        this.rotation -= dragRot;
    }

    @Override
    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        if (this.pfeature.getViewer().isFeatureDebugging() && this.log.isDebugEnabled()) {
            this.log.debug((Object)"startHandleDrag");
        }
        this.rotation = 0.0;
        Collection selArr = this.pfeature.getViewer().getFeatureCollection().getSelectedFeatures();
        for (Object o : selArr) {
            PFeature pf = this.pfeature.getViewer().getPFeatureHM().get(o);
            if (pf == null || pf.getInfoNode() == null) continue;
            pf.getInfoNode().setVisible(false);
        }
        this.pfeature.getViewer().getHandleLayer().removeAllChildren();
        this.pfeature.getViewer().getHandleLayer().addChild((PNode)this);
        if (this.pivotHandle != null) {
            this.pfeature.getViewer().getHandleLayer().addChild((PNode)this.pivotHandle);
        }
        super.startHandleDrag(aLocalPoint, aEvent);
    }

    @Override
    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        try {
            if (this.pfeature.getViewer().isFeatureDebugging() && this.log.isDebugEnabled()) {
                this.log.debug((Object)"endHandleDrag");
            }
            LinkedHashSet temp = (LinkedHashSet)this.pfeature.getViewer().getFeatureCollection().getSelectedFeatures();
            LinkedHashSet<Feature> selArr = new LinkedHashSet<Feature>();
            for (Feature sel : temp) {
                if (!sel.isEditable()) continue;
                selArr.add(sel);
            }
            List<Feature> all = this.pfeature.getViewer().getFeatureCollection().getAllFeatures();
            if (this.pfeature.getViewer().getFeatureCollection() instanceof DefaultFeatureCollection) {
                Vector<Feature> v = new Vector<Feature>();
                for (Object e : selArr) {
                    this.pfeature.getViewer().getPFeatureHM().get(e).setPivotPoint(this.mid);
                    v.add(this.pfeature.getViewer().getPFeatureHM().get(e).getFeature());
                }
                ((DefaultFeatureCollection)this.pfeature.getViewer().getFeatureCollection()).fireFeaturesChanged(v);
            } else {
                this.pfeature.getViewer().getFeatureCollection().reconsiderFeature(this.pfeature.getFeature());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Nach fireFeaturesChanged");
            }
            boolean overlap = false;
            if (CismapBroker.getInstance().isCheckForOverlappingGeometriesAfterFeatureRotation()) {
                if (!(this.pfeature.getFeature() instanceof SearchFeature)) {
                    block4: for (Object e : selArr) {
                        Geometry g = this.pfeature.getViewer().getPFeatureHM().get(e).getFeature().getGeometry();
                        if (overlap) break;
                        for (Feature f : all) {
                            if (g.equals(f.getGeometry()) || !g.overlaps(f.getGeometry())) continue;
                            overlap = true;
                            continue block4;
                        }
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Nach Overlap-Check");
                }
            }
            if (overlap) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u00dcberlappt");
                }
                if (this.pfeature.getViewer().isFeatureDebugging() && this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u00dcberschneidungen nach Drehung der PFeatures");
                }
                int answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)((Object)this.pfeature.getViewer())), DIALOG_TEXT, DIALOG_TITLE, 0, 3);
                if (this.pfeature.getViewer().isFeatureDebugging() && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Drehung durchf\u00fchren: " + (answer == 0 ? "JA" : "NEIN")));
                }
                if (answer == 0) {
                    FeatureRotateAction featureRotateAction = new FeatureRotateAction(this.pfeature.getViewer(), selArr, (Point2D)this.mid.clone(), this.rotation);
                    featureRotateAction.doAction();
                } else if (this.rotation != 0.0) {
                    this.pfeature.getViewer().getMemUndo().addAction(new FeatureRotateAction(this.pfeature.getViewer(), selArr, (Point2D)this.mid.clone(), this.rotation));
                    this.pfeature.getViewer().getMemRedo().clear();
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u00dcberlappt nicht");
                }
                if (this.rotation != 0.0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("arr=" + selArr));
                        this.log.debug((Object)("mid=" + this.mid));
                    }
                    Point2D.Double actionMid = new Point2D.Double(this.mid.getX(), this.mid.getY());
                    this.pfeature.getViewer().getMemUndo().addAction(new FeatureRotateAction(this.pfeature.getViewer(), selArr, actionMid, this.rotation));
                    this.pfeature.getViewer().getMemRedo().clear();
                }
            }
            super.endHandleDrag(aLocalPoint, aEvent);
        }
        catch (Throwable ex) {
            this.log.error((Object)"Boooooom", ex);
        }
    }
}

