/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.gui.piccolo.PaintWrapper;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class SelectionAwareTexturePaint
implements Paint,
Cloneable,
PaintWrapper {
    private final double MIN_SIDE_LENGTH = 0.5;
    private final BufferedImage defaultImage;
    private final BufferedImage highlightedImage;
    private final BufferedImage selectedImage;
    private final Rectangle2D rec;
    private TexturePaint paint;
    private BufferedImage currentImage;
    private Rectangle2D currentRec;

    public SelectionAwareTexturePaint(BufferedImage defaultImage, BufferedImage highlightedImage, BufferedImage selectedImage, Rectangle2D rec) {
        this.paint = new TexturePaint(defaultImage, rec);
        this.rec = rec;
        this.currentRec = rec;
        this.defaultImage = defaultImage;
        this.highlightedImage = highlightedImage;
        this.selectedImage = selectedImage;
        this.currentImage = defaultImage;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    public void setMode(SelectionMode mode) {
        switch (mode) {
            case HIGHLIGHTED: {
                this.paint = new TexturePaint(this.highlightedImage, this.currentRec);
                this.currentImage = this.highlightedImage;
                break;
            }
            case SELECTED: {
                this.paint = new TexturePaint(this.selectedImage, this.currentRec);
                this.currentImage = this.selectedImage;
                break;
            }
            case UNSELECTED: {
                this.paint = new TexturePaint(this.defaultImage, this.currentRec);
                this.currentImage = this.defaultImage;
            }
        }
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.paint.createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    @Override
    public int getTransparency() {
        return this.paint.getTransparency();
    }

    public Object clone() {
        SelectionAwareTexturePaint clone = new SelectionAwareTexturePaint(this.defaultImage, this.highlightedImage, this.selectedImage, this.rec);
        clone.currentRec = this.currentRec;
        clone.currentImage = this.currentImage;
        return clone;
    }

    public void setScale(double scale, Geometry geom) {
        double factor = 1.0 / scale;
        double minSide = Math.min(this.rec.getWidth() * factor, this.rec.getHeight() * factor);
        if (minSide < 0.5) {
            factor = 0.5 / Math.min(this.rec.getWidth(), this.rec.getHeight());
        }
        if (geom.getArea() < 1.0E-4) {
            factor *= Math.sqrt(geom.getArea());
        }
        this.currentRec = new Rectangle2D.Double(this.rec.getMinX(), this.rec.getMinY(), this.rec.getWidth() * factor, this.rec.getHeight() * factor);
        this.paint = new TexturePaint(this.defaultImage, this.currentRec);
    }

    public static enum SelectionMode {
        HIGHLIGHTED,
        SELECTED,
        UNSELECTED;

    }
}

