/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import Sirius.util.collections.MultiMap;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.RequestForUnaddableHandles;
import de.cismet.cismap.commons.features.RequestForUnmoveableHandles;
import de.cismet.cismap.commons.features.RequestForUnremovableHandles;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeregistrationListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.InvalidPolygonTooltip;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.HandleDeleteAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.HandleMoveAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.StaticDecimalTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class TransformationPHandle
extends PHandle
implements DeregistrationListener {
    private static final Logger LOG = Logger.getLogger(TransformationPHandle.class);
    private PText leftInfo;
    private PText rightInfo;
    private MultiMap glueCoordinates = new MultiMap();
    private final PFeature pfeature;
    private final int entityPosition;
    private final int ringPosition;
    private int coordPosition;
    private float startX;
    private float startY;
    private int leftNeighbourIndex;
    private int rightNeighbourIndex;
    private Point2D leftNeighbourPoint;
    private Point2D rightNeighbourPoint;
    private Coordinate leftNeighbourCoordinate;
    private Coordinate rightNeighbourCoordinate;
    private Coordinate[] backupCoordArr;
    private InvalidPolygonTooltip polygonTooltip = new InvalidPolygonTooltip();
    private Map<Point2D, Coordinate> snappedCoordinates = new HashMap<Point2D, Coordinate>();
    private final Color snappedOnPoint = Color.GREEN.darker().darker();
    private final Color snappedOnLine = Color.ORANGE.brighter().brighter();

    public TransformationPHandle(final PFeature pfeature, final int entityPosition, final int ringPosition, final int coordPosition) {
        super(new PLocator(){

            public double locateX() {
                try {
                    return pfeature.getXp(entityPosition, ringPosition)[coordPosition];
                }
                catch (Exception ex) {
                    return -1.0;
                }
            }

            public double locateY() {
                try {
                    return pfeature.getYp(entityPosition, ringPosition)[coordPosition];
                }
                catch (Exception ex) {
                    return -1.0;
                }
            }
        }, pfeature.getViewer());
        this.pfeature = pfeature;
        this.entityPosition = entityPosition;
        this.ringPosition = ringPosition;
        this.coordPosition = coordPosition;
        this.polygonTooltip.setVisible(false);
        this.addChild(this.polygonTooltip);
    }

    private int getLeftNeighbourIndex(int index) {
        if (index == 0) {
            return this.pfeature.getCoordArr(this.entityPosition, this.ringPosition).length - 2;
        }
        if (this.coordPosition == this.pfeature.getCoordArr(this.entityPosition, this.ringPosition).length - 1) {
            return this.coordPosition - 1;
        }
        return index - 1;
    }

    private int getRightNeighbourIndex(int index) {
        if (index == 0) {
            return this.coordPosition + 1;
        }
        if (this.coordPosition == this.pfeature.getCoordArr(this.entityPosition, this.ringPosition).length - 1) {
            return 1;
        }
        return this.coordPosition + 1;
    }

    @Override
    public void dragHandle(PDimension aLocalDimension, PInputEvent pInputEvent) {
        try {
            if (!this.pfeature.getViewer().getInteractionMode().equals("SPLIT_POLYGON") && !this.pfeature.getViewer().getInteractionMode().equals("MOVE_POLYGON") && (!(this.pfeature.getFeature() instanceof RequestForUnaddableHandles) && this.pfeature.getViewer().getHandleInteractionMode().equals("ADD_HANDLE") || !(this.pfeature.getFeature() instanceof RequestForUnmoveableHandles) && this.pfeature.getViewer().getHandleInteractionMode().equals("MOVE_HANDLE"))) {
                float currentY;
                float currentX;
                if (pInputEvent.isLeftMouseButton() && pInputEvent.isControlDown()) {
                    Point2D trigger = pInputEvent.getCanvasPosition();
                    Point2D erg = StaticGeometryFunctions.createPointOnLine((Point2D)this.leftNeighbourPoint, (Point2D)this.rightNeighbourPoint, (Point2D)trigger);
                    Point2D ergPoint = this.pfeature.getViewer().getCamera().localToView((Point2D)erg.clone());
                    currentX = (float)ergPoint.getX();
                    currentY = (float)ergPoint.getY();
                } else {
                    PFeatureTools.SnappedPoint potentiallySnappedPoint = PFeatureTools.getNearestPointInArea(this.pfeature.getViewer(), pInputEvent.getCanvasPosition(), true, this.glueCoordinates);
                    Point2D point = potentiallySnappedPoint.getPoint();
                    if (!PFeatureTools.SnappedPoint.SnappedOn.NOTHING.equals((Object)potentiallySnappedPoint.getSnappedOn())) {
                        Coordinate coord;
                        if ((MappingComponent.SnappingMode.POINT.equals((Object)this.pfeature.getViewer().getSnappingMode()) || MappingComponent.SnappingMode.BOTH.equals((Object)this.pfeature.getViewer().getSnappingMode())) && (coord = PFeatureTools.getNearestCoordinateInArea(this.pfeature.getViewer(), pInputEvent.getCanvasPosition(), true, this.glueCoordinates)) != null) {
                            this.pfeature.getViewer().getWtst().addXCoordinate((float)point.getX(), coord.x);
                            this.pfeature.getViewer().getWtst().addYCoordinate((float)point.getY(), coord.y);
                            this.snappedCoordinates.put(point, coord);
                        }
                        switch (potentiallySnappedPoint.getSnappedOn()) {
                            case POINT: {
                                this.setPaint(this.snappedOnPoint);
                                break;
                            }
                            case LINE: {
                                this.setPaint(this.snappedOnLine);
                            }
                        }
                    } else {
                        this.setPaint(this.isSelected() ? this.getDefaultSelectedColor() : this.getDefaultColor());
                    }
                    currentX = (float)point.getX();
                    currentY = (float)point.getY();
                }
                this.updateGeometryPoints(currentX, currentY);
                this.relocateHandle();
                if ((this.pfeature.getFeature().getGeometry() instanceof MultiPolygon || this.pfeature.getFeature().getGeometry() instanceof Polygon) && !this.pfeature.isValid(this.entityPosition, this.ringPosition)) {
                    boolean creatingHole = this.ringPosition > 0;
                    this.polygonTooltip.setOffset(pInputEvent.getCanvasPosition().getX() + 20.0, pInputEvent.getCanvasPosition().getY() + 20.0);
                    if (creatingHole) {
                        this.polygonTooltip.setMode(InvalidPolygonTooltip.Mode.HOLE_ERROR);
                    } else {
                        this.polygonTooltip.setMode(InvalidPolygonTooltip.Mode.ENTITY_ERROR);
                    }
                    this.polygonTooltip.setVisible(true);
                } else {
                    this.polygonTooltip.setVisible(false);
                }
                if (this.pfeature.getViewer().isInGlueIdenticalPointsMode()) {
                    Set pFeatureSet = this.glueCoordinates.keySet();
                    for (PFeature gluePFeature : pFeatureSet) {
                        Collection coordinates;
                        if (!gluePFeature.getFeature().isEditable() || (coordinates = (Collection)this.glueCoordinates.get((Object)gluePFeature)) == null) continue;
                        for (Object o : coordinates) {
                            int oIndex = (Integer)o;
                            gluePFeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, oIndex, currentX, currentY);
                        }
                    }
                }
                Coordinate[] coordArr = this.pfeature.getCoordArr(this.entityPosition, this.ringPosition);
                Coordinate coordinate = coordArr[this.coordPosition];
                if (this.leftInfo != null && this.leftNeighbourCoordinate != null) {
                    double leftDistance = coordinate.distance(this.leftNeighbourCoordinate);
                    this.leftInfo.setText(StaticDecimalTools.round((double)leftDistance));
                }
                if (this.rightInfo != null && this.rightNeighbourCoordinate != null) {
                    double rightDistance = coordinate.distance(this.rightNeighbourCoordinate);
                    this.rightInfo.setText(StaticDecimalTools.round((double)rightDistance));
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error in dragHandle.", t);
        }
        super.dragHandle(aLocalDimension, pInputEvent);
    }

    @Override
    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        try {
            CismapBroker.getInstance().setSnappingVetoFeature(this.pfeature);
            if (!this.pfeature.getViewer().getInteractionMode().equals("MOVE_POLYGON")) {
                Coordinate[] coordArr = this.pfeature.getCoordArr(this.entityPosition, this.ringPosition);
                float[] xp = this.pfeature.getXp(this.entityPosition, this.ringPosition);
                float[] yp = this.pfeature.getYp(this.entityPosition, this.ringPosition);
                this.backupCoordArr = new Coordinate[coordArr.length];
                System.arraycopy(coordArr, 0, this.backupCoordArr, 0, this.backupCoordArr.length);
                this.leftNeighbourIndex = this.getLeftNeighbourIndex(this.coordPosition);
                if (this.leftNeighbourIndex >= 0 && this.leftNeighbourIndex < coordArr.length) {
                    this.leftNeighbourCoordinate = coordArr[this.leftNeighbourIndex];
                    this.leftNeighbourPoint = new Point2D.Double(xp[this.leftNeighbourIndex], yp[this.leftNeighbourIndex]);
                }
                this.rightNeighbourIndex = this.getRightNeighbourIndex(this.coordPosition);
                if (this.rightNeighbourIndex >= 0 && this.rightNeighbourIndex < coordArr.length) {
                    this.rightNeighbourCoordinate = coordArr[this.rightNeighbourIndex];
                    this.rightNeighbourPoint = new Point2D.Double(xp[this.rightNeighbourIndex], yp[this.rightNeighbourIndex]);
                }
                if (this.pfeature.getFeature() instanceof AbstractNewFeature && (((AbstractNewFeature)this.pfeature.getFeature()).getGeometryType() == AbstractNewFeature.geomTypes.RECTANGLE || ((AbstractNewFeature)this.pfeature.getFeature()).getGeometryType() == AbstractNewFeature.geomTypes.ELLIPSE)) {
                    Collection selArr = this.pfeature.getViewer().getFeatureCollection().getSelectedFeatures();
                    for (Feature feature : selArr) {
                        PFeature pf = this.pfeature.getViewer().getPFeatureHM().get(feature);
                        if (pf == null || pf.getInfoNode() == null) continue;
                        pf.getInfoNode().setVisible(false);
                    }
                    this.pfeature.getViewer().getHandleLayer().removeAllChildren();
                    this.pfeature.getViewer().getHandleLayer().addChild((PNode)this);
                } else if (!this.pfeature.getViewer().getInteractionMode().equals("SPLIT_POLYGON") && this.rightNeighbourPoint != null && this.leftNeighbourPoint != null) {
                    Point2D leftInfoPoint = this.pfeature.getViewer().getCamera().viewToLocal(this.leftNeighbourPoint);
                    Point2D rightInfoPoint = this.pfeature.getViewer().getCamera().viewToLocal(this.rightNeighbourPoint);
                    if (((SelectionListener)CismapBroker.getInstance().getMappingComponent().getInputListener("SELECT")).isShowHandleNeighbourDistance()) {
                        this.leftInfo = new PText();
                        this.leftInfo.setPaint((Paint)new Color(255, 255, 255, 100));
                        this.rightInfo = new PText();
                        this.rightInfo.setPaint((Paint)new Color(255, 255, 255, 100));
                        this.leftInfo.setX(leftInfoPoint.getX() + 6.0);
                        this.leftInfo.setY(leftInfoPoint.getY() - 6.0);
                        this.rightInfo.setX(rightInfoPoint.getX() + 6.0);
                        this.rightInfo.setY(rightInfoPoint.getY() - 6.0);
                        this.leftInfo.setVisible(true);
                        this.rightInfo.setVisible(true);
                        this.addChild((PNode)this.leftInfo);
                        this.addChild((PNode)this.rightInfo);
                    }
                    if (this.pfeature.getViewer().isInGlueIdenticalPointsMode()) {
                        this.glueCoordinates = this.pfeature.checkforGlueCoords(this.entityPosition, this.ringPosition, this.coordPosition);
                        LOG.info((Object)("checkforGlueCoords() aufgerufen und " + this.glueCoordinates.keySet().size() + " gefunden"));
                    }
                    this.startX = xp[this.coordPosition];
                    this.startY = yp[this.coordPosition];
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error in startHandleDrag.", t);
        }
        super.startHandleDrag(aLocalPoint, aEvent);
    }

    @Override
    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        try {
            if (!this.pfeature.getViewer().getInteractionMode().equals("SPLIT_POLYGON") && !this.pfeature.getViewer().getInteractionMode().equals("MOVE_POLYGON")) {
                if ((this.pfeature.getFeature().getGeometry() instanceof MultiPolygon || this.pfeature.getFeature().getGeometry() instanceof Polygon) && !this.pfeature.isValid(this.entityPosition, this.ringPosition)) {
                    this.updateGeometryPoints(this.startX, this.startY);
                    this.relocateHandle();
                }
                if (this.pfeature.getViewer().getFeatureCollection() instanceof DefaultFeatureCollection) {
                    this.pfeature.syncGeometry();
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    features.add(this.pfeature.getFeature());
                    ((DefaultFeatureCollection)this.pfeature.getViewer().getFeatureCollection()).fireFeaturesChanged(features);
                } else {
                    this.pfeature.getViewer().getFeatureCollection().reconsiderFeature(this.pfeature.getFeature());
                }
                CismapBroker.getInstance().setSnappingVetoFeature(null);
                if (this.leftInfo != null) {
                    this.removeChild((PNode)this.leftInfo);
                }
                if (this.rightInfo != null) {
                    this.removeChild((PNode)this.rightInfo);
                }
                this.leftInfo = null;
                this.rightInfo = null;
                if (!(this.pfeature.getFeature() instanceof RequestForUnmoveableHandles) && this.pfeature.getViewer().getHandleInteractionMode().equals("MOVE_HANDLE") && Math.abs((double)this.startX - this.getLocator().locateX()) > 0.001 || Math.abs((double)this.startY - this.getLocator().locateY()) > 0.001) {
                    boolean isGluedAction = false;
                    if (!this.glueCoordinates.isEmpty()) {
                        isGluedAction = true;
                        ArrayList<Feature> features = new ArrayList<Feature>();
                        if (this.pfeature.getViewer().isInGlueIdenticalPointsMode()) {
                            Set pFeatureSet = this.glueCoordinates.keySet();
                            for (PFeature gluePFeature : pFeatureSet) {
                                if (!gluePFeature.getFeature().isEditable()) continue;
                                features.add(gluePFeature.getFeature());
                                Collection coordinates = (Collection)this.glueCoordinates.get((Object)gluePFeature);
                                if (coordinates == null) continue;
                                for (Object o : coordinates) {
                                    if (!this.pfeature.getViewer().isFeatureDebugging() || !LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)("PFeature synced:" + gluePFeature));
                                }
                            }
                            ((DefaultFeatureCollection)this.pfeature.getViewer().getFeatureCollection()).fireFeaturesChanged(features);
                        }
                    }
                    this.pfeature.getViewer().getMemUndo().addAction(new HandleMoveAction(this.entityPosition, this.ringPosition, this.coordPosition, this.pfeature, this.startX, this.startY, (float)this.getLocator().locateX(), (float)this.getLocator().locateY(), isGluedAction));
                    this.pfeature.getViewer().getMemRedo().clear();
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error in endHandleDrag.", t);
        }
        super.endHandleDrag(aLocalPoint, aEvent);
    }

    @Override
    public void handleClicked(PInputEvent pInputEvent) {
        try {
            if (!this.pfeature.getViewer().getInteractionMode().equals("MOVE_POLYGON")) {
                if (this.pfeature.getViewer().isFeatureDebugging() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Handle clicked");
                }
                float[] xp = this.pfeature.getXp(this.entityPosition, this.ringPosition);
                float[] yp = this.pfeature.getYp(this.entityPosition, this.ringPosition);
                if (!(this.pfeature.getFeature() instanceof RequestForUnremovableHandles) && this.pfeature.getViewer().getHandleInteractionMode().equals("REMOVE_HANDLE")) {
                    Coordinate[] coordArr = this.pfeature.getCoordArr(this.entityPosition, this.ringPosition);
                    Coordinate[] newCoordArr = new Coordinate[coordArr.length - 1];
                    System.arraycopy(coordArr, 0, newCoordArr, 0, this.coordPosition);
                    System.arraycopy(coordArr, this.coordPosition + 1, newCoordArr, this.coordPosition, newCoordArr.length - this.coordPosition);
                    if (this.pfeature.getFeature().getGeometry() instanceof Polygon || this.pfeature.getFeature().getGeometry() instanceof MultiPolygon) {
                        newCoordArr[newCoordArr.length - 1] = newCoordArr[0];
                    }
                    if (this.pfeature.isValidWithThisCoordinates(this.entityPosition, this.ringPosition, newCoordArr)) {
                        ((PHandle)pInputEvent.getPickedNode()).removeHandle();
                        this.polygonTooltip.setVisible(false);
                    } else {
                        this.polygonTooltip.setOffset(pInputEvent.getCanvasPosition().getX() + 20.0, pInputEvent.getCanvasPosition().getY() + 20.0);
                        if (this.ringPosition > 0) {
                            this.showInvalidPolygonTooltip(InvalidPolygonTooltip.Mode.HOLE_ERROR);
                        } else {
                            this.showInvalidPolygonTooltip(InvalidPolygonTooltip.Mode.ENTITY_ERROR);
                        }
                    }
                } else if (!(this.pfeature.getFeature() instanceof RequestForUnaddableHandles) && this.pfeature.getViewer().getHandleInteractionMode().equals("ADD_HANDLE")) {
                    this.pfeature.getViewer().getMemUndo().addAction(new HandleDeleteAction(this.pfeature.getViewer(), this.pfeature.getFeature(), this.entityPosition, this.ringPosition, this.coordPosition, xp[this.coordPosition], yp[this.coordPosition]));
                    ((PHandle)pInputEvent.getPickedNode()).duplicateHandle();
                } else if (this.pfeature.getViewer().getInteractionMode().equals("SPLIT_POLYGON")) {
                    if (TransformationPHandle.readyForSplitting(this.pfeature.getFeature().getGeometry())) {
                        this.pfeature.addSplitHandle((PHandle)pInputEvent.getPickedNode());
                    } else if (this.pfeature.getFeature().getGeometry() instanceof LineString && this.coordPosition > 0 && this.coordPosition < xp.length - 1) {
                        this.pfeature.addSplitHandle((PHandle)pInputEvent.getPickedNode());
                    }
                }
                if (this.pfeature.getViewer().isFeatureDebugging() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ende von handleClicked() getFeature().getGeometry().getCoordinates().length:" + this.pfeature.getFeature().getGeometry().getCoordinates().length));
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error in handleClicked.", t);
        }
        super.handleClicked(pInputEvent);
    }

    private static boolean readyForSplitting(Geometry geom) {
        if (geom instanceof Polygon && ((Polygon)geom).getNumInteriorRing() == 0) {
            return true;
        }
        if (geom instanceof MultiPolygon && ((MultiPolygon)geom).getNumGeometries() == 1) {
            return TransformationPHandle.readyForSplitting(((MultiPolygon)geom).getGeometryN(0));
        }
        return false;
    }

    @Override
    public void removeHandle() {
        float[] xp = this.pfeature.getXp(this.entityPosition, this.ringPosition);
        if (xp.length > 4 && (this.pfeature.getFeature().getGeometry() instanceof Polygon || this.pfeature.getFeature().getGeometry() instanceof MultiPolygon) || xp.length > 1 && this.pfeature.getFeature().getGeometry() instanceof LineString) {
            this.pfeature.removeCoordinate(this.entityPosition, this.ringPosition, this.coordPosition);
            if (this.isSelected()) {
                this.pfeature.getViewer().showHandles(false);
            }
        }
    }

    @Override
    public void duplicateHandle() {
        this.pfeature.duplicateCoordinate(this.entityPosition, this.ringPosition, this.coordPosition);
    }

    private void updateGeometryPoints(float newX, float newY) {
        if (this.pfeature.getFeature() instanceof AbstractNewFeature) {
            AbstractNewFeature.geomTypes geomType = ((AbstractNewFeature)this.pfeature.getFeature()).getGeometryType();
            switch (geomType) {
                case RECTANGLE: {
                    if (this.coordPosition == 4) {
                        this.coordPosition = 0;
                    }
                    int posOpposed = (this.coordPosition + 2) % 4;
                    int posPrevious = (this.coordPosition + 3) % 4;
                    int posNext = (this.coordPosition + 1) % 4;
                    float[] xp = this.pfeature.getXp(this.entityPosition, this.ringPosition);
                    float[] yp = this.pfeature.getYp(this.entityPosition, this.ringPosition);
                    this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, this.coordPosition, newX, newY);
                    if (this.coordPosition % 2 == 0) {
                        this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, posPrevious, xp[posPrevious], newY);
                        this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, posNext, newX, yp[posNext]);
                        this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, posOpposed, xp[posPrevious], yp[posNext]);
                    } else {
                        this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, posPrevious, newX, yp[posPrevious]);
                        this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, posNext, xp[posNext], newY);
                        this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, posOpposed, xp[posNext], yp[posPrevious]);
                    }
                    this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, 4, xp[0], yp[0]);
                    this.pfeature.updatePath();
                    break;
                }
                case ELLIPSE: {
                    break;
                }
                default: {
                    this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, this.coordPosition, newX, newY);
                    break;
                }
            }
        } else {
            this.pfeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, this.coordPosition, newX, newY);
        }
    }

    private void showInvalidPolygonTooltip(final InvalidPolygonTooltip.Mode mode) {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                TransformationPHandle.this.polygonTooltip.setMode(mode);
                TransformationPHandle.this.polygonTooltip.setVisible(true);
                Thread.sleep(2000L);
                return null;
            }

            @Override
            protected void done() {
                super.done();
                TransformationPHandle.this.polygonTooltip.setVisible(false);
            }
        }.execute();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (Point2D p : this.snappedCoordinates.keySet()) {
            this.pfeature.getViewer().getWtst().removeXCoordinate((float)p.getX());
            this.pfeature.getViewer().getWtst().removeYCoordinate((float)p.getY());
        }
    }

    @Override
    public void deregistration() {
        if (this.polygonTooltip != null && this.polygonTooltip.getVisible()) {
            this.polygonTooltip.setVisible(false);
        }
    }
}

