/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateSearchGeometryListener;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.log4j.Logger;

public abstract class AbstractCreateSearchGeometryListener
extends CreateGeometryListener
implements CreateSearchGeometryListener {
    private static final Logger LOG = Logger.getLogger(AbstractCreateSearchGeometryListener.class);
    public static final String PROPERTY_LAST_FEATURE = "PROPERTY_LAST_FEATURE";
    public static final String PROPERTY_MODE = "PROPERTY_MODE";
    public static final String PROPERTY_NUM_OF_ELLIPSE_EDGES = "PROPERTY_NUM_OF_ELLIPSE_EDGES";
    public static final String PROPERTY_HOLD_GEOMETRIES = "PROPERTY_HOLD_GEOMETRIES";
    public static final String PROPERTY_SEARCH_COLOR = "PROPERTY_SEARCH_COLOR";
    public static final String PROPERTY_SEARCH_TRANSPARENCY = "PROPERTY_SEARCH_TRANSPARENCY";
    private boolean holdGeometries = false;
    private Color searchColor = Color.GREEN;
    private float searchTransparency = 0.5f;
    private SearchFeature lastFeature;
    private SearchFeature searchFeature;
    private SearchFeature recentlyCreatedFeature;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final String inputListenerName;

    public AbstractCreateSearchGeometryListener(MappingComponent mc, String inputListenerName) {
        super(mc, SearchFeature.class);
        this.inputListenerName = inputListenerName;
    }

    public String getInputListenerName() {
        return this.inputListenerName;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    protected Color getFillingColor() {
        return new Color(this.searchColor.getRed(), this.searchColor.getGreen(), this.searchColor.getBlue(), 255 - (int)(255.0f * this.searchTransparency));
    }

    @Override
    protected void finishGeometry(AbstractNewFeature newFeature) {
        super.finishGeometry(newFeature);
        SearchFeature newSearchFeature = (SearchFeature)newFeature;
        newSearchFeature.setInputListenerName(this.inputListenerName);
        this.recentlyCreatedFeature = newSearchFeature;
    }

    protected void cleanup(final SearchFeature feature) {
        final PFeature pFeature = this.getMappingComponent().getPFeatureHM().get(feature);
        if (this.isHoldingGeometries()) {
            pFeature.moveToFront();
            feature.setEditable(true);
            this.getMappingComponent().getFeatureCollection().holdFeature(feature);
        } else {
            this.getMappingComponent().getTmpFeatureLayer().addChild((PNode)pFeature);
            pFeature.animateToTransparency(0.0f, 2500L);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (pFeature.getTransparency() > 0.0f) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    AbstractCreateSearchGeometryListener.this.getMappingComponent().getFeatureCollection().removeFeature(feature);
                }
            }).start();
        }
    }

    protected void setLastFeature(SearchFeature newValue) {
        SearchFeature oldValue = this.lastFeature;
        this.lastFeature = newValue;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_LAST_FEATURE, oldValue, newValue);
    }

    @Override
    public void redoLastSearch() {
        this.search(this.lastFeature);
    }

    @Override
    public void showLastFeature() {
        this.showFeature(this.lastFeature);
        this.getMappingComponent().getFeatureCollection().holdFeature(this.lastFeature);
    }

    public SearchFeature getSearchFeature() {
        return this.searchFeature;
    }

    protected void setSearchFeature(SearchFeature searchFeature) {
        this.searchFeature = searchFeature;
    }

    protected void showFeature(SearchFeature feature) {
        if (feature != null) {
            feature.setInputListenerName(this.inputListenerName);
            feature.setEditable(feature.getGeometryType() != AbstractNewFeature.geomTypes.MULTIPOLYGON);
            this.getMappingComponent().getFeatureCollection().addFeature(feature);
            if (this.isHoldingGeometries()) {
                this.getMappingComponent().getFeatureCollection().holdFeature(feature);
            }
        }
    }

    @Override
    public boolean isHoldingGeometries() {
        return this.holdGeometries;
    }

    @Override
    public void setHoldGeometries(boolean newValue) {
        boolean oldValue = this.holdGeometries;
        this.holdGeometries = newValue;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_HOLD_GEOMETRIES, oldValue, newValue);
    }

    @Override
    public float getSearchTransparency() {
        return this.searchTransparency;
    }

    @Override
    public void setSearchTransparency(float newValue) {
        float oldValue = this.searchTransparency;
        this.searchTransparency = newValue;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SEARCH_TRANSPARENCY, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    @Override
    public Color getSearchColor() {
        Color filling = this.getFillingColor();
        return new Color(filling.getRed(), filling.getGreen(), filling.getBlue());
    }

    @Override
    public void setSearchColor(Color newValue) {
        Color oldValue = this.searchColor;
        this.searchColor = newValue;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SEARCH_COLOR, oldValue, newValue);
    }

    @Override
    public void setNumOfEllipseEdges(int newValue) {
        int oldValue = this.getNumOfEllipseEdges();
        super.setNumOfEllipseEdges(newValue);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NUM_OF_ELLIPSE_EDGES, oldValue, newValue);
    }

    @Override
    public SearchFeature getLastSearchFeature() {
        return this.lastFeature;
    }

    @Override
    public void search(SearchFeature searchFeature) {
        if (searchFeature != null) {
            this.setSearchFeature(searchFeature);
            boolean searchExecuted = this.performSearch(searchFeature);
            if (searchExecuted) {
                this.setLastFeature(searchFeature);
                this.showFeature(searchFeature);
                this.cleanup(searchFeature);
            }
        }
    }

    @Override
    public void mousePressed(PInputEvent pInputEvent) {
        boolean progressBefore = this.isInProgress();
        super.mousePressed(pInputEvent);
        if (this.recentlyCreatedFeature != null) {
            this.search(this.recentlyCreatedFeature);
            this.recentlyCreatedFeature = null;
        } else if ((!this.isInProgress() || !progressBefore && this.isInProgress()) && pInputEvent.getClickCount() == 2) {
            this.handleDoubleClickInMap(pInputEvent);
        }
    }

    @Override
    public void mouseReleased(PInputEvent arg0) {
        super.mouseReleased(arg0);
        if (this.recentlyCreatedFeature != null) {
            this.search(this.recentlyCreatedFeature);
            this.recentlyCreatedFeature = null;
        }
    }

    protected void handleUserFinishedSearchGeometry(SearchFeature feature) {
        this.getMappingComponent().getFeatureCollection().addFeature(feature);
        this.setLastFeature(feature);
        this.performSearch(feature);
        this.cleanup(feature);
    }

    protected void handleDoubleClickInMap(PInputEvent pInputEvent) {
        PNode o = PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true);
        if (!(o instanceof PFeature)) {
            return;
        }
        PFeature sel = (PFeature)o;
        if (!(sel.getFeature() instanceof SearchFeature)) {
            return;
        }
        SearchFeature searchFeature = (SearchFeature)sel.getFeature();
        if (pInputEvent.isLeftMouseButton()) {
            this.getMappingComponent().getHandleLayer().removeAllChildren();
            this.search(searchFeature);
        }
    }

    @Override
    public void setMode(String newValue) throws IllegalArgumentException {
        String oldValue = this.getMode();
        super.setMode(newValue);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_MODE, oldValue, newValue);
        if (this.getMappingComponent().getInteractionMode().equals("SEARCH_POLYGON")) {
            this.generateAndShowPointerAnnotation();
        }
    }

    public void mouseEntered(PInputEvent event) {
        super.mouseEntered(event);
        if (event.isMouseEnteredOrMouseExited()) {
            this.generateAndShowPointerAnnotation();
        }
    }

    public void mouseExited(PInputEvent event) {
        super.mouseExited(event);
        if (event.isMouseEnteredOrMouseExited()) {
            this.getMappingComponent().setPointerAnnotationVisibility(false);
        }
    }

    protected void generateAndShowPointerAnnotation() {
        final PNode pointerAnnotation = this.getPointerAnnotation();
        if (pointerAnnotation == null) {
            return;
        }
        Runnable showPointerAnnotation = new Runnable(){

            @Override
            public void run() {
                AbstractCreateSearchGeometryListener.this.getMappingComponent().setPointerAnnotation(pointerAnnotation);
                AbstractCreateSearchGeometryListener.this.getMappingComponent().setPointerAnnotationVisibility(true);
            }
        };
        if (EventQueue.isDispatchThread()) {
            showPointerAnnotation.run();
        } else {
            EventQueue.invokeLater(showPointerAnnotation);
        }
    }

    protected abstract boolean performSearch(SearchFeature var1);

    protected abstract PNode getPointerAnnotation();
}

