/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.StaticDebuggingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BackgroundRefreshingPanEventListener
extends PPanEventHandler
implements PropertyChangeListener {
    PImage pi;
    boolean rasterServiceLayerVisible = true;
    private boolean imageBoosterActive = false;
    private final Logger log = Logger.getLogger(this.getClass());
    private List<PNode> nodesToEnable = new ArrayList<PNode>();
    private MappingComponent mappingComponent;
    private volatile Image image = null;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean panStarted = false;

    public BackgroundRefreshingPanEventListener() {
        this.setAutopan(false);
    }

    protected void dragActivityFinalStep(PInputEvent pInputEvent) {
        super.dragActivityFinalStep(pInputEvent);
        this.panStarted = false;
        if (pInputEvent.getComponent() instanceof MappingComponent) {
            MappingComponent mc = (MappingComponent)pInputEvent.getComponent();
            if (this.imageBoosterActive) {
                mc.getRasterServiceLayer().setVisible(this.rasterServiceLayerVisible);
                mc.getDragPerformanceImproverLayer().setVisible(false);
                mc.getDragPerformanceImproverLayer().removeAllChildren();
                for (PNode node : this.nodesToEnable) {
                    node.setVisible(true);
                }
                mc.getFeatureLayer().setVisible(true);
            }
            Rectangle2D oldBounds = mc.getViewBounds();
            PBounds newBounds = mc.getCamera().getViewBounds();
            if (!newBounds.equals(oldBounds)) {
                mc.setNewViewBounds((Rectangle2D)newBounds);
                mc.queryServices();
            }
        }
    }

    protected void dragActivityFirstStep(PInputEvent aEvent) {
        this.panStarted = true;
        if (aEvent.getComponent() instanceof MappingComponent) {
            MappingComponent mc = (MappingComponent)aEvent.getComponent();
            this.imageBoosterActive = StaticDebuggingTools.checkHomeForFile((String)"panPerformanceBooster");
            if (this.imageBoosterActive) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"isPanPerformanceBoosterEnabled");
                }
                this.refreshImage(mc);
                mc.getDragPerformanceImproverLayer().setVisible(true);
                mc.getRasterServiceLayer().setVisible(false);
                for (int i = 0; i < mc.getMapServiceLayer().getChildrenCount(); ++i) {
                    PNode tmp = mc.getMapServiceLayer().getChild(i);
                    if (!tmp.getVisible()) continue;
                    tmp.setVisible(false);
                    this.nodesToEnable.add(tmp);
                }
                mc.getFeatureLayer().setVisible(false);
            }
        }
        super.dragActivityFirstStep(aEvent);
    }

    private void refreshImage(MappingComponent mc) {
        this.rasterServiceLayerVisible = mc.getRasterServiceLayer().getVisible();
        this.image = mc.getCamera().toImage();
        this.pi = new PImage(this.image);
        mc.getDragPerformanceImproverLayer().removeAllChildren();
        mc.getDragPerformanceImproverLayer().addChild((PNode)this.pi);
        this.pi.scale(1.0 / mc.getCamera().getViewScale());
        this.pi.setOffset(mc.getCamera().getViewBounds().getOrigin());
        this.pi.setTransparency(0.5f);
    }

    private BufferedImage componentToImage(JComponent component) {
        BufferedImage img = new BufferedImage(component.getWidth(), component.getHeight(), 3);
        Graphics g = img.getGraphics();
        g.setColor(component.getForeground());
        g.setFont(component.getFont());
        component.paintAll(g);
        return img.getSubimage(0, 0, img.getWidth(), img.getHeight());
    }

    public void mouseDragged(PInputEvent e) {
        super.mouseDragged(e);
        CismapBroker.getInstance().fireMapBoundsChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.panStarted) {
            this.image = null;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BackgroundRefreshingPanEventListener.this.lock.writeLock().lock();
                    try {
                        BackgroundRefreshingPanEventListener.this.image = BackgroundRefreshingPanEventListener.this.mappingComponent.getCamera().toImage();
                    }
                    finally {
                        BackgroundRefreshingPanEventListener.this.lock.writeLock().unlock();
                    }
                }
            }).start();
        }
    }
}

