/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeregistrationListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.InvalidPolygonTooltip;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureAddEntityAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureAddHoleAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureCreateAction;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class DeleteFeatureListener
extends PBasicInputEventHandler
implements DeregistrationListener {
    private static final Logger LOG = Logger.getLogger(DeleteFeatureListener.class);
    public static final String FEATURE_DELETE_REQUEST_NOTIFICATION = "FEATURE_DELETE_REQUEST_NOTIFICATION";
    private static final ClassComparator comparator = new ClassComparator();
    private PFeature featureRequestedForDeletion = null;
    private final InvalidPolygonTooltip multiPolygonPointerAnnotation = new InvalidPolygonTooltip();
    private final MappingComponent mc;
    private Class[] allowedFeatureClassesToDelete = null;

    public DeleteFeatureListener(MappingComponent mc) {
        this.mc = mc;
        mc.getCamera().addChild((PNode)this.multiPolygonPointerAnnotation);
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        this.multiPolygonPointerAnnotation.setOffset(pInputEvent.getCanvasPosition().getX() + 20.0, pInputEvent.getCanvasPosition().getY() + 20.0);
        Collection selectedFeatures = this.mc.getFeatureCollection().getSelectedFeatures();
        if (selectedFeatures.size() != 1) {
            if (pInputEvent.isAltDown()) {
                this.multiPolygonPointerAnnotation.setMode(InvalidPolygonTooltip.Mode.SELECT_FEATURE);
                this.multiPolygonPointerAnnotation.setVisible(true);
            } else {
                this.multiPolygonPointerAnnotation.setVisible(false);
            }
        } else {
            this.multiPolygonPointerAnnotation.setVisible(false);
        }
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        super.mouseClicked(pInputEvent);
        if (pInputEvent.getComponent() instanceof MappingComponent) {
            MappingComponent mappingComponent = (MappingComponent)pInputEvent.getComponent();
            PFeature clickedPFeature = (PFeature)PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true);
            if (clickedPFeature != null && clickedPFeature.getFeature() != null && this.allowedFeatureClassesToDelete != null && Arrays.binarySearch(this.allowedFeatureClassesToDelete, clickedPFeature.getFeature().getClass(), comparator) < 0) {
                return;
            }
            if (pInputEvent.isAltDown()) {
                Collection selectedFeatures = mappingComponent.getFeatureCollection().getSelectedFeatures();
                if (selectedFeatures.size() == 1) {
                    PFeature selectedPFeature = mappingComponent.getPFeatureHM().get((Feature)selectedFeatures.toArray()[0]);
                    if (selectedPFeature != null && selectedPFeature.getFeature().canBeSelected() && selectedPFeature.getFeature().isEditable() && (selectedPFeature.getFeature().getGeometry() instanceof MultiPolygon || selectedPFeature.getFeature().getGeometry() instanceof Polygon)) {
                        if (selectedPFeature.getNumOfEntities() == 1 && selectedPFeature.equals(clickedPFeature)) {
                            this.deletePFeature(selectedPFeature, mappingComponent);
                        } else {
                            Coordinate mouseCoord = new Coordinate(mappingComponent.getWtst().getSourceX(pInputEvent.getPosition().getX() - mappingComponent.getClip_offset_x()), mappingComponent.getWtst().getSourceY(pInputEvent.getPosition().getY() - mappingComponent.getClip_offset_y()));
                            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(mappingComponent.getMappingModel().getSrs().getCode()));
                            Point mousePoint = CrsTransformer.transformToGivenCrs(geometryFactory.createPoint(mouseCoord), CrsTransformer.createCrsFromSrid(selectedPFeature.getFeature().getGeometry().getSRID()));
                            int selectedEntityPosition = selectedPFeature.getEntityPositionUnderPoint(mousePoint);
                            if (selectedEntityPosition >= 0) {
                                Polygon entity = selectedPFeature.getEntityByPosition(selectedEntityPosition);
                                selectedPFeature.removeEntity(selectedEntityPosition);
                                mappingComponent.getMemUndo().addAction(new FeatureAddEntityAction(mappingComponent, selectedPFeature.getFeature(), entity));
                                mappingComponent.getMemRedo().clear();
                            } else {
                                int entityPosition = selectedPFeature.getMostInnerEntityUnderPoint(mousePoint);
                                int holePosition = selectedPFeature.getHolePositionUnderPoint(mousePoint, entityPosition);
                                LineString hole = selectedPFeature.getHoleByPosition(entityPosition, holePosition);
                                selectedPFeature.removeHoleUnderPoint(mousePoint);
                                mappingComponent.getMemUndo().addAction(new FeatureAddHoleAction(mappingComponent, selectedPFeature.getFeature(), entityPosition, hole));
                                mappingComponent.getMemRedo().clear();
                            }
                        }
                    }
                } else if (clickedPFeature != null) {
                    mappingComponent.getFeatureCollection().select(clickedPFeature.getFeature());
                }
            } else if (clickedPFeature != null) {
                this.deletePFeature(clickedPFeature, mappingComponent);
            }
        }
    }

    private void deletePFeature(PFeature pFeature, MappingComponent mappingComponent) {
        if (pFeature.getFeature().isEditable() && pFeature.getFeature().canBeSelected()) {
            this.featureRequestedForDeletion = (PFeature)pFeature.clone();
            mappingComponent.getFeatureCollection().removeFeature(pFeature.getFeature());
            mappingComponent.getMemUndo().addAction(new FeatureCreateAction(mappingComponent, pFeature.getFeature()));
            mappingComponent.getMemRedo().clear();
            this.postFeatureDeleteRequest();
        }
    }

    private void postFeatureDeleteRequest() {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(FEATURE_DELETE_REQUEST_NOTIFICATION, (Object)this);
    }

    public PFeature getFeatureRequestedForDeletion() {
        return this.featureRequestedForDeletion;
    }

    public Class[] getAllowedFeatureClassesToDelete() {
        return this.allowedFeatureClassesToDelete;
    }

    public void setAllowedFeatureClassesToDelete(Class[] allowedFeatureClassesToDelete) {
        this.allowedFeatureClassesToDelete = allowedFeatureClassesToDelete;
        if (allowedFeatureClassesToDelete != null) {
            Arrays.sort(this.allowedFeatureClassesToDelete, comparator);
        }
    }

    @Override
    public void deregistration() {
        if (this.multiPolygonPointerAnnotation != null && this.multiPolygonPointerAnnotation.getVisible()) {
            this.multiPolygonPointerAnnotation.setVisible(false);
        }
    }

    private static class ClassComparator
    implements Comparator<Class> {
        private ClassComparator() {
        }

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    class Tooltip
    extends PNode {
        private final Color COLOR_BACKGROUND = new Color(255, 255, 222, 200);

        public Tooltip(String text) {
            PText pText = new PText(text);
            Font defaultFont = pText.getFont();
            Font boldDefaultFont = new Font(defaultFont.getName(), defaultFont.getStyle() + 1, defaultFont.getSize());
            pText.setFont(boldDefaultFont);
            pText.setOffset(5.0, 5.0);
            PPath background = new PPath((Shape)new RoundRectangle2D.Double(0.0, 0.0, pText.getWidth() + 15.0, pText.getHeight() + 15.0, 10.0, 10.0));
            background.setPaint((Paint)this.COLOR_BACKGROUND);
            background.addChild((PNode)pText);
            this.setTransparency(0.85f);
            this.addChild((PNode)background);
        }
    }
}

