/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeriveRule;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;

public class DerivedFixedPImage
extends FixedPImage
implements PropertyChangeListener {
    PFeature parent;
    DeriveRule rule;
    final MappingComponent mappingComponent;
    private final Logger log = Logger.getLogger(this.getClass());

    public DerivedFixedPImage(Image image, PFeature parent, DeriveRule rule) {
        super(image);
        this.parent = parent;
        this.rule = rule;
        parent.addPropertyChangeListener(this);
        this.mappingComponent = parent.getMappingComponent();
        this.mappingComponent.addStickyNode(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Geometry g = this.parent.getFeature().getGeometry();
        Geometry derivedG = this.rule.derive(g);
        Point p = derivedG.getCentroid();
        double x = this.mappingComponent.getWtst().getScreenX(p.getCoordinate().x);
        double y = this.mappingComponent.getWtst().getScreenY(p.getCoordinate().y);
        super.setOffset(x, y);
        double s = this.mappingComponent.getCamera().getViewScale();
        double targetScale = this.mappingComponent.getStickyFeatureCorrectionFactor() / s;
        if (Math.round(this.getScale() * 100000.0) != Math.round(targetScale * 100000.0)) {
            this.mappingComponent.rescaleStickyNodes();
        }
    }
}

