/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Logger;

public class KeyboardListener
extends PBasicInputEventHandler {
    public static final String X_PAN = "X_PAN";
    public static final String Y_PAN = "Y_PAN";
    MappingComponent viewer;
    Thread refreshThread;
    long refreshTime;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public KeyboardListener(MappingComponent map) {
        this.viewer = map;
    }

    public void keyPressed(PInputEvent event) {
        super.keyPressed(event);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("keyPressed " + event));
        }
        if (event.getKeyChar() == 'a') {
            this.zoom(0.95f, event, 0, 800);
        } else if (event.getKeyChar() == 'y') {
            this.zoom(1.05f, event, 0, 800);
        } else if (event.getKeyCode() == 38) {
            this.pan(Y_PAN, 0.05f, 0, 800);
        } else if (event.getKeyCode() == 40) {
            this.pan(Y_PAN, -0.05f, 0, 800);
        } else if (event.getKeyCode() == 39) {
            this.pan(X_PAN, -0.05f, 0, 800);
        } else if (event.getKeyCode() == 37) {
            this.pan(X_PAN, 0.05f, 0, 800);
        } else if (event.getKeyCode() == 8) {
            CreateNewGeometryListener listener = (CreateNewGeometryListener)this.viewer.getInputListener("NEW_POLYGON");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Event an CreateGeometryListener weitergeleitet:" + listener));
            }
            listener.keyPressed(event);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("kein treffer:" + event.getKeyCode() + "     (" + 40));
        }
    }

    public void pan(String direction, float factor, int localAnimationDuration, int delayTime) {
        block7: {
            final PBounds b = this.viewer.getCamera().getViewBounds();
            if (direction.equals(X_PAN)) {
                b.setOrigin(b.getX() + b.getWidth() * (double)factor, b.getY());
                this.viewer.getHandleLayer().removeAllChildren();
                this.viewer.getCamera().animateViewToCenterBounds((Rectangle2D)b, false, (long)localAnimationDuration);
                this.viewer.showHandles(true);
            } else if (direction.equals(Y_PAN)) {
                b.setOrigin(b.getX(), b.getY() + b.getHeight() * (double)factor);
                this.viewer.getHandleLayer().removeAllChildren();
                this.viewer.getCamera().animateViewToCenterBounds((Rectangle2D)b, false, (long)localAnimationDuration);
                this.viewer.showHandles(true);
            }
            if (localAnimationDuration == 0) {
                CismapBroker.getInstance().fireMapBoundsChanged();
            }
            try {
                this.refreshTime = System.currentTimeMillis() + (long)delayTime;
                if (this.refreshThread == null || !this.refreshThread.isAlive()) {
                    this.refreshThread = new Thread("KeyboardListener pan()"){

                        @Override
                        public void run() {
                            while (System.currentTimeMillis() < KeyboardListener.this.refreshTime) {
                                try {
                                    1.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            KeyboardListener.this.viewer.setNewViewBounds((Rectangle2D)b);
                            KeyboardListener.this.viewer.queryServices();
                        }
                    };
                    CismetThreadPool.execute((Runnable)this.refreshThread);
                }
            }
            catch (Exception ex) {
                if (!this.log.isDebugEnabled()) break block7;
                this.log.debug((Object)"error in pan", (Throwable)ex);
            }
        }
    }

    public void zoom(float factor, PInputEvent e, int localAnimationDuration, int delayTime) {
        block5: {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"zoom");
                }
                final PBounds b = new PBounds();
                double h = this.viewer.getCamera().getViewBounds().getHeight();
                double w = this.viewer.getCamera().getViewBounds().getWidth();
                double scale = factor;
                double oldWidth = this.viewer.getCamera().getViewBounds().getWidth();
                double newWidth = oldWidth * (1.0 - scale + 1.0);
                double oldHeight = this.viewer.getCamera().getViewBounds().getHeight();
                double newHeight = oldHeight * (1.0 - scale + 1.0);
                double offsetX = (newWidth - oldWidth) / 2.0;
                double offsetY = (newHeight - oldHeight) / 2.0;
                b.setOrigin(this.viewer.getCamera().getViewBounds().getOrigin().getX() - offsetX, this.viewer.getCamera().getViewBounds().getOrigin().getY() - offsetY);
                b.setSize(newWidth, newHeight);
                this.viewer.getHandleLayer().removeAllChildren();
                this.viewer.getCamera().animateViewToCenterBounds((Rectangle2D)b, true, (long)localAnimationDuration);
                this.viewer.showHandles(true);
                if (localAnimationDuration == 0) {
                    CismapBroker.getInstance().fireMapBoundsChanged();
                }
                this.refreshTime = System.currentTimeMillis() + (long)delayTime;
                if (this.refreshThread == null || !this.refreshThread.isAlive()) {
                    this.refreshThread = new Thread("MappingComponent KeyListener-Timeout"){

                        @Override
                        public void run() {
                            while (System.currentTimeMillis() < KeyboardListener.this.refreshTime) {
                                try {
                                    2.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            KeyboardListener.this.viewer.setNewViewBounds((Rectangle2D)b);
                            KeyboardListener.this.viewer.queryServices();
                        }
                    };
                    this.refreshThread.setPriority(5);
                    CismetThreadPool.execute((Runnable)this.refreshThread);
                }
            }
            catch (Exception ex) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug((Object)"error in zoom", (Throwable)ex);
            }
        }
    }
}

