/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.linearref.LengthLocationMap;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelfManipulatingFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.math.geometry.StaticGeometryFunctions;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class LinearReferencedPointFeature
extends DefaultStyledFeature
implements XStyledFeature,
SelfManipulatingFeature {
    private static final Logger LOG = Logger.getLogger(LinearReferencedPointFeature.class);
    public static final String PROPERTY_FEATURE_COORDINATE = "featureCoordinate";
    private Geometry baseLineGeom;
    private Collection<LinearReferencedPointFeatureListener> listeners = new ArrayList<LinearReferencedPointFeatureListener>();
    private ImageIcon ico = new ImageIcon(LinearReferencedPointFeature.class.getResource("/de/cismet/cismap/commons/gui/res/linRefPointIcon.png"));
    private ImageIcon annotationIco = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/linRefPoint.png"));
    private ImageIcon annotationSelectedIco = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/linRefPointSelected.png"));
    private Format infoFormat;
    private boolean isMovable = true;

    public LinearReferencedPointFeature(double value, Geometry baseLineGeom) {
        this(value, baseLineGeom, true);
    }

    public LinearReferencedPointFeature(double value, Geometry baseLineGeom, boolean showSubLine) {
        this.baseLineGeom = baseLineGeom;
        this.setGeometry(LinearReferencedPointFeature.getPointOnLine(value, baseLineGeom));
        this.setPointAnnotationSymbol(FeatureAnnotationSymbol.newCenteredFeatureAnnotationSymbol(this.annotationIco.getImage(), this.annotationSelectedIco.getImage()));
    }

    public void setBaseLine(Geometry baseLineGeom) {
        this.baseLineGeom = baseLineGeom;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setInfoFormat(Format infoFormat) {
        this.infoFormat = infoFormat;
    }

    public Format getInfoFormat() {
        return this.infoFormat;
    }

    public void setIconImage(ImageIcon ico) {
        this.ico = ico;
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        PFeature pFeature = mc.getPFeatureHM().get(this);
        if (pFeature != null) {
            pFeature.refresh();
        }
    }

    public Geometry getLineGeometry() {
        return this.baseLineGeom;
    }

    public void addListener(LinearReferencedPointFeatureListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LinearReferencedPointFeatureListener listener) {
        this.listeners.remove(listener);
    }

    public static Coordinate getNearestCoordninateOnLine(Coordinate coord, Geometry lineGeom) {
        Coordinate[] neighbours = LinearReferencedPointFeature.getNearestNeighbours(coord, lineGeom);
        if (neighbours != null) {
            Point2D point = StaticGeometryFunctions.createPointOnLine((Point2D)new Point2D.Double(neighbours[0].x, neighbours[0].y), (Point2D)new Point2D.Double(neighbours[1].x, neighbours[1].y), (Point2D)new Point2D.Double(coord.x, coord.y));
            return new Coordinate(point.getX(), point.getY());
        }
        return null;
    }

    public static double getDistanceOfCoordToLine(Coordinate coord, Geometry lineGeom) {
        Coordinate[] neighbours = LinearReferencedPointFeature.getNearestNeighbours(coord, lineGeom);
        if (neighbours != null) {
            double distance = StaticGeometryFunctions.distanceToLine((Point2D)new Point2D.Double(neighbours[0].x, neighbours[0].y), (Point2D)new Point2D.Double(neighbours[1].x, neighbours[1].y), (Point2D)new Point2D.Double(coord.x, coord.y));
            return distance;
        }
        return -1.0;
    }

    @Override
    public void moveTo(Coordinate coordinate, PDimension delta) {
        Geometry cuttedLineGeom;
        Coordinate manipulatedCoordinate;
        if (this.isMovable() && (manipulatedCoordinate = LinearReferencedPointFeature.getNearestCoordninateOnLine(coordinate, cuttedLineGeom = LinearReferencedPointFeature.getReducedLineGeometry(this.baseLineGeom, this.getGeometry().getCoordinate(), coordinate))) != null) {
            this.performMove(manipulatedCoordinate);
        }
    }

    public static Geometry getReducedLineGeometry(Geometry lineGeom, Coordinate lastCoordinate, Coordinate newCoordinate) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(newCoordinate);
        gsf.setSize(newCoordinate.distance(lastCoordinate) * 2.0);
        Polygon circleGeom = gsf.createCircle();
        return lineGeom.intersection((Geometry)circleGeom);
    }

    private Coordinate transformToRouteSrid(Coordinate coord) {
        try {
            CrsTransformer crsT = new CrsTransformer(CrsTransformer.createCrsFromSrid(this.getLineGeometry().getSRID()));
            CoordinateArraySequence coordSeq = new CoordinateArraySequence(new Coordinate[]{coord});
            Point point = new Point((CoordinateSequence)coordSeq, this.getLineGeometry().getFactory());
            Point transformedPoint = crsT.transformGeometry(point, CismapBroker.getInstance().getSrs().getCode());
            return transformedPoint.getCoordinate();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Umrechnen des CRS", (Throwable)ex);
            return coord;
        }
    }

    private void performMove(Coordinate coordinate) {
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        PFeature pFeature = mc.getPFeatureHM().get(this);
        if (pFeature != null) {
            pFeature.setCoordArr(0, 0, new Coordinate[]{(Coordinate)coordinate.clone()});
            pFeature.updatePath();
            pFeature.syncGeometry();
            pFeature.resetInfoNodePosition();
            pFeature.visualize();
            this.fireFeatureMoved();
        }
    }

    private void fireFeatureMoved() {
        CopyOnWriteArrayList<LinearReferencedPointFeatureListener> listenersCopy = new CopyOnWriteArrayList<LinearReferencedPointFeatureListener>(this.listeners);
        for (LinearReferencedPointFeatureListener listener : listenersCopy) {
            listener.featureMoved(this);
        }
    }

    private void fireFeatureMerged(LinearReferencedPointFeature mergePoint, LinearReferencedPointFeature withPoint) {
        CopyOnWriteArrayList<LinearReferencedPointFeatureListener> listenersCopy = new CopyOnWriteArrayList<LinearReferencedPointFeatureListener>(this.listeners);
        for (LinearReferencedPointFeatureListener listener : listenersCopy) {
            listener.featureMerged(mergePoint, withPoint);
        }
    }

    public void moveToPosition(double position) {
        Coordinate coordinate = LinearReferencedPointFeature.getCoordinateOnLine(position, this.baseLineGeom);
        this.performMove(coordinate);
    }

    public double getCurrentPosition() {
        Coordinate coord = this.getGeometry().getCoordinate();
        double cursorX = coord.x;
        double cursorY = coord.y;
        if (this.baseLineGeom != null) {
            LocationIndexedLine lil = new LocationIndexedLine(this.baseLineGeom);
            Coordinate c = new Coordinate(cursorX, cursorY);
            LinearLocation ll = lil.indexOf(c);
            LengthLocationMap llm = new LengthLocationMap(this.baseLineGeom);
            return llm.getLength(ll);
        }
        return 0.0;
    }

    public static Coordinate[] getNearestNeighbours(Coordinate coord, Geometry lineGeom) {
        Coordinate start = null;
        Coordinate end = null;
        double dist = Double.POSITIVE_INFINITY;
        Coordinate[] coords = lineGeom.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            Coordinate tmpStart = coords[i];
            Coordinate tmpEnd = coords[i + 1];
            double tmpDist = StaticGeometryFunctions.distanceToLine((Point2D)new Point2D.Double(tmpStart.x, tmpStart.y), (Point2D)new Point2D.Double(tmpEnd.x, tmpEnd.y), (Point2D)new Point2D.Double(coord.x, coord.y));
            if (!(tmpDist < dist)) continue;
            dist = tmpDist;
            start = tmpStart;
            end = tmpEnd;
        }
        if (start != null && end != null) {
            return new Coordinate[]{start, end};
        }
        return null;
    }

    public static double getPositionOnLine(Coordinate pointCoord, Geometry linestringOrMultilinestring) {
        LocationIndexedLine lineLIL = new LocationIndexedLine(linestringOrMultilinestring);
        LengthLocationMap lineLLM = new LengthLocationMap(linestringOrMultilinestring);
        LinearLocation pointLL = lineLIL.indexOf(pointCoord);
        double pointPosition = lineLLM.getLength(pointLL);
        return pointPosition;
    }

    private static Coordinate getCoordinateOnLine(double position, Geometry linestringOrMultilinestring) {
        LengthIndexedLine lil = new LengthIndexedLine(linestringOrMultilinestring);
        Coordinate coordinate = lil.extractPoint(position);
        return coordinate;
    }

    public static Geometry getPointOnLine(double position, Geometry linestringOrMultilinestring) {
        Coordinate coordinate = LinearReferencedPointFeature.getCoordinateOnLine(position, linestringOrMultilinestring);
        return new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), linestringOrMultilinestring.getSRID()).createPoint(coordinate);
    }

    @Override
    public ImageIcon getIconImage() {
        return this.ico;
    }

    @Override
    public String getName() {
        return "Station";
    }

    @Override
    public String getType() {
        return "Station";
    }

    @Override
    public JComponent getInfoComponent(Refreshable refresh) {
        return null;
    }

    @Override
    public Stroke getLineStyle() {
        return null;
    }

    @Override
    public void moveFinished() {
        LinearReferencedPointFeature snappingPoint = this.getSnappingPoint();
        if (snappingPoint != null) {
            this.fireFeatureMerged(this, snappingPoint);
            snappingPoint.fireFeatureMerged(this, snappingPoint);
        }
    }

    public LinearReferencedPointFeature getSnappingPoint() {
        boolean snapping = CismapBroker.getInstance().getMappingComponent().isSnappingEnabled();
        if (snapping) {
            FeatureCollection fc = CismapBroker.getInstance().getMappingComponent().getFeatureCollection();
            Feature[] features = fc.getAllFeatures().toArray(new Feature[0]);
            LinearReferencedPointFeature mergePoint = this;
            for (Feature feature : features) {
                boolean isInSnappingDistance;
                if (!(feature instanceof LinearReferencedPointFeature) || feature == mergePoint) continue;
                LinearReferencedPointFeature withPoint = (LinearReferencedPointFeature)feature;
                boolean bl = isInSnappingDistance = Math.abs(withPoint.getCurrentPosition() - mergePoint.getCurrentPosition()) < 0.002 * CismapBroker.getInstance().getMappingComponent().getScaleDenominator();
                if (!isInSnappingDistance) continue;
                return withPoint;
            }
        }
        return null;
    }
}

